/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.cvsoperations.cvsAnnotate;

import com.intellij.cvsSupport2.CvsUtil;
import com.intellij.cvsSupport2.application.CvsEntriesManager;
import com.intellij.cvsSupport2.connections.CvsEnvironment;
import com.intellij.cvsSupport2.connections.CvsRootProvider;
import com.intellij.cvsSupport2.cvsoperations.common.CvsExecutionEnvironment;
import com.intellij.cvsSupport2.cvsoperations.common.LocalPathIndifferentOperation;
import com.intellij.cvsSupport2.cvsoperations.common.LocalPathIndifferentOperationHelper;
import com.intellij.cvsSupport2.cvsoperations.cvsAnnotate.Annotation;
import com.intellij.openapi.diagnostic.Logger;
import java.io.File;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.lib.cvsclient.command.AbstractCommand;
import org.netbeans.lib.cvsclient.command.Command;
import org.netbeans.lib.cvsclient.command.annotate.AnnotateCommand;

public class AnnotateOperation
extends LocalPathIndifferentOperation {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.cvsSupport2.cvsoperations.cvsAnnotate.AnnotateOperation");
    private final String myRevision;
    private final List<Annotation> myAnnotations = new ArrayList<Annotation>();
    private final StringBuilder myBuffer = new StringBuilder();
    private final LocalPathIndifferentOperationHelper myHelper;
    private final boolean myAnnotateBinary;

    public static AnnotateOperation createForFile(File file) {
        File cvsLightweightFile = CvsUtil.getCvsLightweightFileForFile(file);
        String revision = CvsUtil.getRevisionFor(file);
        return new AnnotateOperation(cvsLightweightFile, revision, CvsEntriesManager.getInstance().getCvsConnectionSettingsFor(file.getParentFile()), false);
    }

    public AnnotateOperation(File cvsLightweightFile, String revision, CvsEnvironment env, boolean annotateBinary) {
        this(cvsLightweightFile, revision, env, new LocalPathIndifferentOperationHelper(revision), annotateBinary);
    }

    private AnnotateOperation(File cvsLightweightFile, String revision, CvsEnvironment env, LocalPathIndifferentOperationHelper helper, boolean annotateBinary) {
        super(helper.getAdminReader(), env);
        this.myHelper = helper;
        this.myHelper.addFile(cvsLightweightFile);
        this.myRevision = revision;
        this.myAnnotateBinary = annotateBinary;
    }

    @Override
    protected Command createCommand(CvsRootProvider root, CvsExecutionEnvironment cvsExecutionEnvironment) {
        AnnotateCommand result = new AnnotateCommand();
        this.myHelper.addFilesTo((AbstractCommand)result);
        result.setAnnotateByRevisionOrTag(this.myRevision);
        result.setAnnotateBinary(this.myAnnotateBinary);
        return result;
    }

    public Annotation[] getLineAnnotations() {
        return this.myAnnotations.toArray(new Annotation[0]);
    }

    public String getContent() {
        return this.myBuffer.toString();
    }

    @Override
    public void messageSent(String message, byte[] byteMessage, boolean error, boolean tagged) {
        super.messageSent(message, byteMessage, error, tagged);
        if (!error) {
            try {
                this.myAnnotations.add(Annotation.createOnMessage(message));
                this.myBuffer.append(Annotation.createMessageOn(message));
                this.myBuffer.append('\n');
            }
            catch (ParseException e) {
                LOG.error((Throwable)e);
            }
        }
    }

    @Override
    protected String getOperationName() {
        return "annotate";
    }
}

