/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.browserConnection;

import com.intellij.ide.browsers.BrowserFamily;
import com.intellij.ide.browsers.BrowserLauncher;
import com.intellij.ide.browsers.WebBrowser;
import com.intellij.ide.browsers.WebBrowserManager;
import com.intellij.javascript.debugger.JsFileUtil;
import com.intellij.javascript.debugger.browserConnection.BrowserConnector;
import com.intellij.javascript.debugger.browserConnection.BrowserQualifier;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.util.ArrayUtil;
import com.intellij.util.EventDispatcher;
import com.intellij.util.containers.ConcurrentMultiMap;
import io.netty.handler.codec.http.FullHttpRequest;
import java.util.Collection;
import java.util.EventListener;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;
import org.jetbrains.io.jsonRpc.Client;
import org.jetbrains.io.jsonRpc.ClientListener;
import org.jetbrains.io.jsonRpc.ClientManager;
import org.jetbrains.io.jsonRpc.JsonRpcServer;
import org.jetbrains.io.jsonRpc.JsonRpcServerKt;
import org.jetbrains.io.jsonRpc.MessageServer;
import org.jetbrains.io.webSocket.WebSocketHandshakeHandler;

public class BrowserConnectionManager {
    private static final Logger LOG = Logger.getInstance(BrowserConnectionManager.class);
    private static final Key<BrowserQualifier> BROWSER_KEY = Key.create((String)"browser");
    @Nullable
    private ClientManager server;
    @Nullable
    private JsonRpcServer rpcServer;
    private final ConcurrentMultiMap<BrowserQualifier, AsyncPromise<Client>> pendingActions = new ConcurrentMultiMap();
    private final EventDispatcher<ClientListener> webSocketServerListenerEventDispatcher = EventDispatcher.create(ClientListener.class);

    public static BrowserConnectionManager getInstance() {
        return (BrowserConnectionManager)ServiceManager.getService(BrowserConnectionManager.class);
    }

    @Nullable
    private static String safeGet(String name, Map<String, List<String>> parameters) {
        List<String> values = parameters.get(name);
        return values == null || values.isEmpty() ? null : values.get(0);
    }

    public void addWebSocketServerListener(@NotNull ClientListener listener, @NotNull Disposable disposable) {
        if (listener == null) {
            BrowserConnectionManager.$$$reportNull$$$0(0);
        }
        if (disposable == null) {
            BrowserConnectionManager.$$$reportNull$$$0(1);
        }
        this.webSocketServerListenerEventDispatcher.addListener((EventListener)listener, disposable);
    }

    public boolean hasConnections() {
        return this.server != null && this.server.hasClients();
    }

    @Nullable
    public JsonRpcServer getRpcServer() {
        return this.rpcServer;
    }

    @NotNull
    public Promise<Client> getConnectedBrowser(@NotNull WebBrowser browser, @Nullable Disposable parentDisposable) {
        Client connectedBrowser;
        if (browser == null) {
            BrowserConnectionManager.$$$reportNull$$$0(2);
        }
        if ((connectedBrowser = this.findConnectedBrowser(browser)) != null) {
            Promise promise2 = Promise.resolve((Object)connectedBrowser);
            if (promise2 == null) {
                BrowserConnectionManager.$$$reportNull$$$0(3);
            }
            return promise2;
        }
        BrowserQualifier browserQualifier = BrowserConnectionManager.browserToQualifier(browser);
        final AsyncPromise result2 = new AsyncPromise();
        this.pendingActions.putValue((Object)browserQualifier, (Object)result2);
        result2.onError(throwable -> this.pendingActions.remove((Object)browserQualifier, (Object)result2));
        if (parentDisposable != null) {
            Disposer.register((Disposable)parentDisposable, (Disposable)new Disposable(){

                public void dispose() {
                    result2.setError("rejected");
                }
            });
        }
        AsyncPromise asyncPromise = result2;
        if (asyncPromise == null) {
            BrowserConnectionManager.$$$reportNull$$$0(4);
        }
        return asyncPromise;
    }

    @Nullable
    public Client findConnectedBrowser(@NotNull WebBrowser browser) {
        if (browser == null) {
            BrowserConnectionManager.$$$reportNull$$$0(5);
        }
        if (this.server == null) {
            return null;
        }
        BrowserQualifier browserQualifier = BrowserConnectionManager.browserToQualifier(browser);
        return this.findClient((Condition<Client>)((Condition)client -> browserQualifier.equals(BROWSER_KEY.get((UserDataHolder)client))));
    }

    @Nullable
    public WebBrowser getBrowser(@NotNull Client client) {
        BrowserQualifier browserQualifier;
        if (client == null) {
            BrowserConnectionManager.$$$reportNull$$$0(6);
        }
        return (browserQualifier = (BrowserQualifier)((Object)BROWSER_KEY.get((UserDataHolder)client))) == null ? null : BrowserConnectionManager.qualifierToBrowser(browserQualifier);
    }

    @Nullable
    public Client findClient(@NotNull Condition<Client> condition) {
        if (condition == null) {
            BrowserConnectionManager.$$$reportNull$$$0(7);
        }
        if (this.server == null) {
            return null;
        }
        Ref result2 = Ref.create();
        this.server.forEachClient(client -> {
            if (condition == null) {
                BrowserConnectionManager.$$$reportNull$$$0(29);
            }
            if (condition.value(client)) {
                result2.set(client);
            }
            return result2.isNull();
        });
        return (Client)result2.get();
    }

    @NotNull
    public static BrowserQualifier browserToQualifier(@NotNull WebBrowser browser) {
        if (browser == null) {
            BrowserConnectionManager.$$$reportNull$$$0(8);
        }
        if (WebBrowserManager.isYandexBrowser((WebBrowser)browser)) {
            BrowserQualifier browserQualifier = BrowserQualifier.YANDEX;
            if (browserQualifier == null) {
                BrowserConnectionManager.$$$reportNull$$$0(9);
            }
            return browserQualifier;
        }
        if (WebBrowserManager.isDartium((WebBrowser)browser)) {
            BrowserQualifier browserQualifier = BrowserQualifier.DARTIUM;
            if (browserQualifier == null) {
                BrowserConnectionManager.$$$reportNull$$$0(10);
            }
            return browserQualifier;
        }
        switch (browser.getFamily()) {
            case FIREFOX: {
                BrowserQualifier browserQualifier = BrowserQualifier.FIREFOX;
                if (browserQualifier == null) {
                    BrowserConnectionManager.$$$reportNull$$$0(11);
                }
                return browserQualifier;
            }
            case EXPLORER: {
                BrowserQualifier browserQualifier = BrowserQualifier.EXPLORER;
                if (browserQualifier == null) {
                    BrowserConnectionManager.$$$reportNull$$$0(12);
                }
                return browserQualifier;
            }
            case SAFARI: {
                BrowserQualifier browserQualifier = BrowserQualifier.SAFARI;
                if (browserQualifier == null) {
                    BrowserConnectionManager.$$$reportNull$$$0(13);
                }
                return browserQualifier;
            }
            case OPERA: {
                BrowserQualifier browserQualifier = BrowserQualifier.OPERA;
                if (browserQualifier == null) {
                    BrowserConnectionManager.$$$reportNull$$$0(14);
                }
                return browserQualifier;
            }
        }
        BrowserQualifier browserQualifier = BrowserQualifier.CHROME;
        if (browserQualifier == null) {
            BrowserConnectionManager.$$$reportNull$$$0(15);
        }
        return browserQualifier;
    }

    @NotNull
    private static WebBrowser qualifierToBrowser(@NotNull BrowserQualifier browserQualifier) {
        if (browserQualifier == null) {
            BrowserConnectionManager.$$$reportNull$$$0(16);
        }
        WebBrowserManager browserManager = WebBrowserManager.getInstance();
        switch (browserQualifier) {
            case CHROME: {
                WebBrowser webBrowser = browserManager.getFirstBrowser(BrowserFamily.CHROME);
                if (webBrowser == null) {
                    BrowserConnectionManager.$$$reportNull$$$0(17);
                }
                return webBrowser;
            }
            case DARTIUM: 
            case YANDEX: {
                Condition browserCondition = browser -> {
                    if (browserQualifier == null) {
                        BrowserConnectionManager.$$$reportNull$$$0(28);
                    }
                    if (browser.getFamily().equals((Object)BrowserFamily.CHROME)) {
                        if (browserQualifier == BrowserQualifier.DARTIUM) {
                            return WebBrowserManager.isDartium((WebBrowser)browser);
                        }
                        if (browserQualifier == BrowserQualifier.YANDEX) {
                            return WebBrowserManager.isYandexBrowser((WebBrowser)browser);
                        }
                    }
                    return false;
                };
                List browsers = browserManager.getBrowsers(browserCondition, true);
                if (browsers.isEmpty()) {
                    browsers = browserManager.getBrowsers(browserCondition, false);
                }
                WebBrowser webBrowser = browsers.isEmpty() ? browserManager.getFirstBrowser(BrowserFamily.CHROME) : (WebBrowser)browsers.get(0);
                if (webBrowser == null) {
                    BrowserConnectionManager.$$$reportNull$$$0(18);
                }
                return webBrowser;
            }
            case FIREFOX: {
                WebBrowser webBrowser = browserManager.getFirstBrowser(BrowserFamily.FIREFOX);
                if (webBrowser == null) {
                    BrowserConnectionManager.$$$reportNull$$$0(19);
                }
                return webBrowser;
            }
            case OPERA: {
                WebBrowser webBrowser = browserManager.getFirstBrowser(BrowserFamily.OPERA);
                if (webBrowser == null) {
                    BrowserConnectionManager.$$$reportNull$$$0(20);
                }
                return webBrowser;
            }
        }
        throw new IllegalStateException();
    }

    @NotNull
    public Promise<?> ensureExtensionInstalled(@NotNull WebBrowser browser, @Nullable Project project) {
        if (browser == null) {
            BrowserConnectionManager.$$$reportNull$$$0(21);
        }
        if (this.findConnectedBrowser(browser) != null || JsFileUtil.isWebKitRuntime(browser)) {
            Promise promise2 = Promises.resolvedPromise();
            if (promise2 == null) {
                BrowserConnectionManager.$$$reportNull$$$0(22);
            }
            return promise2;
        }
        BrowserConnector connector = BrowserConnector.get(browser);
        Promise<?> promise3 = connector == null ? Promises.rejectedPromise() : connector.ensureExtensionInstalled(browser, project);
        if (promise3 == null) {
            BrowserConnectionManager.$$$reportNull$$$0(23);
        }
        return promise3;
    }

    public void launchBrowser(@NotNull WebBrowser browser, @Nullable Project project) {
        if (browser == null) {
            BrowserConnectionManager.$$$reportNull$$$0(24);
        }
        if (this.findConnectedBrowser(browser) != null) {
            return;
        }
        BrowserConnector connector = BrowserConnector.get(browser);
        String[] additionalParameters = connector == null ? ArrayUtil.EMPTY_STRING_ARRAY : connector.getLaunchParameters();
        BrowserLauncher.getInstance().browseUsingPath(null, null, browser, project, false, additionalParameters);
    }

    @NotNull
    public Promise<Double> attachInspector(@NotNull Client client, @NotNull CharSequence url, boolean usePreliminaryPage) {
        if (client == null) {
            BrowserConnectionManager.$$$reportNull$$$0(25);
        }
        if (url == null) {
            BrowserConnectionManager.$$$reportNull$$$0(26);
        }
        assert (this.rpcServer != null);
        Promise promise2 = this.rpcServer.call(client, "Debugger", "attach", new Object[]{url, usePreliminaryPage});
        if (promise2 == null) {
            BrowserConnectionManager.$$$reportNull$$$0(27);
        }
        return promise2;
    }

    public void openUrl(Client client, CharSequence url) {
        assert (this.rpcServer != null);
        this.rpcServer.send(client, "Dom", "openUrl", new Object[]{url});
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 27: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 27: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 21: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "browser";
                break;
            }
            case 3: 
            case 4: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/debugger/browserConnection/BrowserConnectionManager";
                break;
            }
            case 6: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "client";
                break;
            }
            case 7: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 16: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "browserQualifier";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/debugger/browserConnection/BrowserConnectionManager";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getConnectedBrowser";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "browserToQualifier";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "qualifierToBrowser";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "ensureExtensionInstalled";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "attachInspector";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addWebSocketServerListener";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getConnectedBrowser";
                break;
            }
            case 3: 
            case 4: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 27: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findConnectedBrowser";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getBrowser";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findClient";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "browserToQualifier";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "qualifierToBrowser";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "ensureExtensionInstalled";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "launchBrowser";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "attachInspector";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "lambda$qualifierToBrowser$3";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "lambda$findClient$2";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 27: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static final class BrowserConnectionRequestHandler
    extends WebSocketHandshakeHandler {
        BrowserConnectionRequestHandler() {
        }

        protected void serverCreated(@NotNull ClientManager server) {
            if (server == null) {
                BrowserConnectionRequestHandler.$$$reportNull$$$0(0);
            }
            BrowserConnectionManager browserConnectionManager = BrowserConnectionManager.getInstance();
            browserConnectionManager.server = server;
            browserConnectionManager.rpcServer = new JsonRpcServer(server);
            JsonRpcServerKt.registerFromEp((JsonRpcServer)browserConnectionManager.rpcServer);
        }

        public boolean isSupported(@NotNull FullHttpRequest request) {
            if (request == null) {
                BrowserConnectionRequestHandler.$$$reportNull$$$0(1);
            }
            return super.isSupported(request) && BrowserConnectionRequestHandler.checkPrefix((String)request.uri(), (String)"jsonRpc");
        }

        @NotNull
        protected MessageServer getMessageServer() {
            JsonRpcServer jsonRpcServer = BrowserConnectionManager.getInstance().rpcServer;
            if (jsonRpcServer == null) {
                BrowserConnectionRequestHandler.$$$reportNull$$$0(2);
            }
            return jsonRpcServer;
        }

        public void connected(@NotNull Client client, @Nullable Map<String, List<String>> parameters) {
            BrowserQualifier browserQualifier;
            String userAgent;
            String version;
            block13: {
                if (client == null) {
                    BrowserConnectionRequestHandler.$$$reportNull$$$0(3);
                }
                ((ClientListener)BrowserConnectionManager.getInstance().webSocketServerListenerEventDispatcher.getMulticaster()).connected(client, parameters);
                version = BrowserConnectionManager.safeGet("v", parameters);
                userAgent = BrowserConnectionManager.safeGet("f", parameters);
                LOG.info("Browser connected: version " + version + ", " + userAgent);
                if (userAgent != null) {
                    try {
                        browserQualifier = BrowserQualifier.valueOf(userAgent);
                    }
                    catch (IllegalArgumentException ignored) {
                        if (userAgent.contains("YaBrowser/")) {
                            browserQualifier = BrowserQualifier.YANDEX;
                            break block13;
                        }
                        if (userAgent.contains("(Dart)")) {
                            browserQualifier = BrowserQualifier.DARTIUM;
                            break block13;
                        }
                        if (userAgent.contains(" OPR/")) {
                            browserQualifier = BrowserQualifier.OPERA;
                            break block13;
                        }
                        browserQualifier = BrowserQualifier.CHROME;
                    }
                } else {
                    browserQualifier = BrowserQualifier.CHROME;
                }
            }
            BROWSER_KEY.set((UserDataHolder)client, (Object)browserQualifier);
            BrowserConnector connector = BrowserConnector.get(browserQualifier);
            if (connector == null) {
                LOG.warn("No connector for " + userAgent);
                return;
            }
            WebBrowser browser = BrowserConnectionManager.qualifierToBrowser(browserQualifier);
            connector.checkVersion(browser, version, null);
            Collection asyncResults = BrowserConnectionManager.getInstance().pendingActions.remove((Object)browserQualifier);
            if (asyncResults != null) {
                for (AsyncPromise asyncResult : asyncResults) {
                    try {
                        asyncResult.setResult((Object)client);
                    }
                    catch (Throwable e) {
                        LOG.error(e);
                    }
                }
            }
        }

        public void disconnected(@NotNull Client client) {
            if (client == null) {
                BrowserConnectionRequestHandler.$$$reportNull$$$0(4);
            }
            ((ClientListener)BrowserConnectionManager.getInstance().webSocketServerListenerEventDispatcher.getMulticaster()).disconnected(client);
            BrowserQualifier browserQualifier = (BrowserQualifier)((Object)BROWSER_KEY.get((UserDataHolder)client));
            if (browserQualifier != null) {
                BROWSER_KEY.set((UserDataHolder)client, null);
                LOG.info("Browser disconnected: " + (Object)((Object)browserQualifier));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "server";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "request";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/javascript/debugger/browserConnection/BrowserConnectionManager$BrowserConnectionRequestHandler";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "client";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/javascript/debugger/browserConnection/BrowserConnectionManager$BrowserConnectionRequestHandler";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMessageServer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "serverCreated";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "isSupported";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "connected";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "disconnected";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

