/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions;

import com.intellij.database.SynchronizeHandler;
import com.intellij.database.dataSource.DataSourceUiUtil;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPackage;
import com.intellij.database.psi.DbTable;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.LoaderContext;
import com.intellij.database.view.DatabaseView;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.hash.HashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class SynchronizeSchemaAction
extends AnAction
implements DumbAware {
    public SynchronizeSchemaAction() {
        super("Synchronize", null, PlatformIcons.SYNCHRONIZE_ICON);
    }

    public void update(@NotNull AnActionEvent e) {
        JBIterable<DbElement> selection;
        boolean enabled;
        if (e == null) {
            SynchronizeSchemaAction.$$$reportNull$$$0(0);
        }
        boolean visible = enabled = !(selection = DatabaseView.getSelectedElements(e.getDataContext(), true)).isEmpty();
        for (DbElement o : selection) {
            LocalDataSource dataSource = (LocalDataSource)ObjectUtils.tryCast((Object)o.getDataSource().getDelegate(), LocalDataSource.class);
            visible &= dataSource != null;
            enabled &= DbImplUtil.canConnectTo(o) && (dataSource == null || !dataSource.isLoading());
        }
        e.getPresentation().setVisible(visible || e.isFromActionToolbar());
        e.getPresentation().setEnabled(enabled);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            SynchronizeSchemaAction.$$$reportNull$$$0(1);
        }
        JBIterable<DbElement> selection = DatabaseView.getSelectedElements(e.getDataContext(), true);
        SynchronizeSchemaAction.refresh(e.getProject(), selection);
    }

    public static void refresh(Project project, JBIterable<DbElement> selection) {
        Map map = ContainerUtil.classify((Iterator)selection.iterator(), o -> o.getDataSource());
        HashSet dataSourceElements = new HashSet();
        dataSourceElements.addAll(map.keySet());
        if (project != null) {
            for (SynchronizeHandler handler : (SynchronizeHandler[])SynchronizeHandler.EP_NAME.getExtensions()) {
                handler.synchronizationStarted(project, (Set)dataSourceElements);
            }
        }
        for (DbDataSource element2 : dataSourceElements) {
            Set elements = (Set)map.get(element2);
            if (elements.contains(element2) && elements.size() > 1) {
                elements.retainAll(Collections.singletonList(element2));
            }
            SynchronizeSchemaAction.refresh(element2, elements);
        }
    }

    private static void refresh(DbDataSource element2, Collection<DbElement> selection) {
        DatabaseSystem delegate = element2.getDelegate();
        if (!(delegate instanceof LocalDataSource)) {
            return;
        }
        LocalDataSource dataSource = (LocalDataSource)delegate;
        LoaderContext context = SynchronizeSchemaAction.createLoaderContext(element2, selection, dataSource);
        DataSourceUiUtil.performManualSyncTask(context);
    }

    static LoaderContext createLoaderContext(@NotNull DbDataSource dataSourceElement, @NotNull Collection<? extends DbElement> selection, @NotNull LocalDataSource dataSource) {
        if (dataSourceElement == null) {
            SynchronizeSchemaAction.$$$reportNull$$$0(2);
        }
        if (selection == null) {
            SynchronizeSchemaAction.$$$reportNull$$$0(3);
        }
        if (dataSource == null) {
            SynchronizeSchemaAction.$$$reportNull$$$0(4);
        }
        LoaderContext context = new LoaderContext(dataSourceElement.getProject(), dataSource);
        boolean loadEverything = selection.contains(dataSourceElement);
        if (loadEverything) {
            context.includeAllSchemas();
        }
        if (selection.size() > 1 || !loadEverything) {
            for (DbElement dbElement : selection) {
                if (dbElement == dataSourceElement || dbElement.getDataSource() != dataSourceElement) continue;
                DbElement parent2 = dbElement.getParent();
                if (parent2 instanceof DbTable || dbElement instanceof DbPackage) {
                    context.include(parent2);
                    continue;
                }
                context.include(dbElement);
            }
        }
        return context;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSourceElement";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selection";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/actions/SynchronizeSchemaAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "createLoaderContext";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

