/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.diff;

import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.GridModel;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.diff.ObjectWrapper;
import com.intellij.database.diff.TableDiffBuilder;
import com.intellij.database.diff.TableDiffSettingsHolder;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.util.DbImplUtil;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import gnu.trove.TIntArrayList;
import gnu.trove.TIntHashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class TableDiffAdapter {
    private static final ObjectWrapper.HasherAndComparator<Object> DB_VALUE_HASHER = new ObjectWrapper.HasherAndComparator<Object>(){

        @Override
        public boolean equals(Object a, Object b2) {
            return DbImplUtil.valuesEqual(a, b2);
        }

        @Override
        public int hash(Object v) {
            return DbImplUtil.valueHashCode(v);
        }
    };

    public static TableDiffBuilder.Data adapt(@NotNull DataGrid grid1, @NotNull Iterable<ModelIndex<DataConsumer.Row>> skippedRows1, @NotNull Iterable<ModelIndex<DataConsumer.Column>> skippedCols1, @NotNull DataGrid grid2, @NotNull Iterable<ModelIndex<DataConsumer.Row>> skippedRows2, @NotNull Iterable<ModelIndex<DataConsumer.Column>> skippedCols2, @NotNull TableDiffSettingsHolder.Settings settings, @NotNull ProgressIndicator indicator, @NotNull TableDiffBuilder.TableDiffResult result2) {
        if (grid1 == null) {
            TableDiffAdapter.$$$reportNull$$$0(0);
        }
        if (skippedRows1 == null) {
            TableDiffAdapter.$$$reportNull$$$0(1);
        }
        if (skippedCols1 == null) {
            TableDiffAdapter.$$$reportNull$$$0(2);
        }
        if (grid2 == null) {
            TableDiffAdapter.$$$reportNull$$$0(3);
        }
        if (skippedRows2 == null) {
            TableDiffAdapter.$$$reportNull$$$0(4);
        }
        if (skippedCols2 == null) {
            TableDiffAdapter.$$$reportNull$$$0(5);
        }
        if (settings == null) {
            TableDiffAdapter.$$$reportNull$$$0(6);
        }
        if (indicator == null) {
            TableDiffAdapter.$$$reportNull$$$0(7);
        }
        if (result2 == null) {
            TableDiffAdapter.$$$reportNull$$$0(8);
        }
        return new TableDiffBuilder.Data(TableDiffAdapter.adapt(grid1, skippedRows1, skippedCols1, result2.skippedRows1, result2.skippedCols1), TableDiffAdapter.adapt(grid2, skippedRows2, skippedCols2, result2.skippedRows2, result2.skippedCols2), settings, indicator);
    }

    private static List<List<Object>> adapt(@NotNull DataGrid grid, @NotNull Iterable<ModelIndex<DataConsumer.Row>> skippedRows, @NotNull Iterable<ModelIndex<DataConsumer.Column>> skippedCols, @NotNull TIntArrayList skippedVisRows, @NotNull TIntArrayList skippedVisCols) {
        if (grid == null) {
            TableDiffAdapter.$$$reportNull$$$0(9);
        }
        if (skippedRows == null) {
            TableDiffAdapter.$$$reportNull$$$0(10);
        }
        if (skippedCols == null) {
            TableDiffAdapter.$$$reportNull$$$0(11);
        }
        if (skippedVisRows == null) {
            TableDiffAdapter.$$$reportNull$$$0(12);
        }
        if (skippedVisCols == null) {
            TableDiffAdapter.$$$reportNull$$$0(13);
        }
        ArrayList values2 = ContainerUtil.newArrayList();
        List cols = TableDiffAdapter.difference(grid, grid.getVisibleColumns().asIterable(), skippedCols);
        List rows = TableDiffAdapter.difference(grid, grid.getVisibleRows().asIterable(), skippedRows);
        GridModel model = grid.getDataModel(DataAccessType.DATABASE_DATA);
        for (JBIterable band : TableDiffAdapter.iterateCells(rows, cols, !grid.isTransposed())) {
            ArrayList row = ContainerUtil.newArrayList();
            for (Pair cell : band) {
                row.add(new ObjectWrapper<Object>(model.getValueAt((ModelIndex)cell.first, (ModelIndex)cell.second), DB_VALUE_HASHER));
            }
            values2.add(row);
        }
        TableDiffAdapter.generateSkipped(grid, rows, model.getRowCount(), !grid.isTransposed() ? skippedVisRows : skippedVisCols);
        TableDiffAdapter.generateSkipped(grid, cols, model.getColumnCount(), grid.isTransposed() ? skippedVisRows : skippedVisCols);
        return values2;
    }

    private static <T> void generateSkipped(@NotNull DataGrid grid, @NotNull Iterable<ModelIndex<T>> ids, int count2, @NotNull TIntArrayList skipped) {
        if (grid == null) {
            TableDiffAdapter.$$$reportNull$$$0(14);
        }
        if (ids == null) {
            TableDiffAdapter.$$$reportNull$$$0(15);
        }
        if (skipped == null) {
            TableDiffAdapter.$$$reportNull$$$0(16);
        }
        TIntHashSet existing = new TIntHashSet();
        for (ModelIndex<T> index2 : ids) {
            existing.add(index2.toView(grid).asInteger());
        }
        for (int i2 = 0; i2 < count2; ++i2) {
            if (existing.contains(i2)) continue;
            skipped.add(i2);
        }
    }

    private static JBIterable<JBIterable<Pair<ModelIndex<DataConsumer.Row>, ModelIndex<DataConsumer.Column>>>> iterateCells(Iterable<ModelIndex<DataConsumer.Row>> rows, Iterable<ModelIndex<DataConsumer.Column>> cols, boolean rowWise) {
        if (rowWise) {
            return JBIterable.from(rows).transform(row -> TableDiffAdapter.iterateRowCells(row, cols));
        }
        return JBIterable.from(cols).transform(col -> TableDiffAdapter.iterateColumnCells(col, rows));
    }

    @NotNull
    private static JBIterable<Pair<ModelIndex<DataConsumer.Row>, ModelIndex<DataConsumer.Column>>> iterateColumnCells(ModelIndex<DataConsumer.Column> col, Iterable<ModelIndex<DataConsumer.Row>> rows) {
        JBIterable jBIterable = JBIterable.from(rows).transform(row -> Pair.create((Object)row, (Object)col));
        if (jBIterable == null) {
            TableDiffAdapter.$$$reportNull$$$0(17);
        }
        return jBIterable;
    }

    @NotNull
    private static JBIterable<Pair<ModelIndex<DataConsumer.Row>, ModelIndex<DataConsumer.Column>>> iterateRowCells(ModelIndex<DataConsumer.Row> row, Iterable<ModelIndex<DataConsumer.Column>> cols) {
        JBIterable jBIterable = JBIterable.from(cols).transform(col -> Pair.create((Object)row, (Object)col));
        if (jBIterable == null) {
            TableDiffAdapter.$$$reportNull$$$0(18);
        }
        return jBIterable;
    }

    private static <T> List<ModelIndex<T>> difference(@NotNull DataGrid grid, @NotNull Iterable<ModelIndex<T>> visible, @NotNull Iterable<ModelIndex<T>> skipped) {
        if (grid == null) {
            TableDiffAdapter.$$$reportNull$$$0(19);
        }
        if (visible == null) {
            TableDiffAdapter.$$$reportNull$$$0(20);
        }
        if (skipped == null) {
            TableDiffAdapter.$$$reportNull$$$0(21);
        }
        ArrayList res2 = ContainerUtil.newArrayList();
        TIntHashSet sset = new TIntHashSet();
        for (ModelIndex<T> index2 : skipped) {
            sset.add(index2.asInteger());
        }
        for (ModelIndex<T> index2 : visible) {
            if (sset.contains(index2.asInteger())) continue;
            res2.add(index2);
        }
        Collections.sort(res2, (o1, o2) -> {
            if (grid == null) {
                TableDiffAdapter.$$$reportNull$$$0(30);
            }
            return Comparing.compare((int)o1.toView(grid).asInteger(), (int)o2.toView(grid).asInteger());
        });
        return res2;
    }

    public static TableDiffBuilder.TableDiffResult process(@NotNull DataGrid grid1, @NotNull Iterable<ModelIndex<DataConsumer.Row>> skippedRows1, @NotNull Iterable<ModelIndex<DataConsumer.Column>> skippedCols1, @NotNull DataGrid grid2, @NotNull Iterable<ModelIndex<DataConsumer.Row>> skippedRows2, @NotNull Iterable<ModelIndex<DataConsumer.Column>> skippedCols2, @NotNull TableDiffSettingsHolder.Settings settings, @NotNull ProgressIndicator indicator) {
        if (grid1 == null) {
            TableDiffAdapter.$$$reportNull$$$0(22);
        }
        if (skippedRows1 == null) {
            TableDiffAdapter.$$$reportNull$$$0(23);
        }
        if (skippedCols1 == null) {
            TableDiffAdapter.$$$reportNull$$$0(24);
        }
        if (grid2 == null) {
            TableDiffAdapter.$$$reportNull$$$0(25);
        }
        if (skippedRows2 == null) {
            TableDiffAdapter.$$$reportNull$$$0(26);
        }
        if (skippedCols2 == null) {
            TableDiffAdapter.$$$reportNull$$$0(27);
        }
        if (settings == null) {
            TableDiffAdapter.$$$reportNull$$$0(28);
        }
        if (indicator == null) {
            TableDiffAdapter.$$$reportNull$$$0(29);
        }
        TableDiffBuilder.TableDiffResult result2 = new TableDiffBuilder.TableDiffResult();
        TableDiffBuilder.TableDiffResult subRes = TableDiffBuilder.process(TableDiffAdapter.adapt(grid1, skippedRows1, skippedCols1, grid2, skippedRows2, skippedCols2, settings, indicator, result2));
        return result2.apply(subRes);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 17: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 17: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grid1";
                break;
            }
            case 1: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "skippedRows1";
                break;
            }
            case 2: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "skippedCols1";
                break;
            }
            case 3: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grid2";
                break;
            }
            case 4: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "skippedRows2";
                break;
            }
            case 5: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "skippedCols2";
                break;
            }
            case 6: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 7: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 9: 
            case 14: 
            case 19: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grid";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "skippedRows";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "skippedCols";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "skippedVisRows";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "skippedVisCols";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ids";
                break;
            }
            case 16: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "skipped";
                break;
            }
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/diff/TableDiffAdapter";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visible";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/diff/TableDiffAdapter";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "iterateColumnCells";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "iterateRowCells";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "adapt";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "generateSkipped";
                break;
            }
            case 17: 
            case 18: {
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "difference";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "process";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "lambda$difference$4";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 17: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

