/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.editors;

import com.intellij.database.schemaEditor.model.DeColumn;
import com.intellij.database.schemaEditor.model.DeTable;
import com.intellij.database.schemaEditor.model.DeTableKey;
import com.intellij.database.view.editors.DatabaseColumnRefEditor;
import com.intellij.database.view.editors.DatabaseEditorBaseEx;
import com.intellij.database.view.editors.DatabaseEditorCapabilities;
import com.intellij.database.view.editors.DatabaseEditorState;
import com.intellij.database.view.editors.DatabaseEditorUtil;
import com.intellij.database.view.editors.DatabaseKeyColumnEditor;
import com.intellij.database.view.models.ColumnEditorModel;
import com.intellij.database.view.models.EditorModelBase;
import com.intellij.database.view.models.EditorModelUtil;
import com.intellij.database.view.models.ObjectEditorModel;
import com.intellij.database.view.models.TableEditorModel;
import com.intellij.database.view.models.TableKeyEditorModel;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionToolbarPosition;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.table.TableView;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.ListTableModel;
import com.intellij.util.ui.table.JBListTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DatabaseKeyEditor
extends DatabaseEditorBaseEx
implements DatabaseEditorUtil.EmbeddableEditor {
    private final TableEditorModel myTableModel;
    private JTextField myNameField;
    private JPanel myMainPanel;
    private JPanel myTablePanel;
    private JComponent myBoxesPanel;
    private ListTableModel<DatabaseKeyColumnEditor> myColumnsTableModel;
    private final TableKeyEditorModel myTableKeyModel;
    private final DatabaseEditorCapabilities.KeyEditorCaps myCaps;
    private final EditorModelBase.Listener myChangeListener;
    private final Map<ColumnEditorModel, Disposable> mySubscribedColumns;
    private JBListTable myTable;
    private boolean myValid;

    public DatabaseKeyEditor(@NotNull DatabaseEditorState state, @NotNull TableKeyEditorModel model, @NotNull DatabaseEditorCapabilities.KeyEditorCaps caps) {
        if (state == null) {
            DatabaseKeyEditor.$$$reportNull$$$0(0);
        }
        if (model == null) {
            DatabaseKeyEditor.$$$reportNull$$$0(1);
        }
        if (caps == null) {
            DatabaseKeyEditor.$$$reportNull$$$0(2);
        }
        super(state);
        this.myChangeListener = new EditorModelBase.Listener(){

            @Override
            public void changed() {
                DatabaseKeyEditor.this.fromModelToUi();
            }
        };
        this.mySubscribedColumns = ContainerUtil.newHashMap();
        this.myTableKeyModel = model;
        this.myCaps = caps;
        this.myTableModel = this.myTableKeyModel.modelsCache.get(this.myTableKeyModel.getTable(), TableEditorModel.class);
        this.$$$setupUI$$$();
        this.applyCaps();
        this.setupControls();
    }

    private void applyCaps() {
        this.myNameField.setEnabled(this.myCaps.getRename().isAvailable());
    }

    @NotNull
    public DeTable getTable() {
        DeTable deTable = (DeTable)this.myTableModel.getObject();
        if (deTable == null) {
            DatabaseKeyEditor.$$$reportNull$$$0(3);
        }
        return deTable;
    }

    private void setupControls() {
        this.initSubscriptions();
        this.updateFromModel();
    }

    @Override
    public boolean canDoAnything() {
        return this.myCaps.canDoAnything();
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myMainPanel;
        if (jPanel == null) {
            DatabaseKeyEditor.$$$reportNull$$$0(4);
        }
        return jPanel;
    }

    @Override
    @NotNull
    public JComponent getPreferredFocusedComponent() {
        JTextField jTextField = this.myNameField;
        if (jTextField == null) {
            DatabaseKeyEditor.$$$reportNull$$$0(5);
        }
        return jTextField;
    }

    @Override
    @NotNull
    public JComponent[] getFocusableComponents() {
        JComponent[] jComponentArray = new JComponent[]{this.myNameField, this.myTable.getTable()};
        if (jComponentArray == null) {
            DatabaseKeyEditor.$$$reportNull$$$0(6);
        }
        return jComponentArray;
    }

    @NotNull
    public TableKeyEditorModel getTableKeyModel() {
        TableKeyEditorModel tableKeyEditorModel = this.myTableKeyModel;
        if (tableKeyEditorModel == null) {
            DatabaseKeyEditor.$$$reportNull$$$0(7);
        }
        return tableKeyEditorModel;
    }

    @Override
    @NotNull
    public ObjectEditorModel<DeTableKey> getModel() {
        TableKeyEditorModel tableKeyEditorModel = this.getTableKeyModel();
        if (tableKeyEditorModel == null) {
            DatabaseKeyEditor.$$$reportNull$$$0(8);
        }
        return tableKeyEditorModel;
    }

    @Override
    protected void updateFromModelImpl() {
        int i2;
        DatabaseKeyEditor.setValue(this.myNameField, this.myTableKeyModel.getName());
        ArrayList items = ContainerUtil.newArrayList((Iterable)this.myColumnsTableModel.getItems());
        int count2 = this.myTableKeyModel.getColumnsCount();
        if (items.size() > count2) {
            items.subList(count2, items.size()).clear();
        } else {
            for (i2 = items.size(); i2 < count2; ++i2) {
                items.add(new DatabaseKeyColumnEditor(this, this.myCaps.getColumnEditorCaps()));
            }
        }
        for (i2 = 0; i2 < items.size(); ++i2) {
            ((DatabaseKeyColumnEditor)items.get(i2)).updateFromModel(i2);
        }
        if (!items.equals(this.myColumnsTableModel.getItems())) {
            this.myColumnsTableModel.setItems((List)items);
        }
        this.myValid = true;
        for (DatabaseKeyColumnEditor item : items) {
            this.myValid &= item.isObjectValid();
        }
        this.updateColumnSubscriptions();
    }

    private void updateColumnSubscriptions() {
        HashSet subs = ContainerUtil.newHashSet();
        for (DeColumn deColumn : this.myTableKeyModel.getColumns()) {
            if (EditorModelUtil.isStub(deColumn)) continue;
            ColumnEditorModel m = this.myTableKeyModel.modelsCache.get(deColumn, ColumnEditorModel.class);
            if (!this.mySubscribedColumns.containsKey(m)) {
                Disposable holder = new Disposable(){

                    public void dispose() {
                    }
                };
                Disposer.register((Disposable)this, (Disposable)holder);
                m.addListener(this.myChangeListener, holder);
                this.mySubscribedColumns.put(m, holder);
            }
            subs.add(m);
        }
        for (Map.Entry entry : ContainerUtil.newArrayList(this.mySubscribedColumns.entrySet())) {
            if (subs.contains(entry.getKey())) continue;
            Disposer.dispose((Disposable)((Disposable)entry.getValue()));
            this.mySubscribedColumns.remove(entry.getKey());
        }
    }

    private void initSubscriptions() {
        this.myTableKeyModel.addListener(this.myChangeListener, this);
        this.myNameField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (!DatabaseKeyEditor.this.myUpdating) {
                    DatabaseKeyEditor.this.myTableKeyModel.setName(DatabaseKeyEditor.this.myNameField.getText());
                    DatabaseKeyEditor.this.myTableKeyModel.commit();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/view/editors/DatabaseKeyEditor$3", "textChanged"));
            }
        });
        this.myTableModel.addListener(this.myChangeListener, this);
    }

    private void createUIComponents() {
        this.myBoxesPanel = new Box(0);
        this.myColumnsTableModel = DatabaseEditorUtil.createTableModel(this.myTableKeyModel, new DatabaseEditorUtil.EditorModelHelper<DatabaseKeyColumnEditor>(){

            @Override
            @Nullable
            public DatabaseKeyColumnEditor createRow() {
                ArrayList columns = ContainerUtil.newArrayList(DatabaseKeyEditor.this.myTableKeyModel.getColumns());
                columns.add(DatabaseKeyEditor.this.getTable().columns.isEmpty() ? DatabaseColumnRefEditor.createStub("", DatabaseKeyEditor.this.getTable()) : DatabaseKeyEditor.this.getTable().columns.get(0));
                DatabaseKeyEditor.this.myTableKeyModel.setColumns(columns);
                return new DatabaseKeyColumnEditor(DatabaseKeyEditor.this, DatabaseKeyEditor.this.myCaps.getColumnEditorCaps());
            }

            @Override
            public boolean removeRow(DatabaseKeyColumnEditor item, int idx) {
                ArrayList columns = ContainerUtil.newArrayList(DatabaseKeyEditor.this.myTableKeyModel.getColumns());
                columns.remove(idx);
                DatabaseKeyEditor.this.myTableKeyModel.setColumns(columns);
                return true;
            }

            @Override
            public boolean exchangeRows(DatabaseKeyColumnEditor item0, int idx0, DatabaseKeyColumnEditor item1, int idx1) {
                ArrayList columns = ContainerUtil.newArrayList(DatabaseKeyEditor.this.myTableKeyModel.getColumns());
                DeColumn tmp = (DeColumn)columns.get(idx0);
                columns.set(idx0, columns.get(idx1));
                columns.set(idx1, tmp);
                DatabaseKeyEditor.this.myTableKeyModel.setColumns(columns);
                return true;
            }
        }, true);
        TableView view = new TableView();
        view.setModelAndUpdateColumns(this.myColumnsTableModel);
        this.myTable = DatabaseEditorUtil.createTableWithEditor(this.myColumnsTableModel, this, -1, JBUI.scale((int)300), null);
        this.myTablePanel = new JPanel(new BorderLayout());
        JPanel panel = ToolbarDecorator.createDecorator((JTable)this.myTable.getTable()).setToolbarPosition(ActionToolbarPosition.LEFT).createPanel();
        DatabaseEditorUtil.setTableDecoratorMinSize(panel, (JTable)this.myTable.getTable());
        this.myTablePanel.add((Component)panel, "Center");
    }

    public int getIndex(@NotNull DatabaseKeyColumnEditor editor) {
        if (editor == null) {
            DatabaseKeyEditor.$$$reportNull$$$0(9);
        }
        return this.myColumnsTableModel.getItems().indexOf(editor);
    }

    @Override
    @NotNull
    public Iterable<Pair<String, TextAttributesKey>> getRowText() {
        DatabaseEditorUtil.ColoredFragmentsBuilder res2 = new DatabaseEditorUtil.ColoredFragmentsBuilder();
        res2.append(this.myTableKeyModel.getName());
        res2.append(((DeTableKey)this.myTableKeyModel.getObject()).isPrimary() ? " PRIMARY KEY " : " KEY ");
        res2.append(this.getTableKey().getTableName());
        res2.append(" (");
        int idx = 0;
        for (DeColumn column2 : this.myTableKeyModel.getColumns()) {
            if (idx != 0) {
                res2.append(", ");
            }
            res2.appendRef(this.getObjectName(column2), DatabaseKeyEditor.isGood(column2));
            ++idx;
        }
        res2.append(")");
        Iterable<Pair<String, TextAttributesKey>> iterable = res2.build();
        if (iterable == null) {
            DatabaseKeyEditor.$$$reportNull$$$0(10);
        }
        return iterable;
    }

    @Override
    public boolean isObjectValid() {
        return this.myValid;
    }

    @NotNull
    public DeTableKey getTableKey() {
        DeTableKey deTableKey = (DeTableKey)this.myTableKeyModel.getObject();
        if (deTableKey == null) {
            DatabaseKeyEditor.$$$reportNull$$$0(11);
        }
        return deTableKey;
    }

    @NotNull
    public JTextField getNameEditor() {
        JTextField jTextField = this.myNameField;
        if (jTextField == null) {
            DatabaseKeyEditor.$$$reportNull$$$0(12);
        }
        return jTextField;
    }

    @NotNull
    public ListTableModel<DatabaseKeyColumnEditor> getColumnsListModel() {
        ListTableModel<DatabaseKeyColumnEditor> listTableModel = this.myColumnsTableModel;
        if (listTableModel == null) {
            DatabaseKeyEditor.$$$reportNull$$$0(13);
        }
        return listTableModel;
    }

    public void addComponent(@NotNull JComponent comp) {
        if (comp == null) {
            DatabaseKeyEditor.$$$reportNull$$$0(14);
        }
        this.myBoxesPanel.add(comp);
    }

    @Override
    @NotNull
    public DatabaseEditorCapabilities.KeyEditorCaps getCaps() {
        DatabaseEditorCapabilities.KeyEditorCaps keyEditorCaps = this.myCaps;
        if (keyEditorCaps == null) {
            DatabaseKeyEditor.$$$reportNull$$$0(15);
        }
        return keyEditorCaps;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caps";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/view/editors/DatabaseKeyEditor";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comp";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/view/editors/DatabaseKeyEditor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTable";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreferredFocusedComponent";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFocusableComponents";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getTableKeyModel";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getModel";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getRowText";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getTableKey";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getNameEditor";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getColumnsListModel";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getCaps";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getIndex";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "addComponent";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JTextField jTextField;
        JPanel jPanel;
        this.createUIComponents();
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JBLabel jBLabel = new JBLabel();
        jBLabel.setText("Name:");
        jBLabel.setDisplayedMnemonic('N');
        jBLabel.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel2 = this.myTablePanel;
        jPanel.add((Component)jPanel2, new GridConstraints(1, 1, 3, 1, 0, 3, 7, 3, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText("Columns:");
        jBLabel2.setDisplayedMnemonic('C');
        jBLabel2.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jBLabel2, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myNameField = jTextField = new JTextField();
        jTextField.setColumns(15);
        jPanel.add((Component)jTextField, new GridConstraints(1, 0, 1, 1, 0, 1, 0, 0, null, null, null));
        JComponent jComponent = this.myBoxesPanel;
        jPanel.add((Component)jComponent, new GridConstraints(2, 0, 1, 1, 4, 2, 3, 3, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }
}

