/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.ui;

import com.intellij.database.DatabaseMessages;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicMateNamespace;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.model.basic.BasicTable;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.meta.BasicMetaObject;
import com.intellij.database.schemaEditor.model.DeColumn;
import com.intellij.database.schemaEditor.model.DeNamespace;
import com.intellij.database.schemaEditor.model.DeObject;
import com.intellij.database.schemaEditor.model.DeTable;
import com.intellij.database.schemaEditor.model.DeTableChild;
import com.intellij.database.view.editors.DatabaseEditorBaseEx;
import com.intellij.database.view.editors.DatabaseEditorCapabilities;
import com.intellij.database.view.editors.DatabaseEditorContext;
import com.intellij.database.view.editors.DatabaseTableEditor;
import com.intellij.database.view.models.TableEditorModel;
import com.intellij.database.view.ui.AbstractDbRefactoringDialog;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.util.containers.JBTreeTraverser;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbTableDialog
extends AbstractDbRefactoringDialog<DatabaseTableEditor> {
    protected TableEditorModel myTableModel;

    public DbTableDialog(@NotNull DatabaseEditorContext context) {
        if (context == null) {
            DbTableDialog.$$$reportNull$$$0(0);
        }
        super(context);
    }

    @Override
    @NotNull
    protected String getTitle(boolean modify) {
        String string = modify ? "Modify Table" : DatabaseMessages.message((String)"action.add.new.table.title", (Object[])new Object[0]);
        if (string == null) {
            DbTableDialog.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    protected DatabaseEditorCapabilities.TableEditorCaps getTableEditorCaps(boolean existing) {
        DatabaseEditorCapabilities.TableEditorCaps tableEditorCaps = this.getContext().getDialect().getSchemaEditor().getDbEditorCaps().getTableEditorCaps(existing);
        if (tableEditorCaps == null) {
            DbTableDialog.$$$reportNull$$$0(2);
        }
        return tableEditorCaps;
    }

    public void setObject(@NotNull DeObject object, boolean allowEverything) {
        if (object == null) {
            DbTableDialog.$$$reportNull$$$0(3);
        }
        if (object.model != this.myModel) {
            throw new AssertionError((Object)"Invalid object");
        }
        DeTable table = null;
        if (object instanceof DeTable) {
            table = (DeTable)object;
        }
        if (object instanceof DeTableChild) {
            table = ((DeTableChild)object).table;
        }
        if (table == null) {
            throw new AssertionError((Object)"Invalid object");
        }
        this.setTable(table, allowEverything);
    }

    public void setTable(@NotNull DeTable table, boolean allowEverything) {
        if (table == null) {
            DbTableDialog.$$$reportNull$$$0(4);
        }
        if (table.model != this.myModel) {
            throw new AssertionError((Object)"Invalid table");
        }
        this.myTableModel = this.myEditorModelsCache.get(table, TableEditorModel.class);
        this.setEditor(new DatabaseTableEditor(this.myState, this.getTableEditorCaps(!allowEverything && table.getEditedObject() != null), this.myTableModel));
    }

    @Override
    protected boolean isRefactoringValid() {
        boolean supportsEmptyTables = this.getContext().getDialect().supportsEmptyTables();
        boolean notEmpty = !this.myTableModel.getColumns().isEmpty();
        return (supportsEmptyTables || notEmpty) && super.isRefactoringValid();
    }

    @Override
    protected ValidationInfo doValidate() {
        ValidationInfo info = ((DatabaseTableEditor)this.myEditor).validate();
        return info == null ? super.doValidate() : info;
    }

    @NotNull
    public DeTable createTable(@Nullable BasicSchema schema, @NotNull String defaultName, @NotNull Collection<String> columnNames) {
        if (defaultName == null) {
            DbTableDialog.$$$reportNull$$$0(5);
        }
        if (columnNames == null) {
            DbTableDialog.$$$reportNull$$$0(6);
        }
        this.checkObjectInContext(schema);
        DeNamespace deSchema = null;
        if (schema != null) {
            deSchema = (DeNamespace)this.export(schema, false);
        }
        DeTable table = new DeTable(defaultName, deSchema, this.myModel);
        for (String name : columnNames) {
            table.columns.add(new DeColumn(name, table, this.myModel));
        }
        if (deSchema != null) {
            deSchema.addLightChild(table);
        } else {
            this.myModel.addRoot(table);
        }
        DeTable deTable = table;
        if (deTable == null) {
            DbTableDialog.$$$reportNull$$$0(7);
        }
        return deTable;
    }

    @NotNull
    public DeTable createTable(@Nullable BasicSchema schema, @NotNull DeTable template) {
        if (template == null) {
            DbTableDialog.$$$reportNull$$$0(8);
        }
        this.checkObjectInContext(schema);
        DeNamespace deSchema = null;
        if (schema != null) {
            deSchema = (DeNamespace)this.export(schema, false);
        }
        DeTable table = this.copyExport(template, true);
        table.parent = deSchema;
        if (deSchema != null) {
            deSchema.addLightChild(table);
        } else {
            this.myModel.addRoot(table);
        }
        DeTable deTable = table;
        if (deTable == null) {
            DbTableDialog.$$$reportNull$$$0(9);
        }
        return deTable;
    }

    @NotNull
    public DeObject createEmptyTemplate(@Nullable BasicElement parent2) {
        this.checkObjectInContext(parent2);
        DeObject tableParent = this.exportTableParent(parent2);
        DeTable table = new DeTable("new_table", tableParent, this.myModel);
        if (table.parent != null) {
            table.parent.addLightChild(table);
        } else {
            this.myModel.addRoot(table);
        }
        DeTable deTable = table;
        if (deTable == null) {
            DbTableDialog.$$$reportNull$$$0(10);
        }
        return deTable;
    }

    @Nullable
    private DeObject exportTableParent(@Nullable BasicElement parent2) {
        Object candidate = this.exportOp(parent2, false);
        if (parent2 == null || parent2.familyOf(ObjectKind.TABLE) != null) {
            return candidate;
        }
        BasicMetaObject meta = parent2.getMetaObject();
        BasicMetaObject table = (BasicMetaObject)((JBTreeTraverser)((JBTreeTraverser)JBTreeTraverser.of(o -> o.children).withRoot((Object)meta)).filter(o -> o.kind == ObjectKind.TABLE)).bfsTraversal().first();
        if (table == null || table.getParent() == null) {
            return null;
        }
        BasicElement preParent = this.findAnyByMeta(parent2, table.getParent());
        Object res2 = this.exportOp(preParent, false);
        if (preParent.getMetaObject() != table.getParent()) {
            res2 = this.createEmptyParents((DeObject)res2, preParent.getMetaObject(), table.getParent());
        }
        return res2;
    }

    @Nullable
    private DeObject createEmptyParents(@NotNull DeObject parent2, @NotNull BasicMetaObject cur, @NotNull BasicMetaObject target) {
        BasicMetaObject child;
        if (parent2 == null) {
            DbTableDialog.$$$reportNull$$$0(11);
        }
        if (cur == null) {
            DbTableDialog.$$$reportNull$$$0(12);
        }
        if (target == null) {
            DbTableDialog.$$$reportNull$$$0(13);
        }
        if ((child = this.findChild(cur, target)) == null) {
            return null;
        }
        if (child.kind != ObjectKind.SCHEMA) {
            return null;
        }
        DeNamespace obj2 = new DeNamespace("", child.kind, parent2.model);
        parent2.addLightChild(obj2);
        if (child == target) {
            return obj2;
        }
        return this.createEmptyParents(obj2, child, target);
    }

    @NotNull
    private BasicElement findAnyByMeta(@NotNull BasicElement parent2, @NotNull BasicMetaObject target) {
        BasicMetaObject parentMeta;
        BasicMetaObject tmp;
        Family<? extends BasicElement> family;
        if (parent2 == null) {
            DbTableDialog.$$$reportNull$$$0(14);
        }
        if (target == null) {
            DbTableDialog.$$$reportNull$$$0(15);
        }
        Family<? extends BasicElement> family2 = family = (tmp = this.findChild(parentMeta = parent2.getMetaObject(), target)) == null ? null : parent2.familyOf(tmp.kind);
        if (family == null) {
            BasicElement basicElement = parent2;
            if (basicElement == null) {
                DbTableDialog.$$$reportNull$$$0(16);
            }
            return basicElement;
        }
        BasicElement child = family.find(o -> o instanceof BasicMateNamespace && ((BasicMateNamespace)o).isCurrent());
        if (child == null) {
            BasicElement basicElement = parent2;
            if (basicElement == null) {
                DbTableDialog.$$$reportNull$$$0(17);
            }
            return basicElement;
        }
        if (tmp == target) {
            BasicElement basicElement = child;
            if (basicElement == null) {
                DbTableDialog.$$$reportNull$$$0(18);
            }
            return basicElement;
        }
        BasicElement basicElement = this.findAnyByMeta(child, target);
        if (basicElement == null) {
            DbTableDialog.$$$reportNull$$$0(19);
        }
        return basicElement;
    }

    @Nullable
    private BasicMetaObject findChild(@NotNull BasicMetaObject parent2, @NotNull BasicMetaObject target) {
        BasicMetaObject tmp;
        if (parent2 == null) {
            DbTableDialog.$$$reportNull$$$0(20);
        }
        if (target == null) {
            DbTableDialog.$$$reportNull$$$0(21);
        }
        for (tmp = target; tmp != null && tmp.getParent() != parent2; tmp = tmp.getParent()) {
        }
        return tmp;
    }

    public void configureForModification(@NotNull BasicElement object, boolean allowEverything) {
        if (object == null) {
            DbTableDialog.$$$reportNull$$$0(22);
        }
        this.checkObjectInContext(object);
        if (object.getParent() instanceof BasicTable) {
            this.export(object.getParent(), true);
        }
        this.configureForModification((DeObject)this.export(object, true), allowEverything);
    }

    public void configureForModification(@NotNull DeObject object, boolean allowEverything) {
        if (object == null) {
            DbTableDialog.$$$reportNull$$$0(23);
        }
        if (object.model != this.myModel) {
            throw new AssertionError((Object)"Invalid object");
        }
        this.setObject(object, allowEverything);
        this.setRefactoring(true);
    }

    public void configureForCreation(@NotNull DeObject object, boolean allowEverything) {
        if (object == null) {
            DbTableDialog.$$$reportNull$$$0(24);
        }
        this.setObject(object, allowEverything);
    }

    @Nullable
    public DatabaseEditorBaseEx startItemEditing(@NotNull DeObject object) {
        if (object == null) {
            DbTableDialog.$$$reportNull$$$0(25);
        }
        return ((DatabaseTableEditor)this.myEditor).startItemEditing(object);
    }

    @Override
    @NotNull
    public DatabaseEditorBaseEx getActiveEditor() {
        DatabaseEditorBaseEx databaseEditorBaseEx = ((DatabaseTableEditor)this.myEditor).getActiveEditor();
        if (databaseEditorBaseEx == null) {
            DbTableDialog.$$$reportNull$$$0(26);
        }
        return databaseEditorBaseEx;
    }

    @Nullable
    protected String getHelpId() {
        return "reference.tools.datasource.table.modify";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 7: 
            case 9: 
            case 10: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 26: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 7: 
            case 9: 
            case 10: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 26: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 2: 
            case 7: 
            case 9: 
            case 10: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/view/ui/DbTableDialog";
                break;
            }
            case 3: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultName";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columnNames";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "template";
                break;
            }
            case 11: 
            case 14: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cur";
                break;
            }
            case 13: 
            case 15: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/view/ui/DbTableDialog";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getTitle";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTableEditorCaps";
                break;
            }
            case 7: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createTable";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createEmptyTemplate";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "findAnyByMeta";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getActiveEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 7: 
            case 9: 
            case 10: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 26: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setObject";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setTable";
                break;
            }
            case 5: 
            case 6: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createTable";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createEmptyParents";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "findAnyByMeta";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "findChild";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "configureForModification";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "configureForCreation";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "startItemEditing";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 7: 
            case 9: 
            case 10: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 26: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

