/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.http.request.run;

import com.intellij.execution.process.ProcessHandler;
import com.intellij.openapi.progress.ProgressIndicator;
import java.io.OutputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HttpClientRequestProcessHandler
extends ProcessHandler {
    public static final int SUCCEED = 0;
    public static final int INTERRUPTED = 1;
    public static final int INTERRUPTED_POST_PROCESSING = 2;
    private ProgressIndicator myPostProcessorIndicator = null;
    private final HttpClientTestsProcessHandler myPostProcessorHandler;

    public HttpClientRequestProcessHandler(boolean withPostProcessor) {
        this.myPostProcessorHandler = withPostProcessor ? new HttpClientTestsProcessHandler() : null;
    }

    public void setPostProcessorIndicator(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            HttpClientRequestProcessHandler.$$$reportNull$$$0(0);
        }
        this.myPostProcessorIndicator = indicator;
    }

    @Nullable
    public ProcessHandler getPostProcessorHandler() {
        return this.myPostProcessorHandler;
    }

    public void startNotify() {
        super.startNotify();
        if (this.myPostProcessorHandler != null) {
            this.myPostProcessorHandler.startNotify();
        }
    }

    public void onRunFinished() {
        if (this.isProcessTerminating() || this.isProcessTerminated()) {
            return;
        }
        this.notifyProcessTerminated(0);
        if (this.myPostProcessorHandler != null && !this.myPostProcessorHandler.isProcessTerminating() && !this.myPostProcessorHandler.isProcessTerminated()) {
            this.myPostProcessorHandler.notifyProcessTerminated(0);
        }
    }

    public boolean isProcessTerminated() {
        return super.isProcessTerminated() && (this.myPostProcessorHandler == null || this.myPostProcessorHandler.isProcessTerminated());
    }

    public boolean isProcessTerminating() {
        return super.isProcessTerminating() && (this.myPostProcessorHandler == null || this.myPostProcessorHandler.isProcessTerminating());
    }

    protected void destroyProcessImpl() {
        boolean onPostProcessing = this.myPostProcessorIndicator != null && this.myPostProcessorIndicator.isRunning();
        this.notifyProcessTerminated(onPostProcessing ? 2 : 1);
        if (this.myPostProcessorHandler != null) {
            this.myPostProcessorHandler.destroyProcess();
        }
        if (this.myPostProcessorIndicator != null && !this.myPostProcessorIndicator.isCanceled()) {
            this.myPostProcessorIndicator.cancel();
        }
    }

    protected void detachProcessImpl() {
        this.notifyProcessDetached();
        if (this.myPostProcessorHandler != null) {
            this.myPostProcessorHandler.detachProcess();
        }
    }

    public boolean detachIsDefault() {
        return false;
    }

    public OutputStream getProcessInput() {
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/ws/http/request/run/HttpClientRequestProcessHandler", "setPostProcessorIndicator"));
    }

    private static class HttpClientTestsProcessHandler
    extends ProcessHandler {
        private HttpClientTestsProcessHandler() {
        }

        public void notifyProcessTerminated(int exitCode) {
            super.notifyProcessTerminated(exitCode);
        }

        protected void destroyProcessImpl() {
            this.notifyProcessTerminated(2);
        }

        protected void detachProcessImpl() {
            this.notifyProcessTerminated(2);
        }

        public boolean detachIsDefault() {
            return false;
        }

        @Nullable
        public OutputStream getProcessInput() {
            return null;
        }
    }
}

