/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.puppet.psi;

import com.intellij.lang.Language;
import com.intellij.lang.puppet.PuppetLanguage;
import com.intellij.lang.puppet.psi.PuppetCompositePsiElement;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.AtomicNullableLazyValue;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.impl.light.LightElement;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PuppetLazyProxyLightElement
extends LightElement
implements PuppetCompositePsiElement,
PsiNamedElement {
    @NotNull
    private final String myName;
    @NotNull
    private final String myFileUrl;
    @NotNull
    private final Project myProject;
    private final int myFileOffset;
    @Nullable
    private final String myTypeName;
    private final AtomicNullableLazyValue<VirtualFile> myTargetVirtualFileProvider;
    private final AtomicNullableLazyValue<PsiFile> myTargetPsiFileProvider;
    private final AtomicNullableLazyValue<PsiElement> myTargetProvider;

    public PuppetLazyProxyLightElement(@NotNull Project project, @NotNull String name, @NotNull String fileUrl, int fileOffset, @Nullable String typeName) {
        if (project == null) {
            PuppetLazyProxyLightElement.$$$reportNull$$$0(0);
        }
        if (name == null) {
            PuppetLazyProxyLightElement.$$$reportNull$$$0(1);
        }
        if (fileUrl == null) {
            PuppetLazyProxyLightElement.$$$reportNull$$$0(2);
        }
        super(PsiManager.getInstance((Project)project), (Language)PuppetLanguage.INSTANCE);
        this.myTargetVirtualFileProvider = new AtomicNullableLazyValue<VirtualFile>(){

            @Nullable
            protected VirtualFile compute() {
                return VirtualFileManager.getInstance().findFileByUrl(PuppetLazyProxyLightElement.this.myFileUrl);
            }
        };
        this.myTargetPsiFileProvider = new AtomicNullableLazyValue<PsiFile>(){

            @Nullable
            protected PsiFile compute() {
                VirtualFile virtualFile = (VirtualFile)PuppetLazyProxyLightElement.this.myTargetVirtualFileProvider.getValue();
                return virtualFile == null ? null : PuppetLazyProxyLightElement.this.getManager().findFile(virtualFile);
            }
        };
        this.myTargetProvider = new AtomicNullableLazyValue<PsiElement>(){

            @Nullable
            protected PsiElement compute() {
                PsiFile file = (PsiFile)PuppetLazyProxyLightElement.this.myTargetPsiFileProvider.getValue();
                return file == null ? null : file.findElementAt(PuppetLazyProxyLightElement.this.myFileOffset);
            }
        };
        this.myName = name;
        this.myFileUrl = fileUrl;
        this.myFileOffset = fileOffset;
        this.myProject = project;
        this.myTypeName = typeName;
    }

    @Nullable
    public String getTypeName() {
        return this.myTypeName;
    }

    public String toString() {
        VirtualFile targetFile = this.getVirtualFile();
        return "PuppetLazyProxyLightElement: " + this.myName + " at " + this.myFileOffset + " in " + (targetFile == null ? null : targetFile.getName());
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            PuppetLazyProxyLightElement.$$$reportNull$$$0(3);
        }
        return string;
    }

    public PsiFile getContainingFile() {
        return (PsiFile)this.myTargetPsiFileProvider.getValue();
    }

    @Nullable
    public VirtualFile getVirtualFile() {
        return (VirtualFile)this.myTargetVirtualFileProvider.getValue();
    }

    @NotNull
    public PsiElement getNavigationElement() {
        PsiElement computedValue = (PsiElement)this.myTargetProvider.getValue();
        PsiElement psiElement = computedValue == null ? super.getNavigationElement() : computedValue;
        if (psiElement == null) {
            PuppetLazyProxyLightElement.$$$reportNull$$$0(4);
        }
        return psiElement;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PuppetLazyProxyLightElement element = (PuppetLazyProxyLightElement)o;
        if (this.myFileOffset != element.myFileOffset) {
            return false;
        }
        if (!this.myName.equals(element.myName)) {
            return false;
        }
        if (!this.myFileUrl.equals(element.myFileUrl)) {
            return false;
        }
        return this.myProject.equals(element.myProject);
    }

    public int hashCode() {
        int result = this.myName.hashCode();
        result = 31 * result + this.myFileUrl.hashCode();
        result = 31 * result + this.myProject.hashCode();
        result = 31 * result + this.myFileOffset;
        return result;
    }

    public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            PuppetLazyProxyLightElement.$$$reportNull$$$0(5);
        }
        throw new IncorrectOperationException("Unavailable");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileUrl";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/puppet/psi/PuppetLazyProxyLightElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/puppet/psi/PuppetLazyProxyLightElement";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getNavigationElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

