/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.auth;

import com.intellij.concurrency.JobScheduler;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.NamedRunnable;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.impl.GenericNotifierImpl;
import com.intellij.openapi.vcs.ui.VcsBalloonProblemNotifier;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.Consumer;
import com.intellij.util.ThreeState;
import com.intellij.util.net.HttpConfigurable;
import com.intellij.util.proxy.CommonProxy;
import java.awt.Component;
import java.awt.Point;
import java.io.File;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.RootsToWorkingCopies;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnConfigurable;
import org.jetbrains.idea.svn.SvnConfiguration;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.WorkingCopy;
import org.jetbrains.idea.svn.api.ClientFactory;
import org.jetbrains.idea.svn.api.Revision;
import org.jetbrains.idea.svn.api.Target;
import org.jetbrains.idea.svn.api.Url;
import org.jetbrains.idea.svn.auth.AuthenticationData;
import org.jetbrains.idea.svn.auth.SvnAuthenticationManager;
import org.jetbrains.idea.svn.auth.SvnInteractiveAuthenticationProvider;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.info.Info;
import org.jetbrains.idea.svn.info.InfoClient;

public class SvnAuthenticationNotifier
extends GenericNotifierImpl<AuthenticationRequest, Url> {
    private static final Logger LOG = Logger.getInstance(SvnAuthenticationNotifier.class);
    private static final List<String> ourAuthKinds = Arrays.asList("svn.simple", "svn.ssh", "svn.ssl.client-passphrase", "svn.username", "svn.ssl.server", "svn.ssh.server");
    private final SvnVcs myVcs;
    private final RootsToWorkingCopies myRootsToWorkingCopies;
    private final Map<Url, Boolean> myCopiesPassiveResults;
    private ScheduledFuture<?> myTimer;
    private volatile boolean myVerificationInProgress;

    public SvnAuthenticationNotifier(SvnVcs svnVcs) {
        super(svnVcs.getProject(), svnVcs.getDisplayName(), "Not Logged In to Subversion", NotificationType.ERROR);
        this.myVcs = svnVcs;
        this.myRootsToWorkingCopies = this.myVcs.getRootsToWorkingCopies();
        this.myCopiesPassiveResults = Collections.synchronizedMap(new HashMap());
        this.myVerificationInProgress = false;
    }

    public void init() {
        if (this.myTimer != null) {
            this.stop();
        }
        this.myTimer = JobScheduler.getScheduler().scheduleWithFixedDelay(this.myCopiesPassiveResults::clear, 10L, 600L, TimeUnit.SECONDS);
    }

    public void stop() {
        this.myTimer.cancel(false);
        this.myTimer = null;
    }

    protected boolean ask(AuthenticationRequest obj, String description) {
        if (this.myVerificationInProgress) {
            return this.showAlreadyChecking();
        }
        this.myVerificationInProgress = true;
        Ref resultRef = new Ref();
        Runnable checker = () -> {
            try {
                boolean result = SvnAuthenticationNotifier.interactiveValidation(obj.myProject, obj.getUrl(), obj.getRealm(), obj.getKind());
                SvnAuthenticationNotifier.log("ask result for: " + obj.getUrl() + " is: " + result);
                resultRef.set((Object)result);
                if (result) {
                    this.onStateChangedToSuccess(obj);
                }
            }
            finally {
                this.myVerificationInProgress = false;
            }
        };
        Application application = ApplicationManager.getApplication();
        if (!application.isReadAccessAllowed() && ProgressManager.getInstance().hasProgressIndicator()) {
            checker.run();
            return (Boolean)resultRef.get();
        }
        application.executeOnPooledThread(checker);
        return false;
    }

    private boolean showAlreadyChecking() {
        IdeFrame frameFor = WindowManagerEx.getInstanceEx().findFrameFor(this.myProject);
        if (frameFor != null) {
            JComponent component = frameFor.getComponent();
            Point point = component.getMousePosition();
            if (point == null) {
                point = new Point((int)((double)component.getWidth() * 0.7), 0);
            }
            SwingUtilities.convertPointToScreen(point, component);
            JBPopupFactory.getInstance().createHtmlTextBalloonBuilder("Already checking...", MessageType.WARNING, null).createBalloon().show(new RelativePoint(point), Balloon.Position.below);
        }
        return false;
    }

    private void onStateChangedToSuccess(AuthenticationRequest obj) {
        this.myCopiesPassiveResults.put(this.getKey(obj), true);
        this.myVcs.invokeRefreshSvnRoots();
        LinkedList<Url> outdatedRequests = new LinkedList<Url>();
        Collection keys = this.getAllCurrentKeys();
        for (Url key : keys) {
            Url commonURLAncestor = key.commonAncestorWith(obj.getUrl());
            if (commonURLAncestor == null || StringUtil.isEmptyOrSpaces((String)commonURLAncestor.getHost()) || StringUtil.isEmptyOrSpaces((String)commonURLAncestor.getPath())) continue;
            outdatedRequests.add(key);
        }
        SvnAuthenticationNotifier.log("on state changed ");
        ApplicationManager.getApplication().invokeLater(() -> {
            for (Url key : outdatedRequests) {
                this.removeLazyNotificationByKey(key);
            }
        }, ModalityState.NON_MODAL);
    }

    public boolean ensureNotify(AuthenticationRequest obj) {
        Url key = this.getKey(obj);
        this.myCopiesPassiveResults.remove(key);
        return super.ensureNotify((Object)obj);
    }

    protected boolean onFirstNotification(AuthenticationRequest obj) {
        if (ProgressManager.getInstance().hasProgressIndicator()) {
            return this.ask(obj, null);
        }
        return false;
    }

    @NotNull
    public Url getKey(AuthenticationRequest obj) {
        Url url = obj.getWcUrl();
        if (url == null) {
            SvnAuthenticationNotifier.$$$reportNull$$$0(0);
        }
        return url;
    }

    @Nullable
    public Url getWcUrl(AuthenticationRequest obj) {
        if (obj.isOutsideCopies()) {
            return null;
        }
        if (obj.getWcUrl() != null) {
            return obj.getWcUrl();
        }
        WorkingCopy copy = this.myRootsToWorkingCopies.getMatchingCopy(obj.getUrl());
        if (copy != null) {
            obj.setOutsideCopies(false);
            obj.setWcUrl(copy.getUrl());
        } else {
            obj.setOutsideCopies(true);
        }
        return copy == null ? null : copy.getUrl();
    }

    public ThreeState isAuthenticatedFor(@NotNull VirtualFile vf, @Nullable ClientFactory factory) {
        WorkingCopy wcCopy;
        if (vf == null) {
            SvnAuthenticationNotifier.$$$reportNull$$$0(1);
        }
        if ((wcCopy = this.myRootsToWorkingCopies.getWcRoot(vf)) == null) {
            return ThreeState.UNSURE;
        }
        boolean haveCancellation = this.getStateFor(wcCopy.getUrl());
        if (haveCancellation) {
            return ThreeState.NO;
        }
        Boolean keptResult = this.myCopiesPassiveResults.get(wcCopy.getUrl());
        if (Boolean.TRUE.equals(keptResult)) {
            return ThreeState.YES;
        }
        if (Boolean.FALSE.equals(keptResult)) {
            return ThreeState.NO;
        }
        boolean calculatedResult = factory == null ? SvnAuthenticationNotifier.passiveValidation(this.myVcs, wcCopy.getUrl()) : SvnAuthenticationNotifier.passiveValidation(factory, wcCopy.getUrl());
        this.myCopiesPassiveResults.put(wcCopy.getUrl(), calculatedResult);
        return calculatedResult ? ThreeState.YES : ThreeState.NO;
    }

    private static boolean passiveValidation(@NotNull ClientFactory factory, @NotNull Url url) {
        if (factory == null) {
            SvnAuthenticationNotifier.$$$reportNull$$$0(2);
        }
        if (url == null) {
            SvnAuthenticationNotifier.$$$reportNull$$$0(3);
        }
        Info info = null;
        try {
            info = factory.create(InfoClient.class, false).doInfo(Target.on(url), Revision.UNDEFINED);
        }
        catch (SvnBindException svnBindException) {
            // empty catch block
        }
        return info != null;
    }

    @NotNull
    protected String getNotificationContent(AuthenticationRequest obj) {
        String string = "<a href=\"\">Click to fix.</a> Not logged In to Subversion '" + obj.getRealm() + "' (" + obj.getUrl().toDecodedString() + ")";
        if (string == null) {
            SvnAuthenticationNotifier.$$$reportNull$$$0(4);
        }
        return string;
    }

    static void log(Throwable t) {
        LOG.debug(t);
    }

    static void log(String s) {
        LOG.debug(s);
    }

    public static boolean passiveValidation(@NotNull SvnVcs vcs, Url url) {
        if (vcs == null) {
            SvnAuthenticationNotifier.$$$reportNull$$$0(5);
        }
        SvnConfiguration configuration = vcs.getSvnConfiguration();
        SvnAuthenticationManager passiveManager = configuration.getPassiveAuthenticationManager(vcs);
        return SvnAuthenticationNotifier.validationImpl(vcs.getProject(), url, configuration, passiveManager, false, null, null, false);
    }

    public static boolean interactiveValidation(Project project, Url url, String realm, String kind) {
        SvnConfiguration configuration = SvnConfiguration.getInstance(project);
        SvnAuthenticationManager passiveManager = configuration.getInteractiveManager(SvnVcs.getInstance(project));
        return SvnAuthenticationNotifier.validationImpl(project, url, configuration, passiveManager, true, realm, kind, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean validationImpl(Project project, Url url, SvnConfiguration configuration, SvnAuthenticationManager manager, boolean checkWrite, String realm, String kind, boolean interactive) {
        Proxy proxyToRelease = null;
        if (!interactive && configuration.isIsUseDefaultProxy()) {
            HttpConfigurable instance = HttpConfigurable.getInstance();
            if (instance.USE_HTTP_PROXY && instance.PROXY_AUTHENTICATION && (StringUtil.isEmptyOrSpaces((String)instance.getProxyLogin()) || StringUtil.isEmptyOrSpaces((String)instance.getPlainProxyPassword()))) {
                return false;
            }
            if (instance.USE_PROXY_PAC) {
                List select;
                try {
                    select = CommonProxy.getInstance().select(new URI(url.toString()));
                }
                catch (URISyntaxException e2) {
                    LOG.info("wrong URL: " + url.toString());
                    return false;
                }
                if (select != null && !select.isEmpty()) {
                    for (Proxy proxy : select) {
                        if (!HttpConfigurable.isRealProxy((Proxy)proxy) || !Proxy.Type.HTTP.equals((Object)proxy.type())) continue;
                        InetSocketAddress address = (InetSocketAddress)proxy.address();
                        PasswordAuthentication password = HttpConfigurable.getInstance().getGenericPassword(address.getHostName(), address.getPort());
                        if (password != null) continue;
                        CommonProxy.getInstance().noAuthentication("http", address.getHostName(), address.getPort());
                        proxyToRelease = proxy;
                    }
                }
            }
        }
        SvnInteractiveAuthenticationProvider.clearCallState();
        Target target = Target.on(url);
        try {
            SvnVcs.getInstance(project).getFactory(target).create(InfoClient.class, interactive).doInfo(target, Revision.HEAD);
        }
        catch (ProcessCanceledException e) {
            boolean e2 = false;
            return e2;
        }
        catch (SvnBindException e) {
            if (SvnUtil.isAuthError(e)) {
                SvnAuthenticationNotifier.log((Throwable)((Object)e));
                boolean e2 = false;
                return e2;
            }
            LOG.info("some other exc", (Throwable)((Object)e));
            if (interactive) {
                SvnAuthenticationNotifier.showAuthenticationFailedWithHotFixes(project, configuration, e);
            }
            boolean e2 = false;
            return e2;
        }
        finally {
            if (!interactive && configuration.isIsUseDefaultProxy() && proxyToRelease != null) {
                InetSocketAddress address = (InetSocketAddress)proxyToRelease.address();
                CommonProxy.getInstance().noAuthentication("http", address.getHostName(), address.getPort());
            }
        }
        if (!checkWrite) {
            return true;
        }
        if (SvnInteractiveAuthenticationProvider.wasCalled() && SvnInteractiveAuthenticationProvider.wasCancelled()) {
            return false;
        }
        if (SvnInteractiveAuthenticationProvider.wasCalled()) {
            return true;
        }
        SvnVcs svnVcs = SvnVcs.getInstance(project);
        SvnInteractiveAuthenticationProvider provider = new SvnInteractiveAuthenticationProvider(svnVcs, manager);
        AuthenticationData svnAuthentication = provider.requestClientAuthentication(kind, url, realm, true);
        if (svnAuthentication != null) {
            configuration.acknowledge(kind, realm, svnAuthentication);
            configuration.getAuthenticationManager(svnVcs).acknowledgeAuthentication(kind, url, realm, svnAuthentication);
            return true;
        }
        return false;
    }

    private static void showAuthenticationFailedWithHotFixes(final Project project, final SvnConfiguration configuration, SvnBindException e) {
        ApplicationManager.getApplication().invokeLater(() -> VcsBalloonProblemNotifier.showOverChangesView((Project)project, (String)("Authentication failed: " + e.getMessage()), (MessageType)MessageType.ERROR, (NamedRunnable[])new NamedRunnable[]{new NamedRunnable(SvnBundle.message("confirmation.title.clear.authentication.cache", new Object[0])){

            public void run() {
                SvnAuthenticationNotifier.clearAuthenticationCache(project, null, configuration.getConfigurationDirectory());
            }
        }, new NamedRunnable(SvnBundle.message("action.title.select.configuration.directory", new Object[0])){

            public void run() {
                SvnConfigurable.selectConfigurationDirectory(configuration.getConfigurationDirectory(), (Consumer<? super String>)((Consumer)s -> configuration.setConfigurationDirParameters(false, (String)s)), project, null);
            }
        }}), ModalityState.NON_MODAL, project.getDisposed());
    }

    public static void clearAuthenticationCache(@NotNull Project project, Component component, String configDirPath) {
        int result;
        if (project == null) {
            SvnAuthenticationNotifier.$$$reportNull$$$0(6);
        }
        if (configDirPath != null && (result = component == null ? Messages.showYesNoDialog((Project)project, (String)SvnBundle.message("confirmation.text.delete.stored.authentication.information", new Object[0]), (String)SvnBundle.message("confirmation.title.clear.authentication.cache", new Object[0]), (Icon)Messages.getWarningIcon()) : Messages.showYesNoDialog((Component)component, (String)SvnBundle.message("confirmation.text.delete.stored.authentication.information", new Object[0]), (String)SvnBundle.message("confirmation.title.clear.authentication.cache", new Object[0]), (Icon)Messages.getWarningIcon())) == 0) {
            SvnConfiguration.RUNTIME_AUTH_CACHE.clear();
            SvnAuthenticationNotifier.clearAuthenticationDirectory(SvnConfiguration.getInstance(project));
        }
    }

    public static void clearAuthenticationDirectory(@NotNull SvnConfiguration configuration) {
        File authDir;
        if (configuration == null) {
            SvnAuthenticationNotifier.$$$reportNull$$$0(7);
        }
        if ((authDir = new File(configuration.getConfigurationDirectory(), "auth")).exists()) {
            Runnable process = () -> {
                File[] files;
                ProgressIndicator ind = ProgressManager.getInstance().getProgressIndicator();
                if (ind != null) {
                    ind.setIndeterminate(true);
                    ind.setText("Clearing stored credentials in " + authDir.getAbsolutePath());
                }
                for (File dir2 : files = authDir.listFiles((dir, name) -> ourAuthKinds.contains(name))) {
                    if (ind != null) {
                        ind.setText("Deleting " + dir2.getAbsolutePath());
                    }
                    FileUtil.delete((File)dir2);
                }
            };
            Application application = ApplicationManager.getApplication();
            if (application.isUnitTestMode() || !application.isDispatchThread()) {
                process.run();
            } else {
                ProgressManager.getInstance().runProcessWithProgressSynchronously(process, "button.text.clear.authentication.cache", false, configuration.getProject());
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/svn/auth/SvnAuthenticationNotifier";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vf";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcs";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getKey";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/svn/auth/SvnAuthenticationNotifier";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getNotificationContent";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isAuthenticatedFor";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "passiveValidation";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "clearAuthenticationCache";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "clearAuthenticationDirectory";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class AuthenticationRequest {
        private final Project myProject;
        private final String myKind;
        private final Url myUrl;
        private final String myRealm;
        private Url myWcUrl;
        private boolean myOutsideCopies;
        private boolean myForceSaving;

        public AuthenticationRequest(Project project, String kind, Url url, String realm) {
            this.myProject = project;
            this.myKind = kind;
            this.myUrl = url;
            this.myRealm = realm;
        }

        public boolean isForceSaving() {
            return this.myForceSaving;
        }

        public void setForceSaving(boolean forceSaving) {
            this.myForceSaving = forceSaving;
        }

        public boolean isOutsideCopies() {
            return this.myOutsideCopies;
        }

        public void setOutsideCopies(boolean outsideCopies) {
            this.myOutsideCopies = outsideCopies;
        }

        public Url getWcUrl() {
            return this.myWcUrl;
        }

        public void setWcUrl(Url wcUrl) {
            this.myWcUrl = wcUrl;
        }

        public String getKind() {
            return this.myKind;
        }

        public Url getUrl() {
            return this.myUrl;
        }

        public String getRealm() {
            return this.myRealm;
        }
    }
}

