/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.i18n.locales;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.FakePsiElement;
import com.intellij.reference.SoftReference;
import java.util.List;
import java.util.Objects;
import javax.swing.Icon;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.i18n.locales.I18nYAMLAdapter;
import org.jetbrains.yaml.YAMLLanguage;
import org.jetbrains.yaml.YAMLUtil;
import org.jetbrains.yaml.psi.YAMLFile;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.impl.YAMLKeyValueImpl;

public class YamlKeyFakePsiElement
extends FakePsiElement {
    @NotNull
    private final YAMLFile myFile;
    @NotNull
    private final String myFullKeyPath;
    @NotNull
    private final String myKeyText;
    private final long myFileStamp;
    private SoftReference<YAMLKeyValue> myTarget;

    public YamlKeyFakePsiElement(@NotNull YAMLFile psiFile, @NotNull String path, @NotNull String keyText) {
        if (psiFile == null) {
            YamlKeyFakePsiElement.$$$reportNull$$$0(0);
        }
        if (path == null) {
            YamlKeyFakePsiElement.$$$reportNull$$$0(1);
        }
        if (keyText == null) {
            YamlKeyFakePsiElement.$$$reportNull$$$0(2);
        }
        this.myTarget = null;
        this.myFile = psiFile;
        this.myFullKeyPath = path;
        this.myKeyText = keyText;
        this.myFileStamp = psiFile.getModificationStamp();
    }

    @NotNull
    public String getFullKeyPath() {
        String string = this.myFullKeyPath;
        if (string == null) {
            YamlKeyFakePsiElement.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public YAMLFile getYamlFile() {
        YAMLFile yAMLFile = this.myFile;
        if (yAMLFile == null) {
            YamlKeyFakePsiElement.$$$reportNull$$$0(4);
        }
        return yAMLFile;
    }

    @NotNull
    public String getKeyText() {
        String string = this.myKeyText;
        if (string == null) {
            YamlKeyFakePsiElement.$$$reportNull$$$0(5);
        }
        return string;
    }

    public PsiElement getParent() {
        return null;
    }

    public boolean isValid() {
        return this.myFile.isValid() && this.myFileStamp == this.myFile.getModificationStamp();
    }

    public PsiFile getContainingFile() {
        return this.getYamlFile();
    }

    public String getName() {
        return this.myKeyText;
    }

    @NotNull
    public Project getProject() {
        Project project = this.myFile.getProject();
        if (project == null) {
            YamlKeyFakePsiElement.$$$reportNull$$$0(6);
        }
        return project;
    }

    public PsiManager getManager() {
        return this.myFile.getManager();
    }

    @NotNull
    public PsiElement getNavigationElement() {
        YAMLKeyValue yamlKeyValue = (YAMLKeyValue)SoftReference.dereference(this.myTarget);
        if (yamlKeyValue == null) {
            List path = StringUtil.split((String)this.getFullKeyPath(), (String)".");
            YAMLFile yamlFile = this.getYamlFile();
            yamlKeyValue = YAMLUtil.getQualifiedKeyInFile((YAMLFile)yamlFile, (List)path);
            if (yamlKeyValue == null) {
                throw new IllegalStateException("Fake YAML I18n element does not correspond to any real YAML key-value: " + this.getFullKeyPath() + " in " + yamlFile.getVirtualFile().getPath());
            }
            this.myTarget = new SoftReference((Object)yamlKeyValue);
        }
        YAMLKeyValue yAMLKeyValue = yamlKeyValue;
        if (yAMLKeyValue == null) {
            YamlKeyFakePsiElement.$$$reportNull$$$0(7);
        }
        return yAMLKeyValue;
    }

    public boolean canNavigate() {
        return true;
    }

    @NotNull
    public Language getLanguage() {
        YAMLLanguage yAMLLanguage = YAMLLanguage.INSTANCE;
        if (yAMLLanguage == null) {
            YamlKeyFakePsiElement.$$$reportNull$$$0(8);
        }
        return yAMLLanguage;
    }

    public String toString() {
        return "Fake YAML I18n: " + this.getFullKeyPath();
    }

    public ItemPresentation getPresentation() {
        return new ItemPresentation(){

            @NotNull
            public String getPresentableText() {
                String translation = I18nYAMLAdapter.getTranslation((PsiElement)YamlKeyFakePsiElement.this);
                String string = StringUtil.notNullize((String)translation, (String)YamlKeyFakePsiElement.this.getKeyText());
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            @NotNull
            public String getLocationString() {
                String string = "[" + YamlKeyFakePsiElement.this.myFile.getName() + "]";
                if (string == null) {
                    1.$$$reportNull$$$0(1);
                }
                return string;
            }

            @Nullable
            public Icon getIcon(boolean unused) {
                return YAMLKeyValueImpl.YAML_KEY_ICON;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "org/jetbrains/plugins/ruby/i18n/locales/YamlKeyFakePsiElement$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getPresentableText";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getLocationString";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
    }

    public boolean isEquivalentTo(PsiElement another) {
        if (this == another) {
            return true;
        }
        if (another instanceof YamlKeyFakePsiElement) {
            return this.equals(another);
        }
        if (another instanceof YAMLKeyValue) {
            return this.getNavigationElement().isEquivalentTo(another.getNavigationElement());
        }
        return false;
    }

    @Nullable
    public Icon getIcon(boolean open) {
        return YAMLKeyValueImpl.YAML_KEY_ICON;
    }

    @Contract(value="null -> false", pure=true)
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        YamlKeyFakePsiElement element = (YamlKeyFakePsiElement)((Object)o);
        return this.myFileStamp == element.myFileStamp && this.myFile.equals(element.myFile) && this.myFullKeyPath.equals(element.myFullKeyPath) && this.myKeyText.equals(element.myKeyText);
    }

    public int hashCode() {
        return Objects.hash(this.myFile, this.myFullKeyPath, this.myKeyText, this.myFileStamp);
    }

    @Nullable
    public TextRange getTextRange() {
        return this.getNavigationElement().getTextRange();
    }

    public int getStartOffsetInParent() {
        return this.getNavigationElement().getStartOffsetInParent();
    }

    public int getTextLength() {
        return this.getNavigationElement().getTextLength();
    }

    @Nullable
    public PsiElement findElementAt(int offset) {
        return this.getNavigationElement().findElementAt(offset);
    }

    public int getTextOffset() {
        return this.getNavigationElement().getTextOffset();
    }

    @Nullable
    @NonNls
    public String getText() {
        return this.getNavigationElement().getText();
    }

    @NotNull
    public char[] textToCharArray() {
        char[] cArray = this.getNavigationElement().textToCharArray();
        if (cArray == null) {
            YamlKeyFakePsiElement.$$$reportNull$$$0(9);
        }
        return cArray;
    }

    public boolean textContains(char c) {
        return this.getNavigationElement().textContains(c);
    }

    @Nullable
    public ASTNode getNode() {
        return this.getNavigationElement().getNode();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyText";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/i18n/locales/YamlKeyFakePsiElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/i18n/locales/YamlKeyFakePsiElement";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFullKeyPath";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getYamlFile";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeyText";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getNavigationElement";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguage";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "textToCharArray";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

