/*
 * Decompiled with CFR 0.152.
 */
package org.jrubyparser.ast;

import org.jrubyparser.NodeVisitor;
import org.jrubyparser.SourcePosition;
import org.jrubyparser.ast.INameNode;
import org.jrubyparser.ast.Node;
import org.jrubyparser.ast.NodeType;

public class UnaryCallNode
extends Node
implements INameNode {
    private Node receiverNode;
    protected String lexicalName;
    private boolean hasParens = false;

    public UnaryCallNode(SourcePosition position, Node receiverNode, String lexicalName) {
        super(position);
        assert (receiverNode != null) : "receiverNode is not null";
        this.receiverNode = this.adopt(receiverNode);
        this.lexicalName = lexicalName;
    }

    public boolean isSame(Node node) {
        if (!super.isSame(node)) {
            return false;
        }
        UnaryCallNode other = (UnaryCallNode)node;
        return this.isNameMatch(other.getName()) && this.isLexicalNameMatch(other.getLexicalName()) && this.getReceiver().isSame(other.getReceiver());
    }

    public NodeType getNodeType() {
        return NodeType.UNARYCALLNODE;
    }

    public Object accept(NodeVisitor iVisitor) {
        return iVisitor.visitUnaryCallNode(this);
    }

    public boolean hasParens() {
        return this.hasParens;
    }

    public void setHasParens(boolean hasParens) {
        this.hasParens = hasParens;
    }

    public String getLexicalName() {
        return this.lexicalName;
    }

    public String getName() {
        return this.lexicalName + "@";
    }

    public void setLexicalName(String lexicalName) {
        this.lexicalName = lexicalName;
    }

    public void setName(String name) {
        assert (name.startsWith("@"));
        this.lexicalName = name.substring(1);
    }

    public boolean isLexicalNameMatch(String name) {
        String thisName = this.getLexicalName();
        return thisName != null && thisName.equals(name);
    }

    public boolean isNameMatch(String name) {
        String thisName = this.getName();
        return thisName != null && thisName.equals(name);
    }

    @Deprecated
    public Node getReceiverNode() {
        return this.getReceiver();
    }

    public Node getReceiver() {
        return this.receiverNode;
    }

    public void setReceiver(Node receiver) {
        this.receiverNode = this.adopt(receiver);
    }

    public SourcePosition getNamePosition() {
        SourcePosition pos = this.receiverNode.getPosition();
        return new SourcePosition(pos.getFile(), pos.getStartLine(), pos.getEndLine(), pos.getEndOffset(), pos.getEndOffset() + this.getName().length());
    }

    public SourcePosition getLexicalNamePosition() {
        return this.getNamePosition();
    }
}

