/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagram.rails;

import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramColorManager;
import com.intellij.diagram.DiagramEdge;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.rails.RailsUmlRelationship;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.ui.JBColor;
import java.awt.Color;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;

public class RailDiagramColorManager
extends DiagramColorManager {
    private static final Color OK_LINE_COLOR = new JBColor(new Color(164, 198, 255), new Color(164, 198, 255));
    private static final Color ERROR_LINE_COLOR = new JBColor(new Color(244, 47, 51), new Color(244, 47, 51));
    public static final Color HEADER_COLOR = new JBColor(new Color(224, 236, 255), new Color(76, 84, 97));
    private static final Color GEMS_COLOR = new JBColor(new Color(255, 255, 228), new Color(255, 255, 228));

    public Color getNodeBackground(Project project, Object nodeElement, boolean selected) {
        return JBColor.background();
    }

    public Color getNodeForegroundColor(boolean selected) {
        return JBColor.foreground();
    }

    public Color getNodeHeaderColor(DiagramBuilder builder, @Nullable DiagramNode node) {
        Module module;
        Object element;
        if (node != null && (element = node.getIdentifyingElement()) instanceof RClass && (module = ModuleUtilCore.findModuleForPsiElement((PsiElement)((PsiElement)element))) == null) {
            return GEMS_COLOR;
        }
        return HEADER_COLOR;
    }

    public Color getEdgeColor(DiagramEdge edge) {
        RailsUmlRelationship relationship = (RailsUmlRelationship)edge.getRelationship();
        return relationship.isInvalid() ? ERROR_LINE_COLOR : OK_LINE_COLOR;
    }
}

