/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagram.rails;

import com.intellij.diagram.AbstractDiagramElementManager;
import com.intellij.diagram.presentation.DiagramState;
import com.intellij.diagram.rails.RailUmlCategoryManager;
import com.intellij.diagram.rails.associations.AssociationManager;
import com.intellij.diagram.rails.associations.AssociationProperty;
import com.intellij.diagram.rails.associations.MigrationFiledType;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleColoredText;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ArrayUtil;
import java.util.HashMap;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.plugins.ruby.rails.associations.AssociationsUtil;
import org.jetbrains.plugins.ruby.rails.facet.versions.BaseRailsFacet;
import org.jetbrains.plugins.ruby.rails.model.ActiveRecordModel;
import org.jetbrains.plugins.ruby.rails.model.RailsApp;
import org.jetbrains.plugins.ruby.ruby.RModuleUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.RElementWithFQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.Type;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.TypeSet;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.Types;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.SymbolProcessor;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.SymbolUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.util.SymbolScopeUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RType;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;

public class RailsUmlElementManager
extends AbstractDiagramElementManager<RClass> {
    private static final Key<RClass> PRECALC_SAMPLE_CLASS_KEY = Key.create((String)"rails.uml.sample.class");

    public RClass findInDataContext(DataContext context) {
        Module module = RModuleUtil.getInstance().getModule(context);
        if (module == null) {
            return null;
        }
        BaseRailsFacet facet = BaseRailsFacet.getInstance((Module)module);
        RClass precalculated = (RClass)PRECALC_SAMPLE_CLASS_KEY.get((UserDataHolder)facet);
        if (precalculated != null) {
            return precalculated;
        }
        RailsApp app = RailsApp.fromModule((Module)module);
        if (app == null) {
            return null;
        }
        Ref result = Ref.create();
        app.processModels(model -> {
            result.set((Object)model.getRClass());
            return false;
        });
        if (result.get() != null) {
            PRECALC_SAMPLE_CLASS_KEY.set((UserDataHolder)facet, result.get());
        }
        return (RClass)result.get();
    }

    public boolean isAcceptableAsNode(Object element) {
        return element instanceof RClass;
    }

    public String getElementTitle(RClass element) {
        return element.getName();
    }

    public SimpleColoredText getItemName(Object element, DiagramState presentation) {
        String text = null;
        if (element instanceof RContainer && ((RContainer)element).isValid()) {
            if (element instanceof RClass) {
                Symbol symbol = SymbolUtil.getSymbolByContainer((RElementWithFQN)((RContainer)element));
                if (symbol != null) {
                    text = symbol.getFQNWithNesting().toString();
                }
            } else {
                text = ((RContainer)element).getName();
            }
        } else {
            text = element instanceof PsiNamedElement ? ((PsiNamedElement)element).getName() : (element instanceof AssociationProperty ? ((AssociationProperty)element).getName() : "");
        }
        if (text == null) {
            text = element.toString();
        }
        return new SimpleColoredText(text, SimpleTextAttributes.REGULAR_ATTRIBUTES);
    }

    public Object[] getNodeItems(RClass parent) {
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)parent);
        if (module != null) {
            AssociationManager associationManager = AssociationManager.getInstance(module);
            RailsUmlElementManager.parseFields(parent);
            return associationManager.getProperties(parent).toArray();
        }
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    public SimpleColoredText getItemType(Object element) {
        if (element instanceof AssociationProperty) {
            AssociationProperty property = (AssociationProperty)element;
            String type = property.getDataType() != null ? property.getDataType() : property.getName();
            return new SimpleColoredText(type, new SimpleTextAttributes(0, JBColor.foreground()));
        }
        return super.getItemType(element);
    }

    public Icon getItemIcon(Object element, DiagramState presentation) {
        if (element instanceof AssociationProperty) {
            MigrationFiledType type = ((AssociationProperty)element).getMigrationFiledType();
            switch (type) {
                case ASSOCIATION: {
                    return RailUmlCategoryManager.ASSOCIATION_FIELDS.getIcon();
                }
                case MIGRATION: {
                    return RailUmlCategoryManager.MIGRATION_FIELDS.getIcon();
                }
                case SYSTEM_DB: {
                    return RailUmlCategoryManager.DB_FIELDS.getIcon();
                }
            }
        }
        return super.getItemIcon(element, presentation);
    }

    private static HashMap<String, Pair<RPsiElement, RType>> parseFields(final RClass rClass) {
        TypeSet set;
        final HashMap<String, Pair<RPsiElement, RType>> myFields = new HashMap<String, Pair<RPsiElement, RType>>();
        Symbol symbol = SymbolUtil.getSymbolByContainer((RElementWithFQN)rClass);
        ActiveRecordModel model = ActiveRecordModel.fromClass((RClass)rClass);
        TypeSet typeSet = set = model != null ? Types.FIELDS : new TypeSet(new Type[]{Type.INSTANCE_FIELD, Type.FIELD_READER, Type.FIELD_WRITER});
        assert (symbol != null);
        SymbolScopeUtil.processSymbolChildren((Symbol)symbol, (SymbolProcessor)new SymbolProcessor(){

            public boolean process(Symbol symbol) {
                if (symbol.getFQNWithNesting().equals(FQN.Builder.fromString((String)"ActiveRecord::Base"))) {
                    return false;
                }
                if (symbol.getFQNWithNesting().equals(FQN.Builder.fromString((String)"ActiveResource::Base"))) {
                    return false;
                }
                if (symbol.getType() == Type.CLASS) {
                    List fields = symbol.getChildren(set, (PsiElement)rClass);
                    for (Symbol field : fields) {
                        RPsiElement element;
                        PsiElement candidate = field.getPsiElement();
                        if (!(candidate instanceof RPsiElement) || AssociationsUtil.isAssociationCall((PsiElement)candidate) || myFields.containsKey((element = (RPsiElement)candidate).getName())) continue;
                        RType type = candidate instanceof RExpression ? ((RExpression)candidate).getType() : null;
                        myFields.put(element.getName(), Pair.create((Object)element, (Object)type));
                    }
                }
                return true;
            }

            public String getName() {
                return "Base";
            }

            public PsiElement getInvocationPoint() {
                return rClass;
            }
        });
        return myFields;
    }

    public String getNodeTooltip(RClass element) {
        return element.getName();
    }
}

