/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.tsconfig;

import com.intellij.lang.ecmascript6.index.ES6FileIncludeProvider;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.typescript.library.TypeScriptLibraryProvider;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigUtil;
import com.intellij.lang.typescript.tsconfig.TypeScriptFileImports;
import com.intellij.lang.typescript.tsconfig.TypeScriptFileImportsResolver;
import com.intellij.lang.typescript.tsconfig.TypeScriptFileInclude;
import com.intellij.lang.typescript.tsconfig.TypeScriptImportResolveContext;
import com.intellij.lang.typescript.tsconfig.TypeScriptImportSimpleResolveContextImpl;
import com.intellij.lang.typescript.tsconfig.TypeScriptImportsResolverProvider;
import com.intellij.lang.typescript.tsconfig.checkers.TypeScriptSimpleFileInclude;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.include.FileIncludeIndex;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptFileImportsImpl
implements TypeScriptFileImports {
    @NotNull
    private final Project myProject;
    @NotNull
    private final TypeScriptFileImportsResolver myResolver;
    @NotNull
    private final TypeScriptFileInclude myChecker;
    @NotNull
    private final TypeScriptImportResolveContext myContext;

    @Nullable
    public static TypeScriptFileImportsImpl createFileImports(@NotNull PsiElement context) {
        PsiFile contextPsiFile;
        VirtualFile contextFile;
        if (context == null) {
            TypeScriptFileImportsImpl.$$$reportNull$$$0(0);
        }
        if ((contextFile = (contextPsiFile = context.getContainingFile().getOriginalFile()).getVirtualFile()) == null) {
            return null;
        }
        Project project = context.getProject();
        TypeScriptConfig config2 = TypeScriptConfigUtil.getConfigForPsiFile(contextPsiFile);
        return config2 == null ? new TypeScriptFileImportsImpl(project, contextFile) : new TypeScriptFileImportsImpl(project, config2);
    }

    public TypeScriptFileImportsImpl(@NotNull Project project, @NotNull TypeScriptConfig config2) {
        if (project == null) {
            TypeScriptFileImportsImpl.$$$reportNull$$$0(1);
        }
        if (config2 == null) {
            TypeScriptFileImportsImpl.$$$reportNull$$$0(2);
        }
        this(project, config2.getInclude(), config2.getResolveContext(), config2.getImportResolver());
    }

    public TypeScriptFileImportsImpl(@NotNull Project project, @NotNull VirtualFile file2) {
        if (project == null) {
            TypeScriptFileImportsImpl.$$$reportNull$$$0(3);
        }
        if (file2 == null) {
            TypeScriptFileImportsImpl.$$$reportNull$$$0(4);
        }
        this(project, (TypeScriptFileInclude)new TypeScriptSimpleFileInclude(file2), file2, new TypeScriptImportSimpleResolveContextImpl(file2));
    }

    public TypeScriptFileImportsImpl(@NotNull Project project, @NotNull TypeScriptFileInclude checker, @NotNull VirtualFile file2, @NotNull TypeScriptImportResolveContext context) {
        if (project == null) {
            TypeScriptFileImportsImpl.$$$reportNull$$$0(5);
        }
        if (checker == null) {
            TypeScriptFileImportsImpl.$$$reportNull$$$0(6);
        }
        if (file2 == null) {
            TypeScriptFileImportsImpl.$$$reportNull$$$0(7);
        }
        if (context == null) {
            TypeScriptFileImportsImpl.$$$reportNull$$$0(8);
        }
        this(project, checker, context, TypeScriptImportsResolverProvider.getResolver(project, context, file2));
    }

    public TypeScriptFileImportsImpl(@NotNull Project project, @NotNull TypeScriptFileInclude checker, @NotNull TypeScriptImportResolveContext context, @NotNull TypeScriptFileImportsResolver resolver) {
        if (project == null) {
            TypeScriptFileImportsImpl.$$$reportNull$$$0(9);
        }
        if (checker == null) {
            TypeScriptFileImportsImpl.$$$reportNull$$$0(10);
        }
        if (context == null) {
            TypeScriptFileImportsImpl.$$$reportNull$$$0(11);
        }
        if (resolver == null) {
            TypeScriptFileImportsImpl.$$$reportNull$$$0(12);
        }
        this.myProject = project;
        this.myChecker = checker;
        this.myContext = context;
        this.myResolver = resolver;
    }

    @Override
    @NotNull
    public Set<VirtualFile> getRootFiles() {
        Set<VirtualFile> set = this.myChecker.getRootFiles(this.myProject);
        if (set == null) {
            TypeScriptFileImportsImpl.$$$reportNull$$$0(13);
        }
        return set;
    }

    @NotNull
    public TypeScriptFileImportsResolver getResolver() {
        TypeScriptFileImportsResolver typeScriptFileImportsResolver = this.myResolver;
        if (typeScriptFileImportsResolver == null) {
            TypeScriptFileImportsImpl.$$$reportNull$$$0(14);
        }
        return typeScriptFileImportsResolver;
    }

    @Override
    @Nullable
    public VirtualFile resolveFile(@NotNull String moduleName, @NotNull VirtualFile containingFile) {
        if (moduleName == null) {
            TypeScriptFileImportsImpl.$$$reportNull$$$0(15);
        }
        if (containingFile == null) {
            TypeScriptFileImportsImpl.$$$reportNull$$$0(16);
        }
        return this.myResolver.resolveFileModule(moduleName, containingFile);
    }

    @Override
    @NotNull
    public Set<VirtualFile> getOutFiles(@NotNull VirtualFile file2) {
        if (file2 == null) {
            TypeScriptFileImportsImpl.$$$reportNull$$$0(17);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        ProgressManager.checkCanceled();
        if (TypeScriptLibraryProvider.checkLibraryFile(this.myProject, file2)) {
            PsiFile psiFile = PsiManager.getInstance((Project)this.myProject).findFile(file2);
            if (psiFile instanceof JSFile) {
                Set paths = ((JSFile)psiFile).getReferencedPaths();
                Set<Object> set = paths.isEmpty() ? Collections.emptySet() : paths.stream().map(el -> {
                    if (file2 == null) {
                        TypeScriptFileImportsImpl.$$$reportNull$$$0(22);
                    }
                    return this.resolveFile(ES6FileIncludeProvider.preProcessPath(el), file2);
                }).filter(el -> el != null).collect(Collectors.toSet());
                if (set == null) {
                    TypeScriptFileImportsImpl.$$$reportNull$$$0(18);
                }
                return set;
            }
            Set<VirtualFile> set = Collections.emptySet();
            if (set == null) {
                TypeScriptFileImportsImpl.$$$reportNull$$$0(19);
            }
            return set;
        }
        Set<VirtualFile> set = FileIncludeIndex.getIncludes((VirtualFile)file2, (GlobalSearchScope)GlobalSearchScope.allScope((Project)this.myProject)).stream().map(el -> {
            if (file2 == null) {
                TypeScriptFileImportsImpl.$$$reportNull$$$0(21);
            }
            return this.resolveFile(el.path, file2);
        }).filter(el -> el != null).collect(Collectors.toSet());
        if (set == null) {
            TypeScriptFileImportsImpl.$$$reportNull$$$0(20);
        }
        return set;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TypeScriptFileImportsImpl imports = (TypeScriptFileImportsImpl)o;
        if (!this.myContext.equals(imports.myContext)) {
            return false;
        }
        return this.myChecker.equals(imports.myChecker);
    }

    public int hashCode() {
        int result2 = this.myChecker.hashCode();
        result2 = 31 * result2 + this.myContext.hashCode();
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 13: 
            case 14: 
            case 18: 
            case 19: 
            case 20: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 13: 
            case 14: 
            case 18: 
            case 19: 
            case 20: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 4: 
            case 7: 
            case 17: 
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checker";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolver";
                break;
            }
            case 13: 
            case 14: 
            case 18: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/tsconfig/TypeScriptFileImportsImpl";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleName";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/tsconfig/TypeScriptFileImportsImpl";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootFiles";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolver";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getOutFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createFileImports";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 13: 
            case 14: 
            case 18: 
            case 19: 
            case 20: {
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "resolveFile";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getOutFiles";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getOutFiles$2";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getOutFiles$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 13: 
            case 14: 
            case 18: 
            case 19: 
            case 20: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

