/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.version.management.rbenv.gemsets;

import b.h.la;
import com.intellij.execution.ExecutionException;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.AtomicClearableLazyValue;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.StreamUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.gem.GemInfo;
import org.jetbrains.plugins.ruby.gem.GemManager;
import org.jetbrains.plugins.ruby.rails.model.RailsApp;
import org.jetbrains.plugins.ruby.remote.RubyRemoteInterpreterManager;
import org.jetbrains.plugins.ruby.ruby.RModuleUtil;
import org.jetbrains.plugins.ruby.ruby.run.RubyRunner;
import org.jetbrains.plugins.ruby.ruby.run.RunnerUtil;
import org.jetbrains.plugins.ruby.ruby.run.context.RubyRunnerExecutionContext;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkType;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkUtil;
import org.jetbrains.plugins.ruby.ruby.sdk.jruby.JRubySdkType;
import org.jetbrains.plugins.ruby.version.management.RubySdkInfo;
import org.jetbrains.plugins.ruby.version.management.rbenv.RbenvSdkData;

public class RbenvGemsetManager {
    public static final String RBENV_GEMSETS_DIRECTORY_NAME = "gemsets";
    public static final String DOT_PREFIX = ".";
    public static final String RBENV_VERSION_ENV = "RBENV_VERSION";
    public static final String RBENV_GEMSETS_ENV = "RBENV_GEMSETS";
    public static final String GEMS_FOLDER = "gems";
    public static final String RBENV_GLOBAL_GEMSET = "global";
    public static final String RBENV_GLOBAL_GEMSET_DISABLED = "-global";
    public static final String BUNDLER_FOLDER = "bundler";
    public static final Object RBENV_GEMSETS_CONFIG_REQUESTOR;
    public static final AtomicClearableLazyValue<Boolean> RBENV_PLUGIN_INSTALLED;
    @NonNls
    static final String RBENV_GEMSETS_FILE_NAME = ".rbenv-gemsets";
    private static final Logger b;
    private static final String a = ".rbenv/shims/";
    private static final long c;

    private RbenvGemsetManager() {
    }

    public static void createGemset(@NotNull Sdk sdk, @Nullable Module module, @Nullable Project project, @NotNull String gemset, @NotNull String version) {
        long l2 = c ^ 0x717344953A8EL;
        if (sdk == null) {
            RbenvGemsetManager.a(0);
        }
        if (gemset == null) {
            RbenvGemsetManager.a(1);
        }
        if (version == null) {
            RbenvGemsetManager.a(2);
        }
        RubyRunner rubyRunner = RunnerUtil.getRunner(sdk, module);
        String string = FileUtil.expandUserHome((String)RbenvSdkData.notNullFrom(sdk).getVersionManagerPath());
        try {
            rubyRunner.execute((RubyRunnerExecutionContext)((RubyRunnerExecutionContext)RubyRunnerExecutionContext.create(sdk, string, "gemset", "create", version, gemset).withProject(project)).withPatchWithVersionManager(false).inSameThread(Registry.intValue((String)"command.line.execution.timeout")));
        }
        catch (ExecutionException executionException) {
            b.error(executionException.getMessage());
        }
    }

    @Nullable
    public static Sdk getGemsetSdk(@NotNull Sdk sdk2, @NotNull String gemset) {
        List list2;
        if (sdk2 == null) {
            RbenvGemsetManager.a(3);
        }
        if (gemset == null) {
            RbenvGemsetManager.a(4);
        }
        if ((list2 = ContainerUtil.filter(RbenvGemsetManager.getGemsetsSdk(sdk2), sdk -> {
            if (gemset == null) {
                RbenvGemsetManager.a(96);
            }
            return gemset.equals(RbenvGemsetManager.getRbenvGemset(sdk));
        })).isEmpty() || list2.size() > 1) {
            return null;
        }
        return (Sdk)list2.get(0);
    }

    @Nullable
    public static String getGemsetSdkVersion(@NotNull Sdk sdk) {
        VirtualFile virtualFile;
        if (sdk == null) {
            RbenvGemsetManager.a(5);
        }
        if ((virtualFile = RbenvGemsetManager.c(sdk)) == null) {
            return null;
        }
        return virtualFile.getName();
    }

    public static void addRbenvLocalGemsetsExcludedFolders(@NotNull Module module, @Nullable Sdk sdk, @NotNull ContentEntry contentEntry) {
        if (module == null) {
            RbenvGemsetManager.a(6);
        }
        if (contentEntry == null) {
            RbenvGemsetManager.a(7);
        }
        if (!RbenvGemsetManager.useRbenvGemsets(module, sdk)) {
            return;
        }
        for (VirtualFile virtualFile : RbenvGemsetManager.getLocalGemsetFolders(module, sdk)) {
            contentEntry.addExcludeFolder(virtualFile.getUrl());
        }
    }

    public static boolean useRbenvGemsets(@Nullable Module module, @Nullable Sdk sdk) {
        return module != null && RbenvGemsetManager.isRbenvSdk(sdk) && RbenvGemsetManager.getConfigVirtualFile(module) != null;
    }

    @Nullable
    public static VirtualFile createLocalGemset(@NotNull Module module, final @NotNull String localGemsetName) {
        long l2 = c ^ 0x7A94EABE6D09L;
        if (module == null) {
            RbenvGemsetManager.a(8);
        }
        if (localGemsetName == null) {
            RbenvGemsetManager.a(9);
        }
        for (final VirtualFile virtualFile : ModuleRootManager.getInstance((Module)module).getContentRoots()) {
            try {
                VirtualFile virtualFile2 = (VirtualFile)ApplicationManager.getApplication().runWriteAction((ThrowableComputable)new ThrowableComputable<VirtualFile, IOException>(){

                    public VirtualFile compute() throws IOException {
                        return virtualFile.createChildDirectory((Object)this, localGemsetName);
                    }
                });
                if (virtualFile2 == null) continue;
                return virtualFile2;
            }
            catch (IOException iOException) {
                b.error("Cannot create local gemset " + virtualFile.getPath() + "; " + iOException.getMessage());
                return null;
            }
        }
        return null;
    }

    @Nullable
    private static VirtualFile a(@NotNull Module module) {
        long l2 = c ^ 0x4414E67E7A0BL;
        if (module == null) {
            RbenvGemsetManager.a(10);
        }
        for (final VirtualFile virtualFile : ModuleRootManager.getInstance((Module)module).getContentRoots()) {
            try {
                VirtualFile virtualFile2 = (VirtualFile)ApplicationManager.getApplication().runWriteAction((ThrowableComputable)new ThrowableComputable<VirtualFile, IOException>(){
                    private static final long a = la.a(876579879370150556L, -4538464920832150798L, MethodHandles.lookup().lookupClass()).a(229059072987205L);

                    public VirtualFile compute() throws IOException {
                        long l2 = a ^ 0x5EDA32B6BB78L;
                        return virtualFile.createChildData((Object)this, RbenvGemsetManager.RBENV_GEMSETS_FILE_NAME);
                    }
                });
                if (virtualFile2 == null) continue;
                return virtualFile2;
            }
            catch (IOException iOException) {
                b.error("Cannot create .rbenv-gemsets file under " + virtualFile.getPath());
                return null;
            }
        }
        return null;
    }

    public static boolean isRbenvGemsetConfig(@NotNull Module module, @NotNull VirtualFile file) {
        if (module == null) {
            RbenvGemsetManager.a(11);
        }
        if (file == null) {
            RbenvGemsetManager.a(12);
        }
        return file.equals(RbenvGemsetManager.getConfigVirtualFile(module));
    }

    @Nullable
    public static PsiFile getRbenvGemsetConfig(@NotNull Module module) {
        VirtualFile virtualFile;
        if (module == null) {
            RbenvGemsetManager.a(13);
        }
        if ((virtualFile = RbenvGemsetManager.getConfigVirtualFile(module)) == null) {
            return null;
        }
        return (PsiFile)ReadAction.compute(() -> {
            if (module == null) {
                RbenvGemsetManager.a(95);
            }
            return PsiManager.getInstance((Project)module.getProject()).findFile(virtualFile);
        });
    }

    @Nullable
    public static VirtualFile getConfigVirtualFile(@NotNull Module module) {
        long l2 = c ^ 0x696FFEBF8F52L;
        if (module == null) {
            RbenvGemsetManager.a(14);
        }
        if (module.isDisposed()) {
            return null;
        }
        VirtualFile virtualFile = null;
        for (VirtualFile virtualFile2 : ModuleRootManager.getInstance((Module)module).getContentRoots()) {
            VirtualFile virtualFile3 = virtualFile2.findChild(RBENV_GEMSETS_FILE_NAME);
            if (virtualFile3 != null) {
                virtualFile = virtualFile3;
                break;
            }
            virtualFile3 = virtualFile2.findChild(".ruby-gemset");
            if (virtualFile3 == null) continue;
            virtualFile = virtualFile3;
            break;
        }
        return virtualFile;
    }

    @NotNull
    public static List<String> getRbenvGemsetNames(@NotNull Sdk sdk) {
        if (sdk == null) {
            RbenvGemsetManager.a(15);
        }
        List list2 = ContainerUtil.map((Object[])RbenvGemsetManager.a(sdk), VirtualFile::getName);
        if (list2 == null) {
            RbenvGemsetManager.a(16);
        }
        return list2;
    }

    @NotNull
    private static VirtualFile[] a(@NotNull Sdk sdk) {
        VirtualFile virtualFile;
        if (sdk == null) {
            RbenvGemsetManager.a(17);
        }
        if ((virtualFile = RbenvGemsetManager.getGemsetsFolder(sdk)) == null) {
            if (VirtualFile.EMPTY_ARRAY == null) {
                RbenvGemsetManager.a(18);
            }
            return VirtualFile.EMPTY_ARRAY;
        }
        VirtualFile[] virtualFileArray = ContainerUtil.filter((Object[])virtualFile.getChildren(), VirtualFile::isDirectory).toArray(VirtualFile.EMPTY_ARRAY);
        if (virtualFileArray == null) {
            RbenvGemsetManager.a(19);
        }
        return virtualFileArray;
    }

    @Nullable
    public static VirtualFile getGemsetsFolder(@NotNull Sdk sdk) {
        VirtualFile virtualFile;
        long l2 = c ^ 0x280740751191L;
        if (sdk == null) {
            RbenvGemsetManager.a(20);
        }
        if ((virtualFile = RbenvGemsetManager.c(sdk)) == null) {
            return null;
        }
        return virtualFile.findChild(RBENV_GEMSETS_DIRECTORY_NAME);
    }

    @Nullable
    private static VirtualFile c(@NotNull Sdk sdk) {
        String string;
        long l2 = c ^ 0x5986B339AC69L;
        if (sdk == null) {
            RbenvGemsetManager.a(21);
        }
        if ((string = RbenvGemsetManager.b(sdk)) == null) {
            return null;
        }
        return VirtualFileManager.getInstance().findFileByUrl(VirtualFileManager.constructUrl((String)(ApplicationManager.getApplication().isUnitTestMode() ? "temp" : "file"), (String)string));
    }

    @Nullable
    private static String b(@NotNull Sdk sdk) {
        String string;
        if (sdk == null) {
            RbenvGemsetManager.a(22);
        }
        if ((string = sdk.getHomePath()) == null) {
            return null;
        }
        String string2 = new File(string).getParent();
        if (string2 == null) {
            return null;
        }
        return new File(string2).getParent();
    }

    @NotNull
    private static Set<VirtualFile> a(Module module, @NotNull String string2) {
        long l2 = c ^ 0x5A9CA6DD25B3L;
        if (string2 == null) {
            RbenvGemsetManager.a(23);
        }
        List<String> list2 = RbenvGemsetManager.b(string2);
        list2.remove(RBENV_GLOBAL_GEMSET_DISABLED);
        list2.remove(RBENV_GLOBAL_GEMSET);
        Set set = ContainerUtil.map2SetNotNull(list2, string -> RbenvGemsetManager.getLocalGemsetFolder(module, string));
        if (set == null) {
            RbenvGemsetManager.a(24);
        }
        return set;
    }

    @NotNull
    public static List<String> getLocalGemsets(@NotNull Module module, @Nullable Sdk sdk) {
        long l2 = c ^ 0x460EE39282BDL;
        if (module == null) {
            RbenvGemsetManager.a(25);
        }
        List<String> list2 = RbenvGemsetManager.getCommandLineRbenvGemsets(module, sdk);
        list2.remove(RBENV_GLOBAL_GEMSET);
        List<String> list3 = RbenvGemsetManager.filterLocalGemsets(list2);
        if (list3 == null) {
            RbenvGemsetManager.a(26);
        }
        return list3;
    }

    @NotNull
    public static List<String> filterLocalGemsets(@NotNull Collection<String> gemsets) {
        if (gemsets == null) {
            RbenvGemsetManager.a(27);
        }
        List list2 = ContainerUtil.filter(gemsets, RbenvGemsetManager::a);
        if (list2 == null) {
            RbenvGemsetManager.a(28);
        }
        return list2;
    }

    private static boolean a(String string) {
        return string.startsWith(DOT_PREFIX);
    }

    @NotNull
    public static List<String> getCommandLineRbenvGemsets(@NotNull Module module, Sdk sdk) {
        long l2 = c ^ 0x5BEED38DABD6L;
        if (module == null) {
            RbenvGemsetManager.a(29);
        }
        List<String> list2 = RbenvGemsetManager.getRbenvConfiguredGemsets(module, sdk);
        list2.remove(RBENV_GLOBAL_GEMSET_DISABLED);
        List<String> list3 = list2;
        if (list3 == null) {
            RbenvGemsetManager.a(30);
        }
        return list3;
    }

    @NotNull
    public static List<String> getCurrentGemsetsOnly(@NotNull Module module) {
        long l2 = c ^ 0x75C52E52B5AAL;
        if (module == null) {
            RbenvGemsetManager.a(31);
        }
        List<String> list2 = RbenvGemsetManager.getRbenvCurrentGemsets(module);
        list2.remove(RBENV_GLOBAL_GEMSET_DISABLED);
        list2.remove(RBENV_GLOBAL_GEMSET);
        List<String> list3 = list2;
        if (list3 == null) {
            RbenvGemsetManager.a(32);
        }
        return list3;
    }

    @NotNull
    public static List<String> getRbenvCurrentGemsets(@Nullable Module module) {
        if (module == null) {
            List<String> list2 = Collections.emptyList();
            if (list2 == null) {
                RbenvGemsetManager.a(33);
            }
            return list2;
        }
        PsiFile psiFile = RbenvGemsetManager.getRbenvGemsetConfig(module);
        if (psiFile == null) {
            List list3 = ContainerUtil.emptyList();
            if (list3 == null) {
                RbenvGemsetManager.a(34);
            }
            return list3;
        }
        List<String> list4 = RbenvGemsetManager.b((String)ReadAction.compute(() -> psiFile.getText()));
        if (list4 == null) {
            RbenvGemsetManager.a(35);
        }
        return list4;
    }

    @NotNull
    public static List<String> getRbenvConfiguredGemsets(@NotNull Module module, @Nullable Sdk sdk) {
        if (module == null) {
            RbenvGemsetManager.a(36);
        }
        if (!RbenvGemsetManager.useRbenvGemsets(module, sdk)) {
            List<String> list2 = Collections.emptyList();
            if (list2 == null) {
                RbenvGemsetManager.a(37);
            }
            return list2;
        }
        String string = RbenvGemsetManager.getConfigText(module);
        if (string == null) {
            List<String> list3 = Collections.emptyList();
            if (list3 == null) {
                RbenvGemsetManager.a(38);
            }
            return list3;
        }
        List<String> list4 = RbenvGemsetManager.b(string);
        if (list4 == null) {
            RbenvGemsetManager.a(39);
        }
        return list4;
    }

    @Nullable
    public static String getConfigText(@NotNull Module module) {
        VirtualFile virtualFile;
        long l2 = c ^ 0x11406FE1A7E0L;
        if (module == null) {
            RbenvGemsetManager.a(40);
        }
        if ((virtualFile = RbenvGemsetManager.getConfigVirtualFile(module)) == null) {
            return null;
        }
        String string = "";
        try {
            string = StreamUtil.readText((InputStream)virtualFile.getInputStream(), (Charset)virtualFile.getCharset());
        }
        catch (IOException iOException) {
            b.error("Cannot read .rbenv-gemset(s) file (" + virtualFile.getPath() + "): " + iOException.getMessage());
        }
        return string;
    }

    @NotNull
    private static List<String> b(@NotNull String string2) {
        long l2 = c ^ 0x2A438BE004CL;
        if (string2 == null) {
            RbenvGemsetManager.a(41);
        }
        if (!RbenvGemsetManager.e(string2) && !RbenvGemsetManager.d(string2)) {
            if (!string2.isEmpty()) {
                string2 = string2 + "\n";
            }
            string2 = string2 + RBENV_GLOBAL_GEMSET;
        }
        ArrayList arrayList = ContainerUtil.newArrayList((Iterable)ContainerUtil.filter((Object[])string2.split("[ \\n]"), string -> !string.isEmpty()));
        if (arrayList == null) {
            RbenvGemsetManager.a(42);
        }
        return arrayList;
    }

    @Nullable
    public static String getShimsCommandPath(@NotNull String command) {
        VirtualFile virtualFile;
        long l2 = c ^ 0x5DD73759CD11L;
        if (command == null) {
            RbenvGemsetManager.a(43);
        }
        if ((virtualFile = VfsUtil.getUserHomeDir()) == null) {
            return null;
        }
        VirtualFile virtualFile2 = virtualFile.findFileByRelativePath(a + command);
        return virtualFile2 == null ? null : virtualFile2.getPath();
    }

    @Contract(value="null -> false")
    public static boolean isRbenvSdk(@Nullable Sdk sdk) {
        if (sdk == null) {
            return false;
        }
        return RbenvGemsetManager.isRbenvSdkPath(sdk.getHomePath());
    }

    public static boolean isLocalRbenvSdk(@Nullable Sdk sdk) {
        return RbenvGemsetManager.isRbenvSdk(sdk) && !RubyRemoteInterpreterManager.getInstance().isRemoteSdk(sdk);
    }

    public static boolean isGemsetOfSdk(@NotNull Sdk rootSdk, @NotNull Sdk gemset) {
        if (rootSdk == null) {
            RbenvGemsetManager.a(44);
        }
        if (gemset == null) {
            RbenvGemsetManager.a(45);
        }
        return RbenvGemsetManager.isRbenvSdk(rootSdk) && RbenvGemsetManager.isRootRbenvSdk(rootSdk) && RbenvGemsetManager.getGemsetsSdk(rootSdk).contains(gemset);
    }

    public static boolean isGemsetSdk(@Nullable Sdk sdk) {
        return RbenvGemsetManager.getRbenvGemset(sdk) != null;
    }

    public static boolean isGemsetSdk(@NotNull RubySdkInfo sdkInfo) {
        if (sdkInfo == null) {
            RbenvGemsetManager.a(46);
        }
        return sdkInfo.getGemSet() != null;
    }

    @Contract(value="null -> false")
    public static boolean isRbenvSdkPath(@Nullable String path) {
        long l2 = c ^ 0x487153EFAC7BL;
        return path != null && path.contains("rbenv");
    }

    public static void applyRbenvGemsetsToConfig(@NotNull Module module, Collection<String> gemsetNames) {
        VirtualFile virtualFile;
        long l2 = c ^ 0x476FEEC7F634L;
        if (module == null) {
            RbenvGemsetManager.a(47);
        }
        VirtualFile virtualFile2 = RbenvGemsetManager.getConfigVirtualFile(module);
        if (gemsetNames.isEmpty() && virtualFile2 == null) {
            return;
        }
        VirtualFile virtualFile3 = virtualFile = virtualFile2 != null ? virtualFile2 : RbenvGemsetManager.a(module);
        if (virtualFile == null) {
            return;
        }
        VirtualFile virtualFile4 = virtualFile;
        try {
            String string = StreamUtil.readText((InputStream)virtualFile4.getInputStream(), (Charset)virtualFile4.getCharset());
            ArrayList arrayList = ContainerUtil.newArrayList(gemsetNames);
            if (!arrayList.contains(RBENV_GLOBAL_GEMSET)) {
                arrayList.add(RBENV_GLOBAL_GEMSET_DISABLED);
            }
            if (arrayList.contains(RBENV_GLOBAL_GEMSET) && !RbenvGemsetManager.e(string)) {
                arrayList.remove(RBENV_GLOBAL_GEMSET);
            }
            String string2 = StringUtil.join((Collection)arrayList, (String)"\n");
            ApplicationManager.getApplication().runWriteAction(() -> {
                long l2 = c ^ 0x14165FB1FD2EL;
                try {
                    virtualFile4.setBinaryContent(string2.getBytes(virtualFile4.getCharset()), -1L, -1L, RBENV_GEMSETS_CONFIG_REQUESTOR);
                }
                catch (IOException iOException) {
                    b.error("Cannot apply selected gemsets " + string2 + " to the config file " + virtualFile4.getPath());
                }
            });
        }
        catch (IOException iOException) {
            b.warn("Cannot read .rbenv-gemsets; " + iOException.getMessage());
        }
    }

    private static boolean e(@NotNull String string) {
        long l2 = c ^ 0x5C76ABE52FA9L;
        if (string == null) {
            RbenvGemsetManager.a(48);
        }
        return ContainerUtil.newArrayList((Object[])string.split("[ \\n]")).contains(RBENV_GLOBAL_GEMSET);
    }

    public static boolean hasGlobalDisabled(@NotNull Module module) {
        String string;
        if (module == null) {
            RbenvGemsetManager.a(49);
        }
        return (string = RbenvGemsetManager.getConfigText(module)) == null || RbenvGemsetManager.d(string);
    }

    private static boolean d(@NotNull String string) {
        long l2 = c ^ 0x27CE46F9BBEEL;
        if (string == null) {
            RbenvGemsetManager.a(50);
        }
        return ContainerUtil.newArrayList((Object[])string.split("[ \\n]")).contains(RBENV_GLOBAL_GEMSET_DISABLED);
    }

    public static boolean isGlobalGemsetSdk(@NotNull Sdk sdk) {
        long l2 = c ^ 0x7A2067784270L;
        if (sdk == null) {
            RbenvGemsetManager.a(51);
        }
        return RBENV_GLOBAL_GEMSET.equals(RbenvGemsetManager.getRbenvGemset(sdk));
    }

    @Nullable
    public static String getRbenvGemset(@Nullable Sdk sdk) {
        RbenvSdkData rbenvSdkData = RbenvSdkData.from(sdk);
        return rbenvSdkData == null ? null : rbenvSdkData.getGemsetName();
    }

    @Nullable
    public static Sdk findRootRbenvSdk(Sdk ... gemsetOrSdks) {
        if (gemsetOrSdks == null) {
            RbenvGemsetManager.a(52);
        }
        return RbenvGemsetManager.findRootRbenvSdk(RbenvGemsetManager.getRubySdks(), gemsetOrSdks);
    }

    @Nullable
    public static Sdk findRootRbenvSdk(@NotNull Collection<? extends Sdk> sdks, Sdk ... gemsetOrSdks) {
        if (sdks == null) {
            RbenvGemsetManager.a(53);
        }
        if (gemsetOrSdks == null) {
            RbenvGemsetManager.a(54);
        }
        return (Sdk)ContainerUtil.find(sdks, sdk -> {
            if (gemsetOrSdks == null) {
                RbenvGemsetManager.a(94);
            }
            boolean bl2 = true;
            for (Sdk sdk2 : gemsetOrSdks) {
                bl2 &= Comparing.equal((String)sdk.getHomePath(), (String)sdk2.getHomePath());
            }
            return RbenvGemsetManager.isRbenvSdk(sdk) && !RbenvGemsetManager.isGemsetSdk(sdk) && bl2;
        });
    }

    @Nullable
    public static Sdk findRootRbenvSdk(@NotNull String version) {
        if (version == null) {
            RbenvGemsetManager.a(55);
        }
        return (Sdk)ContainerUtil.find(RbenvGemsetManager.getRubySdks(), sdk -> {
            if (version == null) {
                RbenvGemsetManager.a(93);
            }
            return RbenvGemsetManager.isRbenvSdk(sdk) && !RbenvGemsetManager.isGemsetSdk(sdk) && Comparing.equal((String)version, (String)RbenvGemsetManager.getSdkVersion(sdk));
        });
    }

    public static boolean isRootRbenvSdk(@NotNull Sdk sdk) {
        if (sdk == null) {
            RbenvGemsetManager.a(56);
        }
        return RubySdkUtil.equalSdks(RbenvGemsetManager.findRootRbenvSdk(sdk), sdk);
    }

    @Nullable
    public static String fetchGemGemset(@NotNull GemInfo gemInfo) {
        int n2;
        long l2 = c ^ 0x79A12A58D88FL;
        if (gemInfo == null) {
            RbenvGemsetManager.a(57);
        }
        if ((n2 = gemInfo.getUrl().indexOf(RBENV_GEMSETS_DIRECTORY_NAME)) == -1) {
            return null;
        }
        String string = StringUtil.substringAfter((String)gemInfo.getUrl(), (String)"gemsets/");
        if (string == null) {
            return null;
        }
        return string.substring(0, string.indexOf("/"));
    }

    public static void refreshGemsetFolder(@NotNull Sdk rootSdk, @NotNull String gemset) {
        VirtualFile virtualFile;
        long l2 = c ^ 0x2455E478E131L;
        if (rootSdk == null) {
            RbenvGemsetManager.a(58);
        }
        if (gemset == null) {
            RbenvGemsetManager.a(59);
        }
        if ((virtualFile = RbenvGemsetManager.c(rootSdk)) == null) {
            return;
        }
        VirtualFileManager.getInstance().refreshAndFindFileByUrl(virtualFile.getUrl() + File.separator + RBENV_GEMSETS_DIRECTORY_NAME + File.separator + gemset);
    }

    public static boolean hasGemset(@NotNull Sdk rootSdk, @NotNull String gemset) {
        VirtualFile virtualFile;
        if (rootSdk == null) {
            RbenvGemsetManager.a(60);
        }
        if (gemset == null) {
            RbenvGemsetManager.a(61);
        }
        return (virtualFile = RbenvGemsetManager.getGemsetsFolder(rootSdk)) != null && virtualFile.findChild(gemset) != null;
    }

    public static boolean hasLocalGemset(@NotNull Module module, @NotNull String gemset) {
        if (module == null) {
            RbenvGemsetManager.a(62);
        }
        if (gemset == null) {
            RbenvGemsetManager.a(63);
        }
        return RbenvGemsetManager.getLocalGemsetFolder(module, gemset) != null;
    }

    @NotNull
    public static List<Sdk> getGemsetsSdk(@NotNull Sdk rootSdk) {
        if (rootSdk == null) {
            RbenvGemsetManager.a(64);
        }
        List list2 = ContainerUtil.filter(RbenvGemsetManager.getRubySdks(), sdk2 -> {
            if (rootSdk == null) {
                RbenvGemsetManager.a(92);
            }
            return RbenvGemsetManager.isGemsetSdk(sdk2) && Comparing.equal((Object)sdk2.getHomeDirectory(), (Object)rootSdk.getHomeDirectory());
        });
        if (list2 == null) {
            RbenvGemsetManager.a(65);
        }
        return list2;
    }

    @NotNull
    public static List<Sdk> getConfiguredGemsetSdks(@NotNull Sdk rootSdk, Collection<String> gemsets) {
        if (rootSdk == null) {
            RbenvGemsetManager.a(66);
        }
        List<Sdk> list2 = RbenvGemsetManager.getGemsetsSdk(rootSdk);
        List list3 = ContainerUtil.filter(list2, sdk -> !ContainerUtil.filter((Collection)gemsets, string -> string.equals(RbenvGemsetManager.getRbenvGemset(sdk))).isEmpty());
        if (list3 == null) {
            RbenvGemsetManager.a(67);
        }
        return list3;
    }

    @NotNull
    public static List<Sdk> getRubySdks() {
        ArrayList arrayList = ContainerUtil.newArrayList();
        arrayList.addAll(ProjectJdkTable.getInstance().getSdksOfType((SdkTypeId)RubySdkType.getInstance()));
        arrayList.addAll(ProjectJdkTable.getInstance().getSdksOfType((SdkTypeId)JRubySdkType.getInstance()));
        ArrayList arrayList2 = arrayList;
        if (arrayList2 == null) {
            RbenvGemsetManager.a(68);
        }
        return arrayList2;
    }

    @Nullable
    public static String getSdkVersion(@NotNull Sdk sdk) {
        VirtualFile virtualFile;
        if (sdk == null) {
            RbenvGemsetManager.a(69);
        }
        if ((virtualFile = sdk.getHomeDirectory()) == null) {
            return null;
        }
        VirtualFile virtualFile2 = virtualFile.getParent();
        if (virtualFile2 == null) {
            return null;
        }
        VirtualFile virtualFile3 = virtualFile2.getParent();
        if (virtualFile3 == null) {
            return null;
        }
        return virtualFile3.getName();
    }

    public static void refreshAttachedGemsetSdks(@NotNull Module module) {
        Sdk sdk2;
        if (module == null) {
            RbenvGemsetManager.a(70);
        }
        if (!RbenvGemsetManager.isRbenvSdk(sdk2 = RModuleUtil.getInstance().findRubySdkForModule(module))) {
            return;
        }
        GemManager.getInstance().refresh(sdk2);
        List<String> list2 = RbenvGemsetManager.getRbenvConfiguredGemsets(module, sdk2);
        RbenvGemsetManager.getConfiguredGemsetSdks(sdk2, list2).forEach(sdk -> GemManager.getInstance().refresh((Sdk)sdk));
    }

    @NotNull
    public static Collection<String> getGemsetGemsURLs(@NotNull Sdk sdk) {
        String string;
        long l2 = c ^ 0x2A61B228FDBAL;
        if (sdk == null) {
            RbenvGemsetManager.a(71);
        }
        if ((string = RbenvGemsetManager.getRbenvGemset(sdk)) == null) {
            List list2 = ContainerUtil.emptyList();
            if (list2 == null) {
                RbenvGemsetManager.a(72);
            }
            return list2;
        }
        VirtualFile virtualFile2 = (VirtualFile)ContainerUtil.find((Object[])RbenvGemsetManager.a(sdk), virtualFile -> string.equals(virtualFile.getName()));
        if (virtualFile2 == null) {
            List list3 = ContainerUtil.emptyList();
            if (list3 == null) {
                RbenvGemsetManager.a(73);
            }
            return list3;
        }
        List list4 = ContainerUtil.newSmartList((Object[])new String[]{virtualFile2.getUrl() + File.separator + GEMS_FOLDER, virtualFile2.getUrl() + File.separator + BUNDLER_FOLDER + File.separator + GEMS_FOLDER});
        if (list4 == null) {
            RbenvGemsetManager.a(74);
        }
        return list4;
    }

    @NotNull
    public static List<VirtualFile> getLocalGemsetFolders(@NotNull Module module, @Nullable Sdk sdk) {
        if (module == null) {
            RbenvGemsetManager.a(75);
        }
        List<String> list2 = RbenvGemsetManager.getLocalGemsets(module, sdk);
        List list3 = ContainerUtil.mapNotNull(list2, string -> {
            if (module == null) {
                RbenvGemsetManager.a(91);
            }
            if (string.startsWith(DOT_PREFIX)) {
                return RbenvGemsetManager.getLocalGemsetFolder(module, string);
            }
            return null;
        });
        if (list3 == null) {
            RbenvGemsetManager.a(76);
        }
        return list3;
    }

    @Nullable
    public static VirtualFile getLocalGemsetFolder(@NotNull Module module, @NotNull String localGemsetName) {
        VirtualFile[] virtualFileArray;
        if (module == null) {
            RbenvGemsetManager.a(77);
        }
        if (localGemsetName == null) {
            RbenvGemsetManager.a(78);
        }
        if (!RbenvGemsetManager.a(localGemsetName)) {
            return null;
        }
        RailsApp railsApp = RailsApp.fromModule(module);
        if (railsApp != null && (virtualFileArray = railsApp.getRailsApplicationRoot()) != null) {
            return virtualFileArray.findChild(localGemsetName);
        }
        if (module.isDisposed()) {
            return null;
        }
        for (VirtualFile virtualFile : ModuleRootManager.getInstance((Module)module).getContentRoots()) {
            VirtualFile virtualFile2 = virtualFile.findFileByRelativePath(localGemsetName);
            if (virtualFile2 == null) continue;
            return virtualFile2;
        }
        return null;
    }

    public static void excludeLocalGemsets(@NotNull Module module) {
        PsiFile psiFile;
        if (module == null) {
            RbenvGemsetManager.a(79);
        }
        if ((psiFile = RbenvGemsetManager.getRbenvGemsetConfig(module)) == null) {
            return;
        }
        for (VirtualFile virtualFile : RbenvGemsetManager.a(module, psiFile.getText())) {
            RbenvGemsetManager.a(module, virtualFile);
        }
    }

    public static void excludeAndUpdateLocalGemset(@NotNull Module module, @NotNull VirtualFile gemsetDirectory) {
        if (module == null) {
            RbenvGemsetManager.a(80);
        }
        if (gemsetDirectory == null) {
            RbenvGemsetManager.a(81);
        }
        if (!RbenvGemsetManager.a(module, gemsetDirectory)) {
            return;
        }
        GemManager.updateGemset(module);
    }

    private static boolean a(@NotNull Module module, @NotNull VirtualFile virtualFile) {
        ProjectFileIndex projectFileIndex;
        if (module == null) {
            RbenvGemsetManager.a(82);
        }
        if (virtualFile == null) {
            RbenvGemsetManager.a(83);
        }
        if ((projectFileIndex = ProjectRootManager.getInstance((Project)module.getProject()).getFileIndex()).isExcluded(virtualFile)) {
            return false;
        }
        VirtualFile virtualFile2 = projectFileIndex.getContentRootForFile(virtualFile);
        if (virtualFile2 == null) {
            return false;
        }
        return (Boolean)WriteAction.compute(() -> {
            if (module == null) {
                RbenvGemsetManager.a(89);
            }
            if (virtualFile == null) {
                RbenvGemsetManager.a(90);
            }
            ModifiableRootModel modifiableRootModel = ModuleRootManager.getInstance((Module)module).getModifiableModel();
            try {
                for (ContentEntry contentEntry : modifiableRootModel.getContentEntries()) {
                    if (!StringUtil.equals((CharSequence)virtualFile2.getUrl(), (CharSequence)contentEntry.getUrl())) continue;
                    contentEntry.addExcludeFolder(virtualFile);
                    modifiableRootModel.commit();
                    Boolean bl2 = true;
                    return bl2;
                }
                Boolean bl3 = false;
                return bl3;
            }
            finally {
                if (!modifiableRootModel.isDisposed()) {
                    modifiableRootModel.dispose();
                }
            }
        });
    }

    public static void updateLibraries(@NotNull Sdk rootSdk, @NotNull Module module) {
        if (rootSdk == null) {
            RbenvGemsetManager.a(84);
        }
        if (module == null) {
            RbenvGemsetManager.a(85);
        }
        ApplicationManager.getApplication().invokeAndWait(() -> {
            if (module == null) {
                RbenvGemsetManager.a(87);
            }
            if (rootSdk == null) {
                RbenvGemsetManager.a(88);
            }
            List<String> list2 = RbenvGemsetManager.getRbenvCurrentGemsets(module);
            List<Sdk> list3 = RbenvGemsetManager.getConfiguredGemsetSdks(rootSdk, list2);
            for (Sdk sdk2 : list3) {
                GemManager.getInstance().refresh(sdk2);
            }
            GemManager.getInstance().refresh(rootSdk);
            GemManager.updateGemset(module);
        }, ModalityState.current());
    }

    public static void saveConfigFile(@NotNull Module module) {
        VirtualFile virtualFile;
        if (module == null) {
            RbenvGemsetManager.a(86);
        }
        if ((virtualFile = RbenvGemsetManager.getConfigVirtualFile(module)) == null) {
            return;
        }
        Document document = FileDocumentManager.getInstance().getDocument(virtualFile);
        if (document == null) {
            return;
        }
        FileDocumentManager.getInstance().saveDocument(document);
    }

    private static boolean a() {
        long l2 = c ^ 0x5FD9280E70E7L;
        return FileUtil.exists((String)FileUtil.expandUserHome((String)"~/.rbenv/plugins/rbenv-gemset")) || FileUtil.exists((String)"/usr/local/bin/rbenv-gemset");
    }

    static {
        c = la.a(8252829343785491762L, 7966407888945702272L, MethodHandles.lookup().lookupClass()).a(101899628871813L);
        RBENV_GEMSETS_CONFIG_REQUESTOR = new Object();
        RBENV_PLUGIN_INSTALLED = new AtomicClearableLazyValue<Boolean>(){
            private static final long a = la.a(-2134440700595009292L, -4383760164833694256L, MethodHandles.lookup().lookupClass()).a(66056658074813L);

            @NotNull
            protected Boolean compute() {
                Boolean bl2 = RbenvGemsetManager.a();
                if (bl2 == null) {
                    1.a(0);
                }
                return bl2;
            }

            private static /* synthetic */ void a(int n2) {
                long l2 = a ^ 0x75960D78F6F7L;
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/ruby/version/management/rbenv/gemsets/RbenvGemsetManager$1", "compute"));
            }
        };
        b = Logger.getInstance(RbenvGemsetManager.class);
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = c ^ 0x757D2FDE25D8L;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 16: 
            case 18: 
            case 19: 
            case 24: 
            case 26: 
            case 28: 
            case 30: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 37: 
            case 38: 
            case 39: 
            case 42: 
            case 65: 
            case 67: 
            case 68: 
            case 72: 
            case 73: 
            case 74: 
            case 76: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 16: 
            case 18: 
            case 19: 
            case 24: 
            case 26: 
            case 28: 
            case 30: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 37: 
            case 38: 
            case 39: 
            case 42: 
            case 65: 
            case 67: 
            case 68: 
            case 72: 
            case 73: 
            case 74: 
            case 76: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 1: 
            case 4: 
            case 45: 
            case 59: 
            case 61: 
            case 63: 
            case 83: 
            case 90: 
            case 96: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gemset";
                break;
            }
            case 2: 
            case 55: 
            case 93: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 25: 
            case 29: 
            case 31: 
            case 36: 
            case 40: 
            case 47: 
            case 49: 
            case 62: 
            case 70: 
            case 75: 
            case 77: 
            case 79: 
            case 80: 
            case 82: 
            case 85: 
            case 86: 
            case 87: 
            case 89: 
            case 91: 
            case 95: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentEntry";
                break;
            }
            case 9: 
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localGemsetName";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 16: 
            case 18: 
            case 19: 
            case 24: 
            case 26: 
            case 28: 
            case 30: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 37: 
            case 38: 
            case 39: 
            case 42: 
            case 65: 
            case 67: 
            case 68: 
            case 72: 
            case 73: 
            case 74: 
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/version/management/rbenv/gemsets/RbenvGemsetManager";
                break;
            }
            case 23: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = RBENV_GEMSETS_DIRECTORY_NAME;
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 44: 
            case 58: 
            case 60: 
            case 64: 
            case 66: 
            case 84: 
            case 88: 
            case 92: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootSdk";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkInfo";
                break;
            }
            case 48: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configText";
                break;
            }
            case 52: 
            case 54: 
            case 94: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gemsetOrSdks";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdks";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gemInfo";
                break;
            }
            case 81: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gemsetDirectory";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/version/management/rbenv/gemsets/RbenvGemsetManager";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getRbenvGemsetNames";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getRbenvGemsets";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalGemsetsFolders";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalGemsets";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "filterLocalGemsets";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommandLineRbenvGemsets";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentGemsetsOnly";
                break;
            }
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getRbenvCurrentGemsets";
                break;
            }
            case 37: 
            case 38: 
            case 39: 
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "getRbenvConfiguredGemsets";
                break;
            }
            case 65: {
                objectArray = objectArray2;
                objectArray2[1] = "getGemsetsSdk";
                break;
            }
            case 67: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfiguredGemsetSdks";
                break;
            }
            case 68: {
                objectArray = objectArray2;
                objectArray2[1] = "getRubySdks";
                break;
            }
            case 72: 
            case 73: 
            case 74: {
                objectArray = objectArray2;
                objectArray2[1] = "getGemsetGemsURLs";
                break;
            }
            case 76: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalGemsetFolders";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createGemset";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getGemsetSdk";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getGemsetSdkVersion";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addRbenvLocalGemsetsExcludedFolders";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createLocalGemset";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createRbenvGemsetConfig";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isRbenvGemsetConfig";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getRbenvGemsetConfig";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getConfigVirtualFile";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getRbenvGemsetNames";
                break;
            }
            case 16: 
            case 18: 
            case 19: 
            case 24: 
            case 26: 
            case 28: 
            case 30: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 37: 
            case 38: 
            case 39: 
            case 42: 
            case 65: 
            case 67: 
            case 68: 
            case 72: 
            case 73: 
            case 74: 
            case 76: {
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getRbenvGemsets";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getGemsetsFolder";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getSdkHomeDirectory";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getSdkHomePath";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getLocalGemsetsFolders";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getLocalGemsets";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "filterLocalGemsets";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getCommandLineRbenvGemsets";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getCurrentGemsetsOnly";
                break;
            }
            case 36: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getRbenvConfiguredGemsets";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getConfigText";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "getShimsCommandPath";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "isGemsetOfSdk";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "isGemsetSdk";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "applyRbenvGemsetsToConfig";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "hasGlobal";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "hasGlobalDisabled";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "isGlobalGemsetSdk";
                break;
            }
            case 52: 
            case 53: 
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "findRootRbenvSdk";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "isRootRbenvSdk";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "fetchGemGemset";
                break;
            }
            case 58: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "refreshGemsetFolder";
                break;
            }
            case 60: 
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "hasGemset";
                break;
            }
            case 62: 
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "hasLocalGemset";
                break;
            }
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "getGemsetsSdk";
                break;
            }
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "getConfiguredGemsetSdks";
                break;
            }
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "getSdkVersion";
                break;
            }
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "refreshAttachedGemsetSdks";
                break;
            }
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "getGemsetGemsURLs";
                break;
            }
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "getLocalGemsetFolders";
                break;
            }
            case 77: 
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "getLocalGemsetFolder";
                break;
            }
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "excludeLocalGemsets";
                break;
            }
            case 80: 
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "excludeAndUpdateLocalGemset";
                break;
            }
            case 82: 
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "markFolderAsExcluded";
                break;
            }
            case 84: 
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "updateLibraries";
                break;
            }
            case 86: {
                objectArray = objectArray;
                objectArray[2] = "saveConfigFile";
                break;
            }
            case 87: 
            case 88: {
                objectArray = objectArray;
                objectArray[2] = "lambda$updateLibraries$15";
                break;
            }
            case 89: 
            case 90: {
                objectArray = objectArray;
                objectArray[2] = "lambda$markFolderAsExcluded$14";
                break;
            }
            case 91: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getLocalGemsetFolders$13";
                break;
            }
            case 92: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getGemsetsSdk$8";
                break;
            }
            case 93: {
                objectArray = objectArray;
                objectArray[2] = "lambda$findRootRbenvSdk$7";
                break;
            }
            case 94: {
                objectArray = objectArray;
                objectArray[2] = "lambda$findRootRbenvSdk$6";
                break;
            }
            case 95: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getRbenvGemsetConfig$1";
                break;
            }
            case 96: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getGemsetSdk$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 16: 
            case 18: 
            case 19: 
            case 24: 
            case 26: 
            case 28: 
            case 30: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 37: 
            case 38: 
            case 39: 
            case 42: 
            case 65: 
            case 67: 
            case 68: 
            case 72: 
            case 73: 
            case 74: 
            case 76: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

