/*
 * Decompiled with CFR 0.152.
 */
package org.rubyforge.debugcommons;

import b.h.la;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.invoke.MethodHandles;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.rubyforge.debugcommons.RubyDebuggerException;
import org.rubyforge.debugcommons.Util;
import org.rubyforge.debugcommons.model.ExpressionInfo;
import org.rubyforge.debugcommons.model.Message;
import org.rubyforge.debugcommons.model.RubyFrameInfo;
import org.rubyforge.debugcommons.model.RubyThreadInfo;
import org.rubyforge.debugcommons.model.RubyVariableInfo;
import org.rubyforge.debugcommons.model.SuspensionPoint;
import org.rubyforge.debugcommons.reader.BreakpointAddedReader;
import org.rubyforge.debugcommons.reader.BreakpointDeletedReader;
import org.rubyforge.debugcommons.reader.BreakpointDisabledReader;
import org.rubyforge.debugcommons.reader.BreakpointEnabledReader;
import org.rubyforge.debugcommons.reader.CatchpointSetReader;
import org.rubyforge.debugcommons.reader.ConditionSetReader;
import org.rubyforge.debugcommons.reader.ErrorReader;
import org.rubyforge.debugcommons.reader.ExpressionInfoReader;
import org.rubyforge.debugcommons.reader.FramesReader;
import org.rubyforge.debugcommons.reader.SuspensionReader;
import org.rubyforge.debugcommons.reader.ThreadInfoReader;
import org.rubyforge.debugcommons.reader.VariablesReader;
import org.rubyforge.debugcommons.reader.XmlStreamReader;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

final class ReadersSupport {
    private static final Logger j;
    private static final String i = "breakpoint";
    private static final String k = "suspended";
    private static final String q = "exception";
    private static final String I = "breakpointAdded";
    private static final String c = "breakpointDeleted";
    private static final String t = "breakpointEnabled";
    private static final String b = "breakpointDisabled";
    private static final String d = "conditionSet";
    private static final String o = "catchpointSet";
    private static final String e = "catchpointDeleted";
    private static final String L = "threads";
    private static final String f = "frames";
    private static final String J = "frame";
    private static final String E = "variables";
    private static final String m = "processingException";
    private static final String h = "expressionInfo";
    private static final String H = "fileIncluded";
    private static final String s = "fileExcluded";
    private static final String n = "fileFilter";
    private static final String C = "PROMPT";
    private static final String z = "finished";
    private final long u;
    private final BlockingQueue<RubyThreadInfo[]> v;
    private final BlockingQueue<RubyFrameInfo[]> G;
    private final BlockingQueue<RubyVariableInfo[]> w;
    private final BlockingQueue<SuspensionPoint> g;
    private static final Set<InputStream> l;
    private final BlockingQueue<Integer> p;
    private final BlockingQueue<Integer> K;
    private final BlockingQueue<Integer> B;
    private final BlockingQueue<Integer> F;
    private final BlockingQueue<Integer> A;
    private final BlockingQueue<String> a;
    private final BlockingQueue<String> D;
    private final BlockingQueue<ExpressionInfo> y;
    private boolean x;
    private boolean r;
    private static final long M;

    ReadersSupport(long timeout) {
        this.u = 2L * Math.max(10L, timeout);
        this.v = new LinkedBlockingQueue<RubyThreadInfo[]>();
        this.G = new LinkedBlockingQueue<RubyFrameInfo[]>();
        this.w = new LinkedBlockingQueue<RubyVariableInfo[]>();
        this.g = new LinkedBlockingQueue<SuspensionPoint>();
        this.p = new LinkedBlockingQueue<Integer>();
        this.K = new LinkedBlockingQueue<Integer>();
        this.B = new LinkedBlockingQueue<Integer>();
        this.F = new LinkedBlockingQueue<Integer>();
        this.A = new LinkedBlockingQueue<Integer>();
        this.a = new LinkedBlockingQueue<String>();
        this.D = new LinkedBlockingQueue<String>();
        this.y = new LinkedBlockingQueue<ExpressionInfo>();
    }

    boolean startCommandLoop(InputStream is2) throws RubyDebuggerException {
        long l2 = M ^ 0x2C5795671664L;
        if (l.contains(is2)) {
            return false;
        }
        try {
            new XPPLoop(is2, ReadersSupport.class + " command loop").start();
            l.add(is2);
            return true;
        }
        catch (IOException iOException) {
            throw new RubyDebuggerException(iOException);
        }
        catch (XmlPullParserException xmlPullParserException) {
            throw new RubyDebuggerException(xmlPullParserException);
        }
    }

    private void b(XmlPullParser xmlPullParser) throws XmlPullParserException, IOException {
        long l2 = M ^ 0x562860DEA0AAL;
        int n2 = xmlPullParser.getEventType();
        do {
            if (n2 == 2) {
                this.a(xmlPullParser);
            } else if (n2 == 3) {
                assert (false) : "Unexpected state: end tag " + xmlPullParser.getName();
            } else if (n2 == 4) {
                if (xmlPullParser.getText().contains(C)) {
                    j.debug("got ruby-debug prompt message");
                } else assert (false) : "Unexpected state: got text \"" + xmlPullParser.getText() + '\"';
            } else if (n2 != 0) assert (false) : "Unexpected state: " + n2;
            if (this.x) break;
            n2 = xmlPullParser.next();
            Util.logEvent(xmlPullParser);
        } while (n2 != 1);
    }

    private void a(XmlPullParser xmlPullParser) throws IOException, XmlPullParserException {
        long l2 = M ^ 0x3C1763C13195L;
        String string = xmlPullParser.getName();
        if (I.equals(string)) {
            this.p.add(BreakpointAddedReader.readBreakpointNo(xmlPullParser));
        } else if (c.equals(string)) {
            this.K.add(BreakpointDeletedReader.readBreakpointNo(xmlPullParser));
        } else if (t.equals(string)) {
            this.B.add(BreakpointEnabledReader.readBreakpointNo(xmlPullParser));
        } else if (b.equals(string)) {
            this.F.add(BreakpointDisabledReader.readBreakpointNo(xmlPullParser));
        } else if (i.equals(string) || k.equals(string) || q.equals(string)) {
            SuspensionPoint suspensionPoint = SuspensionReader.readSuspension(xmlPullParser);
            this.g.add(suspensionPoint);
        } else if (d.equals(string)) {
            this.A.add(ConditionSetReader.readBreakpointNo(xmlPullParser));
        } else if (o.equals(string)) {
            this.a.add(CatchpointSetReader.readExceptionClassName(xmlPullParser));
        } else if (e.equals(string)) {
            this.D.add(CatchpointSetReader.readExceptionClassName(xmlPullParser));
        } else if (L.equals(string)) {
            this.v.add(ThreadInfoReader.readThreads(xmlPullParser));
        } else if (f.equals(string)) {
            this.G.add(FramesReader.readFrames(xmlPullParser));
        } else if (E.equals(string)) {
            this.w.add(VariablesReader.readVariables(xmlPullParser));
        } else if (m.equals(string)) {
            VariablesReader.logProcessingException(xmlPullParser);
            this.w.add(new RubyVariableInfo[0]);
        } else if (J.equals(string)) {
            XmlStreamReader.ensureEndTag(xmlPullParser, string);
        } else if (h.equals(string)) {
            this.y.add(ExpressionInfoReader.readExpressionInfo(xmlPullParser));
        } else if (H.equals(string) || s.equals(string) || n.equals(string)) {
            XmlStreamReader.ensureEndTag(xmlPullParser, string);
        } else {
            Message message = ErrorReader.tryToReadMessageOrError(xmlPullParser, string);
            if (message != null) {
                if (message.getText().equals(z)) {
                    j.debug("Got 'finished' <message>, text == finished");
                    this.x = true;
                }
            } else assert (false) : "Unexpected element: " + string + " pid = " + xmlPullParser.getAttributeValue("", "pid");
        }
    }

    private <T> T[] a(BlockingQueue<T[]> blockingQueue) throws RubyDebuggerException {
        long l2 = M ^ 0x48557067E7E4L;
        Application application = ApplicationManager.getApplication();
        if (application.isInternal()) {
            j.assertTrue(!application.isReadAccessAllowed(), (Object)"do not poll ruby debugger under read lock");
        }
        try {
            T[] TArray = blockingQueue.poll(this.u, TimeUnit.SECONDS);
            if (TArray == null) {
                throw new RubyDebuggerException("Unable to read information in the specified timeout [" + this.u + "s]");
            }
            return TArray;
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            throw new RubyDebuggerException("Interruped during reading information " + blockingQueue.getClass(), interruptedException);
        }
    }

    RubyThreadInfo[] readThreads() throws RubyDebuggerException {
        return (RubyThreadInfo[])this.a(this.v);
    }

    RubyFrameInfo[] readFrames() throws RubyDebuggerException {
        return (RubyFrameInfo[])this.a(this.G);
    }

    ExpressionInfo readExpressionInfo() throws RubyDebuggerException {
        long l2 = M ^ 0x115D6563ACB3L;
        return this.a(this.y, "expression info");
    }

    RubyVariableInfo[] readVariables() throws RubyDebuggerException {
        return (RubyVariableInfo[])this.a(this.w);
    }

    int readAddedBreakpointNo() throws RubyDebuggerException {
        long l2 = M ^ 0x455208684A71L;
        return this.a(this.p, "added breakpoint number");
    }

    int readEnabledBreakpointNo(int breakpointID) throws RubyDebuggerException {
        long l2 = M ^ 0x4AB9D6A7A712L;
        int n2 = this.a(this.B, "breakpoint number of the enabled breakpoint (" + breakpointID + ")");
        if (n2 != breakpointID) {
            throw new RubyDebuggerException("Unexpected breakpoint removed. Received id: " + n2 + ", expected: " + breakpointID);
        }
        return n2;
    }

    int readDisabledBreakpointNo(int breakpointID) throws RubyDebuggerException {
        long l2 = M ^ 0x7FFDB72F05D2L;
        int n2 = this.a(this.F, "breakpoint number of the disabled breakpoint (" + breakpointID + ")");
        if (n2 != breakpointID) {
            throw new RubyDebuggerException("Unexpected breakpoint removed. Received id: " + n2 + ", expected: " + breakpointID);
        }
        return n2;
    }

    int readConditionSet() throws RubyDebuggerException {
        long l2 = M ^ 0x42F34B502BA5L;
        return this.a(this.A, "breakpoint number of the set condition");
    }

    String readCatchpointSet() throws RubyDebuggerException {
        long l2 = M ^ 0x4ED70DB059A9L;
        return this.a(this.a, "catchpoint set");
    }

    String readCatchpointDeleted() throws RubyDebuggerException {
        long l2 = M ^ 0x188E024587E5L;
        return this.a(this.D, "catchpoint deleted");
    }

    int waitForRemovedBreakpoint(int breakpointID) throws RubyDebuggerException {
        long l2 = M ^ 0x64E7F8A6F872L;
        int n2 = this.a(this.K, "breakpoint number of the removed breakpoint (" + breakpointID + ")");
        if (n2 != breakpointID) {
            throw new RubyDebuggerException("Unexpected breakpoint removed. Received id: " + n2 + ", expected: " + breakpointID);
        }
        return n2;
    }

    private <T> T a(BlockingQueue<T> blockingQueue, String string) throws RubyDebuggerException {
        long l2 = M ^ 0x6EB9FAEA77D0L;
        Application application = ApplicationManager.getApplication();
        j.assertTrue(!application.isInternal() || !application.isReadAccessAllowed(), (Object)"do not poll ruby debugger under read lock");
        try {
            T t2 = blockingQueue.poll(this.u, TimeUnit.SECONDS);
            if (t2 == null) {
                throw new RubyDebuggerException("Unable to read " + string + " in the specified timeout [" + this.u + "s]");
            }
            return t2;
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            throw new RubyDebuggerException("Interruped during reading " + string + " (timeout: " + this.u + ')', interruptedException);
        }
    }

    SuspensionPoint readSuspension() {
        long l2 = M ^ 0x210E8E98AD29L;
        try {
            return this.g.take();
        }
        catch (InterruptedException interruptedException) {
            j.error("Interrupted during reading suspension point", (Throwable)interruptedException);
            return null;
        }
    }

    boolean isUnexpectedFail() {
        return this.r;
    }

    private static XmlPullParser a(InputStream inputStream) throws XmlPullParserException, IOException {
        long l2 = M ^ 0x717B3AD257C8L;
        XmlPullParserFactory xmlPullParserFactory = XmlPullParserFactory.newInstance((String)"org.kxml2.io.KXmlParser,org.kxml2.io.KXmlSerializer", null);
        XmlPullParser xmlPullParser = xmlPullParserFactory.newPullParser();
        xmlPullParser.setInput((Reader)new BufferedReader(new InputStreamReader(inputStream)));
        return xmlPullParser;
    }

    static {
        M = la.a(-7745361181111072431L, 6371261974868493160L, MethodHandles.lookup().lookupClass()).a(157744771627416L);
        j = Logger.getInstance(ReadersSupport.class);
        l = new HashSet<InputStream>();
    }

    private class XPPLoop
    extends Thread {
        private final XmlPullParser a;
        private final InputStream b;
        private static final long c = la.a(-1522891301830724210L, -5653680978606384038L, MethodHandles.lookup().lookupClass()).a(30880835909397L);

        XPPLoop(InputStream is2, String loopName) throws XmlPullParserException, IOException {
            super(loopName);
            this.b = is2;
            this.a = ReadersSupport.a(is2);
        }

        @Override
        public void run() {
            long l2 = c ^ 0x63BCBF9BB9F2L;
            try {
                j.debug("Starting ReadersSupport readloop: " + this.getName());
                ReadersSupport.this.b(this.a);
                j.debug("ReadersSupport readloop [" + this.getName() + "] successfully finished.");
            }
            catch (IOException iOException) {
                j.debug("SocketException. Loop [" + this.getName() + "]: " + iOException.getMessage());
                j.debug(iOException.getMessage(), (Throwable)iOException);
                ReadersSupport.this.r = true;
            }
            catch (XmlPullParserException xmlPullParserException) {
                j.error("Exception during ReadersSupport loop [" + this.getName() + ']', (Throwable)xmlPullParserException);
                ReadersSupport.this.r = true;
            }
            finally {
                ReadersSupport.this.g.add(SuspensionPoint.END);
                try {
                    this.b.close();
                    Thread.sleep(1000L);
                }
                catch (IOException iOException) {
                    j.error("Cannot close socket's input stream", (Throwable)iOException);
                }
                catch (InterruptedException interruptedException) {
                    j.error("Readers loop interrupted", (Throwable)interruptedException);
                }
            }
        }
    }
}

