/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.history;

import com.intellij.CommonBundle;
import com.intellij.icons.AllIcons;
import com.intellij.ide.CopyProvider;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.VcsInternalDataKeys;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.EmptyAction;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.colors.EditorColorsListener;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.Clock;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.ByteBackedContentRevision;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.CurrentContentRevision;
import com.intellij.openapi.vcs.changes.issueLinks.IssueLinkRenderer;
import com.intellij.openapi.vcs.changes.issueLinks.TableLinkMouseListener;
import com.intellij.openapi.vcs.history.DetailsPanel;
import com.intellij.openapi.vcs.history.FileHistoryColumnWrapper;
import com.intellij.openapi.vcs.history.FileHistoryRefresherI;
import com.intellij.openapi.vcs.history.HistoryAsTreeProvider;
import com.intellij.openapi.vcs.history.TreeNodeOnVcsRevision;
import com.intellij.openapi.vcs.history.VcsCachingHistory;
import com.intellij.openapi.vcs.history.VcsDependentHistoryComponents;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsFileRevisionEx;
import com.intellij.openapi.vcs.history.VcsHistoryProvider;
import com.intellij.openapi.vcs.history.VcsHistorySession;
import com.intellij.openapi.vcs.history.VcsHistoryUtil;
import com.intellij.openapi.vcs.history.VcsRevisionDescription;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.impl.VcsBackgroundableActions;
import com.intellij.openapi.vcs.vfs.VcsFileSystem;
import com.intellij.openapi.vcs.vfs.VcsVirtualFile;
import com.intellij.openapi.vcs.vfs.VcsVirtualFolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.JBColor;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.SpeedSearchComparator;
import com.intellij.ui.TableSpeedSearch;
import com.intellij.ui.dualView.CellWrapper;
import com.intellij.ui.dualView.DualView;
import com.intellij.ui.dualView.DualViewColumnInfo;
import com.intellij.ui.dualView.TreeTableView;
import com.intellij.ui.speedSearch.SpeedSearchUtil;
import com.intellij.ui.table.TableView;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.PlatformIcons;
import com.intellij.util.TreeItem;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.StatusText;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcsUtil.VcsUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileHistoryPanelImpl
extends JPanel
implements DataProvider,
Disposable,
EditorColorsListener,
CopyProvider {
    private static final String COMMIT_MESSAGE_TITLE = VcsBundle.message((String)"label.selected.revision.commit.message", (Object[])new Object[0]);
    private static final String VCS_HISTORY_POPUP_ACTION_GROUP = "VcsHistoryInternalGroup.Popup";
    private static final String VCS_HISTORY_TOOLBAR_ACTION_GROUP = "VcsHistoryInternalGroup.Toolbar";
    public static final DataKey<VcsFileRevision> PREVIOUS_REVISION_FOR_DIFF = DataKey.create((String)"PREVIOUS_VCS_FILE_REVISION_FOR_DIFF");
    private final String myHelpId;
    @NotNull
    private final AbstractVcs myVcs;
    private final VcsHistoryProvider myProvider;
    @NotNull
    private final FileHistoryRefresherI myRefresherI;
    @NotNull
    private final FilePath myFilePath;
    @Nullable
    private final VcsRevisionNumber myStartingRevision;
    @NotNull
    private final Map<VcsRevisionNumber, Integer> myRevisionsOrder;
    @NotNull
    private final Map<VcsFileRevision, VirtualFile> myRevisionToVirtualFile;
    @NotNull
    private final DetailsPanel myDetails;
    @NotNull
    private final DualView myDualView;
    @Nullable
    private final JComponent myAdditionalDetails;
    @Nullable
    private final Consumer<VcsFileRevision> myRevisionSelectionListener;
    @NotNull
    private VcsHistorySession myHistorySession;
    private VcsFileRevision myBottomRevisionForShowDiff;
    private List<Object> myTargetSelection;
    private boolean myIsStaticAndEmbedded;
    private Splitter myDetailsSplitter;
    private Splitter mySplitter;

    public FileHistoryPanelImpl(@NotNull AbstractVcs vcs, @NotNull FilePath filePath, @NotNull VcsHistorySession session2, VcsHistoryProvider provider, @NotNull FileHistoryRefresherI refresherI, boolean isStaticEmbedded) {
        if (vcs == null) {
            FileHistoryPanelImpl.$$$reportNull$$$0(0);
        }
        if (filePath == null) {
            FileHistoryPanelImpl.$$$reportNull$$$0(1);
        }
        if (session2 == null) {
            FileHistoryPanelImpl.$$$reportNull$$$0(2);
        }
        if (refresherI == null) {
            FileHistoryPanelImpl.$$$reportNull$$$0(3);
        }
        this(vcs, filePath, null, session2, provider, refresherI, isStaticEmbedded);
    }

    public FileHistoryPanelImpl(@NotNull AbstractVcs vcs, @NotNull FilePath filePath, @Nullable VcsRevisionNumber startingRevision, @NotNull VcsHistorySession session2, VcsHistoryProvider provider, @NotNull FileHistoryRefresherI refresherI, boolean isStaticEmbedded) {
        if (vcs == null) {
            FileHistoryPanelImpl.$$$reportNull$$$0(4);
        }
        if (filePath == null) {
            FileHistoryPanelImpl.$$$reportNull$$$0(5);
        }
        if (session2 == null) {
            FileHistoryPanelImpl.$$$reportNull$$$0(6);
        }
        if (refresherI == null) {
            FileHistoryPanelImpl.$$$reportNull$$$0(7);
        }
        super(new BorderLayout());
        this.myRevisionsOrder = ContainerUtil.newHashMap();
        this.myRevisionToVirtualFile = ContainerUtil.newHashMap();
        this.myHelpId = provider.getHelpId() != null ? provider.getHelpId() : "reference.versionControl.toolwindow.history";
        this.myIsStaticAndEmbedded = false;
        this.myVcs = vcs;
        this.myProvider = provider;
        this.myRefresherI = refresherI;
        this.myHistorySession = session2;
        this.myFilePath = filePath;
        this.myStartingRevision = startingRevision;
        this.myDetails = new DetailsPanel(vcs.getProject());
        this.refreshRevisionsOrder();
        VcsDependentHistoryComponents components = provider.getUICustomization(session2, (JComponent)this);
        this.myAdditionalDetails = components.getDetailsComponent();
        this.myRevisionSelectionListener = components.getRevisionListener();
        DualViewColumnInfo[] columns = this.createColumnList(vcs.getProject(), provider, components.getColumns());
        String storageKey = "FileHistory." + provider.getClass().getName();
        HistoryAsTreeProvider treeHistoryProvider = this.myHistorySession.getHistoryAsTreeProvider();
        if (treeHistoryProvider != null) {
            this.myDualView = new DualView((Object)new TreeNodeOnVcsRevision(null, treeHistoryProvider.createTreeOn(this.myHistorySession.getRevisionList())), columns, storageKey, this.myVcs.getProject());
        } else {
            this.myDualView = new DualView((Object)new TreeNodeOnVcsRevision(null, ContainerUtil.map((Collection)this.myHistorySession.getRevisionList(), TreeItem::new)), columns, storageKey, this.myVcs.getProject());
            this.myDualView.switchToTheFlatMode();
        }
        new TableSpeedSearch((JTable)this.myDualView.getFlatView()).setComparator(new SpeedSearchComparator(false));
        TableLinkMouseListener listener2 = new TableLinkMouseListener();
        listener2.installOn((Component)this.myDualView.getFlatView());
        listener2.installOn((Component)this.myDualView.getTreeView());
        this.myDualView.setEmptyText(CommonBundle.getLoadingTreeNodeText());
        this.setupDualView(this.fillActionGroup(true, new DefaultActionGroup(null, false)));
        if (isStaticEmbedded) {
            this.setIsStaticAndEmbedded(true);
        }
        DefaultActionGroup toolbarGroup = new DefaultActionGroup(null, false);
        this.fillActionGroup(false, toolbarGroup);
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("FileHistoryViewToolbar", (ActionGroup)toolbarGroup, isStaticEmbedded);
        JComponent centerPanel = this.createCenterPanel();
        toolbar.setTargetComponent(centerPanel);
        for (AnAction action : toolbarGroup.getChildren(null)) {
            action.registerCustomShortcutSet(action.getShortcutSet(), centerPanel);
        }
        this.add((Component)centerPanel, "Center");
        this.add((Component)toolbar.getComponent(), isStaticEmbedded ? "North" : "West");
        this.chooseView();
        Disposer.register((Disposable)vcs.getProject(), (Disposable)this);
    }

    private static void makeBold(Component component) {
        if (component instanceof JComponent) {
            JComponent jComponent = (JComponent)component;
            Font font = jComponent.getFont();
            if (font != null) {
                jComponent.setFont(font.deriveFont(1));
            }
        } else if (component instanceof Container) {
            Container container = (Container)component;
            for (int i = 0; i < container.getComponentCount(); ++i) {
                FileHistoryPanelImpl.makeBold(container.getComponent(i));
            }
        }
    }

    @NotNull
    public static String getPresentableText(@NotNull VcsFileRevision revision, boolean withMessage) {
        if (revision == null) {
            FileHistoryPanelImpl.$$$reportNull$$$0(8);
        }
        StringBuilder sb = new StringBuilder();
        sb.append(VcsUtil.getShortRevisionString((VcsRevisionNumber)revision.getRevisionNumber())).append(" ");
        sb.append(revision.getAuthor());
        long time = revision.getRevisionDate().getTime();
        sb.append(" on ").append(DateFormatUtil.formatDate((long)time)).append(" at ").append(DateFormatUtil.formatTime((long)time));
        if (revision instanceof VcsFileRevisionEx && !Comparing.equal((String)revision.getAuthor(), (String)((VcsFileRevisionEx)revision).getCommitterName())) {
            sb.append(" (committed by ").append(((VcsFileRevisionEx)revision).getCommitterName()).append(")");
        }
        if (withMessage) {
            sb.append(" ").append(MessageColumnInfo.getSubject(revision));
        }
        String string = sb.toString();
        if (string == null) {
            FileHistoryPanelImpl.$$$reportNull$$$0(9);
        }
        return string;
    }

    static boolean sameHistories(@NotNull FileHistoryPanelImpl historyPanel, @NotNull FilePath filePath2, @Nullable VcsRevisionNumber startingRevision2) {
        if (historyPanel == null) {
            FileHistoryPanelImpl.$$$reportNull$$$0(10);
        }
        if (filePath2 == null) {
            FileHistoryPanelImpl.$$$reportNull$$$0(11);
        }
        return FileHistoryPanelImpl.sameHistories(historyPanel.myFilePath, historyPanel.myStartingRevision, filePath2, startingRevision2);
    }

    public static boolean sameHistories(@NotNull FilePath filePath1, @Nullable VcsRevisionNumber startingRevision1, @NotNull FilePath filePath2, @Nullable VcsRevisionNumber startingRevision2) {
        if (filePath1 == null) {
            FileHistoryPanelImpl.$$$reportNull$$$0(12);
        }
        if (filePath2 == null) {
            FileHistoryPanelImpl.$$$reportNull$$$0(13);
        }
        String existingRevision = startingRevision1 == null ? null : startingRevision1.asString();
        String newRevision = startingRevision2 == null ? null : startingRevision2.asString();
        return filePath1.equals(filePath2) && Comparing.equal((String)existingRevision, (String)newRevision);
    }

    @NotNull
    private DualViewColumnInfo[] createColumnList(@NotNull Project project, @NotNull VcsHistoryProvider provider, @Nullable ColumnInfo[] additionalColumns) {
        if (project == null) {
            FileHistoryPanelImpl.$$$reportNull$$$0(14);
        }
        if (provider == null) {
            FileHistoryPanelImpl.$$$reportNull$$$0(15);
        }
        ArrayList columns = new ArrayList();
        columns.add(new TreeNodeColumnInfoWrapper<VcsRevisionNumber>(new RevisionColumnInfo(Comparator.comparing(revision -> this.myRevisionsOrder.get(revision.getRevisionNumber()), Comparator.reverseOrder()))));
        if (!provider.isDateOmittable()) {
            columns.add(new TreeNodeColumnInfoWrapper<Date>(new DateColumnInfo()));
        }
        columns.add(new TreeNodeColumnInfoWrapper<String>(new AuthorColumnInfo()));
        if (additionalColumns != null) {
            for (ColumnInfo additionalColumn : additionalColumns) {
                columns.add(new TreeNodeColumnInfoWrapper(additionalColumn));
            }
        }
        columns.add(new TreeNodeColumnInfoWrapper<String>(new MessageColumnInfo(project)));
        DualViewColumnInfo[] dualViewColumnInfoArray = columns.toArray(new DualViewColumnInfo[0]);
        if (dualViewColumnInfoArray == null) {
            FileHistoryPanelImpl.$$$reportNull$$$0(16);
        }
        return dualViewColumnInfoArray;
    }

    public void setHistorySession(@NotNull VcsHistorySession session2) {
        if (session2 == null) {
            FileHistoryPanelImpl.$$$reportNull$$$0(17);
        }
        if (this.myTargetSelection == null) {
            this.myTargetSelection = this.myDualView.getFlatView().getSelectedObjects();
        }
        this.myHistorySession = session2;
        this.refreshRevisionsOrder();
        HistoryAsTreeProvider treeHistoryProvider = session2.getHistoryAsTreeProvider();
        if (this.myHistorySession.getRevisionList().isEmpty()) {
            this.adjustEmptyText();
        }
        if (treeHistoryProvider != null) {
            this.myDualView.setRoot((TreeNode)new TreeNodeOnVcsRevision(null, treeHistoryProvider.createTreeOn(this.myHistorySession.getRevisionList())), this.myTargetSelection);
        } else {
            this.myDualView.setRoot((TreeNode)new TreeNodeOnVcsRevision(null, ContainerUtil.map((Collection)this.myHistorySession.getRevisionList(), TreeItem::new)), this.myTargetSelection);
        }
        this.mySplitter.revalidate();
        this.mySplitter.repaint();
        this.myDualView.expandAll();
        this.myDualView.repaint();
    }

    public void finishRefresh() {
        TreeTableView treeView;
        int lastRow;
        if (this.myHistorySession.getHistoryAsTreeProvider() != null && (lastRow = (treeView = this.myDualView.getTreeView()).getRowCount() - 1) >= 0) {
            treeView.scrollRectToVisible(treeView.getCellRect(lastRow, 0, true));
        }
        this.myTargetSelection = null;
        this.mySplitter.revalidate();
        this.mySplitter.repaint();
    }

    private void adjustEmptyText() {
        VirtualFile virtualFile = this.myFilePath.getVirtualFile();
        if (!(virtualFile != null && virtualFile.isValid() || this.myFilePath.getIOFile().exists())) {
            this.myDualView.setEmptyText("File " + this.myFilePath.getName() + " not found");
        } else if (VcsCachingHistory.getHistoryLock(this.myVcs, VcsBackgroundableActions.CREATE_HISTORY_SESSION, this.myFilePath, this.myStartingRevision).isLocked()) {
            this.myDualView.setEmptyText(CommonBundle.getLoadingTreeNodeText());
        } else {
            this.myDualView.setEmptyText(StatusText.DEFAULT_EMPTY_TEXT);
        }
    }

    private void setupDualView(@NotNull DefaultActionGroup group) {
        if (group == null) {
            FileHistoryPanelImpl.$$$reportNull$$$0(18);
        }
        this.myDualView.setShowGrid(true);
        PopupHandler.installPopupHandler((JComponent)this.myDualView.getTreeView(), (ActionGroup)group, (String)"UpdatePopup", (ActionManager)ActionManager.getInstance());
        PopupHandler.installPopupHandler((JComponent)this.myDualView.getFlatView(), (ActionGroup)group, (String)"UpdatePopup", (ActionManager)ActionManager.getInstance());
        IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)this.myDualView, true));
        this.myDualView.addListSelectionListener(e -> this.updateMessage());
        this.myDualView.setRootVisible(false);
        this.myDualView.expandAll();
        this.myDualView.setTreeCellRenderer((TreeCellRenderer)new MyTreeCellRenderer(this.myDualView.getTree().getCellRenderer(), (Getter<VcsHistorySession>)((Getter)() -> this.myHistorySession)));
        this.myDualView.setCellWrapper((CellWrapper)new MyCellWrapper((Getter<VcsHistorySession>)((Getter)() -> this.myHistorySession)));
        this.myDualView.installDoubleClickHandler(EmptyAction.wrap((AnAction)ActionManager.getInstance().getAction("Diff.ShowDiff")));
        this.myDualView.getFlatView().getTableViewModel().setSortable(true);
        RowSorter rowSorter = this.myDualView.getFlatView().getRowSorter();
        if (rowSorter != null) {
            rowSorter.setSortKeys(Collections.singletonList(new RowSorter.SortKey(0, SortOrder.DESCENDING)));
        }
    }

    private void updateMessage() {
        List selection = this.myDualView.getSelection();
        this.myDetails.update(selection);
        if (selection.isEmpty()) {
            return;
        }
        if (this.myRevisionSelectionListener != null) {
            this.myRevisionSelectionListener.consume((Object)((TreeNodeOnVcsRevision)selection.get(0)).getRevision());
        }
    }

    @NotNull
    protected JComponent createCenterPanel() {
        this.mySplitter = new OnePixelSplitter(true, "vcs.history.splitter.proportion", 0.6f);
        this.mySplitter.setFirstComponent((JComponent)this.myDualView);
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane((Component)this.myDetails);
        scrollPane.setBorder(IdeBorderFactory.createBorder((int)1));
        this.myDetailsSplitter = new OnePixelSplitter(false, "vcs.history.details.splitter.proportion", 0.5f);
        this.myDetailsSplitter.setFirstComponent((JComponent)scrollPane);
        this.myDetailsSplitter.setSecondComponent(this.myAdditionalDetails);
        this.setupDetails();
        Splitter splitter = this.mySplitter;
        if (splitter == null) {
            FileHistoryPanelImpl.$$$reportNull$$$0(19);
        }
        return splitter;
    }

    private void setupDetails() {
        boolean showDetails = !this.myIsStaticAndEmbedded && VcsConfiguration.getInstance((Project)this.myVcs.getProject()).SHOW_FILE_HISTORY_DETAILS;
        this.myDualView.setViewBorder(IdeBorderFactory.createBorder((int)1));
        this.mySplitter.setSecondComponent((JComponent)(showDetails ? this.myDetailsSplitter : null));
    }

    private void chooseView() {
        if (VcsConfiguration.getInstance((Project)this.myVcs.getProject()).SHOW_FILE_HISTORY_AS_TREE) {
            this.myDualView.switchToTheTreeMode();
        } else {
            this.myDualView.switchToTheFlatMode();
        }
    }

    @NotNull
    private DefaultActionGroup fillActionGroup(boolean popup2, DefaultActionGroup result2) {
        if (popup2) {
            result2.add(ActionManager.getInstance().getAction("EditSource"));
        }
        AnAction actionGroup = ActionManager.getInstance().getAction(popup2 ? VCS_HISTORY_POPUP_ACTION_GROUP : VCS_HISTORY_TOOLBAR_ACTION_GROUP);
        result2.add(actionGroup);
        AnAction[] additionalActions = this.myProvider.getAdditionalActions(() -> ApplicationManager.getApplication().invokeAndWait(() -> this.myRefresherI.refresh(true)));
        if (additionalActions != null) {
            for (AnAction additionalAction : additionalActions) {
                if (!popup2 && additionalAction.getTemplatePresentation().getIcon() == null) continue;
                result2.add(additionalAction);
            }
        }
        if (!this.myIsStaticAndEmbedded) {
            result2.add((AnAction)new MyShowDetailsAction());
        }
        if (!popup2 && this.myHistorySession.getHistoryAsTreeProvider() != null) {
            result2.add((AnAction)new MyShowAsTreeAction());
        }
        DefaultActionGroup defaultActionGroup = result2;
        if (defaultActionGroup == null) {
            FileHistoryPanelImpl.$$$reportNull$$$0(20);
        }
        return defaultActionGroup;
    }

    public Object getData(@NotNull String dataId) {
        if (dataId == null) {
            FileHistoryPanelImpl.$$$reportNull$$$0(21);
        }
        if (CommonDataKeys.NAVIGATABLE.is(dataId)) {
            Object[] selectedRevisions = this.getSelectedRevisions();
            if (selectedRevisions.length != 1) {
                return null;
            }
            VcsFileRevision firstSelectedRevision = (VcsFileRevision)ArrayUtil.getFirstElement((Object[])selectedRevisions);
            if (!this.myHistorySession.isContentAvailable(firstSelectedRevision)) {
                return null;
            }
            VirtualFile virtualFileForRevision = this.createVirtualFileForRevision(firstSelectedRevision);
            if (virtualFileForRevision != null) {
                return new OpenFileDescriptor(this.myVcs.getProject(), virtualFileForRevision);
            }
            return null;
        }
        if (CommonDataKeys.PROJECT.is(dataId)) {
            return this.myVcs.getProject();
        }
        if (VcsDataKeys.VCS_FILE_REVISION.is(dataId)) {
            return ArrayUtil.getFirstElement((Object[])this.getSelectedRevisions());
        }
        if (VcsDataKeys.VCS_NON_LOCAL_HISTORY_SESSION.is(dataId)) {
            return !this.myHistorySession.hasLocalSource();
        }
        if (VcsDataKeys.VCS.is(dataId)) {
            return this.myVcs.getKeyInstanceMethod();
        }
        if (VcsDataKeys.VCS_FILE_REVISIONS.is(dataId)) {
            return this.getSelectedRevisions();
        }
        if (VcsDataKeys.REMOTE_HISTORY_CHANGED_LISTENER.is(dataId)) {
            return s -> this.myDualView.rebuild();
        }
        if (VcsDataKeys.CHANGES.is(dataId)) {
            return this.getChanges();
        }
        if (VcsDataKeys.VCS_VIRTUAL_FILE.is(dataId)) {
            Object[] selectedRevisions = this.getSelectedRevisions();
            if (selectedRevisions.length == 0) {
                return null;
            }
            return this.createVirtualFileForRevision((VcsFileRevision)ArrayUtil.getFirstElement((Object[])selectedRevisions));
        }
        if (VcsDataKeys.FILE_PATH.is(dataId)) {
            return this.myFilePath;
        }
        if (VcsDataKeys.IO_FILE.is(dataId)) {
            return this.myFilePath.getIOFile();
        }
        if (CommonDataKeys.VIRTUAL_FILE.is(dataId)) {
            VirtualFile virtualFile = this.myFilePath.getVirtualFile();
            return virtualFile == null || !virtualFile.isValid() ? null : virtualFile;
        }
        if (VcsDataKeys.FILE_HISTORY_PANEL.is(dataId)) {
            return this;
        }
        if (VcsDataKeys.HISTORY_SESSION.is(dataId)) {
            return this.myHistorySession;
        }
        if (VcsDataKeys.HISTORY_PROVIDER.is(dataId)) {
            return this.myProvider;
        }
        if (PlatformDataKeys.COPY_PROVIDER.is(dataId)) {
            return this;
        }
        if (PREVIOUS_REVISION_FOR_DIFF.is(dataId)) {
            TableView flatView = this.myDualView.getFlatView();
            if (flatView.getSelectedRow() == flatView.getRowCount() - 1) {
                return this.myBottomRevisionForShowDiff != null ? this.myBottomRevisionForShowDiff : VcsFileRevision.NULL;
            }
            return ((TreeNodeOnVcsRevision)flatView.getRow(flatView.getSelectedRow() + 1)).getRevision();
        }
        if (VcsInternalDataKeys.FILE_HISTORY_REFRESHER.is(dataId)) {
            return this.myRefresherI;
        }
        if (PlatformDataKeys.HELP_ID.is(dataId)) {
            return this.myHelpId;
        }
        return null;
    }

    @Nullable
    private Change[] getChanges() {
        VcsFileRevision[] revisions = this.getSelectedRevisions();
        if (revisions.length > 0) {
            Arrays.sort(revisions, Comparator.comparing(VcsRevisionDescription::getRevisionNumber));
            for (VcsFileRevision revision : revisions) {
                if (this.myHistorySession.isContentAvailable(revision)) continue;
                return null;
            }
            LoadedContentRevision startRevision = new LoadedContentRevision(this.myFilePath, revisions[0], this.myVcs.getProject());
            Object endRevision = revisions.length == 1 ? new CurrentContentRevision(this.myFilePath) : new LoadedContentRevision(this.myFilePath, revisions[revisions.length - 1], this.myVcs.getProject());
            return new Change[]{new Change((ContentRevision)startRevision, (ContentRevision)endRevision)};
        }
        return null;
    }

    private VirtualFile createVirtualFileForRevision(VcsFileRevision revision) {
        if (!this.myRevisionToVirtualFile.containsKey(revision)) {
            FilePath filePath = revision instanceof VcsFileRevisionEx ? ((VcsFileRevisionEx)revision).getPath() : this.myFilePath;
            this.myRevisionToVirtualFile.put(revision, filePath.isDirectory() ? new VcsVirtualFolder(filePath.getPath(), null, (VirtualFileSystem)VcsFileSystem.getInstance()) : new VcsVirtualFile(filePath.getPath(), revision, (VirtualFileSystem)VcsFileSystem.getInstance()));
        }
        return this.myRevisionToVirtualFile.get(revision);
    }

    @NotNull
    public VcsFileRevision[] getSelectedRevisions() {
        List selection = this.myDualView.getSelection();
        VcsFileRevision[] result2 = new VcsFileRevision[selection.size()];
        for (int i = 0; i < selection.size(); ++i) {
            result2[i] = ((TreeNodeOnVcsRevision)selection.get(i)).getRevision();
        }
        if (result2 == null) {
            FileHistoryPanelImpl.$$$reportNull$$$0(22);
        }
        return result2;
    }

    public void dispose() {
        this.myDualView.dispose();
    }

    private void refreshRevisionsOrder() {
        List list2 = this.myHistorySession.getRevisionList();
        this.myRevisionsOrder.clear();
        int cnt = 0;
        for (VcsFileRevision revision : list2) {
            this.myRevisionsOrder.put(revision.getRevisionNumber(), cnt);
            ++cnt;
        }
    }

    public void setIsStaticAndEmbedded(boolean isStaticAndEmbedded) {
        this.myIsStaticAndEmbedded = isStaticAndEmbedded;
        this.myDualView.setZipByHeight(isStaticAndEmbedded);
        this.myDualView.getFlatView().updateColumnSizes();
        if (this.myIsStaticAndEmbedded) {
            this.myDualView.getFlatView().getTableHeader().setBorder(IdeBorderFactory.createBorder((int)2));
            this.myDualView.getTreeView().getTableHeader().setBorder(IdeBorderFactory.createBorder((int)2));
            this.myDualView.getFlatView().setBorder(null);
            this.myDualView.getTreeView().setBorder(null);
        }
    }

    public void setBottomRevisionForShowDiff(VcsFileRevision bottomRevisionForShowDiff) {
        this.myBottomRevisionForShowDiff = bottomRevisionForShowDiff;
    }

    public boolean equals(Object obj) {
        return obj instanceof FileHistoryPanelImpl && FileHistoryPanelImpl.sameHistories((FileHistoryPanelImpl)obj, this.myFilePath, this.myStartingRevision);
    }

    public int hashCode() {
        int result2 = this.myFilePath.hashCode();
        result2 = 31 * result2 + (this.myStartingRevision != null ? this.myStartingRevision.asString().hashCode() : 0);
        return result2;
    }

    public void performCopy(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            FileHistoryPanelImpl.$$$reportNull$$$0(23);
        }
        String text = StringUtil.join((Object[])this.getSelectedRevisions(), revision -> FileHistoryPanelImpl.getPresentableText(revision, true), (String)"\n");
        CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(text));
    }

    public boolean isCopyEnabled(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            FileHistoryPanelImpl.$$$reportNull$$$0(24);
        }
        return this.myDualView.getSelection().size() > 0;
    }

    public boolean isCopyVisible(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            FileHistoryPanelImpl.$$$reportNull$$$0(25);
        }
        return true;
    }

    public void globalSchemeChange(EditorColorsScheme scheme2) {
        this.updateMessage();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 16: 
            case 19: 
            case 20: 
            case 22: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 16: 
            case 19: 
            case 20: 
            case 22: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcs";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 2: 
            case 6: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refresherI";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "revision";
                break;
            }
            case 9: 
            case 16: 
            case 19: 
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/history/FileHistoryPanelImpl";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "historyPanel";
                break;
            }
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath2";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath1";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/history/FileHistoryPanelImpl";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableText";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "createColumnList";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "createCenterPanel";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "fillActionGroup";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedRevisions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getPresentableText";
                break;
            }
            case 9: 
            case 16: 
            case 19: 
            case 20: 
            case 22: {
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "sameHistories";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createColumnList";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "setHistorySession";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "setupDualView";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "performCopy";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "isCopyEnabled";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "isCopyVisible";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: 
            case 16: 
            case 19: 
            case 20: 
            case 22: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyShowDetailsAction
    extends ToggleAction
    implements DumbAware {
        MyShowDetailsAction() {
            super("Show Details", "Display details panel", AllIcons.Actions.PreviewDetailsVertically);
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            if (e == null) {
                MyShowDetailsAction.$$$reportNull$$$0(0);
            }
            return VcsConfiguration.getInstance((Project)((FileHistoryPanelImpl)FileHistoryPanelImpl.this).myVcs.getProject()).SHOW_FILE_HISTORY_DETAILS;
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            if (e == null) {
                MyShowDetailsAction.$$$reportNull$$$0(1);
            }
            VcsConfiguration.getInstance((Project)((FileHistoryPanelImpl)FileHistoryPanelImpl.this).myVcs.getProject()).SHOW_FILE_HISTORY_DETAILS = state;
            FileHistoryPanelImpl.this.setupDetails();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/openapi/vcs/history/FileHistoryPanelImpl$MyShowDetailsAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSelected";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setSelected";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class MyShowAsTreeAction
    extends ToggleAction
    implements DumbAware {
        MyShowAsTreeAction() {
            super(VcsBundle.message((String)"action.name.show.files.as.tree", (Object[])new Object[0]), null, PlatformIcons.SMALL_VCS_CONFIGURABLE);
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            if (e == null) {
                MyShowAsTreeAction.$$$reportNull$$$0(0);
            }
            return VcsConfiguration.getInstance((Project)((FileHistoryPanelImpl)FileHistoryPanelImpl.this).myVcs.getProject()).SHOW_FILE_HISTORY_AS_TREE;
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            if (e == null) {
                MyShowAsTreeAction.$$$reportNull$$$0(1);
            }
            VcsConfiguration.getInstance((Project)((FileHistoryPanelImpl)FileHistoryPanelImpl.this).myVcs.getProject()).SHOW_FILE_HISTORY_AS_TREE = state;
            FileHistoryPanelImpl.this.chooseView();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/openapi/vcs/history/FileHistoryPanelImpl$MyShowAsTreeAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSelected";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setSelected";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class MyCellWrapper
    implements CellWrapper {
        private final Getter<VcsHistorySession> myHistorySession;

        MyCellWrapper(Getter<VcsHistorySession> historySession) {
            this.myHistorySession = historySession;
        }

        public void wrap(Component component, JTable table, Object value, boolean isSelected, boolean hasFocus, int row2, int column, Object treeNode) {
            VcsFileRevision revision = ((TreeNodeOnVcsRevision)treeNode).getRevision();
            if (((VcsHistorySession)this.myHistorySession.get()).isCurrentRevision(revision.getRevisionNumber())) {
                FileHistoryPanelImpl.makeBold(component);
            }
        }
    }

    private static class MyTreeCellRenderer
    implements TreeCellRenderer {
        private final TreeCellRenderer myDefaultCellRenderer;
        private final Getter<VcsHistorySession> myHistorySession;

        MyTreeCellRenderer(TreeCellRenderer defaultCellRenderer, Getter<VcsHistorySession> historySession) {
            this.myDefaultCellRenderer = defaultCellRenderer;
            this.myHistorySession = historySession;
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row2, boolean hasFocus) {
            TreeNodeOnVcsRevision node;
            Component result2 = this.myDefaultCellRenderer.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row2, hasFocus);
            TreePath path = tree.getPathForRow(row2);
            if (path == null) {
                return result2;
            }
            TreeNodeOnVcsRevision treeNodeOnVcsRevision = node = row2 >= 0 ? (TreeNodeOnVcsRevision)path.getLastPathComponent() : null;
            if (node != null) {
                if (((VcsHistorySession)this.myHistorySession.get()).isCurrentRevision(node.getRevision().getRevisionNumber())) {
                    FileHistoryPanelImpl.makeBold(result2);
                }
                if (!selected && ((VcsHistorySession)this.myHistorySession.get()).isCurrentRevision(node.getRevision().getRevisionNumber())) {
                    result2.setBackground((Color)new JBColor(new Color(188, 227, 231), new Color(188, 227, 231)));
                }
                ((JComponent)result2).setOpaque(false);
            } else if (selected) {
                result2.setBackground(UIUtil.getTableSelectionBackground());
            } else {
                result2.setBackground(UIUtil.getTableBackground());
            }
            return result2;
        }
    }

    private static class LoadedContentRevision
    implements ByteBackedContentRevision {
        private final FilePath myFile;
        private final VcsFileRevision myRevision;
        private final Project myProject;

        private LoadedContentRevision(FilePath file2, VcsFileRevision revision, Project project) {
            this.myFile = file2;
            this.myRevision = revision;
            this.myProject = project;
        }

        public String getContent() throws VcsException {
            try {
                return VcsHistoryUtil.loadRevisionContentGuessEncoding(this.myRevision, this.myFile.getVirtualFile(), this.myProject);
            }
            catch (IOException e) {
                throw new VcsException(VcsBundle.message((String)"message.text.cannot.load.revision", (Object[])new Object[]{e.getLocalizedMessage()}));
            }
        }

        @Nullable
        public byte[] getContentAsBytes() throws VcsException {
            try {
                return VcsHistoryUtil.loadRevisionContent(this.myRevision);
            }
            catch (IOException e) {
                throw new VcsException(VcsBundle.message((String)"message.text.cannot.load.revision", (Object[])new Object[]{e.getLocalizedMessage()}));
            }
        }

        @NotNull
        public FilePath getFile() {
            FilePath filePath = this.myFile;
            if (filePath == null) {
                LoadedContentRevision.$$$reportNull$$$0(0);
            }
            return filePath;
        }

        @NotNull
        public VcsRevisionNumber getRevisionNumber() {
            VcsRevisionNumber vcsRevisionNumber = this.myRevision.getRevisionNumber();
            if (vcsRevisionNumber == null) {
                LoadedContentRevision.$$$reportNull$$$0(1);
            }
            return vcsRevisionNumber;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/openapi/vcs/history/FileHistoryPanelImpl$LoadedContentRevision";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFile";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRevisionNumber";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    public static class MessageColumnInfo
    extends ColumnInfo<VcsFileRevision, String> {
        private final ColoredTableCellRenderer myRenderer = new BaseHistoryCellRenderer(){

            protected void customizeCellRenderer(JTable table, Object value, boolean selected, boolean hasFocus, int row2, int column) {
                this.setOpaque(selected);
                if (value instanceof String) {
                    String message = (String)value;
                    myIssueLinkRenderer.appendTextWithLinks(message, this.getDefaultAttributes());
                    SpeedSearchUtil.applySpeedSearchHighlighting((JComponent)table, (SimpleColoredComponent)this, (boolean)false, (boolean)selected);
                }
            }
        };
        private final IssueLinkRenderer myIssueLinkRenderer;

        public MessageColumnInfo(Project project) {
            super(COMMIT_MESSAGE_TITLE);
            this.myIssueLinkRenderer = new IssueLinkRenderer(project, (SimpleColoredComponent)this.myRenderer);
        }

        @NotNull
        public static String getSubject(@NotNull VcsFileRevision object) {
            String originalMessage;
            if (object == null) {
                MessageColumnInfo.$$$reportNull$$$0(0);
            }
            if ((originalMessage = object.getCommitMessage()) == null) {
                if ("" == null) {
                    MessageColumnInfo.$$$reportNull$$$0(1);
                }
                return "";
            }
            int index = StringUtil.indexOfAny((String)originalMessage, (String)"\n\r");
            String string = index == -1 ? originalMessage : originalMessage.substring(0, index);
            if (string == null) {
                MessageColumnInfo.$$$reportNull$$$0(2);
            }
            return string;
        }

        @Nullable
        public String valueOf(VcsFileRevision revision) {
            return MessageColumnInfo.getSubject(revision);
        }

        public String getPreferredStringValue() {
            return StringUtil.repeatSymbol((char)'m', (int)80);
        }

        @Nullable
        public TableCellRenderer getRenderer(VcsFileRevision revision) {
            return this.myRenderer;
        }

        @NotNull
        public Comparator<VcsFileRevision> getComparator() {
            Comparator<VcsFileRevision> comparator2 = Comparator.comparing(revision -> this.valueOf((VcsFileRevision)revision));
            if (comparator2 == null) {
                MessageColumnInfo.$$$reportNull$$$0(3);
            }
            return comparator2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "object";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/history/FileHistoryPanelImpl$MessageColumnInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/history/FileHistoryPanelImpl$MessageColumnInfo";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSubject";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getComparator";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getSubject";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class AuthorColumnInfo
    extends ColumnInfo<VcsFileRevision, String> {
        private final TableCellRenderer AUTHOR_RENDERER = new AuthorCellRenderer();

        public AuthorColumnInfo() {
            super(VcsBundle.message((String)"column.name.revision.list.author", (Object[])new Object[0]));
        }

        @Nullable
        public TableCellRenderer getRenderer(VcsFileRevision revision) {
            return this.AUTHOR_RENDERER;
        }

        public TableCellRenderer getCustomizedRenderer(VcsFileRevision revision, TableCellRenderer renderer) {
            if (renderer instanceof AuthorCellRenderer && revision instanceof VcsFileRevisionEx) {
                VcsFileRevisionEx ex = (VcsFileRevisionEx)revision;
                StringBuilder sb = new StringBuilder(StringUtil.notNullize((String)ex.getAuthor()));
                if (ex.getAuthorEmail() != null) {
                    sb.append(" &lt;").append(ex.getAuthorEmail()).append("&gt;");
                }
                if (ex.getCommitterName() != null && !Comparing.equal((String)ex.getAuthor(), (String)ex.getCommitterName())) {
                    sb.append(", via ").append(ex.getCommitterName());
                    if (ex.getCommitterEmail() != null) {
                        sb.append(" &lt;").append(ex.getCommitterEmail()).append("&gt;");
                    }
                }
                ((AuthorCellRenderer)((Object)renderer)).setTooltipText(sb.toString());
            }
            return renderer;
        }

        @Nullable
        public String valueOf(VcsFileRevision revision) {
            if (revision instanceof VcsFileRevisionEx && !Comparing.equal((String)revision.getAuthor(), (String)((VcsFileRevisionEx)revision).getCommitterName())) {
                return revision.getAuthor() + "*";
            }
            return revision.getAuthor();
        }

        @NonNls
        public String getPreferredStringValue() {
            return StringUtil.repeatSymbol((char)'m', (int)14);
        }

        @NotNull
        public Comparator<VcsFileRevision> getComparator() {
            Comparator<VcsFileRevision> comparator2 = Comparator.comparing(revision -> this.valueOf((VcsFileRevision)revision));
            if (comparator2 == null) {
                AuthorColumnInfo.$$$reportNull$$$0(0);
            }
            return comparator2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/history/FileHistoryPanelImpl$AuthorColumnInfo", "getComparator"));
        }
    }

    private static class AuthorCellRenderer
    extends BaseHistoryCellRenderer {
        private String myTooltipText;

        private AuthorCellRenderer() {
        }

        public void setTooltipText(String text) {
            this.myTooltipText = text;
        }

        protected void customizeCellRenderer(JTable table, @Nullable Object value, boolean selected, boolean hasFocus, int row2, int column) {
            this.setToolTipText(this.myTooltipText);
            if (selected || hasFocus) {
                this.setBackground(table.getSelectionBackground());
                this.setForeground(table.getSelectionForeground());
            } else {
                this.setBackground(table.getBackground());
                this.setForeground(table.getForeground());
            }
            if (value != null) {
                this.append(value.toString(), this.getDefaultAttributes());
            }
            SpeedSearchUtil.applySpeedSearchHighlighting((JComponent)table, (SimpleColoredComponent)this, (boolean)false, (boolean)selected);
        }
    }

    public static class DateColumnInfo
    extends ColumnInfo<VcsFileRevision, Date> {
        @NotNull
        private final ColoredTableCellRenderer myRenderer = new BaseHistoryCellRenderer(){

            protected void customizeCellRenderer(JTable table, Object value, boolean selected, boolean hasFocus, int row2, int column) {
                this.setOpaque(selected);
                Date date = (Date)value;
                if (date != null) {
                    this.append(DateFormatUtil.formatPrettyDateTime((Date)date), this.getDefaultAttributes());
                }
                SpeedSearchUtil.applySpeedSearchHighlighting((JComponent)table, (SimpleColoredComponent)this, (boolean)false, (boolean)selected);
            }
        };

        public DateColumnInfo() {
            super(VcsBundle.message((String)"column.name.revision.date", (Object[])new Object[0]));
        }

        @NotNull
        public Comparator<VcsFileRevision> getComparator() {
            Comparator<VcsFileRevision> comparator2 = Comparator.comparing(revision -> this.valueOf((VcsFileRevision)revision));
            if (comparator2 == null) {
                DateColumnInfo.$$$reportNull$$$0(0);
            }
            return comparator2;
        }

        @Nullable
        public Date valueOf(VcsFileRevision revision) {
            return revision.getRevisionDate();
        }

        public String getPreferredStringValue() {
            return DateFormatUtil.formatPrettyDateTime((long)(Clock.getTime() + 1000L));
        }

        @Nullable
        public TableCellRenderer getRenderer(VcsFileRevision revision) {
            return this.myRenderer;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/history/FileHistoryPanelImpl$DateColumnInfo", "getComparator"));
        }
    }

    public static class RevisionColumnInfo
    extends ColumnInfo<VcsFileRevision, VcsRevisionNumber> {
        @Nullable
        private final Comparator<VcsFileRevision> myComparator;
        @NotNull
        private final ColoredTableCellRenderer myRenderer;

        public RevisionColumnInfo(@Nullable Comparator<VcsFileRevision> comparator2) {
            super(VcsBundle.message((String)"column.name.revision.version", (Object[])new Object[0]));
            this.myComparator = comparator2;
            this.myRenderer = new BaseHistoryCellRenderer(){

                protected void customizeCellRenderer(JTable table, Object value, boolean selected, boolean hasFocus, int row2, int column) {
                    this.setOpaque(selected);
                    this.append(VcsUtil.getShortRevisionString((VcsRevisionNumber)((VcsRevisionNumber)value)), this.getDefaultAttributes());
                    SpeedSearchUtil.applySpeedSearchHighlighting((JComponent)table, (SimpleColoredComponent)this, (boolean)false, (boolean)selected);
                }
            };
        }

        @Nullable
        public VcsRevisionNumber valueOf(VcsFileRevision revision) {
            return revision.getRevisionNumber();
        }

        @Nullable
        public Comparator<VcsFileRevision> getComparator() {
            return this.myComparator;
        }

        public String getPreferredStringValue() {
            return StringUtil.repeatSymbol((char)'m', (int)10);
        }

        @Nullable
        public TableCellRenderer getRenderer(VcsFileRevision revision) {
            return this.myRenderer;
        }
    }

    private static abstract class BaseHistoryCellRenderer
    extends ColoredTableCellRenderer {
        private boolean myIsCurrentRevision = false;

        private BaseHistoryCellRenderer() {
        }

        protected SimpleTextAttributes getDefaultAttributes() {
            return this.myIsCurrentRevision ? SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES : SimpleTextAttributes.REGULAR_ATTRIBUTES;
        }

        public void setCurrentRevision(boolean currentRevision) {
            this.myIsCurrentRevision = currentRevision;
        }
    }

    private class TreeNodeColumnInfoWrapper<T extends Comparable<T>>
    extends FileHistoryColumnWrapper<T> {
        TreeNodeColumnInfoWrapper(ColumnInfo<VcsFileRevision, T> additionalColumn) {
            if (additionalColumn == null) {
                TreeNodeColumnInfoWrapper.$$$reportNull$$$0(0);
            }
            super(additionalColumn);
        }

        @Override
        protected DualView getDualView() {
            return FileHistoryPanelImpl.this.myDualView;
        }

        public TableCellRenderer getCustomizedRenderer(TreeNodeOnVcsRevision revision, @Nullable TableCellRenderer renderer) {
            if (renderer instanceof BaseHistoryCellRenderer) {
                ((BaseHistoryCellRenderer)((Object)renderer)).setCurrentRevision(FileHistoryPanelImpl.this.myHistorySession.isCurrentRevision(revision.getRevision().getRevisionNumber()));
            }
            return renderer;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "additionalColumn", "com/intellij/openapi/vcs/history/FileHistoryPanelImpl$TreeNodeColumnInfoWrapper", "<init>"));
        }
    }
}

