/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.settings.mappings;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.BeforeAfter;
import com.intellij.util.ThreeState;
import com.jetbrains.jsonSchema.UserDefinedJsonSchemaConfiguration;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonSchemaPatternComparator {
    @NotNull
    private final Project myProject;

    public JsonSchemaPatternComparator(@NotNull Project project) {
        if (project == null) {
            JsonSchemaPatternComparator.$$$reportNull$$$0(0);
        }
        this.myProject = project;
    }

    @NotNull
    public ThreeState isSimilar(@NotNull UserDefinedJsonSchemaConfiguration.Item itemLeft, @NotNull UserDefinedJsonSchemaConfiguration.Item itemRight) {
        if (itemLeft == null) {
            JsonSchemaPatternComparator.$$$reportNull$$$0(1);
        }
        if (itemRight == null) {
            JsonSchemaPatternComparator.$$$reportNull$$$0(2);
        }
        if (itemLeft.isPattern() != itemRight.isPattern()) {
            ThreeState threeState = ThreeState.NO;
            if (threeState == null) {
                JsonSchemaPatternComparator.$$$reportNull$$$0(3);
            }
            return threeState;
        }
        if (itemLeft.isPattern()) {
            ThreeState threeState = JsonSchemaPatternComparator.comparePatterns(itemLeft, itemRight);
            if (threeState == null) {
                JsonSchemaPatternComparator.$$$reportNull$$$0(4);
            }
            return threeState;
        }
        ThreeState threeState = this.comparePaths(itemLeft, itemRight);
        if (threeState == null) {
            JsonSchemaPatternComparator.$$$reportNull$$$0(5);
        }
        return threeState;
    }

    private ThreeState comparePaths(UserDefinedJsonSchemaConfiguration.Item left, UserDefinedJsonSchemaConfiguration.Item right) {
        String leftPath = left.getPath();
        String rightPath = right.getPath();
        if (leftPath.startsWith("mock:///") || rightPath.startsWith("mock:///")) {
            return leftPath.equals(rightPath) ? ThreeState.YES : ThreeState.NO;
        }
        File leftFile = new File(this.myProject.getBasePath(), leftPath);
        File rightFile = new File(this.myProject.getBasePath(), rightPath);
        if (left.isDirectory() && FileUtil.isAncestor((File)leftFile, (File)rightFile, (boolean)true)) {
            return ThreeState.YES;
        }
        if (right.isDirectory() && FileUtil.isAncestor((File)rightFile, (File)leftFile, (boolean)true)) {
            return ThreeState.YES;
        }
        return FileUtil.filesEqual((File)leftFile, (File)rightFile) && left.isDirectory() == right.isDirectory() ? ThreeState.YES : ThreeState.NO;
    }

    private static ThreeState comparePatterns(@NotNull UserDefinedJsonSchemaConfiguration.Item leftItem, @NotNull UserDefinedJsonSchemaConfiguration.Item rightItem) {
        if (leftItem == null) {
            JsonSchemaPatternComparator.$$$reportNull$$$0(6);
        }
        if (rightItem == null) {
            JsonSchemaPatternComparator.$$$reportNull$$$0(7);
        }
        if (leftItem.getPath().equals(rightItem.getPath())) {
            return ThreeState.YES;
        }
        if (leftItem.getPath().indexOf(File.separatorChar) >= 0 || rightItem.getPath().indexOf(File.separatorChar) >= 0) {
            return ThreeState.NO;
        }
        BeforeAfter<String> left = JsonSchemaPatternComparator.getBeforeAfterAroundWildCards(leftItem.getPath());
        BeforeAfter<String> right = JsonSchemaPatternComparator.getBeforeAfterAroundWildCards(rightItem.getPath());
        if (left == null || right == null) {
            if (left == null && right == null) {
                return leftItem.getPath().equals(rightItem.getPath()) ? ThreeState.YES : ThreeState.NO;
            }
            if (left == null) {
                return JsonSchemaPatternComparator.checkOneSideWithoutWildcard(leftItem, right);
            }
            return JsonSchemaPatternComparator.checkOneSideWithoutWildcard(rightItem, left);
        }
        if (!StringUtil.isEmptyOrSpaces((String)((String)left.getBefore())) && !StringUtil.isEmptyOrSpaces((String)((String)right.getBefore()))) {
            if (((String)left.getBefore()).startsWith((String)right.getBefore()) || ((String)right.getBefore()).startsWith((String)left.getBefore())) {
                return ThreeState.YES;
            }
            return ThreeState.NO;
        }
        if (!StringUtil.isEmptyOrSpaces((String)((String)left.getAfter())) && !StringUtil.isEmptyOrSpaces((String)((String)right.getAfter()))) {
            if (((String)left.getAfter()).endsWith((String)right.getAfter()) || ((String)right.getAfter()).endsWith((String)left.getAfter())) {
                return ThreeState.YES;
            }
            return ThreeState.NO;
        }
        return ThreeState.UNSURE;
    }

    @NotNull
    private static ThreeState checkOneSideWithoutWildcard(UserDefinedJsonSchemaConfiguration.Item item, BeforeAfter<String> beforeAfter) {
        if (!StringUtil.isEmptyOrSpaces((String)((String)beforeAfter.getBefore())) && item.getPath().startsWith((String)beforeAfter.getBefore())) {
            ThreeState threeState = ThreeState.YES;
            if (threeState == null) {
                JsonSchemaPatternComparator.$$$reportNull$$$0(8);
            }
            return threeState;
        }
        if (!StringUtil.isEmptyOrSpaces((String)((String)beforeAfter.getAfter())) && item.getPath().endsWith((String)beforeAfter.getAfter())) {
            ThreeState threeState = ThreeState.YES;
            if (threeState == null) {
                JsonSchemaPatternComparator.$$$reportNull$$$0(9);
            }
            return threeState;
        }
        ThreeState threeState = ThreeState.UNSURE;
        if (threeState == null) {
            JsonSchemaPatternComparator.$$$reportNull$$$0(10);
        }
        return threeState;
    }

    @Nullable
    private static BeforeAfter<String> getBeforeAfterAroundWildCards(@NotNull String pattern) {
        if (pattern == null) {
            JsonSchemaPatternComparator.$$$reportNull$$$0(11);
        }
        int firstIdx = pattern.indexOf(42);
        int lastIdx = pattern.lastIndexOf(42);
        if (firstIdx < 0 || lastIdx < 0) {
            return null;
        }
        return new BeforeAfter((Object)pattern.substring(0, firstIdx), (Object)pattern.substring(lastIdx + 1));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "itemLeft";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "itemRight";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/jsonSchema/settings/mappings/JsonSchemaPatternComparator";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "leftItem";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rightItem";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/jsonSchema/settings/mappings/JsonSchemaPatternComparator";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "isSimilar";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "checkOneSideWithoutWildcard";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isSimilar";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "comparePatterns";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getBeforeAfterAroundWildCards";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

