/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security.pkcs;

import gnu.java.security.OID;
import gnu.java.security.ber.BER;
import gnu.java.security.ber.BEREncodingException;
import gnu.java.security.ber.BERReader;
import gnu.java.security.ber.BERValue;
import gnu.java.security.der.DERValue;
import gnu.java.security.pkcs.SignerInfo;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.cert.CRL;
import java.security.cert.CRLException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;

public class PKCS7SignedData {
    public static final OID PKCS7_DATA = new OID("1.2.840.113549.1.7.1");
    public static final OID PKCS7_SIGNED_DATA = new OID("1.2.840.113549.1.7.2");
    private static final boolean DEBUG = false;
    private BigInteger version;
    private Set digestAlgorithms;
    private OID contentType;
    private byte[] content;
    private Certificate[] certificates;
    private CRL[] crls;
    private Set signerInfos;

    private static final void debug(String msg) {
        System.err.print("PKCS7SignedData >> ");
        System.err.println(msg);
    }

    public BigInteger getVersion() {
        return this.version;
    }

    public Certificate[] getCertificates() {
        return this.certificates != null ? (Certificate[])this.certificates.clone() : null;
    }

    public OID getContentType() {
        return this.contentType;
    }

    public byte[] getContent() {
        return this.content != null ? (byte[])this.content.clone() : null;
    }

    public Set getDigestAlgorithms() {
        return Collections.unmodifiableSet(this.digestAlgorithms);
    }

    public Set getSignerInfos() {
        HashSet copy = new HashSet();
        Iterator it = this.signerInfos.iterator();
        while (it.hasNext()) {
            copy.add(it.next());
        }
        return Collections.unmodifiableSet(copy);
    }

    public PKCS7SignedData(InputStream in) throws CRLException, CertificateException, IOException {
        this(new BERReader(in));
    }

    public PKCS7SignedData(BERReader ber) throws CRLException, CertificateException, IOException {
        int i;
        CertificateFactory x509 = CertificateFactory.getInstance("X509");
        DERValue val = ber.read();
        if (!val.isConstructed()) {
            throw new BEREncodingException("malformed ContentInfo");
        }
        val = ber.read();
        if (val.getTag() != 6) {
            throw new BEREncodingException("malformed ContentType");
        }
        if (!PKCS7_SIGNED_DATA.equals(val.getValue())) {
            throw new BEREncodingException("content is not SignedData");
        }
        val = ber.read();
        if (val.getTag() != 0) {
            throw new BEREncodingException("malformed Content");
        }
        val = ber.read();
        if (!val.isConstructed()) {
            throw new BEREncodingException("malformed SignedData");
        }
        val = ber.read();
        if (val.getTag() != 2) {
            throw new BEREncodingException("expecting Version");
        }
        this.version = (BigInteger)val.getValue();
        this.digestAlgorithms = new HashSet();
        val = ber.read();
        if (!val.isConstructed()) {
            throw new BEREncodingException("malformed DigestAlgorithmIdentifiers");
        }
        int count = 0;
        DERValue val2 = ber.read();
        while (val2 != BER.END_OF_SEQUENCE && val.getLength() > 0 && val.getLength() > count) {
            if (!val2.isConstructed()) {
                throw new BEREncodingException("malformed AlgorithmIdentifier");
            }
            count += val2.getEncodedLength();
            val2 = ber.read();
            if (val2.getTag() != 6) {
                throw new BEREncodingException("malformed AlgorithmIdentifier");
            }
            ArrayList algId = new ArrayList(2);
            algId.add(val2.getValue());
            val2 = ber.read();
            if (val2 != BER.END_OF_SEQUENCE) {
                count += val2.getEncodedLength();
                if (val2.getTag() == 5) {
                    algId.add(null);
                } else {
                    algId.add(val2.getEncoded());
                }
                if (val2.isConstructed()) {
                    ber.skip(val2.getLength());
                }
                if (BERValue.isIndefinite(val)) {
                    val2 = ber.read();
                }
            } else {
                algId.add(null);
            }
            this.digestAlgorithms.add(algId);
        }
        val = ber.read();
        if (!val.isConstructed()) {
            throw new BEREncodingException("malformed ContentInfo");
        }
        val2 = ber.read();
        if (val2.getTag() != 6) {
            throw new BEREncodingException("malformed ContentType");
        }
        this.contentType = (OID)val2.getValue();
        if ((BERValue.isIndefinite(val) || val.getLength() > 0 && val.getLength() > val2.getEncodedLength()) && (val2 = ber.read()) != BER.END_OF_SEQUENCE) {
            this.content = val2.getEncoded();
            if (BERValue.isIndefinite(val)) {
                val2 = ber.read();
            }
        }
        if ((val = ber.read()).getTag() == 0) {
            if (!val.isConstructed()) {
                throw new BEREncodingException("malformed ExtendedCertificatesAndCertificates");
            }
            count = 0;
            val2 = ber.read();
            LinkedList certs = new LinkedList();
            while (val2 != BER.END_OF_SEQUENCE && val.getLength() > 0 && val.getLength() > count) {
                Certificate cert = x509.generateCertificate(new ByteArrayInputStream(val2.getEncoded()));
                certs.add(cert);
                ber.skip(val2.getLength());
                if (!BERValue.isIndefinite(val) && val.getLength() <= (count += val2.getEncodedLength())) continue;
                val2 = ber.read();
            }
            this.certificates = (Certificate[])certs.toArray(new Certificate[certs.size()]);
            val = ber.read();
        }
        if (val.getTag() == 1) {
            if (!val.isConstructed()) {
                throw new BEREncodingException("malformed CertificateRevocationLists");
            }
            count = 0;
            val2 = ber.read();
            LinkedList crls = new LinkedList();
            while (val2 != BER.END_OF_SEQUENCE && val.getLength() > 0 && val.getLength() > count) {
                CRL crl = x509.generateCRL(new ByteArrayInputStream(val2.getEncoded()));
                crls.add(crl);
                ber.skip(val2.getLength());
                if (!BERValue.isIndefinite(val) && val.getLength() <= (count += val2.getEncodedLength())) continue;
                val2 = ber.read();
            }
            this.crls = (CRL[])crls.toArray(new CRL[crls.size()]);
            val = ber.read();
        }
        this.signerInfos = new HashSet();
        if (!val.isConstructed()) {
            throw new BEREncodingException("malformed SignerInfos");
        }
        while ((i = ber.peek()) != 0 && i != -1) {
            this.signerInfos.add(new SignerInfo(ber));
        }
    }
}

