/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.instruct;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.xml.transform.SourceLocator;
import net.sf.saxon.event.LocationProvider;
import net.sf.saxon.expr.Binding;
import net.sf.saxon.expr.Container;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.MonoIterator;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.Executable;
import net.sf.saxon.expr.instruct.LocationMap;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.RoleLocator;
import net.sf.saxon.expr.parser.TypeChecker;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.SequenceType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GeneralVariable
implements Binding,
SourceLocator {
    private static final int REQUIRED = 4;
    private static final int TUNNEL = 8;
    private static final int IMPLICITLY_REQUIRED = 16;
    private byte properties = 0;
    Expression select = null;
    protected StructuredQName variableQName;
    SequenceType requiredType;
    protected int slotNumber;
    protected int referenceCount = 10;
    protected int evaluationMode = -1;
    private Container container;
    private int locationId = -1;

    public void init(Expression select, StructuredQName qName) {
        this.select = select;
        this.variableQName = qName;
    }

    public void setContainer(Container container) {
        this.container = container;
        if (container != null) {
            Iterator<Expression> children = this.iterateSubExpressions();
            while (children.hasNext()) {
                Container childContainer;
                Expression child = children.next();
                if (child == null || (childContainer = child.getContainer()) == container || childContainer != null && childContainer.getContainerGranularity() >= container.getContainerGranularity()) continue;
                child.setContainer(container);
            }
        }
    }

    public Container getContainer() {
        return this.container;
    }

    public void setLocationId(int id) {
        this.locationId = id;
    }

    public final int getLocationId() {
        return this.locationId;
    }

    @Override
    public int getLineNumber() {
        if (this.locationId == -1) {
            return -1;
        }
        return this.locationId & 0xFFFFF;
    }

    @Override
    public int getColumnNumber() {
        return -1;
    }

    @Override
    public String getSystemId() {
        if (this.locationId == -1) {
            return null;
        }
        Executable exec = this.getExecutable();
        if (exec == null) {
            return null;
        }
        LocationMap map = exec.getLocationMap();
        if (map == null) {
            return null;
        }
        return map.getSystemId(this.locationId);
    }

    @Override
    public final String getPublicId() {
        return null;
    }

    public Executable getExecutable() {
        Container container = this.getContainer();
        return container == null ? null : container.getExecutable();
    }

    public LocationProvider getLocationProvider() {
        Container container = this.getContainer();
        return container == null ? null : container.getLocationProvider();
    }

    public String getSystemId(long locationId) {
        return this.getLocationProvider().getSystemId(locationId);
    }

    public void setSelectExpression(Expression select) {
        this.select = select;
        this.evaluationMode = -1;
    }

    public Expression getSelectExpression() {
        return this.select;
    }

    public void setRequiredType(SequenceType required) {
        this.requiredType = required;
    }

    @Override
    public SequenceType getRequiredType() {
        return this.requiredType;
    }

    @Override
    public IntegerValue[] getIntegerBoundsForVariable() {
        if (this.select != null) {
            return this.select.getIntegerBounds();
        }
        return null;
    }

    public void setRequiredParam(boolean requiredParam) {
        this.properties = requiredParam ? (byte)(this.properties | 4) : (byte)(this.properties & 0xFFFFFFFB);
    }

    public void setImplicitlyRequiredParam(boolean requiredParam) {
        this.properties = requiredParam ? (byte)(this.properties | 0x10) : (byte)(this.properties & 0xFFFFFFEF);
    }

    public void setTunnel(boolean tunnel) {
        this.properties = tunnel ? (byte)(this.properties | 8) : (byte)(this.properties & 0xFFFFFFF7);
    }

    public void setReferenceCount(int refCount) {
        this.referenceCount = refCount;
    }

    public int getEvaluationMode() {
        if (this.evaluationMode == -1) {
            this.evaluationMode = this.referenceCount == 10000 ? 12 : ExpressionTool.lazyEvaluationMode(this.select);
        }
        return this.evaluationMode;
    }

    public int getCardinality() {
        return 8192;
    }

    @Override
    public boolean isAssignable() {
        return false;
    }

    @Override
    public boolean isGlobal() {
        return false;
    }

    @Override
    public int getLocalSlotNumber() {
        return this.slotNumber;
    }

    public final boolean isRequiredParam() {
        return (this.properties & 4) != 0;
    }

    public final boolean isImplicitlyRequiredParam() {
        return (this.properties & 0x10) != 0;
    }

    public final boolean isTunnelParam() {
        return (this.properties & 8) != 0;
    }

    public int getInstructionNameCode() {
        return 205;
    }

    public void simplify(ExpressionVisitor visitor) throws XPathException {
        if (this.select != null) {
            this.select = visitor.simplify(this.select);
        }
    }

    public void typeCheck(ExpressionVisitor visitor, ExpressionVisitor.ContextItemType contextItemType) throws XPathException {
        if (this.select != null) {
            this.select = visitor.typeCheck(this.select, contextItemType);
        }
        this.checkAgainstRequiredType(visitor);
    }

    public void optimize(ExpressionVisitor visitor, ExpressionVisitor.ContextItemType contextItemType) throws XPathException {
        if (this.select != null) {
            this.select = visitor.optimize(this.select, contextItemType);
            this.computeEvaluationMode();
        }
    }

    public void computeEvaluationMode() {
        this.evaluationMode = this.isAssignable() ? ExpressionTool.eagerEvaluationMode(this.select) : (this.referenceCount == 10000 ? 12 : ExpressionTool.lazyEvaluationMode(this.select));
    }

    public Expression copy() {
        throw new UnsupportedOperationException("GeneralVariable.copy()");
    }

    @Override
    public void addReference(boolean isLoopingReference) {
    }

    public void checkAgainstRequiredType(ExpressionVisitor visitor) throws XPathException {
        RoleLocator role = new RoleLocator(3, this.variableQName, 0);
        SequenceType r = this.requiredType;
        if (r != null && this.select != null) {
            this.select = TypeChecker.staticTypeCheck(this.select, this.requiredType, false, role, visitor);
        }
    }

    public Sequence getSelectValue(XPathContext context) throws XPathException {
        if (this.select == null) {
            throw new AssertionError((Object)"*** No select expression!!");
        }
        return ExpressionTool.evaluate(this.select, this.evaluationMode, context, this.referenceCount);
    }

    public Iterator<Expression> iterateSubExpressions() {
        if (this.select != null) {
            return new MonoIterator<Expression>(this.select);
        }
        List list = Collections.emptyList();
        return list.iterator();
    }

    public boolean replaceSubExpression(Expression original, Expression replacement) {
        boolean found = false;
        if (this.select == original) {
            this.select = replacement;
            found = true;
        }
        return found;
    }

    public void explain(ExpressionPresenter out) {
        out.startElement("variable");
        out.emitAttribute("name", this.variableQName.getDisplayName());
        if (this.select != null) {
            this.select.explain(out);
        }
        out.endElement();
    }

    public int getSlotNumber() {
        return this.slotNumber;
    }

    public void setSlotNumber(int s) {
        this.slotNumber = s;
    }

    public void setVariableQName(StructuredQName s) {
        this.variableQName = s;
    }

    @Override
    public StructuredQName getVariableQName() {
        return this.variableQName;
    }
}

