/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.editor.autotext;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.omegat.util.Log;
import org.omegat.util.StaticUtils;

public final class Autotext {
    private static final String AUTOTEXT_FILE_NAME = "omegat.autotext";
    private static final File DEFAULT_FILE = new File(StaticUtils.getConfigDir(), "omegat.autotext");
    private static volatile List<AutotextItem> list = Collections.emptyList();

    private Autotext() {
    }

    public static List<AutotextItem> getItems() {
        return Collections.unmodifiableList(list);
    }

    public static void setList(Collection<AutotextItem> items) {
        list = new ArrayList<AutotextItem>(items);
    }

    public static List<AutotextItem> load(File file) throws IOException {
        return Files.lines(file.toPath()).filter(line -> !line.trim().isEmpty()).map(line -> line.split("\t")).filter(parts -> ((String[])parts).length >= 2).map(parts -> new AutotextItem(parts[0], parts[1], Arrays.copyOfRange(parts, 2, ((String[])parts).length))).collect(Collectors.toList());
    }

    public static void save(Collection<AutotextItem> items, File file) throws IOException {
        Files.write(file.toPath(), (Iterable<? extends CharSequence>)items.stream().map(AutotextItem::toString).collect(Collectors.toList()), StandardCharsets.UTF_8, new OpenOption[0]);
    }

    public static void save() throws IOException {
        Autotext.save(list, DEFAULT_FILE);
    }

    static {
        if (DEFAULT_FILE.isFile()) {
            try {
                list = Autotext.load(DEFAULT_FILE);
            }
            catch (IOException ex) {
                Log.log(ex);
            }
        }
    }

    public static class AutotextItem {
        public final String source;
        public final String target;
        public final String comment;

        public AutotextItem() {
            this("", "", new String[0]);
        }

        public AutotextItem(String source, String target, String ... comment) {
            this.source = source == null ? "" : source;
            this.target = target == null ? "" : target;
            this.comment = comment.length == 0 || comment[0] == null ? "" : comment[0];
        }

        public String toString() {
            return this.source + "\t" + this.target + "\t" + this.comment;
        }
    }
}

