/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.editor.history;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class WordPredictor {
    static final double MIN_FREQUENCY = 10.0;
    private static final Comparator<Prediction> RESULT_SORTER = Comparator.comparing(Prediction::getFrequency).reversed().thenComparing(Prediction::getWord);
    private Map<String, FrequencyStrings> data = new HashMap<String, FrequencyStrings>();

    public void reset() {
        this.data.clear();
    }

    public void train(String[] tokens) {
        if (tokens.length == 0) {
            return;
        }
        for (int i = 0; i < tokens.length - 1; ++i) {
            String token = tokens[i];
            FrequencyStrings strings = this.data.get(token);
            if (strings == null) {
                strings = new FrequencyStrings();
                this.data.put(token, strings);
            }
            strings.encounter(tokens[i + 1]);
        }
    }

    public List<Prediction> predictWord(String seed) {
        if (seed == null) {
            throw new NullPointerException("Prediction seed can't be null");
        }
        if (this.data.isEmpty() || seed.isEmpty()) {
            return Collections.emptyList();
        }
        FrequencyStrings candidates = this.data.get(seed);
        if (candidates == null) {
            return Collections.emptyList();
        }
        List entries = candidates.getEntries().stream().filter(e -> (Integer)e.getValue() > 1).collect(Collectors.toList());
        int total = entries.stream().mapToInt(Map.Entry::getValue).sum();
        return entries.stream().map(e -> {
            double percent = (double)((Integer)e.getValue()).intValue() / (double)total * 100.0;
            return percent >= 10.0 ? new Prediction((String)e.getKey(), percent) : null;
        }).filter(Objects::nonNull).sorted(RESULT_SORTER).collect(Collectors.toList());
    }

    public static class Prediction {
        private final String word;
        private final double frequency;

        public Prediction(String word, double frequency) {
            this.word = word;
            this.frequency = frequency;
        }

        public String getWord() {
            return this.word;
        }

        public double getFrequency() {
            return this.frequency;
        }
    }

    private static class FrequencyStrings {
        private final Map<String, Integer> map = new HashMap<String, Integer>();

        private FrequencyStrings() {
        }

        public void encounter(String string) {
            Integer count = this.map.get(string);
            this.map.put(string, count == null ? 1 : count + 1);
        }

        public List<Map.Entry<String, Integer>> getEntries() {
            return new ArrayList<Map.Entry<String, Integer>>(this.map.entrySet());
        }
    }
}

