/*
 * Decompiled with CFR 0.152.
 */
package org.usadellab.trimmomatic.fastq;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayDeque;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.zip.ZipInputStream;
import org.itadaki.bzip2.BZip2InputStream;
import org.usadellab.trimmomatic.fastq.FastqRecord;
import org.usadellab.trimmomatic.util.ConcatGZIPInputStream;
import org.usadellab.trimmomatic.util.PositionTrackingInputStream;

public class FastqParser {
    private static final int PREREAD_COUNT = 10000;
    private int phredOffset;
    private ArrayDeque<FastqRecord> deque;
    int[] qualHistogram;
    int[] patternHistogram;
    private PositionTrackingInputStream posTrackInputStream;
    private BufferedReader reader;
    private FastqRecord current;
    private long fileLength;
    private AtomicBoolean atEOF;

    public FastqParser(int phredOffset) {
        this.phredOffset = phredOffset;
        this.deque = new ArrayDeque(10000);
        this.atEOF = new AtomicBoolean();
    }

    public void setPhredOffset(int phredOffset) {
        this.phredOffset = phredOffset;
        if (this.current != null) {
            this.current.setPhredOffset(phredOffset);
        }
    }

    public void parseOne() throws IOException {
        this.current = null;
        String line = this.reader.readLine();
        if (line == null) {
            this.atEOF.set(true);
            return;
        }
        if (line.charAt(0) != '@') {
            throw new RuntimeException("Invalid FASTQ name line: " + line);
        }
        String name = line.substring(1);
        String sequence = this.reader.readLine();
        if (sequence == null) {
            throw new RuntimeException("Missing sequence line from record: " + name);
        }
        line = this.reader.readLine();
        if (line == null) {
            throw new RuntimeException("Missing comment line from record: " + name);
        }
        if (line.charAt(0) != '+') {
            throw new RuntimeException("Invalid FASTQ comment line: " + line);
        }
        String comment = line.substring(1);
        String quality = this.reader.readLine();
        if (quality == null) {
            throw new RuntimeException("Missing quality line from record: " + name);
        }
        this.current = new FastqRecord(name, sequence, comment, quality, this.phredOffset);
    }

    public int getProgress() {
        if (this.atEOF.get()) {
            return 100;
        }
        long bytesRead = this.posTrackInputStream.getPosition();
        return (int)((float)bytesRead / (float)this.fileLength * 100.0f);
    }

    private void accumulateHistogram(FastqRecord rec) {
        int[] quals;
        int[] nArray = quals = rec.getQualityAsInteger(false);
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            int i2;
            int n2 = i2 = nArray[i];
            this.qualHistogram[n2] = this.qualHistogram[n2] + 1;
        }
    }

    public int determinePhredOffset() {
        int i;
        int phred33Total = 0;
        int phred64Total = 0;
        for (i = 33; i <= 58; ++i) {
            phred33Total += this.qualHistogram[i];
        }
        for (i = 80; i <= 104; ++i) {
            phred64Total += this.qualHistogram[i];
        }
        if (phred33Total == 0 && phred64Total > 0) {
            return 64;
        }
        if (phred64Total == 0 && phred33Total > 0) {
            return 33;
        }
        return 0;
    }

    public void parse(File file) throws IOException {
        String name = file.getName();
        this.fileLength = file.length();
        InputStream contentInputStream = this.posTrackInputStream = new PositionTrackingInputStream(new FileInputStream(file));
        if (name.toLowerCase().endsWith(".gz")) {
            contentInputStream = new ConcatGZIPInputStream(this.posTrackInputStream);
        } else if (name.toLowerCase().endsWith(".bz2")) {
            contentInputStream = new BZip2InputStream(this.posTrackInputStream, false);
        } else if (name.toLowerCase().endsWith(".zip")) {
            contentInputStream = new ZipInputStream(this.posTrackInputStream);
        }
        this.reader = new BufferedReader(new InputStreamReader(contentInputStream), 32768);
        if (this.phredOffset == 0) {
            this.deque.clear();
            this.qualHistogram = new int[256];
            for (int i = 0; i < 10000; ++i) {
                this.parseOne();
                if (this.current == null) continue;
                this.deque.add(this.current);
                this.accumulateHistogram(this.current);
            }
        }
        this.parseOne();
    }

    public void close() throws IOException {
        this.reader.close();
    }

    public boolean hasNext() {
        return !this.deque.isEmpty() || this.current != null;
    }

    public FastqRecord next() throws IOException {
        if (this.deque.isEmpty()) {
            FastqRecord current = this.current;
            this.parseOne();
            return current;
        }
        FastqRecord rec = this.deque.poll();
        if (rec != null) {
            rec.setPhredOffset(this.phredOffset);
        }
        return rec;
    }
}

