/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.util;

import com.google.common.util.concurrent.RateLimiter;
import java.nio.MappedByteBuffer;
import java.util.TreeMap;
import org.apache.cassandra.io.compress.CompressedRandomAccessReader;
import org.apache.cassandra.io.compress.CompressedSequentialWriter;
import org.apache.cassandra.io.compress.CompressedThrottledReader;
import org.apache.cassandra.io.compress.CompressionMetadata;
import org.apache.cassandra.io.util.ChannelProxy;
import org.apache.cassandra.io.util.CompressedSegmentedFile;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.io.util.ICompressedFile;
import org.apache.cassandra.io.util.PoolingSegmentedFile;
import org.apache.cassandra.io.util.RandomAccessReader;
import org.apache.cassandra.io.util.SegmentedFile;

public class CompressedPoolingSegmentedFile
extends PoolingSegmentedFile
implements ICompressedFile {
    public final CompressionMetadata metadata;
    private final TreeMap<Long, MappedByteBuffer> chunkSegments;

    public CompressedPoolingSegmentedFile(ChannelProxy channel, CompressionMetadata metadata) {
        this(channel, metadata, CompressedSegmentedFile.createMappedSegments(channel, metadata));
    }

    private CompressedPoolingSegmentedFile(ChannelProxy channel, CompressionMetadata metadata, TreeMap<Long, MappedByteBuffer> chunkSegments) {
        super(new Cleanup(channel, metadata, chunkSegments), channel, metadata.dataLength, metadata.compressedFileLength);
        this.metadata = metadata;
        this.chunkSegments = chunkSegments;
    }

    private CompressedPoolingSegmentedFile(CompressedPoolingSegmentedFile copy) {
        super(copy);
        this.metadata = copy.metadata;
        this.chunkSegments = copy.chunkSegments;
    }

    @Override
    public ChannelProxy channel() {
        return this.channel;
    }

    @Override
    public TreeMap<Long, MappedByteBuffer> chunkSegments() {
        return this.chunkSegments;
    }

    @Override
    public void dropPageCache(long before) {
        if (before >= this.metadata.dataLength) {
            super.dropPageCache(0L);
        }
        super.dropPageCache(this.metadata.chunkFor((long)before).offset);
    }

    @Override
    public RandomAccessReader createReader() {
        return CompressedRandomAccessReader.open(this);
    }

    @Override
    public RandomAccessReader createThrottledReader(RateLimiter limiter) {
        return CompressedThrottledReader.open(this, limiter);
    }

    @Override
    protected RandomAccessReader createPooledReader() {
        return CompressedRandomAccessReader.open(this);
    }

    @Override
    public CompressionMetadata getMetadata() {
        return this.metadata;
    }

    @Override
    public CompressedPoolingSegmentedFile sharedCopy() {
        return new CompressedPoolingSegmentedFile(this);
    }

    public static class Builder
    extends CompressedSegmentedFile.Builder {
        public Builder(CompressedSequentialWriter writer) {
            super(writer);
        }

        @Override
        public void addPotentialBoundary(long boundary) {
        }

        @Override
        public SegmentedFile complete(ChannelProxy channel, long overrideLength) {
            return new CompressedPoolingSegmentedFile(channel, this.metadata(channel.filePath(), overrideLength));
        }
    }

    protected static final class Cleanup
    extends PoolingSegmentedFile.Cleanup {
        final CompressionMetadata metadata;
        final TreeMap<Long, MappedByteBuffer> chunkSegments;

        protected Cleanup(ChannelProxy channel, CompressionMetadata metadata, TreeMap<Long, MappedByteBuffer> chunkSegments) {
            super(channel);
            this.metadata = metadata;
            this.chunkSegments = chunkSegments;
        }

        @Override
        public void tidy() {
            super.tidy();
            this.metadata.close();
            if (this.chunkSegments != null) {
                for (MappedByteBuffer segment : this.chunkSegments.values()) {
                    FileUtils.clean(segment);
                }
            }
        }
    }
}

