/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils;

import com.google.common.collect.SortedSetMultimap;
import com.google.common.collect.TreeMultimap;
import java.util.Comparator;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.cassandra.utils.BiMultiValMap;

public class SortedBiMultiValMap<K, V>
extends BiMultiValMap<K, V> {
    protected SortedBiMultiValMap(SortedMap<K, V> forwardMap, SortedSetMultimap<V, K> reverseMap) {
        super(forwardMap, reverseMap);
    }

    public static <K extends Comparable<K>, V extends Comparable<V>> SortedBiMultiValMap<K, V> create() {
        return new SortedBiMultiValMap(new TreeMap(), TreeMultimap.create());
    }

    public static <K, V> SortedBiMultiValMap<K, V> create(Comparator<K> keyComparator, Comparator<V> valueComparator) {
        if (keyComparator == null) {
            keyComparator = SortedBiMultiValMap.defaultComparator();
        }
        if (valueComparator == null) {
            valueComparator = SortedBiMultiValMap.defaultComparator();
        }
        return new SortedBiMultiValMap(new TreeMap(keyComparator), TreeMultimap.create(valueComparator, keyComparator));
    }

    public static <K extends Comparable<K>, V extends Comparable<V>> SortedBiMultiValMap<K, V> create(BiMultiValMap<K, V> map) {
        SortedBiMultiValMap<K, V> newMap = SortedBiMultiValMap.create();
        newMap.forwardMap.putAll(map);
        newMap.reverseMap.putAll(map.inverse());
        return newMap;
    }

    public static <K, V> SortedBiMultiValMap<K, V> create(BiMultiValMap<K, V> map, Comparator<K> keyComparator, Comparator<V> valueComparator) {
        SortedBiMultiValMap<K, V> newMap = SortedBiMultiValMap.create(keyComparator, valueComparator);
        newMap.forwardMap.putAll(map);
        newMap.reverseMap.putAll(map.inverse());
        return newMap;
    }

    private static <T> Comparator<T> defaultComparator() {
        return new Comparator<T>(){

            @Override
            public int compare(T o1, T o2) {
                return ((Comparable)o1).compareTo(o2);
            }
        };
    }
}

