/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.security.authentication;

import java.io.IOException;
import java.util.Collections;
import java.util.Enumeration;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import javax.servlet.http.HttpSession;
import org.eclipse.jetty.security.Authenticator;
import org.eclipse.jetty.security.ServerAuthException;
import org.eclipse.jetty.security.UserAuthentication;
import org.eclipse.jetty.security.authentication.DeferredAuthentication;
import org.eclipse.jetty.security.authentication.LoginAuthenticator;
import org.eclipse.jetty.security.authentication.SessionAuthentication;
import org.eclipse.jetty.server.AbstractHttpConnection;
import org.eclipse.jetty.server.Authentication;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.UserIdentity;
import org.eclipse.jetty.util.MultiMap;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.URIUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class FormAuthenticator
extends LoginAuthenticator {
    private static final Logger LOG = Log.getLogger(FormAuthenticator.class);
    public static final String __FORM_LOGIN_PAGE = "org.eclipse.jetty.security.form_login_page";
    public static final String __FORM_ERROR_PAGE = "org.eclipse.jetty.security.form_error_page";
    public static final String __FORM_DISPATCH = "org.eclipse.jetty.security.dispatch";
    public static final String __J_URI = "org.eclipse.jetty.security.form_URI";
    public static final String __J_POST = "org.eclipse.jetty.security.form_POST";
    public static final String __J_SECURITY_CHECK = "/j_security_check";
    public static final String __J_USERNAME = "j_username";
    public static final String __J_PASSWORD = "j_password";
    private String _formErrorPage;
    private String _formErrorPath;
    private String _formLoginPage;
    private String _formLoginPath;
    private boolean _dispatch;

    public FormAuthenticator() {
    }

    public FormAuthenticator(String login, String error, boolean dispatch) {
        this();
        if (login != null) {
            this.setLoginPage(login);
        }
        if (error != null) {
            this.setErrorPage(error);
        }
        this._dispatch = dispatch;
    }

    public void setConfiguration(Authenticator.AuthConfiguration configuration) {
        String dispatch;
        String error;
        super.setConfiguration(configuration);
        String login = configuration.getInitParameter(__FORM_LOGIN_PAGE);
        if (login != null) {
            this.setLoginPage(login);
        }
        if ((error = configuration.getInitParameter(__FORM_ERROR_PAGE)) != null) {
            this.setErrorPage(error);
        }
        this._dispatch = (dispatch = configuration.getInitParameter(__FORM_DISPATCH)) == null ? this._dispatch : Boolean.valueOf(dispatch);
    }

    public String getAuthMethod() {
        return "FORM";
    }

    private void setLoginPage(String path) {
        if (!path.startsWith("/")) {
            LOG.warn("form-login-page must start with /", new Object[0]);
            path = "/" + path;
        }
        this._formLoginPage = path;
        this._formLoginPath = path;
        if (this._formLoginPath.indexOf(63) > 0) {
            this._formLoginPath = this._formLoginPath.substring(0, this._formLoginPath.indexOf(63));
        }
    }

    private void setErrorPage(String path) {
        if (path == null || path.trim().length() == 0) {
            this._formErrorPath = null;
            this._formErrorPage = null;
        } else {
            if (!path.startsWith("/")) {
                LOG.warn("form-error-page must start with /", new Object[0]);
                path = "/" + path;
            }
            this._formErrorPage = path;
            this._formErrorPath = path;
            if (this._formErrorPath.indexOf(63) > 0) {
                this._formErrorPath = this._formErrorPath.substring(0, this._formErrorPath.indexOf(63));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Authentication validateRequest(ServletRequest req, ServletResponse res, boolean mandatory) throws ServerAuthException {
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        String uri = request.getRequestURI();
        if (uri == null) {
            uri = "/";
        }
        if (!(mandatory |= this.isJSecurityCheck(uri))) {
            return this._deferred;
        }
        if (this.isLoginOrErrorPage(URIUtil.addPaths(request.getServletPath(), request.getPathInfo()))) {
            return Authentication.NOT_CHECKED;
        }
        HttpSession session = request.getSession(true);
        try {
            if (this.isJSecurityCheck(uri)) {
                String password;
                String username = request.getParameter(__J_USERNAME);
                UserIdentity user = this._loginService.login(username, password = request.getParameter(__J_PASSWORD));
                if (user != null) {
                    String nuri;
                    HttpSession httpSession = session = this.renewSessionOnAuthentication(request, response);
                    synchronized (httpSession) {
                        nuri = (String)session.getAttribute(__J_URI);
                    }
                    if ((nuri == null || nuri.length() == 0) && (nuri = request.getContextPath()).length() == 0) {
                        nuri = "/";
                    }
                    response.setContentLength(0);
                    response.sendRedirect(response.encodeRedirectURL(nuri));
                    SessionAuthentication cached = new SessionAuthentication(this.getAuthMethod(), user, password);
                    session.setAttribute("org.eclipse.jetty.security.UserIdentity", (Object)cached);
                    return new FormAuthentication(this.getAuthMethod(), user);
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Form authentication FAILED for " + StringUtil.printable(username), new Object[0]);
                }
                if (this._formErrorPage == null) {
                    if (response != null) {
                        response.sendError(403);
                    }
                } else if (this._dispatch) {
                    RequestDispatcher dispatcher = request.getRequestDispatcher(this._formErrorPage);
                    response.setHeader("Cache-Control", "No-cache");
                    response.setDateHeader("Expires", 1L);
                    dispatcher.forward((ServletRequest)new FormRequest(request), (ServletResponse)new FormResponse(response));
                } else {
                    response.sendRedirect(response.encodeRedirectURL(URIUtil.addPaths(request.getContextPath(), this._formErrorPage)));
                }
                return Authentication.SEND_FAILURE;
            }
            Authentication authentication = (Authentication)session.getAttribute("org.eclipse.jetty.security.UserIdentity");
            if (authentication != null) {
                if (authentication instanceof Authentication.User && this._loginService != null && !this._loginService.validate(((Authentication.User)authentication).getUserIdentity())) {
                    session.removeAttribute("org.eclipse.jetty.security.UserIdentity");
                } else {
                    String j_uri = (String)session.getAttribute(__J_URI);
                    if (j_uri != null) {
                        MultiMap j_post = (MultiMap)session.getAttribute(__J_POST);
                        if (j_post != null) {
                            StringBuffer buf = request.getRequestURL();
                            if (request.getQueryString() != null) {
                                buf.append("?").append(request.getQueryString());
                            }
                            if (j_uri.equals(buf.toString())) {
                                session.removeAttribute(__J_POST);
                                Request base_request = req instanceof Request ? (Request)req : AbstractHttpConnection.getCurrentConnection().getRequest();
                                base_request.setMethod("POST");
                                base_request.setParameters(j_post);
                            }
                        } else {
                            session.removeAttribute(__J_URI);
                        }
                    }
                    return authentication;
                }
            }
            if (DeferredAuthentication.isDeferred(response)) {
                return Authentication.UNAUTHENTICATED;
            }
            HttpSession j_uri = session;
            synchronized (j_uri) {
                if (session.getAttribute(__J_URI) == null) {
                    StringBuffer buf = request.getRequestURL();
                    if (request.getQueryString() != null) {
                        buf.append("?").append(request.getQueryString());
                    }
                    session.setAttribute(__J_URI, (Object)buf.toString());
                    if ("application/x-www-form-urlencoded".equalsIgnoreCase(req.getContentType()) && "POST".equals(request.getMethod())) {
                        Request base_request = req instanceof Request ? (Request)req : AbstractHttpConnection.getCurrentConnection().getRequest();
                        base_request.extractParameters();
                        session.setAttribute(__J_POST, new MultiMap<String>(base_request.getParameters()));
                    }
                }
            }
            if (this._dispatch) {
                RequestDispatcher dispatcher = request.getRequestDispatcher(this._formLoginPage);
                response.setHeader("Cache-Control", "No-cache");
                response.setDateHeader("Expires", 1L);
                dispatcher.forward((ServletRequest)new FormRequest(request), (ServletResponse)new FormResponse(response));
            } else {
                response.sendRedirect(response.encodeRedirectURL(URIUtil.addPaths(request.getContextPath(), this._formLoginPage)));
            }
            return Authentication.SEND_CONTINUE;
        }
        catch (IOException e) {
            throw new ServerAuthException(e);
        }
        catch (ServletException e) {
            throw new ServerAuthException(e);
        }
    }

    public boolean isJSecurityCheck(String uri) {
        int jsc = uri.indexOf(__J_SECURITY_CHECK);
        if (jsc < 0) {
            return false;
        }
        int e = jsc + __J_SECURITY_CHECK.length();
        if (e == uri.length()) {
            return true;
        }
        char c = uri.charAt(e);
        return c == ';' || c == '#' || c == '/' || c == '?';
    }

    public boolean isLoginOrErrorPage(String pathInContext) {
        return pathInContext != null && (pathInContext.equals(this._formErrorPath) || pathInContext.equals(this._formLoginPath));
    }

    public boolean secureResponse(ServletRequest req, ServletResponse res, boolean mandatory, Authentication.User validatedUser) throws ServerAuthException {
        return true;
    }

    public static class FormAuthentication
    extends UserAuthentication
    implements Authentication.ResponseSent {
        public FormAuthentication(String method, UserIdentity userIdentity) {
            super(method, userIdentity);
        }

        public String toString() {
            return "Form" + super.toString();
        }
    }

    protected static class FormResponse
    extends HttpServletResponseWrapper {
        public FormResponse(HttpServletResponse response) {
            super(response);
        }

        public void addDateHeader(String name, long date) {
            if (this.notIgnored(name)) {
                super.addDateHeader(name, date);
            }
        }

        public void addHeader(String name, String value) {
            if (this.notIgnored(name)) {
                super.addHeader(name, value);
            }
        }

        public void setDateHeader(String name, long date) {
            if (this.notIgnored(name)) {
                super.setDateHeader(name, date);
            }
        }

        public void setHeader(String name, String value) {
            if (this.notIgnored(name)) {
                super.setHeader(name, value);
            }
        }

        private boolean notIgnored(String name) {
            return !"Cache-Control".equalsIgnoreCase(name) && !"Pragma".equalsIgnoreCase(name) && !"ETag".equalsIgnoreCase(name) && !"Expires".equalsIgnoreCase(name) && !"Last-Modified".equalsIgnoreCase(name) && !"Age".equalsIgnoreCase(name);
        }
    }

    protected static class FormRequest
    extends HttpServletRequestWrapper {
        public FormRequest(HttpServletRequest request) {
            super(request);
        }

        public long getDateHeader(String name) {
            if (name.toLowerCase().startsWith("if-")) {
                return -1L;
            }
            return super.getDateHeader(name);
        }

        public String getHeader(String name) {
            if (name.toLowerCase().startsWith("if-")) {
                return null;
            }
            return super.getHeader(name);
        }

        public Enumeration getHeaderNames() {
            return Collections.enumeration(Collections.list(super.getHeaderNames()));
        }

        public Enumeration getHeaders(String name) {
            if (name.toLowerCase().startsWith("if-")) {
                return Collections.enumeration(Collections.EMPTY_LIST);
            }
            return super.getHeaders(name);
        }
    }
}

