/*
 * Decompiled with CFR 0.152.
 */
package org.igoweb.igoweb.client.swing;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Collection;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import org.igoweb.igoweb.client.CRoom;
import org.igoweb.igoweb.client.Client;
import org.igoweb.igoweb.client.swing.EditableUserList;
import org.igoweb.igoweb.client.swing.GuiClientUtil;
import org.igoweb.igoweb.shared.RoomCategories;
import org.igoweb.igoweb.shared.User;
import org.igoweb.util.Defs;
import org.igoweb.util.Event;
import org.igoweb.util.EventListener;
import org.igoweb.util.swing.AFrame;
import org.igoweb.util.swing.ATextField;
import org.igoweb.util.swing.DFrame;
import org.igoweb.util.swing.Errout;
import org.igoweb.util.swing.GCLayout;
import org.igoweb.util.swing.LabelPair;
import org.igoweb.util.swing.MsgOut;
import org.igoweb.util.swing.SingletonWindow;
import org.igoweb.util.swing.TBlock;

public class CreateRoomWindow
extends DFrame
implements ActionListener,
EventListener {
    private final JButton okBut;
    private final ATextField roomNameIn = new ATextField(20, (ActionListener)this);
    private final JCheckBox tournOnly = new JCheckBox(Defs.getString(-903340663), false);
    private final JCheckBox privateIn = new JCheckBox(Defs.getString(-903340643), false);
    private final JCheckBox globalGamesOnlyIn = new JCheckBox(Defs.getString(-903340557), false);
    private final Client client;
    private final SingletonWindow closeConfWin = new SingletonWindow();
    private final CRoom room;
    private final JComboBox<String> categoryIn = new JComboBox();
    private final JTextArea descIn = new JTextArea();
    private EditableUserList ownerList;
    private EditableUserList accessList;
    private HashMap<String, EditableUserList> nameToList = new HashMap();

    public CreateRoomWindow(Client newClient, AFrame parent) {
        this(newClient, null, parent);
    }

    public CreateRoomWindow(Client newClient, CRoom newRoom, Component parent) {
        super(Defs.getString(newRoom == null ? -903340768 : -903340755), parent);
        this.client = newClient;
        this.room = newRoom;
        LabelPair.Group grp = new LabelPair.Group();
        JComponent mainPanel = this.getMainPanel();
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                CreateRoomWindow.this.cancelPressed();
            }
        });
        if (newRoom == null) {
            mainPanel.add("x=0,xGrow=t,yGrow=f", new JLabel(Defs.getString(-903340752)));
        }
        mainPanel.add("x=0,xGrow=f,yGrow=f" + (newRoom == null ? "" : ",xSpan=3"), this.roomNameIn);
        User me = newClient.getMe();
        this.roomNameIn.setEditable(newRoom == null || me.getAuthLevel() >= 4);
        JPanel descPanel = new JPanel(new GCLayout());
        if (newRoom == null) {
            mainPanel.add("x=0,yGrow=t,xGrow=t,xSpan=1", descPanel);
        } else {
            this.ownerList = new EditableUserList(newClient, Defs.getString(-903340498));
            mainPanel.add("x=0,yGrow=t,xGrow=f,xSpan=1", this.ownerList);
            this.ownerList.addAll(newRoom.getOwners());
            this.ownerList.addListener(this);
            mainPanel.add("xGrow=t", descPanel);
            this.accessList = new EditableUserList(newClient, Defs.getString(-903340819));
            mainPanel.add("xGrow=f", this.accessList);
            this.accessList.addListener(this);
            if (newRoom.isPrivate()) {
                this.accessList.addAll(newRoom.getAccessList().values());
            } else {
                this.accessList.setEnabled(false);
            }
        }
        descPanel.add("x=0,xSpan=2,yGrow=f", new TBlock(Defs.getString(-903340520), 30));
        descPanel.add("x=0,yGrow=t", this.descIn);
        this.descIn.setLineWrap(true);
        this.descIn.setWrapStyleWord(true);
        this.descIn.setBorder(BorderFactory.createEtchedBorder());
        descPanel.add("x=0,xGrow=t,yGrow=f,xSpan=1", new LabelPair(Defs.getString(-903340519), this.categoryIn, grp));
        for (RoomCategories cat : RoomCategories.values()) {
            if (!cat.isVisible()) continue;
            this.categoryIn.addItem(Defs.getString(-897758079 + cat.ordinal()));
        }
        this.categoryIn.setSelectedIndex(newRoom == null ? RoomCategories.TEMPORARY.ordinal() : newRoom.getCategory().ordinal());
        this.categoryIn.setEnabled(me.getAuthLevel() >= 3);
        descPanel.add(this.privateIn);
        descPanel.add("x=0", this.globalGamesOnlyIn);
        if (me.getAuthLevel() >= 4) {
            descPanel.add(this.tournOnly);
        }
        if (newRoom == null) {
            this.okBut = this.addButton(Defs.getString(1436228518), this);
            this.addButton(Defs.getString(1436228510), this);
        } else {
            this.roomNameIn.setText(newRoom.getName());
            this.descIn.setText(newRoom.getDesc());
            newRoom.addListener(this);
            this.privateIn.setSelected(newRoom.isPrivate());
            this.tournOnly.setSelected(newRoom.isTournOnly());
            this.globalGamesOnlyIn.setSelected(newRoom.isGlobalGamesOnly());
            this.okBut = new JButton(Defs.getString(-903340785));
            this.okBut.addActionListener(this);
            descPanel.add("x=0,xSpan=2,yGrow=f", this.okBut);
            this.addButton(Defs.getString(1436228518), this);
        }
        this.pack(parent);
        GuiClientUtil.addToWindowList(newClient, this);
        this.setVisible(true);
    }

    @Override
    public Dimension getDefaultPreferredSize() {
        Dimension prev = super.getDefaultPreferredSize();
        return new Dimension(prev.width, prev.height * 3 / 2);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object src = event.getSource();
        if (src == this.okBut) {
            if (this.room == null) {
                this.createRoom();
            } else {
                String roomName = this.roomNameIn.getText().trim();
                if (roomName.isEmpty()) {
                    roomName = this.room.getName();
                }
                if (this.verifyTexts()) {
                    this.room.sendChanges(roomName, this.categoryIn.getSelectedIndex(), this.tournOnly.isSelected(), this.privateIn.isSelected(), this.globalGamesOnlyIn.isSelected(), this.descIn.getText());
                }
            }
        } else {
            this.cancelPressed();
        }
    }

    private void createRoom() {
        String roomName = this.roomNameIn.getText().trim();
        if (roomName.isEmpty()) {
            this.dispose();
            return;
        }
        if (this.verifyTexts()) {
            this.client.sendCreateRoomRequest(roomName, this.descIn.getText(), this.categoryIn.getSelectedIndex(), this.tournOnly.isSelected(), this.privateIn.isSelected(), this.globalGamesOnlyIn.isSelected(), this);
        }
    }

    private boolean verifyTexts() {
        if (this.roomNameIn.getText().trim().length() > 50) {
            new Errout(Defs.getString(-903340697, 50.0), this);
            return false;
        }
        if (this.descIn.getText().length() > 1000) {
            new Errout(Defs.getString(-903340820, 1000.0), this);
            return false;
        }
        return true;
    }

    private void cancelPressed() {
        if (!this.roomChanged()) {
            this.dispose();
            return;
        }
        String[] buttons = new String[]{Defs.getString(1436228510), Defs.getString(-903340654)};
        this.closeConfWin.setWindow(new MsgOut(Defs.getString(-903340547), Defs.getString(-903340517), 3, (Component)this, buttons, event -> {
            if (event.getActionCommand().equals(Defs.getString(-903340654))) {
                this.dispose();
            }
            this.closeConfWin.dispose();
        }));
    }

    @Override
    public void firstPaint() {
        super.firstPaint();
        if (this.roomNameIn.getText().isEmpty()) {
            this.roomNameIn.requestFocus();
        }
    }

    @Override
    public void dispose() {
        if (this.room != null) {
            this.room.removeListener(this);
        }
        super.dispose();
    }

    private boolean roomChanged() {
        if (this.room == null) {
            return !this.roomNameIn.getText().isEmpty();
        }
        return !this.roomNameIn.getText().equals(this.room.getName()) || this.tournOnly.isSelected() != this.room.isTournOnly() || this.privateIn.isSelected() != this.room.isPrivate() || this.categoryIn.getSelectedIndex() != this.room.getCategory().ordinal() || this.globalGamesOnlyIn.isSelected() != this.room.isGlobalGamesOnly() || !this.descIn.getText().equals(this.room.getDesc());
    }

    @Override
    public void handleEvent(Event event) {
        switch (event.type) {
            case 25: {
                String name = (String)event.arg;
                EditableUserList list = this.nameToList.get(name);
                if (list != null) {
                    list.setAddText(name);
                }
                new Errout(Defs.getString(-903340718, name), this);
                break;
            }
            case 115: {
                Boolean nameInUse = (Boolean)event.arg;
                if (nameInUse == null) {
                    this.dispose();
                    break;
                }
                new Errout(Defs.getString(nameInUse != false ? -903340518 : -903340782));
                break;
            }
            case 78: {
                this.roomNameIn.setText(this.room.getName());
                this.accessList.setEnabled(this.room.isPrivate());
                break;
            }
            case 135: {
                String name = (String)event.arg;
                this.nameToList.put(name, (EditableUserList)event.source);
                if (event.source == this.accessList) {
                    this.room.sendAddAccess(name);
                    break;
                }
                this.room.sendAddOwner(name);
                break;
            }
            case 137: {
                User u = (User)event.arg;
                if (u == this.client.getMe()) {
                    new Errout(Defs.getString(-903340670), this);
                    return;
                }
                if (event.source == this.ownerList) {
                    this.room.sendRemoveOwner(u.name);
                    break;
                }
                if (this.room.getOwners().contains(u)) {
                    new Errout(Defs.getString(-903340677, u.name), this);
                    break;
                }
                this.room.sendRemoveAccess(u.name);
                break;
            }
            case 23: {
                this.accessList.clear();
                for (Object o : (Collection)event.arg) {
                    this.accessList.add((User)o);
                }
                break;
            }
            case 81: {
                this.ownerList.clear();
                this.ownerList.addAll(this.room.getOwners());
                break;
            }
            case 79: {
                this.categoryIn.setSelectedIndex(this.room.getCategory().ordinal());
            }
        }
    }
}

