/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.session;

import java.util.Collections;
import java.util.List;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.xpack.sql.expression.Attribute;
import org.elasticsearch.xpack.sql.session.Executable;
import org.elasticsearch.xpack.sql.session.Rows;
import org.elasticsearch.xpack.sql.session.SchemaRowSet;
import org.elasticsearch.xpack.sql.session.SqlSession;
import org.elasticsearch.xpack.sql.util.Check;

public class SingletonExecutable
implements Executable {
    private final List<Attribute> output;
    private final Object[] values;

    public SingletonExecutable() {
        this(Collections.emptyList(), new Object[0]);
    }

    public SingletonExecutable(List<Attribute> output, Object ... values) {
        Check.isTrue(output.size() == values.length, "Attributes {} and values {} are out of sync", output, values);
        this.output = output;
        this.values = values;
    }

    @Override
    public List<Attribute> output() {
        return this.output;
    }

    @Override
    public void execute(SqlSession session, ActionListener<SchemaRowSet> listener) {
        listener.onResponse((Object)Rows.singleton(this.output, this.values));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.values.length; ++i) {
            sb.append(this.output.get(i));
            sb.append("=");
            sb.append(this.values[i]);
        }
        return sb.toString();
    }
}

