/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.annotations;

import java.io.IOException;
import java.util.Date;
import java.util.Objects;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.ml.job.config.Job;
import org.elasticsearch.xpack.core.ml.utils.time.TimeUtils;

public class Annotation
implements ToXContentObject,
Writeable {
    public static final ParseField ANNOTATION = new ParseField("annotation", new String[0]);
    public static final ParseField CREATE_TIME = new ParseField("create_time", new String[0]);
    public static final ParseField CREATE_USERNAME = new ParseField("create_username", new String[0]);
    public static final ParseField TIMESTAMP = new ParseField("timestamp", new String[0]);
    public static final ParseField END_TIMESTAMP = new ParseField("end_timestamp", new String[0]);
    public static final ParseField MODIFIED_TIME = new ParseField("modified_time", new String[0]);
    public static final ParseField MODIFIED_USERNAME = new ParseField("modified_username", new String[0]);
    public static final ParseField TYPE = new ParseField("type", new String[0]);
    public static final ObjectParser<Annotation, Void> PARSER = new ObjectParser(TYPE.getPreferredName(), true, Annotation::new);
    private String annotation;
    private Date createTime;
    private String createUsername;
    private Date timestamp;
    private Date endTimestamp;
    private String jobId;
    private Date modifiedTime;
    private String modifiedUsername;
    private String type;

    private Annotation() {
    }

    public Annotation(String annotation, Date createTime, String createUsername, Date timestamp, Date endTimestamp, String jobId, Date modifiedTime, String modifiedUsername, String type) {
        this.annotation = Objects.requireNonNull(annotation);
        this.createTime = Objects.requireNonNull(createTime);
        this.createUsername = Objects.requireNonNull(createUsername);
        this.timestamp = Objects.requireNonNull(timestamp);
        this.endTimestamp = endTimestamp;
        this.jobId = jobId;
        this.modifiedTime = modifiedTime;
        this.modifiedUsername = modifiedUsername;
        this.type = Objects.requireNonNull(type);
    }

    public Annotation(Annotation other) {
        Objects.requireNonNull(other);
        this.annotation = other.annotation;
        this.createTime = new Date(other.createTime.getTime());
        this.createUsername = other.createUsername;
        this.timestamp = new Date(other.timestamp.getTime());
        this.endTimestamp = other.endTimestamp == null ? null : new Date(other.endTimestamp.getTime());
        this.jobId = other.jobId;
        this.modifiedTime = other.modifiedTime == null ? null : new Date(other.modifiedTime.getTime());
        this.modifiedUsername = other.modifiedUsername;
        this.type = other.type;
    }

    public Annotation(StreamInput in) throws IOException {
        this.annotation = in.readString();
        this.createTime = new Date(in.readLong());
        this.createUsername = in.readString();
        this.timestamp = new Date(in.readLong());
        this.endTimestamp = in.readBoolean() ? new Date(in.readLong()) : null;
        this.jobId = in.readOptionalString();
        this.modifiedTime = in.readBoolean() ? new Date(in.readLong()) : null;
        this.modifiedUsername = in.readOptionalString();
        this.type = in.readString();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.annotation);
        out.writeLong(this.createTime.getTime());
        out.writeString(this.createUsername);
        out.writeLong(this.timestamp.getTime());
        if (this.endTimestamp != null) {
            out.writeBoolean(true);
            out.writeLong(this.endTimestamp.getTime());
        } else {
            out.writeBoolean(false);
        }
        out.writeOptionalString(this.jobId);
        if (this.modifiedTime != null) {
            out.writeBoolean(true);
            out.writeLong(this.modifiedTime.getTime());
        } else {
            out.writeBoolean(false);
        }
        out.writeOptionalString(this.modifiedUsername);
        out.writeString(this.type);
    }

    public String getAnnotation() {
        return this.annotation;
    }

    public void setAnnotation(String annotation) {
        this.annotation = Objects.requireNonNull(annotation);
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = Objects.requireNonNull(createTime);
    }

    public String getCreateUsername() {
        return this.createUsername;
    }

    public void setCreateUsername(String createUsername) {
        this.createUsername = Objects.requireNonNull(createUsername);
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Date timestamp) {
        this.timestamp = Objects.requireNonNull(timestamp);
    }

    public Date getEndTimestamp() {
        return this.endTimestamp;
    }

    public void setEndTimestamp(Date endTimestamp) {
        this.endTimestamp = endTimestamp;
    }

    public String getJobId() {
        return this.jobId;
    }

    public void setJobId(String jobId) {
        this.jobId = jobId;
    }

    public Date getModifiedTime() {
        return this.modifiedTime;
    }

    public void setModifiedTime(Date modifiedTime) {
        this.modifiedTime = modifiedTime;
    }

    public String getModifiedUsername() {
        return this.modifiedUsername;
    }

    public void setModifiedUsername(String modifiedUsername) {
        this.modifiedUsername = modifiedUsername;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = Objects.requireNonNull(type);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(ANNOTATION.getPreferredName(), this.annotation);
        builder.timeField(CREATE_TIME.getPreferredName(), CREATE_TIME.getPreferredName() + "_string", this.createTime.getTime());
        builder.field(CREATE_USERNAME.getPreferredName(), this.createUsername);
        builder.timeField(TIMESTAMP.getPreferredName(), TIMESTAMP.getPreferredName() + "_string", this.timestamp.getTime());
        if (this.endTimestamp != null) {
            builder.timeField(END_TIMESTAMP.getPreferredName(), END_TIMESTAMP.getPreferredName() + "_string", this.endTimestamp.getTime());
        }
        if (this.jobId != null) {
            builder.field(Job.ID.getPreferredName(), this.jobId);
        }
        if (this.modifiedTime != null) {
            builder.timeField(MODIFIED_TIME.getPreferredName(), MODIFIED_TIME.getPreferredName() + "_string", this.modifiedTime.getTime());
        }
        if (this.modifiedUsername != null) {
            builder.field(MODIFIED_USERNAME.getPreferredName(), this.modifiedUsername);
        }
        builder.field(TYPE.getPreferredName(), this.type);
        builder.endObject();
        return builder;
    }

    public int hashCode() {
        return Objects.hash(this.annotation, this.createTime, this.createUsername, this.timestamp, this.endTimestamp, this.jobId, this.modifiedTime, this.modifiedUsername, this.type);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Annotation other = (Annotation)obj;
        return Objects.equals(this.annotation, other.annotation) && Objects.equals(this.createTime, other.createTime) && Objects.equals(this.createUsername, other.createUsername) && Objects.equals(this.timestamp, other.timestamp) && Objects.equals(this.endTimestamp, other.endTimestamp) && Objects.equals(this.jobId, other.jobId) && Objects.equals(this.modifiedTime, other.modifiedTime) && Objects.equals(this.modifiedUsername, other.modifiedUsername) && Objects.equals(this.type, other.type);
    }

    static {
        PARSER.declareString(Annotation::setAnnotation, ANNOTATION);
        PARSER.declareField(Annotation::setCreateTime, p -> TimeUtils.parseTimeField(p, CREATE_TIME.getPreferredName()), CREATE_TIME, ObjectParser.ValueType.VALUE);
        PARSER.declareString(Annotation::setCreateUsername, CREATE_USERNAME);
        PARSER.declareField(Annotation::setTimestamp, p -> TimeUtils.parseTimeField(p, TIMESTAMP.getPreferredName()), TIMESTAMP, ObjectParser.ValueType.VALUE);
        PARSER.declareField(Annotation::setEndTimestamp, p -> TimeUtils.parseTimeField(p, END_TIMESTAMP.getPreferredName()), END_TIMESTAMP, ObjectParser.ValueType.VALUE);
        PARSER.declareString(Annotation::setJobId, Job.ID);
        PARSER.declareField(Annotation::setModifiedTime, p -> TimeUtils.parseTimeField(p, MODIFIED_TIME.getPreferredName()), MODIFIED_TIME, ObjectParser.ValueType.VALUE);
        PARSER.declareString(Annotation::setModifiedUsername, MODIFIED_USERNAME);
        PARSER.declareString(Annotation::setType, TYPE);
    }
}

