/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.liftover;

import htsjdk.samtools.SAMException;
import htsjdk.samtools.util.BufferedLineReader;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Interval;
import htsjdk.samtools.util.OverlapDetector;
import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;

class Chain {
    private static final Pattern SPLITTER = Pattern.compile("\\s");
    final double score;
    final Interval interval;
    final String fromSequenceName;
    final int fromSequenceSize;
    final int fromChainStart;
    final int fromChainEnd;
    final String toSequenceName;
    final int toSequenceSize;
    final boolean toOppositeStrand;
    final int toChainStart;
    final int toChainEnd;
    final int id;
    private final List<ContinuousBlock> blockList = new ArrayList<ContinuousBlock>();

    private Chain(double score, String fromSequenceName, int fromSequenceSize, int fromChainStart, int fromChainEnd, String toSequenceName, int toSequenceSize, boolean toOppositeStrand, int toChainStart, int toChainEnd, int id) {
        this.interval = new Interval(fromSequenceName, fromChainStart + 1, fromChainEnd);
        this.score = score;
        this.toChainEnd = toChainEnd;
        this.toSequenceName = toSequenceName;
        this.toOppositeStrand = toOppositeStrand;
        this.toSequenceSize = toSequenceSize;
        this.toChainStart = toChainStart;
        this.fromChainEnd = fromChainEnd;
        this.fromSequenceName = fromSequenceName;
        this.fromSequenceSize = fromSequenceSize;
        this.fromChainStart = fromChainStart;
        this.id = id;
    }

    private void addBlock(int tStart, int qStart, int blockLength) {
        this.blockList.add(new ContinuousBlock(tStart, qStart, blockLength));
    }

    ContinuousBlock getBlock(int i) {
        return this.blockList.get(i);
    }

    List<ContinuousBlock> getBlocks() {
        return Collections.unmodifiableList(this.blockList);
    }

    void write(PrintWriter writer) {
        writer.printf("chain\t%f\t%s\t%d\t+\t%d\t%d\t%s\t%d\t%s\t%d\t%d\t%d\n", this.score, this.fromSequenceName, this.fromSequenceSize, this.fromChainStart, this.fromChainEnd, this.toSequenceName, this.toSequenceSize, this.toOppositeStrand ? "-" : "+", this.toChainStart, this.toChainEnd, this.id);
        for (int i = 0; i < this.blockList.size() - 1; ++i) {
            ContinuousBlock thisBlock = this.blockList.get(i);
            ContinuousBlock nextBlock = this.blockList.get(i + 1);
            int fromGap = nextBlock.fromStart - thisBlock.getFromEnd();
            int toGap = nextBlock.toStart - thisBlock.getToEnd();
            writer.printf("%d\t%d\t%d\n", thisBlock.blockLength, fromGap, toGap);
        }
        writer.printf("%d\n", this.blockList.get((int)(this.blockList.size() - 1)).blockLength);
        writer.println();
    }

    void validate() {
        this.validatePositive("fromSequenceSize", this.fromSequenceSize);
        this.validateNonNegative("fromChainStart", this.fromChainStart);
        this.validateNonNegative("fromChainEnd", this.fromChainEnd);
        this.validatePositive("toSequenceSize", this.toSequenceSize);
        this.validateNonNegative("toChainStart", this.toChainStart);
        this.validateNonNegative("toChainEnd", this.toChainEnd);
        int fromLength = this.fromChainEnd - this.fromChainStart;
        this.validatePositive("from length", fromLength);
        int toLength = this.toChainEnd - this.toChainStart;
        this.validatePositive("to length", toLength);
        if (fromLength > this.fromSequenceSize) {
            throw new SAMException("From chain length (" + fromLength + ") < from sequence length (" + this.fromSequenceSize + ") for chain " + this.id);
        }
        if (toLength > this.toSequenceSize) {
            throw new SAMException("To chain length (" + toLength + ") < to sequence length (" + this.toSequenceSize + ") for chain " + this.id);
        }
        if (this.fromSequenceName.isEmpty()) {
            throw new SAMException("Chain " + this.id + "has empty from sequence name.");
        }
        if (this.toSequenceName.isEmpty()) {
            throw new SAMException("Chain " + this.id + "has empty to sequence name.");
        }
        if (this.blockList.isEmpty()) {
            throw new SAMException("Chain " + this.id + " has empty block list.");
        }
        ContinuousBlock firstBlock = this.blockList.get(0);
        if (firstBlock.fromStart != this.fromChainStart) {
            throw new SAMException("First block from start != chain from start for chain " + this.id);
        }
        if (firstBlock.toStart != this.toChainStart) {
            throw new SAMException("First block to start != chain to start for chain " + this.id);
        }
        ContinuousBlock lastBlock = this.blockList.get(this.blockList.size() - 1);
        if (lastBlock.getFromEnd() != this.fromChainEnd) {
            throw new SAMException("Last block from end != chain from end for chain " + this.id);
        }
        if (lastBlock.getToEnd() != this.toChainEnd) {
            throw new SAMException("Last block to end < chain to end for chain " + this.id);
        }
        for (int i = 1; i < this.blockList.size(); ++i) {
            ContinuousBlock thisBlock = this.blockList.get(i);
            ContinuousBlock prevBlock = this.blockList.get(i - 1);
            if (thisBlock.fromStart < prevBlock.getFromEnd()) {
                throw new SAMException("Continuous block " + i + " from starts before previous block ends for chain " + this.id);
            }
            if (thisBlock.toStart >= prevBlock.getToEnd()) continue;
            throw new SAMException("Continuous block " + i + " to starts before previous block ends for chain " + this.id);
        }
    }

    private void validatePositive(String attributeName, int attribute) {
        if (attribute <= 0) {
            throw new SAMException(attributeName + " is not positive: " + attribute + " for chain " + this.id);
        }
    }

    private void validateNonNegative(String attributeName, int attribute) {
        if (attribute < 0) {
            throw new SAMException(attributeName + " is negative: " + attribute + " for chain " + this.id);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Chain chain = (Chain)o;
        if (this.fromChainEnd != chain.fromChainEnd) {
            return false;
        }
        if (this.fromChainStart != chain.fromChainStart) {
            return false;
        }
        if (this.fromSequenceSize != chain.fromSequenceSize) {
            return false;
        }
        if (this.id != chain.id) {
            return false;
        }
        if (Double.compare(chain.score, this.score) != 0) {
            return false;
        }
        if (this.toChainEnd != chain.toChainEnd) {
            return false;
        }
        if (this.toChainStart != chain.toChainStart) {
            return false;
        }
        if (this.toOppositeStrand != chain.toOppositeStrand) {
            return false;
        }
        if (this.toSequenceSize != chain.toSequenceSize) {
            return false;
        }
        if (this.blockList != null ? !this.blockList.equals(chain.blockList) : chain.blockList != null) {
            return false;
        }
        if (this.fromSequenceName != null ? !this.fromSequenceName.equals(chain.fromSequenceName) : chain.fromSequenceName != null) {
            return false;
        }
        if (this.interval != null ? !this.interval.equals(chain.interval) : chain.interval != null) {
            return false;
        }
        return !(this.toSequenceName != null ? !this.toSequenceName.equals(chain.toSequenceName) : chain.toSequenceName != null);
    }

    public int hashCode() {
        long temp = this.score != 0.0 ? Double.doubleToLongBits(this.score) : 0L;
        int result = (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.interval != null ? this.interval.hashCode() : 0);
        result = 31 * result + (this.fromSequenceName != null ? this.fromSequenceName.hashCode() : 0);
        result = 31 * result + this.fromSequenceSize;
        result = 31 * result + this.fromChainStart;
        result = 31 * result + this.fromChainEnd;
        result = 31 * result + (this.toSequenceName != null ? this.toSequenceName.hashCode() : 0);
        result = 31 * result + this.toSequenceSize;
        result = 31 * result + (this.toOppositeStrand ? 1 : 0);
        result = 31 * result + this.toChainStart;
        result = 31 * result + this.toChainEnd;
        result = 31 * result + this.id;
        result = 31 * result + (this.blockList != null ? this.blockList.hashCode() : 0);
        return result;
    }

    static OverlapDetector<Chain> loadChains(File chainFile) {
        IOUtil.assertFileIsReadable(chainFile);
        try (BufferedLineReader reader = new BufferedLineReader(IOUtil.openFileForReading(chainFile));){
            OverlapDetector<Chain> overlapDetector = Chain.loadChains(reader, chainFile.toString());
            return overlapDetector;
        }
    }

    static OverlapDetector<Chain> loadChains(BufferedLineReader reader, String sourceName) {
        Chain chain;
        OverlapDetector<Chain> ret = new OverlapDetector<Chain>(0, 0);
        while ((chain = Chain.loadChain(reader, sourceName)) != null) {
            ret.addLhs(chain, chain.interval);
        }
        return ret;
    }

    private static Chain loadChain(BufferedLineReader reader, String sourceName) {
        String line;
        do {
            if ((line = reader.readLine()) != null) continue;
            return null;
        } while (line.startsWith("#"));
        String[] chainFields = SPLITTER.split(line);
        if (chainFields.length != 13) {
            Chain.throwChainFileParseException("chain line has wrong number of fields", sourceName, reader.getLineNumber());
        }
        if (!"chain".equals(chainFields[0])) {
            Chain.throwChainFileParseException("chain line does not start with 'chain'", sourceName, reader.getLineNumber());
        }
        double score = 0.0;
        String fromSequenceName = null;
        int fromSequenceSize = 0;
        int fromChainStart = 0;
        int fromChainEnd = 0;
        String toSequenceName = null;
        int toSequenceSize = 0;
        boolean toNegativeStrand = false;
        int toChainStart = 0;
        int toChainEnd = 0;
        int id = 0;
        try {
            score = Double.parseDouble(chainFields[1]);
            fromSequenceName = chainFields[2];
            fromSequenceSize = Integer.parseInt(chainFields[3]);
            fromChainStart = Integer.parseInt(chainFields[5]);
            fromChainEnd = Integer.parseInt(chainFields[6]);
            toSequenceName = chainFields[7];
            toSequenceSize = Integer.parseInt(chainFields[8]);
            toNegativeStrand = chainFields[9].equals("-");
            toChainStart = Integer.parseInt(chainFields[10]);
            toChainEnd = Integer.parseInt(chainFields[11]);
            id = Integer.parseInt(chainFields[12]);
        }
        catch (NumberFormatException e) {
            Chain.throwChainFileParseException("Invalid field", sourceName, reader.getLineNumber());
        }
        Chain chain = new Chain(score, fromSequenceName, fromSequenceSize, fromChainStart, fromChainEnd, toSequenceName, toSequenceSize, toNegativeStrand, toChainStart, toChainEnd, id);
        int toBlockStart = chain.toChainStart;
        int fromBlockStart = chain.fromChainStart;
        boolean sawLastLine = false;
        while (true) {
            String[] blockFields;
            if ((line = reader.readLine()) == null || line.equals("")) {
                if (sawLastLine) break;
                Chain.throwChainFileParseException("Reached end of chain without seeing terminal block", sourceName, reader.getLineNumber());
                break;
            }
            if (sawLastLine) {
                Chain.throwChainFileParseException("Terminal block seen before end of chain", sourceName, reader.getLineNumber());
            }
            if ((blockFields = SPLITTER.split(line)).length == 1) {
                sawLastLine = true;
            } else if (blockFields.length != 3) {
                Chain.throwChainFileParseException("Block line has unexpected number of fields", sourceName, reader.getLineNumber());
            }
            int size = Integer.parseInt(blockFields[0]);
            chain.addBlock(fromBlockStart, toBlockStart, size);
            if (sawLastLine) continue;
            fromBlockStart += Integer.parseInt(blockFields[1]) + size;
            toBlockStart += Integer.parseInt(blockFields[2]) + size;
        }
        chain.validate();
        return chain;
    }

    private static void throwChainFileParseException(String message, String sourceName, int lineNumber) {
        throw new SAMException(message + " in chain file " + sourceName + " at line " + lineNumber);
    }

    static class ContinuousBlock {
        final int fromStart;
        final int toStart;
        final int blockLength;

        private ContinuousBlock(int fromStart, int toStart, int blockLength) {
            this.fromStart = fromStart;
            this.toStart = toStart;
            this.blockLength = blockLength;
        }

        int getFromEnd() {
            return this.fromStart + this.blockLength;
        }

        int getToEnd() {
            return this.toStart + this.blockLength;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ContinuousBlock that = (ContinuousBlock)o;
            if (this.blockLength != that.blockLength) {
                return false;
            }
            if (this.fromStart != that.fromStart) {
                return false;
            }
            return this.toStart == that.toStart;
        }

        public int hashCode() {
            int result = this.fromStart;
            result = 31 * result + this.toStart;
            result = 31 * result + this.blockLength;
            return result;
        }
    }
}

