/*
 * Decompiled with CFR 0.152.
 */
package tokyocabinet;

import java.io.File;
import java.io.PrintStream;
import java.util.Random;
import tokyocabinet.HDB;
import tokyocabinet.Util;

class HDBTest {
    private static final PrintStream STDOUT = System.out;
    private static final PrintStream STDERR = System.err;
    private static final Random RND = new Random();

    public static void main(String[] stringArray) {
        int n = 0;
        if (stringArray.length < 1) {
            HDBTest.usage();
        }
        if (stringArray[0].equals("write")) {
            n = HDBTest.runwrite(stringArray);
        } else if (stringArray[0].equals("read")) {
            n = HDBTest.runread(stringArray);
        } else if (stringArray[0].equals("remove")) {
            n = HDBTest.runremove(stringArray);
        } else if (stringArray[0].equals("misc")) {
            n = HDBTest.runmisc(stringArray);
        } else {
            HDBTest.usage();
        }
        System.gc();
        System.exit(n);
    }

    private static void usage() {
        STDERR.println("test cases of the hash database API");
        STDERR.println("");
        STDERR.println("synopsis:");
        STDERR.println("  java " + HDBTest.class.getName() + " arguments...");
        STDERR.println("");
        STDERR.println("arguments:");
        STDERR.println("  tchtest.rb write [-tl] [-td|-tb] [-nl|-nb] [-as] path rnum [bnum [apow [fpow]]]");
        STDERR.println("  tchtest.rb read [-nl|-nb] path");
        STDERR.println("  tchtest.rb remove [-nl|-nb] path");
        STDERR.println("  tchtest.rb misc [-tl] [-td|-tb] [-nl|-nb] path rnum");
        STDERR.println("");
        System.exit(1);
    }

    private static void eprint(HDB hDB, String string) {
        String string2 = hDB.path();
        STDERR.println(HDBTest.class.getName() + ": " + string2 + ": " + string + ": " + hDB.errmsg());
    }

    private static int runwrite(String[] stringArray) {
        int n;
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        int n2 = 0;
        int n3 = 0;
        boolean bl = false;
        for (n = 1; n < stringArray.length; ++n) {
            String string6 = stringArray[n];
            if (string == null && string6.startsWith("-")) {
                if (string6.equals("-tl")) {
                    n2 |= 1;
                    continue;
                }
                if (string6.equals("-td")) {
                    n2 |= 2;
                    continue;
                }
                if (string6.equals("-tb")) {
                    n2 |= 4;
                    continue;
                }
                if (string6.equals("-tt")) {
                    n2 |= 8;
                    continue;
                }
                if (string6.equals("-nl")) {
                    n3 |= 0x10;
                    continue;
                }
                if (string6.equals("-nb")) {
                    n3 |= 0x20;
                    continue;
                }
                if (string6.equals("-as")) {
                    bl = true;
                    continue;
                }
                HDBTest.usage();
                continue;
            }
            if (string == null) {
                string = string6;
                continue;
            }
            if (string2 == null) {
                string2 = string6;
                continue;
            }
            if (string3 == null) {
                string3 = string6;
                continue;
            }
            if (string4 == null) {
                string4 = string6;
                continue;
            }
            if (string5 == null) {
                string5 = string6;
                continue;
            }
            HDBTest.usage();
        }
        if (string == null || string2 == null) {
            HDBTest.usage();
        }
        if ((n = Util.atoi(string2)) < 1) {
            HDBTest.usage();
        }
        int n4 = string3 != null ? Util.atoi(string3) : -1;
        int n5 = string4 != null ? Util.atoi(string4) : -1;
        int n6 = string5 != null ? Util.atoi(string5) : -1;
        int n7 = HDBTest.procwrite(string, n, n4, n5, n6, n2, n3, bl);
        return n7;
    }

    private static int runread(String[] stringArray) {
        int n;
        String string = null;
        int n2 = 0;
        for (n = 1; n < stringArray.length; ++n) {
            String string2 = stringArray[n];
            if (string == null && string2.startsWith("-")) {
                if (string2.equals("-nl")) {
                    n2 |= 0x10;
                    continue;
                }
                if (string2.equals("-nb")) {
                    n2 |= 0x20;
                    continue;
                }
                HDBTest.usage();
                continue;
            }
            if (string == null) {
                string = string2;
                continue;
            }
            HDBTest.usage();
        }
        if (string == null) {
            HDBTest.usage();
        }
        n = HDBTest.procread(string, n2);
        return n;
    }

    private static int runremove(String[] stringArray) {
        int n;
        String string = null;
        int n2 = 0;
        for (n = 1; n < stringArray.length; ++n) {
            String string2 = stringArray[n];
            if (string == null && string2.startsWith("-")) {
                if (string2.equals("-nl")) {
                    n2 |= 0x10;
                    continue;
                }
                if (string2.equals("-nb")) {
                    n2 |= 0x20;
                    continue;
                }
                HDBTest.usage();
                continue;
            }
            if (string == null) {
                string = string2;
                continue;
            }
            HDBTest.usage();
        }
        if (string == null) {
            HDBTest.usage();
        }
        n = HDBTest.procremove(string, n2);
        return n;
    }

    private static int runmisc(String[] stringArray) {
        int n;
        String string = null;
        String string2 = null;
        int n2 = 0;
        int n3 = 0;
        for (n = 1; n < stringArray.length; ++n) {
            String string3 = stringArray[n];
            if (string == null && string3.startsWith("-")) {
                if (string3.equals("-tl")) {
                    n2 |= 1;
                    continue;
                }
                if (string3.equals("-td")) {
                    n2 |= 2;
                    continue;
                }
                if (string3.equals("-tb")) {
                    n2 |= 4;
                    continue;
                }
                if (string3.equals("-tt")) {
                    n2 |= 8;
                    continue;
                }
                if (string3.equals("-nl")) {
                    n3 |= 0x10;
                    continue;
                }
                if (string3.equals("-nb")) {
                    n3 |= 0x20;
                    continue;
                }
                HDBTest.usage();
                continue;
            }
            if (string == null) {
                string = string3;
                continue;
            }
            if (string2 == null) {
                string2 = string3;
                continue;
            }
            HDBTest.usage();
        }
        if (string == null || string2 == null) {
            HDBTest.usage();
        }
        if ((n = Util.atoi(string2)) < 1) {
            HDBTest.usage();
        }
        int n4 = HDBTest.procmisc(string, n, n2, n3);
        return n4;
    }

    private static int procwrite(String string, int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        STDOUT.println("<Writing Test>");
        STDOUT.println("  path=" + string + "  rnum=" + n + "  bnum=" + n2 + "  apow=" + n3 + "  fpow=" + n4 + "  opts=" + n5 + "  omode=" + n6 + "  as=" + bl);
        STDOUT.println("");
        boolean bl2 = false;
        double d = Util.time();
        HDB hDB = new HDB();
        if (!hDB.tune(n2, n3, n4, n5)) {
            HDBTest.eprint(hDB, "tune");
            bl2 = true;
        }
        if (!hDB.open(string, 0xE | n6)) {
            HDBTest.eprint(hDB, "open");
            bl2 = true;
        }
        for (int i = 1; i <= n; ++i) {
            String string2 = Util.itoa(i, 8, '0');
            if (bl) {
                if (!hDB.putasync(string2, string2)) {
                    HDBTest.eprint(hDB, "putasync");
                    bl2 = true;
                    break;
                }
            } else if (!hDB.put(string2, string2)) {
                HDBTest.eprint(hDB, "put");
                bl2 = true;
                break;
            }
            if (n <= 250 || i % (n / 250) != 0) continue;
            STDOUT.print('.');
            if (i != n && i % (n / 10) != 0) continue;
            STDOUT.println(" (" + string2 + ")");
        }
        STDOUT.println("record number: " + hDB.rnum());
        STDOUT.println("size: " + hDB.fsiz());
        if (!hDB.close()) {
            HDBTest.eprint(hDB, "close");
            bl2 = true;
        }
        STDOUT.println("time: " + (Util.time() - d));
        STDOUT.println(bl2 ? "error" : "ok");
        STDOUT.println("");
        return bl2 ? 1 : 0;
    }

    private static int procread(String string, int n) {
        STDOUT.println("<Reading Test>");
        STDOUT.println("  path=" + string + "  omode=" + n);
        STDOUT.println("");
        boolean bl = false;
        double d = Util.time();
        HDB hDB = new HDB();
        if (!hDB.open(string, 1 | n)) {
            HDBTest.eprint(hDB, "open");
            bl = true;
        }
        int n2 = (int)hDB.rnum();
        for (int i = 1; i <= n2; ++i) {
            String string2 = Util.itoa(i, 8, '0');
            if (hDB.get(string2) == null) {
                HDBTest.eprint(hDB, "get");
                bl = true;
                break;
            }
            if (n2 <= 250 || i % (n2 / 250) != 0) continue;
            STDOUT.print('.');
            if (i != n2 && i % (n2 / 10) != 0) continue;
            STDOUT.println(" (" + string2 + ")");
        }
        STDOUT.println("record number: " + hDB.rnum());
        STDOUT.println("size: " + hDB.fsiz());
        if (!hDB.close()) {
            HDBTest.eprint(hDB, "close");
            bl = true;
        }
        STDOUT.println("time: " + (Util.time() - d));
        STDOUT.println(bl ? "error" : "ok");
        STDOUT.println("");
        return bl ? 1 : 0;
    }

    private static int procremove(String string, int n) {
        STDOUT.println("<Removing Test>");
        STDOUT.println("  path=" + string + "  omode=" + n);
        STDOUT.println("");
        boolean bl = false;
        double d = Util.time();
        HDB hDB = new HDB();
        if (!hDB.open(string, 2 | n)) {
            HDBTest.eprint(hDB, "open");
            bl = true;
        }
        int n2 = (int)hDB.rnum();
        for (int i = 1; i <= n2; ++i) {
            String string2 = Util.itoa(i, 8, '0');
            if (!hDB.out(string2)) {
                HDBTest.eprint(hDB, "out");
                bl = true;
                break;
            }
            if (n2 <= 250 || i % (n2 / 250) != 0) continue;
            STDOUT.print('.');
            if (i != n2 && i % (n2 / 10) != 0) continue;
            STDOUT.println(" (" + string2 + ")");
        }
        STDOUT.println("record number: " + hDB.rnum());
        STDOUT.println("size: " + hDB.fsiz());
        if (!hDB.close()) {
            HDBTest.eprint(hDB, "close");
            bl = true;
        }
        STDOUT.println("time: " + (Util.time() - d));
        STDOUT.println(bl ? "error" : "ok");
        STDOUT.println("");
        return bl ? 1 : 0;
    }

    private static int procmisc(String string, int n, int n2, int n3) {
        String string2;
        Object object;
        String string3;
        int n4;
        STDOUT.println("<Miscellaneous Test>");
        STDOUT.println("  path=" + string + "  rnum=" + n + "  opts=" + n2 + "  omode=" + n3);
        STDOUT.println("");
        boolean bl = false;
        double d = Util.time();
        HDB hDB = new HDB();
        if (!hDB.tune(n / 50, 2, -1, n2)) {
            HDBTest.eprint(hDB, "tune");
            bl = true;
        }
        if (!hDB.setcache(n / 10)) {
            HDBTest.eprint(hDB, "setcache");
            bl = true;
        }
        if (!hDB.setxmsiz(n * 4)) {
            HDBTest.eprint(hDB, "setxmsiz");
            bl = true;
        }
        if (!hDB.setdfunit(8)) {
            HDBTest.eprint(hDB, "setdfunit");
            bl = true;
        }
        if (!hDB.open(string, 0xE | n3)) {
            HDBTest.eprint(hDB, "open");
            bl = true;
        }
        STDOUT.println("writing:");
        for (n4 = 1; n4 <= n; ++n4) {
            string3 = Util.itoa(n4, 8, '0');
            if (!hDB.put(string3, string3)) {
                HDBTest.eprint(hDB, "put");
                bl = true;
                break;
            }
            if (n <= 250 || n4 % (n / 250) != 0) continue;
            STDOUT.print('.');
            if (n4 != n && n4 % (n / 10) != 0) continue;
            STDOUT.println(" (" + string3 + ")");
        }
        STDOUT.println("reading:");
        for (n4 = 1; n4 <= n; ++n4) {
            string3 = Util.itoa(n4, 8, '0');
            if (hDB.get(string3) == null) {
                HDBTest.eprint(hDB, "get");
                bl = true;
                break;
            }
            if (n <= 250 || n4 % (n / 250) != 0) continue;
            STDOUT.print('.');
            if (n4 != n && n4 % (n / 10) != 0) continue;
            STDOUT.println(" (" + string3 + ")");
        }
        STDOUT.println("removing:");
        for (n4 = 1; n4 <= n; ++n4) {
            string3 = Util.itoa(n4, 8, '0');
            if (RND.nextInt(2) == 0 && !hDB.out(string3)) {
                HDBTest.eprint(hDB, "get");
                bl = true;
                break;
            }
            if (n <= 250 || n4 % (n / 250) != 0) continue;
            STDOUT.print('.');
            if (n4 != n && n4 % (n / 10) != 0) continue;
            STDOUT.println(" (" + string3 + ")");
        }
        STDOUT.println("checking iterator:");
        if (!hDB.iterinit()) {
            HDBTest.eprint(hDB, "iterinit");
            bl = true;
        }
        n4 = 0;
        while ((string3 = hDB.iternext2()) != null) {
            object = hDB.get(string3);
            if (object == null) {
                HDBTest.eprint(hDB, "get");
                bl = true;
            }
            if (n4 > 0 && n > 250 && n4 % (n / 250) == 0) {
                STDOUT.print('.');
                if (n4 == n || n4 % (n / 10) == 0) {
                    STDOUT.println(" (" + Util.itoa(n4, 8, '0') + ")");
                }
            }
            ++n4;
        }
        if (n > 250) {
            STDOUT.println(" (" + Util.itoa(n4, 8, '0') + ")");
        }
        if (hDB.ecode() != 22 || (long)n4 != hDB.rnum()) {
            HDBTest.eprint(hDB, "(validation)");
            bl = true;
        }
        object = hDB.fwmkeys("0", 10);
        if (hDB.rnum() >= 10L && object.size() != 10) {
            HDBTest.eprint(hDB, "fwmkeys");
            bl = true;
        }
        STDOUT.println("checking counting:");
        for (int i = 1; i <= n; ++i) {
            String string4 = "[" + RND.nextInt(n) + "]";
            if (RND.nextInt(2) == 0) {
                if (hDB.addint(string4, 1) == Integer.MIN_VALUE && hDB.ecode() != 21) {
                    HDBTest.eprint(hDB, "addint");
                    bl = true;
                    break;
                }
            } else if (hDB.adddouble(string4, 1.0) == -2.147483648E9 && hDB.ecode() != 21) {
                HDBTest.eprint(hDB, "adddouble");
                bl = true;
                break;
            }
            if (n <= 250 || i % (n / 250) != 0) continue;
            STDOUT.print('.');
            if (i != n && i % (n / 10) != 0) continue;
            STDOUT.println(" (" + Util.itoa(i, 8, '0') + ")");
        }
        if (!hDB.sync()) {
            HDBTest.eprint(hDB, "sync");
            bl = true;
        }
        if (!hDB.optimize()) {
            HDBTest.eprint(hDB, "optimize");
            bl = true;
        }
        if (!hDB.copy(string2 = string + "-tmp")) {
            HDBTest.eprint(hDB, "copy");
            bl = true;
        }
        new File(string2).delete();
        if (!hDB.vanish()) {
            HDBTest.eprint(hDB, "vanish");
            bl = true;
        }
        STDOUT.println("checking transaction commit:");
        if (!hDB.tranbegin()) {
            HDBTest.eprint(hDB, "tranbegin");
            bl = true;
        }
        for (int i = 1; i <= n; ++i) {
            String string5 = i + "";
            if (RND.nextInt(2) == 0) {
                if (!hDB.putcat(string5, string5)) {
                    HDBTest.eprint(hDB, "putcat");
                    bl = true;
                    break;
                }
            } else if (!hDB.out(string5) && hDB.ecode() != 22) {
                HDBTest.eprint(hDB, "out");
                bl = true;
                break;
            }
            if (n <= 250 || i % (n / 250) != 0) continue;
            STDOUT.print('.');
            if (i != n && i % (n / 10) != 0) continue;
            STDOUT.println(" (" + Util.itoa(i, 8, '0') + ")");
        }
        if (!hDB.trancommit()) {
            HDBTest.eprint(hDB, "trancommit");
            bl = true;
        }
        STDOUT.println("checking transaction abort:");
        long l = hDB.rnum();
        long l2 = hDB.fsiz();
        if (!hDB.tranbegin()) {
            HDBTest.eprint(hDB, "tranbegin");
            bl = true;
        }
        for (int i = 1; i <= n; ++i) {
            String string6 = i + "";
            if (RND.nextInt(2) == 0) {
                if (!hDB.putcat(string6, string6)) {
                    HDBTest.eprint(hDB, "putcat");
                    bl = true;
                    break;
                }
            } else if (!hDB.out(string6) && hDB.ecode() != 22) {
                HDBTest.eprint(hDB, "out");
                bl = true;
                break;
            }
            if (n <= 250 || i % (n / 250) != 0) continue;
            STDOUT.print('.');
            if (i != n && i % (n / 10) != 0) continue;
            STDOUT.println(" (" + Util.itoa(i, 8, '0') + ")");
        }
        if (!hDB.tranabort()) {
            HDBTest.eprint(hDB, "trancommit");
            bl = true;
        }
        if (hDB.rnum() != l || hDB.fsiz() != l2) {
            HDBTest.eprint(hDB, "(validation)");
            bl = true;
        }
        STDOUT.println("checking common interface:");
        HDB hDB2 = hDB;
        for (int i = 1; i <= n; ++i) {
            String string7 = "[" + Util.itoa(RND.nextInt(n), 8, '0') + "]";
            int n5 = RND.nextInt(3);
            if (n5 == 0) {
                hDB2.put(string7, string7);
            } else if (n5 == 1) {
                hDB2.get(string7);
            } else {
                hDB2.out(string7);
            }
            if (n <= 250 || i % (n / 250) != 0) continue;
            STDOUT.print('.');
            if (i != n && i % (n / 10) != 0) continue;
            STDOUT.println(" (" + Util.itoa(i, 8, '0') + ")");
        }
        STDOUT.println("checking iterator:");
        n4 = 0;
        if (!hDB2.iterinit()) {
            HDBTest.eprint(hDB, "iterinit");
            bl = true;
        }
        while ((string3 = hDB2.iternext2()) != null) {
            String string8 = hDB2.get(string3);
            if (string8 == null) {
                HDBTest.eprint(hDB, "get");
                bl = true;
            }
            if (n4 > 0 && n > 250 && n4 % (n / 250) == 0) {
                STDOUT.print('.');
                if (n4 == n || n4 % (n / 10) == 0) {
                    STDOUT.println(" (" + Util.itoa(n4, 8, '0') + ")");
                }
            }
            ++n4;
        }
        if (n > 250) {
            STDOUT.println(" (" + Util.itoa(n4, 8, '0') + ")");
        }
        STDOUT.println("record number: " + hDB.rnum());
        STDOUT.println("size: " + hDB.fsiz());
        if (!hDB.close()) {
            HDBTest.eprint(hDB, "close");
            bl = true;
        }
        STDOUT.println("time: " + (Util.time() - d));
        STDOUT.println(bl ? "error" : "ok");
        STDOUT.println("");
        return bl ? 1 : 0;
    }

    private HDBTest() throws NoSuchMethodException {
        throw new NoSuchMethodException();
    }
}

