/*
 * Decompiled with CFR 0.152.
 */
package jd.core.process.analyzer.classfile.visitor;

import java.util.List;
import jd.core.model.classfile.ClassFile;
import jd.core.model.classfile.ConstantPool;
import jd.core.model.classfile.Method;
import jd.core.model.classfile.constant.ConstantFieldref;
import jd.core.model.classfile.constant.ConstantMethodref;
import jd.core.model.classfile.constant.ConstantNameAndType;
import jd.core.model.instruction.bytecode.instruction.ANewArray;
import jd.core.model.instruction.bytecode.instruction.AThrow;
import jd.core.model.instruction.bytecode.instruction.ArrayLength;
import jd.core.model.instruction.bytecode.instruction.ArrayLoadInstruction;
import jd.core.model.instruction.bytecode.instruction.ArrayStoreInstruction;
import jd.core.model.instruction.bytecode.instruction.AssertInstruction;
import jd.core.model.instruction.bytecode.instruction.AssignmentInstruction;
import jd.core.model.instruction.bytecode.instruction.BinaryOperatorInstruction;
import jd.core.model.instruction.bytecode.instruction.CheckCast;
import jd.core.model.instruction.bytecode.instruction.ComplexConditionalBranchInstruction;
import jd.core.model.instruction.bytecode.instruction.ConvertInstruction;
import jd.core.model.instruction.bytecode.instruction.DupStore;
import jd.core.model.instruction.bytecode.instruction.GetField;
import jd.core.model.instruction.bytecode.instruction.GetStatic;
import jd.core.model.instruction.bytecode.instruction.IfCmp;
import jd.core.model.instruction.bytecode.instruction.IfInstruction;
import jd.core.model.instruction.bytecode.instruction.IncInstruction;
import jd.core.model.instruction.bytecode.instruction.InitArrayInstruction;
import jd.core.model.instruction.bytecode.instruction.InstanceOf;
import jd.core.model.instruction.bytecode.instruction.Instruction;
import jd.core.model.instruction.bytecode.instruction.InvokeInstruction;
import jd.core.model.instruction.bytecode.instruction.InvokeNoStaticInstruction;
import jd.core.model.instruction.bytecode.instruction.Invokestatic;
import jd.core.model.instruction.bytecode.instruction.LookupSwitch;
import jd.core.model.instruction.bytecode.instruction.MonitorEnter;
import jd.core.model.instruction.bytecode.instruction.MonitorExit;
import jd.core.model.instruction.bytecode.instruction.MultiANewArray;
import jd.core.model.instruction.bytecode.instruction.NewArray;
import jd.core.model.instruction.bytecode.instruction.Pop;
import jd.core.model.instruction.bytecode.instruction.PutField;
import jd.core.model.instruction.bytecode.instruction.PutStatic;
import jd.core.model.instruction.bytecode.instruction.ReturnInstruction;
import jd.core.model.instruction.bytecode.instruction.StoreInstruction;
import jd.core.model.instruction.bytecode.instruction.TableSwitch;
import jd.core.model.instruction.bytecode.instruction.TernaryOpStore;
import jd.core.model.instruction.bytecode.instruction.TernaryOperator;
import jd.core.model.instruction.bytecode.instruction.UnaryOperatorInstruction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReplaceOuterAccessorVisitor {
    protected ClassFile classFile;

    public ReplaceOuterAccessorVisitor(ClassFile classFile) {
        this.classFile = classFile;
    }

    public void visit(Instruction instruction) {
        switch (instruction.opcode) {
            case 190: {
                ArrayLength al = (ArrayLength)instruction;
                ClassFile matchedClassFile = this.match(al.arrayref);
                if (matchedClassFile != null) {
                    al.arrayref = this.newInstruction(matchedClassFile, al.arrayref);
                    break;
                }
                this.visit(al.arrayref);
                break;
            }
            case 83: 
            case 272: {
                ArrayStoreInstruction asi = (ArrayStoreInstruction)instruction;
                ClassFile matchedClassFile = this.match(asi.arrayref);
                if (matchedClassFile != null) {
                    asi.arrayref = this.newInstruction(matchedClassFile, asi.arrayref);
                } else {
                    this.visit(asi.arrayref);
                }
                matchedClassFile = this.match(asi.indexref);
                if (matchedClassFile != null) {
                    asi.indexref = this.newInstruction(matchedClassFile, asi.indexref);
                } else {
                    this.visit(asi.indexref);
                }
                matchedClassFile = this.match(asi.valueref);
                if (matchedClassFile != null) {
                    asi.valueref = this.newInstruction(matchedClassFile, asi.valueref);
                    break;
                }
                this.visit(asi.valueref);
                break;
            }
            case 286: {
                AssertInstruction ai = (AssertInstruction)instruction;
                ClassFile matchedClassFile = this.match(ai.test);
                if (matchedClassFile != null) {
                    ai.test = this.newInstruction(matchedClassFile, ai.test);
                } else {
                    this.visit(ai.test);
                }
                if (ai.msg == null) break;
                matchedClassFile = this.match(ai.msg);
                if (matchedClassFile != null) {
                    ai.msg = this.newInstruction(matchedClassFile, ai.msg);
                    break;
                }
                this.visit(ai.msg);
                break;
            }
            case 191: {
                AThrow aThrow = (AThrow)instruction;
                ClassFile matchedClassFile = this.match(aThrow.value);
                if (matchedClassFile != null) {
                    aThrow.value = this.newInstruction(matchedClassFile, aThrow.value);
                    break;
                }
                this.visit(aThrow.value);
                break;
            }
            case 266: {
                UnaryOperatorInstruction uoi = (UnaryOperatorInstruction)instruction;
                ClassFile matchedClassFile = this.match(uoi.value);
                if (matchedClassFile != null) {
                    uoi.value = this.newInstruction(matchedClassFile, uoi.value);
                    break;
                }
                this.visit(uoi.value);
                break;
            }
            case 267: {
                BinaryOperatorInstruction boi = (BinaryOperatorInstruction)instruction;
                ClassFile matchedClassFile = this.match(boi.value1);
                if (matchedClassFile != null) {
                    boi.value1 = this.newInstruction(matchedClassFile, boi.value1);
                } else {
                    this.visit(boi.value1);
                }
                matchedClassFile = this.match(boi.value2);
                if (matchedClassFile != null) {
                    boi.value2 = this.newInstruction(matchedClassFile, boi.value2);
                    break;
                }
                this.visit(boi.value2);
                break;
            }
            case 192: {
                CheckCast checkCast = (CheckCast)instruction;
                ClassFile matchedClassFile = this.match(checkCast.objectref);
                if (matchedClassFile != null) {
                    checkCast.objectref = this.newInstruction(matchedClassFile, checkCast.objectref);
                    break;
                }
                this.visit(checkCast.objectref);
                break;
            }
            case 54: 
            case 58: 
            case 269: {
                StoreInstruction storeInstruction = (StoreInstruction)instruction;
                ClassFile matchedClassFile = this.match(storeInstruction.valueref);
                if (matchedClassFile != null) {
                    storeInstruction.valueref = this.newInstruction(matchedClassFile, storeInstruction.valueref);
                    break;
                }
                this.visit(storeInstruction.valueref);
                break;
            }
            case 264: {
                DupStore dupStore = (DupStore)instruction;
                ClassFile matchedClassFile = this.match(dupStore.objectref);
                if (matchedClassFile != null) {
                    dupStore.objectref = this.newInstruction(matchedClassFile, dupStore.objectref);
                    break;
                }
                this.visit(dupStore.objectref);
                break;
            }
            case 275: 
            case 276: {
                ConvertInstruction ci = (ConvertInstruction)instruction;
                ClassFile matchedClassFile = this.match(ci.value);
                if (matchedClassFile != null) {
                    ci.value = this.newInstruction(matchedClassFile, ci.value);
                    break;
                }
                this.visit(ci.value);
                break;
            }
            case 261: {
                IfCmp ifCmp = (IfCmp)instruction;
                ClassFile matchedClassFile = this.match(ifCmp.value1);
                if (matchedClassFile != null) {
                    ifCmp.value1 = this.newInstruction(matchedClassFile, ifCmp.value1);
                } else {
                    this.visit(ifCmp.value1);
                }
                matchedClassFile = this.match(ifCmp.value2);
                if (matchedClassFile != null) {
                    ifCmp.value2 = this.newInstruction(matchedClassFile, ifCmp.value2);
                    break;
                }
                this.visit(ifCmp.value2);
                break;
            }
            case 260: 
            case 262: {
                IfInstruction iff = (IfInstruction)instruction;
                ClassFile matchedClassFile = this.match(iff.value);
                if (matchedClassFile != null) {
                    iff.value = this.newInstruction(matchedClassFile, iff.value);
                    break;
                }
                this.visit(iff.value);
                break;
            }
            case 284: {
                List<Instruction> branchList = ((ComplexConditionalBranchInstruction)instruction).instructions;
                int i = branchList.size() - 1;
                while (i >= 0) {
                    this.visit(branchList.get(i));
                    --i;
                }
                break;
            }
            case 193: {
                InstanceOf instanceOf = (InstanceOf)instruction;
                ClassFile matchedClassFile = this.match(instanceOf.objectref);
                if (matchedClassFile != null) {
                    instanceOf.objectref = this.newInstruction(matchedClassFile, instanceOf.objectref);
                    break;
                }
                this.visit(instanceOf.objectref);
                break;
            }
            case 182: 
            case 183: 
            case 185: {
                InvokeNoStaticInstruction insi = (InvokeNoStaticInstruction)instruction;
                ClassFile matchedClassFile = this.match(insi.objectref);
                if (matchedClassFile != null) {
                    insi.objectref = this.newInstruction(matchedClassFile, insi.objectref);
                } else {
                    this.visit(insi.objectref);
                }
            }
            case 184: 
            case 274: {
                List<Instruction> list = ((InvokeInstruction)instruction).args;
                int i = list.size() - 1;
                while (i >= 0) {
                    ClassFile matchedClassFile = this.match(list.get(i));
                    if (matchedClassFile != null) {
                        list.set(i, this.newInstruction(matchedClassFile, list.get(i)));
                    } else {
                        this.visit(list.get(i));
                    }
                    --i;
                }
                break;
            }
            case 171: {
                LookupSwitch ls = (LookupSwitch)instruction;
                ClassFile matchedClassFile = this.match(ls.key);
                if (matchedClassFile != null) {
                    ls.key = this.newInstruction(matchedClassFile, ls.key);
                    break;
                }
                this.visit(ls.key);
                break;
            }
            case 194: {
                MonitorEnter monitorEnter = (MonitorEnter)instruction;
                ClassFile matchedClassFile = this.match(monitorEnter.objectref);
                if (matchedClassFile != null) {
                    monitorEnter.objectref = this.newInstruction(matchedClassFile, monitorEnter.objectref);
                    break;
                }
                this.visit(monitorEnter.objectref);
                break;
            }
            case 195: {
                MonitorExit monitorExit = (MonitorExit)instruction;
                ClassFile matchedClassFile = this.match(monitorExit.objectref);
                if (matchedClassFile != null) {
                    monitorExit.objectref = this.newInstruction(matchedClassFile, monitorExit.objectref);
                    break;
                }
                this.visit(monitorExit.objectref);
                break;
            }
            case 197: {
                Instruction[] dimensions = ((MultiANewArray)instruction).dimensions;
                int i = dimensions.length - 1;
                while (i >= 0) {
                    ClassFile matchedClassFile = this.match(dimensions[i]);
                    if (matchedClassFile != null) {
                        dimensions[i] = this.newInstruction(matchedClassFile, dimensions[i]);
                    } else {
                        this.visit(dimensions[i]);
                    }
                    --i;
                }
                break;
            }
            case 188: {
                NewArray newArray = (NewArray)instruction;
                ClassFile matchedClassFile = this.match(newArray.dimension);
                if (matchedClassFile != null) {
                    newArray.dimension = this.newInstruction(matchedClassFile, newArray.dimension);
                    break;
                }
                this.visit(newArray.dimension);
                break;
            }
            case 189: {
                ANewArray aNewArray = (ANewArray)instruction;
                ClassFile matchedClassFile = this.match(aNewArray.dimension);
                if (matchedClassFile != null) {
                    aNewArray.dimension = this.newInstruction(matchedClassFile, aNewArray.dimension);
                    break;
                }
                this.visit(aNewArray.dimension);
                break;
            }
            case 87: {
                Pop pop = (Pop)instruction;
                ClassFile matchedClassFile = this.match(pop.objectref);
                if (matchedClassFile != null) {
                    pop.objectref = this.newInstruction(matchedClassFile, pop.objectref);
                    break;
                }
                this.visit(pop.objectref);
                break;
            }
            case 181: {
                PutField putField = (PutField)instruction;
                ClassFile matchedClassFile = this.match(putField.objectref);
                if (matchedClassFile != null) {
                    putField.objectref = this.newInstruction(matchedClassFile, putField.objectref);
                } else {
                    this.visit(putField.objectref);
                }
                matchedClassFile = this.match(putField.valueref);
                if (matchedClassFile != null) {
                    putField.valueref = this.newInstruction(matchedClassFile, putField.valueref);
                    break;
                }
                this.visit(putField.valueref);
                break;
            }
            case 179: {
                PutStatic putStatic = (PutStatic)instruction;
                ClassFile matchedClassFile = this.match(putStatic.valueref);
                if (matchedClassFile != null) {
                    putStatic.valueref = this.newInstruction(matchedClassFile, putStatic.valueref);
                    break;
                }
                this.visit(putStatic.valueref);
                break;
            }
            case 273: {
                ReturnInstruction ri = (ReturnInstruction)instruction;
                ClassFile matchedClassFile = this.match(ri.valueref);
                if (matchedClassFile != null) {
                    ri.valueref = this.newInstruction(matchedClassFile, ri.valueref);
                    break;
                }
                this.visit(ri.valueref);
                break;
            }
            case 170: {
                TableSwitch ts = (TableSwitch)instruction;
                ClassFile matchedClassFile = this.match(ts.key);
                if (matchedClassFile != null) {
                    ts.key = this.newInstruction(matchedClassFile, ts.key);
                    break;
                }
                this.visit(ts.key);
                break;
            }
            case 280: {
                TernaryOpStore tos = (TernaryOpStore)instruction;
                ClassFile matchedClassFile = this.match(tos.objectref);
                if (matchedClassFile != null) {
                    tos.objectref = this.newInstruction(matchedClassFile, tos.objectref);
                    break;
                }
                this.visit(tos.objectref);
                break;
            }
            case 281: {
                TernaryOperator to = (TernaryOperator)instruction;
                ClassFile matchedClassFile = this.match(to.test);
                if (matchedClassFile != null) {
                    to.test = this.newInstruction(matchedClassFile, to.test);
                } else {
                    this.visit(to.test);
                }
                matchedClassFile = this.match(to.value1);
                if (matchedClassFile != null) {
                    to.value1 = this.newInstruction(matchedClassFile, to.value1);
                } else {
                    this.visit(to.value1);
                }
                matchedClassFile = this.match(to.value2);
                if (matchedClassFile != null) {
                    to.value2 = this.newInstruction(matchedClassFile, to.value2);
                    break;
                }
                this.visit(to.value2);
                break;
            }
            case 265: {
                AssignmentInstruction ai = (AssignmentInstruction)instruction;
                ClassFile matchedClassFile = this.match(ai.value1);
                if (matchedClassFile != null) {
                    ai.value1 = this.newInstruction(matchedClassFile, ai.value1);
                } else {
                    this.visit(ai.value1);
                }
                matchedClassFile = this.match(ai.value2);
                if (matchedClassFile != null) {
                    ai.value2 = this.newInstruction(matchedClassFile, ai.value2);
                    break;
                }
                this.visit(ai.value2);
                break;
            }
            case 271: {
                ArrayLoadInstruction ali = (ArrayLoadInstruction)instruction;
                ClassFile matchedClassFile = this.match(ali.arrayref);
                if (matchedClassFile != null) {
                    ali.arrayref = this.newInstruction(matchedClassFile, ali.arrayref);
                } else {
                    this.visit(ali.arrayref);
                }
                matchedClassFile = this.match(ali.indexref);
                if (matchedClassFile != null) {
                    ali.indexref = this.newInstruction(matchedClassFile, ali.indexref);
                    break;
                }
                this.visit(ali.indexref);
                break;
            }
            case 277: 
            case 278: {
                IncInstruction ii = (IncInstruction)instruction;
                ClassFile matchedClassFile = this.match(ii.value);
                if (matchedClassFile != null) {
                    ii.value = this.newInstruction(matchedClassFile, ii.value);
                    break;
                }
                this.visit(ii.value);
                break;
            }
            case 180: {
                GetField gf = (GetField)instruction;
                ClassFile matchedClassFile = this.match(gf.objectref);
                if (matchedClassFile != null) {
                    gf.objectref = this.newInstruction(matchedClassFile, gf.objectref);
                    break;
                }
                this.visit(gf.objectref);
                break;
            }
            case 282: 
            case 283: {
                InitArrayInstruction iai = (InitArrayInstruction)instruction;
                ClassFile matchedClassFile = this.match(iai.newArray);
                if (matchedClassFile != null) {
                    iai.newArray = this.newInstruction(matchedClassFile, iai.newArray);
                } else {
                    this.visit(iai.newArray);
                }
                if (iai.values == null) break;
                this.visit(iai.values);
                break;
            }
            case 0: 
            case 1: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 25: 
            case 132: 
            case 167: 
            case 168: 
            case 169: 
            case 177: 
            case 178: 
            case 187: 
            case 256: 
            case 257: 
            case 258: 
            case 259: 
            case 263: 
            case 268: 
            case 270: 
            case 279: 
            case 285: {
                break;
            }
            default: {
                System.err.println("Can not replace DupLoad in " + instruction.getClass().getName() + ", opcode=" + instruction.opcode);
            }
        }
    }

    public void visit(List<Instruction> instructions) {
        int index = instructions.size() - 1;
        while (index >= 0) {
            Instruction i = instructions.get(index);
            ClassFile matchedClassFile = this.match(i);
            if (matchedClassFile != null) {
                instructions.set(index, this.newInstruction(matchedClassFile, i));
            } else {
                this.visit(i);
            }
            --index;
        }
    }

    protected ClassFile match(Instruction instruction) {
        String methodDescriptor;
        if (instruction.opcode != 184) {
            return null;
        }
        Invokestatic is = (Invokestatic)instruction;
        if (is.args.size() != 1) {
            return null;
        }
        ClassFile matchedClassFile = this.innerMatch((Instruction)is.args.get(0));
        if (matchedClassFile == null || !matchedClassFile.isAInnerClass()) {
            return null;
        }
        ConstantPool constants = this.classFile.getConstantPool();
        ConstantMethodref cmr = constants.getConstantMethodref(is.index);
        String className = constants.getConstantClassName(cmr.class_index);
        if (!className.equals(matchedClassFile.getThisClassName())) {
            return null;
        }
        ConstantNameAndType cnat = constants.getConstantNameAndType(cmr.name_and_type_index);
        String methodName = constants.getConstantUtf8(cnat.name_index);
        Method method = matchedClassFile.getMethod(methodName, methodDescriptor = constants.getConstantUtf8(cnat.descriptor_index));
        if (method == null || (method.access_flags & 0x1008) != 4104) {
            return null;
        }
        ClassFile outerClassFile = matchedClassFile.getOuterClass();
        String returnedSignature = cmr.getReturnedSignature();
        if (!returnedSignature.equals(outerClassFile.getInternalClassName())) {
            return null;
        }
        return outerClassFile;
    }

    private ClassFile innerMatch(Instruction instruction) {
        switch (instruction.opcode) {
            case 285: {
                GetStatic gs = (GetStatic)instruction;
                ConstantPool constants = this.classFile.getConstantPool();
                ConstantFieldref cfr = constants.getConstantFieldref(gs.index);
                String className = constants.getConstantClassName(cfr.class_index);
                ClassFile outerClassFile = this.classFile.getOuterClass();
                if (outerClassFile == null || !className.equals(outerClassFile.getThisClassName())) {
                    return null;
                }
                ConstantNameAndType cnat = constants.getConstantNameAndType(cfr.name_and_type_index);
                String descriptor = constants.getConstantUtf8(cnat.descriptor_index);
                if (!descriptor.equals(outerClassFile.getInternalClassName())) {
                    return null;
                }
                return outerClassFile;
            }
            case 184: {
                return this.match(instruction);
            }
        }
        return null;
    }

    private Instruction newInstruction(ClassFile matchedClassFile, Instruction i) {
        String internalMatchedClassName = matchedClassFile.getInternalClassName();
        String matchedClassName = matchedClassFile.getThisClassName();
        ConstantPool constants = this.classFile.getConstantPool();
        int signatureIndex = constants.addConstantUtf8(matchedClassName);
        int classIndex = constants.addConstantClass(signatureIndex);
        int thisIndex = constants.thisLocalVariableNameIndex;
        int descriptorIndex = constants.addConstantUtf8(internalMatchedClassName);
        int nameAndTypeIndex = constants.addConstantNameAndType(thisIndex, descriptorIndex);
        int matchedThisFieldrefIndex = constants.addConstantFieldref(classIndex, nameAndTypeIndex);
        return new GetStatic(285, i.offset, i.lineNumber, matchedThisFieldrefIndex);
    }
}

