/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.spdy.frames;

import org.eclipse.jetty.spdy.frames.ControlFrame;
import org.eclipse.jetty.spdy.frames.ControlFrameType;
import org.eclipse.jetty.util.Fields;

public class SynStreamFrame
extends ControlFrame {
    private final int streamId;
    private final int associatedStreamId;
    private final byte priority;
    private final short slot;
    private final Fields headers;

    public SynStreamFrame(short version, byte flags, int streamId, int associatedStreamId, byte priority, short slot, Fields headers) {
        super(version, ControlFrameType.SYN_STREAM, flags);
        this.streamId = streamId;
        this.associatedStreamId = associatedStreamId;
        this.priority = priority;
        this.slot = slot;
        this.headers = headers;
    }

    public int getStreamId() {
        return this.streamId;
    }

    public int getAssociatedStreamId() {
        return this.associatedStreamId;
    }

    public byte getPriority() {
        return this.priority;
    }

    public short getSlot() {
        return this.slot;
    }

    public Fields getHeaders() {
        return this.headers;
    }

    public boolean isClose() {
        return (this.getFlags() & 1) == 1;
    }

    public boolean isUnidirectional() {
        return (this.getFlags() & 2) == 2;
    }

    @Override
    public String toString() {
        return String.format("%s stream=%d close=%b", super.toString(), this.getStreamId(), this.isClose());
    }
}

