/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.xmpp.extensions.rayo;

import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.jitsi.xmpp.extensions.DefaultPacketExtensionProvider;
import org.jitsi.xmpp.extensions.rayo.DialIq;
import org.jitsi.xmpp.extensions.rayo.EndExtension;
import org.jitsi.xmpp.extensions.rayo.HangUp;
import org.jitsi.xmpp.extensions.rayo.HeaderExtension;
import org.jitsi.xmpp.extensions.rayo.RayoIq;
import org.jitsi.xmpp.extensions.rayo.RefIq;
import org.jivesoftware.smack.packet.IqData;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.parsing.SmackParsingException;
import org.jivesoftware.smack.provider.IqProvider;
import org.jivesoftware.smack.provider.ProviderManager;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.jivesoftware.smack.xml.XmlPullParserException;

public class RayoIqProvider
extends IqProvider<RayoIq> {
    public static final String NAMESPACE = "urn:xmpp:rayo:1";

    public void registerRayoIQs() {
        ProviderManager.addIQProvider("dial", NAMESPACE, this);
        ProviderManager.addIQProvider("ref", NAMESPACE, this);
        ProviderManager.addIQProvider("hangup", NAMESPACE, this);
        ProviderManager.addExtensionProvider("end", NAMESPACE, new DefaultPacketExtensionProvider<EndExtension>(EndExtension.class));
        ProviderManager.addExtensionProvider("header", NAMESPACE, new DefaultPacketExtensionProvider<HeaderExtension>(HeaderExtension.class));
    }

    @Override
    public RayoIq parse(XmlPullParser parser2, int initialDepth, IqData data2, XmlEnvironment xmlEnvironment) throws XmlPullParserException, IOException, SmackParsingException {
        RayoIq iq;
        String namespace = parser2.getNamespace();
        if (!NAMESPACE.equals(namespace)) {
            return null;
        }
        String rootElement = parser2.getName();
        if ("dial".equals(rootElement)) {
            DialIq dial = new DialIq();
            iq = dial;
            String src = parser2.getAttributeValue("", "from");
            String dst = parser2.getAttributeValue("", "to");
            if (StringUtils.isEmpty(dst)) {
                return null;
            }
            dial.setSource(src);
            dial.setDestination(dst);
        } else if ("ref".equals(rootElement)) {
            RefIq ref = new RefIq();
            iq = ref;
            String uri = parser2.getAttributeValue("", "uri");
            if (StringUtils.isEmpty(uri)) {
                return null;
            }
            ref.setUri(uri);
        } else if ("hangup".equals(rootElement)) {
            iq = new HangUp();
        } else {
            return null;
        }
        boolean done = false;
        HeaderExtension header = null;
        while (!done) {
            switch (parser2.next()) {
                case END_ELEMENT: {
                    String name = parser2.getName();
                    if (rootElement.equals(name)) {
                        done = true;
                        break;
                    }
                    if (!"header".equals(name) || header == null) break;
                    iq.addExtension(header);
                    header = null;
                    break;
                }
                case START_ELEMENT: {
                    String name = parser2.getName();
                    if (!"header".equals(name)) break;
                    header = new HeaderExtension();
                    String nameAttr = parser2.getAttributeValue("", "name");
                    header.setName(nameAttr);
                    String valueAttr = parser2.getAttributeValue("", "value");
                    header.setValue(valueAttr);
                    break;
                }
            }
        }
        return iq;
    }
}

