/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.producer.internals;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.clients.RequestCompletionHandler;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.producer.internals.ProducerBatch;
import org.apache.kafka.clients.producer.internals.ProducerIdAndEpoch;
import org.apache.kafka.clients.producer.internals.TransactionalRequestResult;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.AuthenticationException;
import org.apache.kafka.common.errors.GroupAuthorizationException;
import org.apache.kafka.common.errors.TopicAuthorizationException;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.AddOffsetsToTxnRequest;
import org.apache.kafka.common.requests.AddOffsetsToTxnResponse;
import org.apache.kafka.common.requests.AddPartitionsToTxnRequest;
import org.apache.kafka.common.requests.AddPartitionsToTxnResponse;
import org.apache.kafka.common.requests.EndTxnRequest;
import org.apache.kafka.common.requests.EndTxnResponse;
import org.apache.kafka.common.requests.FindCoordinatorRequest;
import org.apache.kafka.common.requests.FindCoordinatorResponse;
import org.apache.kafka.common.requests.InitProducerIdRequest;
import org.apache.kafka.common.requests.InitProducerIdResponse;
import org.apache.kafka.common.requests.ProduceResponse;
import org.apache.kafka.common.requests.TransactionResult;
import org.apache.kafka.common.requests.TxnOffsetCommitRequest;
import org.apache.kafka.common.requests.TxnOffsetCommitResponse;
import org.apache.kafka.common.utils.LogContext;
import org.slf4j.Logger;

public class TransactionManager {
    private static final int NO_INFLIGHT_REQUEST_CORRELATION_ID = -1;
    private final Logger log;
    private final String transactionalId;
    private final int transactionTimeoutMs;
    private final Map<TopicPartition, Integer> nextSequence;
    private final Map<TopicPartition, Integer> lastAckedSequence;
    private final Set<TopicPartition> partitionsWithUnresolvedSequences;
    private final Map<TopicPartition, PriorityQueue<ProducerBatch>> inflightBatchesBySequence;
    private final Map<TopicPartition, Long> lastAckedOffset;
    private final PriorityQueue<TxnRequestHandler> pendingRequests;
    private final Set<TopicPartition> newPartitionsInTransaction;
    private final Set<TopicPartition> pendingPartitionsInTransaction;
    private final Set<TopicPartition> partitionsInTransaction;
    private final Map<TopicPartition, TxnOffsetCommitRequest.CommittedOffset> pendingTxnOffsetCommits;
    private final long retryBackoffMs;
    private static final long ADD_PARTITIONS_RETRY_BACKOFF_MS = 20L;
    private int inFlightRequestCorrelationId = -1;
    private Node transactionCoordinator;
    private Node consumerGroupCoordinator;
    private volatile State currentState = State.UNINITIALIZED;
    private volatile RuntimeException lastError = null;
    private volatile ProducerIdAndEpoch producerIdAndEpoch = new ProducerIdAndEpoch(-1L, -1);
    private volatile boolean transactionStarted = false;

    public TransactionManager(LogContext logContext, String transactionalId, int transactionTimeoutMs, long retryBackoffMs) {
        this.nextSequence = new HashMap<TopicPartition, Integer>();
        this.lastAckedSequence = new HashMap<TopicPartition, Integer>();
        this.transactionalId = transactionalId;
        this.log = logContext.logger(TransactionManager.class);
        this.transactionTimeoutMs = transactionTimeoutMs;
        this.transactionCoordinator = null;
        this.consumerGroupCoordinator = null;
        this.newPartitionsInTransaction = new HashSet<TopicPartition>();
        this.pendingPartitionsInTransaction = new HashSet<TopicPartition>();
        this.partitionsInTransaction = new HashSet<TopicPartition>();
        this.pendingTxnOffsetCommits = new HashMap<TopicPartition, TxnOffsetCommitRequest.CommittedOffset>();
        this.pendingRequests = new PriorityQueue<TxnRequestHandler>(10, new Comparator<TxnRequestHandler>(){

            @Override
            public int compare(TxnRequestHandler o1, TxnRequestHandler o2) {
                return Integer.compare(o1.priority().priority, o2.priority().priority);
            }
        });
        this.partitionsWithUnresolvedSequences = new HashSet<TopicPartition>();
        this.inflightBatchesBySequence = new HashMap<TopicPartition, PriorityQueue<ProducerBatch>>();
        this.lastAckedOffset = new HashMap<TopicPartition, Long>();
        this.retryBackoffMs = retryBackoffMs;
    }

    TransactionManager() {
        this(new LogContext(), null, 0, 100L);
    }

    public synchronized TransactionalRequestResult initializeTransactions() {
        this.ensureTransactional();
        this.transitionTo(State.INITIALIZING);
        this.setProducerIdAndEpoch(ProducerIdAndEpoch.NONE);
        this.nextSequence.clear();
        InitProducerIdRequest.Builder builder = new InitProducerIdRequest.Builder(this.transactionalId, this.transactionTimeoutMs);
        InitProducerIdHandler handler = new InitProducerIdHandler(builder);
        this.enqueueRequest(handler);
        return handler.result;
    }

    public synchronized void beginTransaction() {
        this.ensureTransactional();
        this.maybeFailWithError();
        this.transitionTo(State.IN_TRANSACTION);
    }

    public synchronized TransactionalRequestResult beginCommit() {
        this.ensureTransactional();
        this.maybeFailWithError();
        this.transitionTo(State.COMMITTING_TRANSACTION);
        return this.beginCompletingTransaction(TransactionResult.COMMIT);
    }

    public synchronized TransactionalRequestResult beginAbort() {
        this.ensureTransactional();
        if (this.currentState != State.ABORTABLE_ERROR) {
            this.maybeFailWithError();
        }
        this.transitionTo(State.ABORTING_TRANSACTION);
        this.newPartitionsInTransaction.clear();
        return this.beginCompletingTransaction(TransactionResult.ABORT);
    }

    private TransactionalRequestResult beginCompletingTransaction(TransactionResult transactionResult) {
        if (!this.newPartitionsInTransaction.isEmpty()) {
            this.enqueueRequest(this.addPartitionsToTransactionHandler());
        }
        EndTxnRequest.Builder builder = new EndTxnRequest.Builder(this.transactionalId, this.producerIdAndEpoch.producerId, this.producerIdAndEpoch.epoch, transactionResult);
        EndTxnHandler handler = new EndTxnHandler(builder);
        this.enqueueRequest(handler);
        return handler.result;
    }

    public synchronized TransactionalRequestResult sendOffsetsToTransaction(Map<TopicPartition, OffsetAndMetadata> offsets, String consumerGroupId) {
        this.ensureTransactional();
        this.maybeFailWithError();
        if (this.currentState != State.IN_TRANSACTION) {
            throw new KafkaException("Cannot send offsets to transaction either because the producer is not in an active transaction");
        }
        this.log.debug("Begin adding offsets {} for consumer group {} to transaction", offsets, (Object)consumerGroupId);
        AddOffsetsToTxnRequest.Builder builder = new AddOffsetsToTxnRequest.Builder(this.transactionalId, this.producerIdAndEpoch.producerId, this.producerIdAndEpoch.epoch, consumerGroupId);
        AddOffsetsToTxnHandler handler = new AddOffsetsToTxnHandler(builder, offsets);
        this.enqueueRequest(handler);
        return handler.result;
    }

    public synchronized void maybeAddPartitionToTransaction(TopicPartition topicPartition) {
        this.failIfNotReadyForSend();
        if (this.isPartitionAdded(topicPartition) || this.isPartitionPendingAdd(topicPartition)) {
            return;
        }
        this.log.debug("Begin adding new partition {} to transaction", (Object)topicPartition);
        this.newPartitionsInTransaction.add(topicPartition);
    }

    RuntimeException lastError() {
        return this.lastError;
    }

    public synchronized void failIfNotReadyForSend() {
        if (this.hasError()) {
            throw new KafkaException("Cannot perform send because at least one previous transactional or idempotent request has failed with errors.", this.lastError);
        }
        if (this.isTransactional()) {
            if (!this.hasProducerId()) {
                throw new IllegalStateException("Cannot perform a 'send' before completing a call to initTransactions when transactions are enabled.");
            }
            if (this.currentState != State.IN_TRANSACTION) {
                throw new IllegalStateException("Cannot call send in state " + (Object)((Object)this.currentState));
            }
        }
    }

    synchronized boolean isSendToPartitionAllowed(TopicPartition tp) {
        if (this.hasFatalError()) {
            return false;
        }
        return !this.isTransactional() || this.partitionsInTransaction.contains(tp);
    }

    public String transactionalId() {
        return this.transactionalId;
    }

    public boolean hasProducerId() {
        return this.producerIdAndEpoch.isValid();
    }

    public boolean isTransactional() {
        return this.transactionalId != null;
    }

    synchronized boolean hasPartitionsToAdd() {
        return !this.newPartitionsInTransaction.isEmpty() || !this.pendingPartitionsInTransaction.isEmpty();
    }

    synchronized boolean isCompleting() {
        return this.currentState == State.COMMITTING_TRANSACTION || this.currentState == State.ABORTING_TRANSACTION;
    }

    synchronized boolean hasError() {
        return this.currentState == State.ABORTABLE_ERROR || this.currentState == State.FATAL_ERROR;
    }

    synchronized boolean isAborting() {
        return this.currentState == State.ABORTING_TRANSACTION;
    }

    synchronized void transitionToAbortableError(RuntimeException exception) {
        if (this.currentState == State.ABORTING_TRANSACTION) {
            this.log.debug("Skipping transition to abortable error state since the transaction is already being aborted. Underlying exception: ", (Throwable)exception);
            return;
        }
        this.transitionTo(State.ABORTABLE_ERROR, exception);
    }

    synchronized void transitionToFatalError(RuntimeException exception) {
        this.transitionTo(State.FATAL_ERROR, exception);
    }

    synchronized boolean isPartitionAdded(TopicPartition partition) {
        return this.partitionsInTransaction.contains(partition);
    }

    synchronized boolean isPartitionPendingAdd(TopicPartition partition) {
        return this.newPartitionsInTransaction.contains(partition) || this.pendingPartitionsInTransaction.contains(partition);
    }

    ProducerIdAndEpoch producerIdAndEpoch() {
        return this.producerIdAndEpoch;
    }

    boolean hasProducerId(long producerId) {
        return this.producerIdAndEpoch.producerId == producerId;
    }

    boolean hasProducerIdAndEpoch(long producerId, short producerEpoch) {
        ProducerIdAndEpoch idAndEpoch = this.producerIdAndEpoch;
        return idAndEpoch.producerId == producerId && idAndEpoch.epoch == producerEpoch;
    }

    void setProducerIdAndEpoch(ProducerIdAndEpoch producerIdAndEpoch) {
        this.log.info("ProducerId set to {} with epoch {}", (Object)producerIdAndEpoch.producerId, (Object)producerIdAndEpoch.epoch);
        this.producerIdAndEpoch = producerIdAndEpoch;
    }

    synchronized void resetProducerId() {
        if (this.isTransactional()) {
            throw new IllegalStateException("Cannot reset producer state for a transactional producer. You must either abort the ongoing transaction or reinitialize the transactional producer instead");
        }
        this.setProducerIdAndEpoch(ProducerIdAndEpoch.NONE);
        this.nextSequence.clear();
        this.lastAckedSequence.clear();
        this.inflightBatchesBySequence.clear();
        this.partitionsWithUnresolvedSequences.clear();
        this.lastAckedOffset.clear();
    }

    synchronized Integer sequenceNumber(TopicPartition topicPartition) {
        Integer currentSequenceNumber = this.nextSequence.get(topicPartition);
        if (currentSequenceNumber == null) {
            currentSequenceNumber = 0;
            this.nextSequence.put(topicPartition, currentSequenceNumber);
        }
        return currentSequenceNumber;
    }

    synchronized void incrementSequenceNumber(TopicPartition topicPartition, int increment) {
        Integer currentSequenceNumber = this.nextSequence.get(topicPartition);
        if (currentSequenceNumber == null) {
            throw new IllegalStateException("Attempt to increment sequence number for a partition with no current sequence.");
        }
        currentSequenceNumber = currentSequenceNumber + increment;
        this.nextSequence.put(topicPartition, currentSequenceNumber);
    }

    synchronized void addInFlightBatch(ProducerBatch batch) {
        if (!batch.hasSequence()) {
            throw new IllegalStateException("Can't track batch for partition " + batch.topicPartition + " when sequence is not set.");
        }
        if (!this.inflightBatchesBySequence.containsKey(batch.topicPartition)) {
            this.inflightBatchesBySequence.put(batch.topicPartition, new PriorityQueue<ProducerBatch>(5, new Comparator<ProducerBatch>(){

                @Override
                public int compare(ProducerBatch o1, ProducerBatch o2) {
                    return o1.baseSequence() - o2.baseSequence();
                }
            }));
        }
        this.inflightBatchesBySequence.get(batch.topicPartition).offer(batch);
    }

    synchronized int firstInFlightSequence(TopicPartition topicPartition) {
        PriorityQueue<ProducerBatch> inFlightBatches = this.inflightBatchesBySequence.get(topicPartition);
        if (inFlightBatches == null) {
            return -1;
        }
        ProducerBatch firstInFlightBatch = inFlightBatches.peek();
        if (firstInFlightBatch == null) {
            return -1;
        }
        return firstInFlightBatch.baseSequence();
    }

    synchronized ProducerBatch nextBatchBySequence(TopicPartition topicPartition) {
        PriorityQueue<ProducerBatch> queue = this.inflightBatchesBySequence.get(topicPartition);
        if (queue == null) {
            return null;
        }
        return queue.peek();
    }

    synchronized void removeInFlightBatch(ProducerBatch batch) {
        PriorityQueue<ProducerBatch> queue = this.inflightBatchesBySequence.get(batch.topicPartition);
        if (queue == null) {
            return;
        }
        queue.remove(batch);
    }

    synchronized void maybeUpdateLastAckedSequence(TopicPartition topicPartition, int sequence) {
        if (sequence > this.lastAckedSequence(topicPartition)) {
            this.lastAckedSequence.put(topicPartition, sequence);
        }
    }

    synchronized int lastAckedSequence(TopicPartition topicPartition) {
        Integer currentLastAckedSequence = this.lastAckedSequence.get(topicPartition);
        if (currentLastAckedSequence == null) {
            return -1;
        }
        return currentLastAckedSequence;
    }

    synchronized long lastAckedOffset(TopicPartition topicPartition) {
        Long offset = this.lastAckedOffset.get(topicPartition);
        if (offset == null) {
            return -1L;
        }
        return offset;
    }

    synchronized void updateLastAckedOffset(ProduceResponse.PartitionResponse response, ProducerBatch batch) {
        if (response.baseOffset == -1L) {
            return;
        }
        long lastOffset = response.baseOffset + (long)batch.recordCount - 1L;
        if (lastOffset > this.lastAckedOffset(batch.topicPartition)) {
            this.lastAckedOffset.put(batch.topicPartition, lastOffset);
        } else {
            this.log.trace("Partition {} keeps lastOffset at {}", (Object)batch.topicPartition, (Object)lastOffset);
        }
    }

    synchronized void adjustSequencesDueToFailedBatch(ProducerBatch batch) {
        if (!this.nextSequence.containsKey(batch.topicPartition)) {
            return;
        }
        this.log.debug("producerId: {}, send to partition {} failed fatally. Reducing future sequence numbers by {}", new Object[]{batch.producerId(), batch.topicPartition, batch.recordCount});
        int currentSequence = this.sequenceNumber(batch.topicPartition);
        if ((currentSequence -= batch.recordCount) < 0) {
            throw new IllegalStateException("Sequence number for partition " + batch.topicPartition + " is going to become negative : " + currentSequence);
        }
        this.setNextSequence(batch.topicPartition, currentSequence);
        for (ProducerBatch inFlightBatch : this.inflightBatchesBySequence.get(batch.topicPartition)) {
            if (inFlightBatch.baseSequence() < batch.baseSequence()) continue;
            int newSequence = inFlightBatch.baseSequence() - batch.recordCount;
            if (newSequence < 0) {
                throw new IllegalStateException("Sequence number for batch with sequence " + inFlightBatch.baseSequence() + " for partition " + batch.topicPartition + " is going to become negative :" + newSequence);
            }
            this.log.info("Resetting sequence number of batch with current sequence {} for partition {} to {}", new Object[]{inFlightBatch.baseSequence(), batch.topicPartition, newSequence});
            inFlightBatch.resetProducerState(new ProducerIdAndEpoch(inFlightBatch.producerId(), inFlightBatch.producerEpoch()), newSequence, inFlightBatch.isTransactional());
        }
    }

    private synchronized void startSequencesAtBeginning(TopicPartition topicPartition) {
        int sequence = 0;
        for (ProducerBatch inFlightBatch : this.inflightBatchesBySequence.get(topicPartition)) {
            this.log.info("Resetting sequence number of batch with current sequence {} for partition {} to {}", new Object[]{inFlightBatch.baseSequence(), inFlightBatch.topicPartition, sequence});
            inFlightBatch.resetProducerState(new ProducerIdAndEpoch(inFlightBatch.producerId(), inFlightBatch.producerEpoch()), sequence, inFlightBatch.isTransactional());
            sequence += inFlightBatch.recordCount;
        }
        this.setNextSequence(topicPartition, sequence);
        this.lastAckedSequence.remove(topicPartition);
    }

    synchronized boolean hasInflightBatches(TopicPartition topicPartition) {
        return this.inflightBatchesBySequence.containsKey(topicPartition) && !this.inflightBatchesBySequence.get(topicPartition).isEmpty();
    }

    synchronized boolean hasUnresolvedSequences() {
        return !this.partitionsWithUnresolvedSequences.isEmpty();
    }

    synchronized boolean hasUnresolvedSequence(TopicPartition topicPartition) {
        return this.partitionsWithUnresolvedSequences.contains(topicPartition);
    }

    synchronized void markSequenceUnresolved(TopicPartition topicPartition) {
        this.log.debug("Marking partition {} unresolved", (Object)topicPartition);
        this.partitionsWithUnresolvedSequences.add(topicPartition);
    }

    synchronized boolean shouldResetProducerStateAfterResolvingSequences() {
        if (this.isTransactional()) {
            return false;
        }
        Iterator<TopicPartition> iter = this.partitionsWithUnresolvedSequences.iterator();
        while (iter.hasNext()) {
            TopicPartition topicPartition = iter.next();
            if (this.hasInflightBatches(topicPartition)) continue;
            if (this.isNextSequence(topicPartition, this.sequenceNumber(topicPartition))) {
                iter.remove();
                continue;
            }
            this.log.info("No inflight batches remaining for {}, last ack'd sequence for partition is {}, next sequence is {}. Going to reset producer state.", new Object[]{topicPartition, this.lastAckedSequence(topicPartition), this.sequenceNumber(topicPartition)});
            return true;
        }
        return false;
    }

    synchronized boolean isNextSequence(TopicPartition topicPartition, int sequence) {
        return sequence - this.lastAckedSequence(topicPartition) == 1;
    }

    private synchronized void setNextSequence(TopicPartition topicPartition, int sequence) {
        if (!this.nextSequence.containsKey(topicPartition) && sequence != 0) {
            throw new IllegalStateException("Trying to set the sequence number for " + topicPartition + " to " + sequence + ", but the sequence number was never set for this partition.");
        }
        this.nextSequence.put(topicPartition, sequence);
    }

    synchronized TxnRequestHandler nextRequestHandler(boolean hasIncompleteBatches) {
        TxnRequestHandler nextRequestHandler;
        if (!this.newPartitionsInTransaction.isEmpty()) {
            this.enqueueRequest(this.addPartitionsToTransactionHandler());
        }
        if ((nextRequestHandler = this.pendingRequests.peek()) == null) {
            return null;
        }
        if (nextRequestHandler.isEndTxn() && hasIncompleteBatches) {
            return null;
        }
        this.pendingRequests.poll();
        if (this.maybeTerminateRequestWithError(nextRequestHandler)) {
            this.log.trace("Not sending transactional request {} because we are in an error state", nextRequestHandler.requestBuilder());
            return null;
        }
        if (nextRequestHandler.isEndTxn() && !this.transactionStarted) {
            nextRequestHandler.result.done();
            if (this.currentState != State.FATAL_ERROR) {
                this.log.debug("Not sending EndTxn for completed transaction since no partitions or offsets were successfully added");
                this.completeTransaction();
            }
            nextRequestHandler = this.pendingRequests.poll();
        }
        if (nextRequestHandler != null) {
            this.log.trace("Request {} dequeued for sending", nextRequestHandler.requestBuilder());
        }
        return nextRequestHandler;
    }

    synchronized void retry(TxnRequestHandler request) {
        request.setRetry();
        this.enqueueRequest(request);
    }

    synchronized void authenticationFailed(AuthenticationException e) {
        for (TxnRequestHandler request : this.pendingRequests) {
            request.fatalError(e);
        }
    }

    Node coordinator(FindCoordinatorRequest.CoordinatorType type) {
        switch (type) {
            case GROUP: {
                return this.consumerGroupCoordinator;
            }
            case TRANSACTION: {
                return this.transactionCoordinator;
            }
        }
        throw new IllegalStateException("Received an invalid coordinator type: " + (Object)((Object)type));
    }

    void lookupCoordinator(TxnRequestHandler request) {
        this.lookupCoordinator(request.coordinatorType(), request.coordinatorKey());
    }

    void setInFlightTransactionalRequestCorrelationId(int correlationId) {
        this.inFlightRequestCorrelationId = correlationId;
    }

    void clearInFlightTransactionalRequestCorrelationId() {
        this.inFlightRequestCorrelationId = -1;
    }

    boolean hasInFlightTransactionalRequest() {
        return this.inFlightRequestCorrelationId != -1;
    }

    boolean hasFatalError() {
        return this.currentState == State.FATAL_ERROR;
    }

    boolean hasAbortableError() {
        return this.currentState == State.ABORTABLE_ERROR;
    }

    synchronized boolean transactionContainsPartition(TopicPartition topicPartition) {
        return this.partitionsInTransaction.contains(topicPartition);
    }

    synchronized boolean hasPendingOffsetCommits() {
        return !this.pendingTxnOffsetCommits.isEmpty();
    }

    synchronized boolean hasOngoingTransaction() {
        return this.currentState == State.IN_TRANSACTION || this.isCompleting() || this.hasAbortableError();
    }

    synchronized boolean canRetry(ProduceResponse.PartitionResponse response, ProducerBatch batch) {
        if (!this.hasProducerId(batch.producerId())) {
            return false;
        }
        Errors error = response.error;
        if (!(error != Errors.OUT_OF_ORDER_SEQUENCE_NUMBER || this.hasUnresolvedSequence(batch.topicPartition) || !batch.sequenceHasBeenReset() && this.isNextSequence(batch.topicPartition, batch.baseSequence()))) {
            return true;
        }
        if (error == Errors.UNKNOWN_PRODUCER_ID) {
            if (response.logStartOffset == -1L) {
                return true;
            }
            if (batch.sequenceHasBeenReset()) {
                return true;
            }
            if (this.lastAckedOffset(batch.topicPartition) < response.logStartOffset) {
                this.startSequencesAtBeginning(batch.topicPartition);
                return true;
            }
        }
        return false;
    }

    synchronized boolean isReady() {
        return this.isTransactional() && this.currentState == State.READY;
    }

    private void transitionTo(State target) {
        this.transitionTo(target, null);
    }

    private synchronized void transitionTo(State target, RuntimeException error) {
        if (!this.currentState.isTransitionValid(this.currentState, target)) {
            String idString = this.transactionalId == null ? "" : "TransactionalId " + this.transactionalId + ": ";
            throw new KafkaException(idString + "Invalid transition attempted from state " + this.currentState.name() + " to state " + target.name());
        }
        if (target == State.FATAL_ERROR || target == State.ABORTABLE_ERROR) {
            if (error == null) {
                throw new IllegalArgumentException("Cannot transition to " + (Object)((Object)target) + " with an null exception");
            }
            this.lastError = error;
        } else {
            this.lastError = null;
        }
        if (this.lastError != null) {
            this.log.debug("Transition from state {} to error state {}", new Object[]{this.currentState, target, this.lastError});
        } else {
            this.log.debug("Transition from state {} to {}", (Object)this.currentState, (Object)target);
        }
        this.currentState = target;
    }

    private void ensureTransactional() {
        if (!this.isTransactional()) {
            throw new IllegalStateException("Transactional method invoked on a non-transactional producer.");
        }
    }

    private void maybeFailWithError() {
        if (this.hasError()) {
            throw new KafkaException("Cannot execute transactional method because we are in an error state", this.lastError);
        }
    }

    private boolean maybeTerminateRequestWithError(TxnRequestHandler requestHandler) {
        if (this.hasError()) {
            if (this.hasAbortableError() && requestHandler instanceof FindCoordinatorHandler) {
                return false;
            }
            requestHandler.fail(this.lastError);
            return true;
        }
        return false;
    }

    private void enqueueRequest(TxnRequestHandler requestHandler) {
        this.log.debug("Enqueuing transactional request {}", requestHandler.requestBuilder());
        this.pendingRequests.add(requestHandler);
    }

    private synchronized void lookupCoordinator(FindCoordinatorRequest.CoordinatorType type, String coordinatorKey) {
        switch (type) {
            case GROUP: {
                this.consumerGroupCoordinator = null;
                break;
            }
            case TRANSACTION: {
                this.transactionCoordinator = null;
                break;
            }
            default: {
                throw new IllegalStateException("Invalid coordinator type: " + (Object)((Object)type));
            }
        }
        FindCoordinatorRequest.Builder builder = new FindCoordinatorRequest.Builder(type, coordinatorKey);
        this.enqueueRequest(new FindCoordinatorHandler(builder));
    }

    private synchronized void completeTransaction() {
        this.transitionTo(State.READY);
        this.lastError = null;
        this.transactionStarted = false;
        this.newPartitionsInTransaction.clear();
        this.pendingPartitionsInTransaction.clear();
        this.partitionsInTransaction.clear();
    }

    private synchronized TxnRequestHandler addPartitionsToTransactionHandler() {
        this.pendingPartitionsInTransaction.addAll(this.newPartitionsInTransaction);
        this.newPartitionsInTransaction.clear();
        AddPartitionsToTxnRequest.Builder builder = new AddPartitionsToTxnRequest.Builder(this.transactionalId, this.producerIdAndEpoch.producerId, this.producerIdAndEpoch.epoch, new ArrayList<TopicPartition>(this.pendingPartitionsInTransaction));
        return new AddPartitionsToTxnHandler(builder);
    }

    private TxnOffsetCommitHandler txnOffsetCommitHandler(TransactionalRequestResult result, Map<TopicPartition, OffsetAndMetadata> offsets, String consumerGroupId) {
        for (Map.Entry<TopicPartition, OffsetAndMetadata> entry : offsets.entrySet()) {
            OffsetAndMetadata offsetAndMetadata = entry.getValue();
            TxnOffsetCommitRequest.CommittedOffset committedOffset = new TxnOffsetCommitRequest.CommittedOffset(offsetAndMetadata.offset(), offsetAndMetadata.metadata());
            this.pendingTxnOffsetCommits.put(entry.getKey(), committedOffset);
        }
        TxnOffsetCommitRequest.Builder builder = new TxnOffsetCommitRequest.Builder(this.transactionalId, consumerGroupId, this.producerIdAndEpoch.producerId, this.producerIdAndEpoch.epoch, this.pendingTxnOffsetCommits);
        return new TxnOffsetCommitHandler(result, builder);
    }

    private class TxnOffsetCommitHandler
    extends TxnRequestHandler {
        private final TxnOffsetCommitRequest.Builder builder;

        private TxnOffsetCommitHandler(TransactionalRequestResult result, TxnOffsetCommitRequest.Builder builder) {
            super(result);
            this.builder = builder;
        }

        TxnOffsetCommitRequest.Builder requestBuilder() {
            return this.builder;
        }

        @Override
        Priority priority() {
            return Priority.ADD_PARTITIONS_OR_OFFSETS;
        }

        @Override
        FindCoordinatorRequest.CoordinatorType coordinatorType() {
            return FindCoordinatorRequest.CoordinatorType.GROUP;
        }

        @Override
        String coordinatorKey() {
            return this.builder.consumerGroupId();
        }

        @Override
        public void handleResponse(AbstractResponse response) {
            TxnOffsetCommitResponse txnOffsetCommitResponse = (TxnOffsetCommitResponse)response;
            boolean coordinatorReloaded = false;
            boolean hadFailure = false;
            Map<TopicPartition, Errors> errors = txnOffsetCommitResponse.errors();
            for (Map.Entry<TopicPartition, Errors> entry : errors.entrySet()) {
                TopicPartition topicPartition = entry.getKey();
                Errors error = entry.getValue();
                if (error == Errors.NONE) {
                    TransactionManager.this.log.debug("Successfully added offsets {} from consumer group {} to transaction.", this.builder.offsets(), (Object)this.builder.consumerGroupId());
                    TransactionManager.this.pendingTxnOffsetCommits.remove(topicPartition);
                    continue;
                }
                if (error == Errors.COORDINATOR_NOT_AVAILABLE || error == Errors.NOT_COORDINATOR || error == Errors.REQUEST_TIMED_OUT) {
                    hadFailure = true;
                    if (coordinatorReloaded) continue;
                    coordinatorReloaded = true;
                    TransactionManager.this.lookupCoordinator(FindCoordinatorRequest.CoordinatorType.GROUP, this.builder.consumerGroupId());
                    continue;
                }
                if (error == Errors.UNKNOWN_TOPIC_OR_PARTITION) {
                    hadFailure = true;
                    continue;
                }
                if (error == Errors.GROUP_AUTHORIZATION_FAILED) {
                    this.abortableError(new GroupAuthorizationException(this.builder.consumerGroupId()));
                    return;
                }
                if (error == Errors.TRANSACTIONAL_ID_AUTHORIZATION_FAILED || error == Errors.INVALID_PRODUCER_EPOCH || error == Errors.UNSUPPORTED_FOR_MESSAGE_FORMAT) {
                    this.fatalError(error.exception());
                    return;
                }
                this.fatalError(new KafkaException("Unexpected error in TxnOffsetCommitResponse: " + error.message()));
                return;
            }
            if (!hadFailure || !this.result.isSuccessful()) {
                this.result.done();
                return;
            }
            if (!TransactionManager.this.pendingTxnOffsetCommits.isEmpty()) {
                this.reenqueue();
            }
        }
    }

    private class AddOffsetsToTxnHandler
    extends TxnRequestHandler {
        private final AddOffsetsToTxnRequest.Builder builder;
        private final Map<TopicPartition, OffsetAndMetadata> offsets;

        private AddOffsetsToTxnHandler(AddOffsetsToTxnRequest.Builder builder, Map<TopicPartition, OffsetAndMetadata> offsets) {
            this.builder = builder;
            this.offsets = offsets;
        }

        AddOffsetsToTxnRequest.Builder requestBuilder() {
            return this.builder;
        }

        @Override
        Priority priority() {
            return Priority.ADD_PARTITIONS_OR_OFFSETS;
        }

        @Override
        public void handleResponse(AbstractResponse response) {
            AddOffsetsToTxnResponse addOffsetsToTxnResponse = (AddOffsetsToTxnResponse)response;
            Errors error = addOffsetsToTxnResponse.error();
            if (error == Errors.NONE) {
                TransactionManager.this.log.debug("Successfully added partition for consumer group {} to transaction", (Object)this.builder.consumerGroupId());
                TransactionManager.this.pendingRequests.add(TransactionManager.this.txnOffsetCommitHandler(this.result, this.offsets, this.builder.consumerGroupId()));
                TransactionManager.this.transactionStarted = true;
            } else if (error == Errors.COORDINATOR_NOT_AVAILABLE || error == Errors.NOT_COORDINATOR) {
                TransactionManager.this.lookupCoordinator(FindCoordinatorRequest.CoordinatorType.TRANSACTION, TransactionManager.this.transactionalId);
                this.reenqueue();
            } else if (error == Errors.COORDINATOR_LOAD_IN_PROGRESS || error == Errors.CONCURRENT_TRANSACTIONS) {
                this.reenqueue();
            } else if (error == Errors.INVALID_PRODUCER_EPOCH) {
                this.fatalError(error.exception());
            } else if (error == Errors.TRANSACTIONAL_ID_AUTHORIZATION_FAILED) {
                this.fatalError(error.exception());
            } else if (error == Errors.GROUP_AUTHORIZATION_FAILED) {
                this.abortableError(new GroupAuthorizationException(this.builder.consumerGroupId()));
            } else {
                this.fatalError(new KafkaException("Unexpected error in AddOffsetsToTxnResponse: " + error.message()));
            }
        }
    }

    private class EndTxnHandler
    extends TxnRequestHandler {
        private final EndTxnRequest.Builder builder;

        private EndTxnHandler(EndTxnRequest.Builder builder) {
            this.builder = builder;
        }

        EndTxnRequest.Builder requestBuilder() {
            return this.builder;
        }

        @Override
        Priority priority() {
            return Priority.END_TXN;
        }

        @Override
        boolean isEndTxn() {
            return true;
        }

        @Override
        public void handleResponse(AbstractResponse response) {
            EndTxnResponse endTxnResponse = (EndTxnResponse)response;
            Errors error = endTxnResponse.error();
            if (error == Errors.NONE) {
                TransactionManager.this.completeTransaction();
                this.result.done();
            } else if (error == Errors.COORDINATOR_NOT_AVAILABLE || error == Errors.NOT_COORDINATOR) {
                TransactionManager.this.lookupCoordinator(FindCoordinatorRequest.CoordinatorType.TRANSACTION, TransactionManager.this.transactionalId);
                this.reenqueue();
            } else if (error == Errors.COORDINATOR_LOAD_IN_PROGRESS || error == Errors.CONCURRENT_TRANSACTIONS) {
                this.reenqueue();
            } else if (error == Errors.INVALID_PRODUCER_EPOCH) {
                this.fatalError(error.exception());
            } else if (error == Errors.TRANSACTIONAL_ID_AUTHORIZATION_FAILED) {
                this.fatalError(error.exception());
            } else if (error == Errors.INVALID_TXN_STATE) {
                this.fatalError(error.exception());
            } else {
                this.fatalError(new KafkaException("Unhandled error in EndTxnResponse: " + error.message()));
            }
        }
    }

    private class FindCoordinatorHandler
    extends TxnRequestHandler {
        private final FindCoordinatorRequest.Builder builder;

        private FindCoordinatorHandler(FindCoordinatorRequest.Builder builder) {
            this.builder = builder;
        }

        FindCoordinatorRequest.Builder requestBuilder() {
            return this.builder;
        }

        @Override
        Priority priority() {
            return Priority.FIND_COORDINATOR;
        }

        @Override
        FindCoordinatorRequest.CoordinatorType coordinatorType() {
            return null;
        }

        @Override
        String coordinatorKey() {
            return null;
        }

        @Override
        public void handleResponse(AbstractResponse response) {
            FindCoordinatorResponse findCoordinatorResponse = (FindCoordinatorResponse)response;
            Errors error = findCoordinatorResponse.error();
            if (error == Errors.NONE) {
                Node node = findCoordinatorResponse.node();
                switch (this.builder.coordinatorType()) {
                    case GROUP: {
                        TransactionManager.this.consumerGroupCoordinator = node;
                        break;
                    }
                    case TRANSACTION: {
                        TransactionManager.this.transactionCoordinator = node;
                    }
                }
                this.result.done();
            } else if (error == Errors.COORDINATOR_NOT_AVAILABLE) {
                this.reenqueue();
            } else if (error == Errors.TRANSACTIONAL_ID_AUTHORIZATION_FAILED) {
                this.fatalError(error.exception());
            } else if (findCoordinatorResponse.error() == Errors.GROUP_AUTHORIZATION_FAILED) {
                this.abortableError(new GroupAuthorizationException(this.builder.coordinatorKey()));
            } else {
                this.fatalError(new KafkaException(String.format("Could not find a coordinator with type %s with key %s due tounexpected error: %s", new Object[]{this.builder.coordinatorType(), this.builder.coordinatorKey(), findCoordinatorResponse.error().message()})));
            }
        }
    }

    private class AddPartitionsToTxnHandler
    extends TxnRequestHandler {
        private final AddPartitionsToTxnRequest.Builder builder;
        private long retryBackoffMs;

        private AddPartitionsToTxnHandler(AddPartitionsToTxnRequest.Builder builder) {
            this.builder = builder;
            this.retryBackoffMs = TransactionManager.this.retryBackoffMs;
        }

        AddPartitionsToTxnRequest.Builder requestBuilder() {
            return this.builder;
        }

        @Override
        Priority priority() {
            return Priority.ADD_PARTITIONS_OR_OFFSETS;
        }

        @Override
        public void handleResponse(AbstractResponse response) {
            AddPartitionsToTxnResponse addPartitionsToTxnResponse = (AddPartitionsToTxnResponse)response;
            Map<TopicPartition, Errors> errors = addPartitionsToTxnResponse.errors();
            boolean hasPartitionErrors = false;
            HashSet<String> unauthorizedTopics = new HashSet<String>();
            this.retryBackoffMs = TransactionManager.this.retryBackoffMs;
            for (Map.Entry<TopicPartition, Errors> topicPartitionErrorEntry : errors.entrySet()) {
                TopicPartition topicPartition = topicPartitionErrorEntry.getKey();
                Errors error = topicPartitionErrorEntry.getValue();
                if (error == Errors.NONE) continue;
                if (error == Errors.COORDINATOR_NOT_AVAILABLE || error == Errors.NOT_COORDINATOR) {
                    TransactionManager.this.lookupCoordinator(FindCoordinatorRequest.CoordinatorType.TRANSACTION, TransactionManager.this.transactionalId);
                    this.reenqueue();
                    return;
                }
                if (error == Errors.CONCURRENT_TRANSACTIONS) {
                    this.maybeOverrideRetryBackoffMs();
                    this.reenqueue();
                    return;
                }
                if (error == Errors.COORDINATOR_LOAD_IN_PROGRESS || error == Errors.UNKNOWN_TOPIC_OR_PARTITION) {
                    this.reenqueue();
                    return;
                }
                if (error == Errors.INVALID_PRODUCER_EPOCH) {
                    this.fatalError(error.exception());
                    return;
                }
                if (error == Errors.TRANSACTIONAL_ID_AUTHORIZATION_FAILED) {
                    this.fatalError(error.exception());
                    return;
                }
                if (error == Errors.INVALID_PRODUCER_ID_MAPPING || error == Errors.INVALID_TXN_STATE) {
                    this.fatalError(new KafkaException(error.exception()));
                    return;
                }
                if (error == Errors.TOPIC_AUTHORIZATION_FAILED) {
                    unauthorizedTopics.add(topicPartition.topic());
                    continue;
                }
                if (error == Errors.OPERATION_NOT_ATTEMPTED) {
                    TransactionManager.this.log.debug("Did not attempt to add partition {} to transaction because other partitions in the batch had errors.", (Object)topicPartition);
                    hasPartitionErrors = true;
                    continue;
                }
                TransactionManager.this.log.error("Could not add partition {} due to unexpected error {}", (Object)topicPartition, (Object)error);
                hasPartitionErrors = true;
            }
            Set<TopicPartition> partitions = errors.keySet();
            TransactionManager.this.pendingPartitionsInTransaction.removeAll(partitions);
            if (!unauthorizedTopics.isEmpty()) {
                this.abortableError(new TopicAuthorizationException(unauthorizedTopics));
            } else if (hasPartitionErrors) {
                this.abortableError(new KafkaException("Could not add partitions to transaction due to errors: " + errors));
            } else {
                TransactionManager.this.log.debug("Successfully added partitions {} to transaction", partitions);
                TransactionManager.this.partitionsInTransaction.addAll(partitions);
                TransactionManager.this.transactionStarted = true;
                this.result.done();
            }
        }

        @Override
        public long retryBackoffMs() {
            return Math.min(TransactionManager.this.retryBackoffMs, this.retryBackoffMs);
        }

        private void maybeOverrideRetryBackoffMs() {
            if (TransactionManager.this.partitionsInTransaction.isEmpty()) {
                this.retryBackoffMs = 20L;
            }
        }
    }

    private class InitProducerIdHandler
    extends TxnRequestHandler {
        private final InitProducerIdRequest.Builder builder;

        private InitProducerIdHandler(InitProducerIdRequest.Builder builder) {
            this.builder = builder;
        }

        InitProducerIdRequest.Builder requestBuilder() {
            return this.builder;
        }

        @Override
        Priority priority() {
            return Priority.INIT_PRODUCER_ID;
        }

        @Override
        public void handleResponse(AbstractResponse response) {
            InitProducerIdResponse initProducerIdResponse = (InitProducerIdResponse)response;
            Errors error = initProducerIdResponse.error();
            if (error == Errors.NONE) {
                ProducerIdAndEpoch producerIdAndEpoch = new ProducerIdAndEpoch(initProducerIdResponse.producerId(), initProducerIdResponse.epoch());
                TransactionManager.this.setProducerIdAndEpoch(producerIdAndEpoch);
                TransactionManager.this.transitionTo(State.READY);
                TransactionManager.this.lastError = null;
                this.result.done();
            } else if (error == Errors.NOT_COORDINATOR || error == Errors.COORDINATOR_NOT_AVAILABLE) {
                TransactionManager.this.lookupCoordinator(FindCoordinatorRequest.CoordinatorType.TRANSACTION, TransactionManager.this.transactionalId);
                this.reenqueue();
            } else if (error == Errors.COORDINATOR_LOAD_IN_PROGRESS || error == Errors.CONCURRENT_TRANSACTIONS) {
                this.reenqueue();
            } else if (error == Errors.TRANSACTIONAL_ID_AUTHORIZATION_FAILED) {
                this.fatalError(error.exception());
            } else {
                this.fatalError(new KafkaException("Unexpected error in InitProducerIdResponse; " + error.message()));
            }
        }
    }

    abstract class TxnRequestHandler
    implements RequestCompletionHandler {
        protected final TransactionalRequestResult result;
        private boolean isRetry = false;

        TxnRequestHandler(TransactionalRequestResult result) {
            this.result = result;
        }

        TxnRequestHandler() {
            this(new TransactionalRequestResult());
        }

        void fatalError(RuntimeException e) {
            this.result.setError(e);
            TransactionManager.this.transitionToFatalError(e);
            this.result.done();
        }

        void abortableError(RuntimeException e) {
            this.result.setError(e);
            TransactionManager.this.transitionToAbortableError(e);
            this.result.done();
        }

        void fail(RuntimeException e) {
            this.result.setError(e);
            this.result.done();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void reenqueue() {
            TransactionManager transactionManager = TransactionManager.this;
            synchronized (transactionManager) {
                this.isRetry = true;
                TransactionManager.this.enqueueRequest(this);
            }
        }

        long retryBackoffMs() {
            return TransactionManager.this.retryBackoffMs;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onComplete(ClientResponse response) {
            if (response.requestHeader().correlationId() != TransactionManager.this.inFlightRequestCorrelationId) {
                this.fatalError(new RuntimeException("Detected more than one in-flight transactional request."));
            } else {
                TransactionManager.this.clearInFlightTransactionalRequestCorrelationId();
                if (response.wasDisconnected()) {
                    TransactionManager.this.log.debug("Disconnected from {}. Will retry.", (Object)response.destination());
                    if (this.needsCoordinator()) {
                        TransactionManager.this.lookupCoordinator(this.coordinatorType(), this.coordinatorKey());
                    }
                    this.reenqueue();
                } else if (response.versionMismatch() != null) {
                    this.fatalError(response.versionMismatch());
                } else if (response.hasResponse()) {
                    TransactionManager.this.log.trace("Received transactional response {} for request {}", (Object)response.responseBody(), this.requestBuilder());
                    TransactionManager transactionManager = TransactionManager.this;
                    synchronized (transactionManager) {
                        this.handleResponse(response.responseBody());
                    }
                } else {
                    this.fatalError(new KafkaException("Could not execute transactional request for unknown reasons"));
                }
            }
        }

        boolean needsCoordinator() {
            return this.coordinatorType() != null;
        }

        FindCoordinatorRequest.CoordinatorType coordinatorType() {
            return FindCoordinatorRequest.CoordinatorType.TRANSACTION;
        }

        String coordinatorKey() {
            return TransactionManager.this.transactionalId;
        }

        void setRetry() {
            this.isRetry = true;
        }

        boolean isRetry() {
            return this.isRetry;
        }

        boolean isEndTxn() {
            return false;
        }

        abstract AbstractRequest.Builder<?> requestBuilder();

        abstract void handleResponse(AbstractResponse var1);

        abstract Priority priority();
    }

    private static enum Priority {
        FIND_COORDINATOR(0),
        INIT_PRODUCER_ID(1),
        ADD_PARTITIONS_OR_OFFSETS(2),
        END_TXN(3);

        final int priority;

        private Priority(int priority) {
            this.priority = priority;
        }
    }

    private static enum State {
        UNINITIALIZED,
        INITIALIZING,
        READY,
        IN_TRANSACTION,
        COMMITTING_TRANSACTION,
        ABORTING_TRANSACTION,
        ABORTABLE_ERROR,
        FATAL_ERROR;


        private boolean isTransitionValid(State source, State target) {
            switch (target) {
                case INITIALIZING: {
                    return source == UNINITIALIZED;
                }
                case READY: {
                    return source == INITIALIZING || source == COMMITTING_TRANSACTION || source == ABORTING_TRANSACTION;
                }
                case IN_TRANSACTION: {
                    return source == READY;
                }
                case COMMITTING_TRANSACTION: {
                    return source == IN_TRANSACTION;
                }
                case ABORTING_TRANSACTION: {
                    return source == IN_TRANSACTION || source == ABORTABLE_ERROR;
                }
                case ABORTABLE_ERROR: {
                    return source == IN_TRANSACTION || source == COMMITTING_TRANSACTION || source == ABORTABLE_ERROR;
                }
            }
            return true;
        }
    }
}

