/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.linkage.issues;

import java.util.Collection;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.linkage.issues.KotlinIrLinkerIssue;
import org.jetbrains.kotlin.backend.common.linkage.issues.KotlinIrLinkerIssuesKt;
import org.jetbrains.kotlin.backend.common.linkage.issues.UserVisibleIrModulesSupport;
import org.jetbrains.kotlin.backend.common.serialization.IrModuleDeserializer;
import org.jetbrains.kotlin.ir.util.IdSignature;
import org.jetbrains.kotlin.ir.util.IdSignatureRendererKt;
import org.jetbrains.kotlin.utils.ResolvedDependency;
import org.jetbrains.kotlin.utils.ResolvedDependencyId;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\u0010\u001a\u00020\rH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\rX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/backend/common/linkage/issues/SignatureIdNotFoundInModuleWithDependencies;", "Lorg/jetbrains/kotlin/backend/common/linkage/issues/KotlinIrLinkerIssue;", "idSignature", "Lorg/jetbrains/kotlin/ir/util/IdSignature;", "problemModuleDeserializer", "Lorg/jetbrains/kotlin/backend/common/serialization/IrModuleDeserializer;", "allModuleDeserializers", "", "userVisibleIrModulesSupport", "Lorg/jetbrains/kotlin/backend/common/linkage/issues/UserVisibleIrModulesSupport;", "<init>", "(Lorg/jetbrains/kotlin/ir/util/IdSignature;Lorg/jetbrains/kotlin/backend/common/serialization/IrModuleDeserializer;Ljava/util/Collection;Lorg/jetbrains/kotlin/backend/common/linkage/issues/UserVisibleIrModulesSupport;)V", "errorMessage", "", "getErrorMessage", "()Ljava/lang/String;", "computeErrorMessage", "ir.serialization.common"})
public final class SignatureIdNotFoundInModuleWithDependencies
extends KotlinIrLinkerIssue {
    @NotNull
    private final IdSignature idSignature;
    @NotNull
    private final IrModuleDeserializer problemModuleDeserializer;
    @NotNull
    private final Collection<IrModuleDeserializer> allModuleDeserializers;
    @NotNull
    private final UserVisibleIrModulesSupport userVisibleIrModulesSupport;
    @NotNull
    private final String errorMessage;

    /*
     * WARNING - void declaration
     */
    public SignatureIdNotFoundInModuleWithDependencies(@NotNull IdSignature idSignature, @NotNull IrModuleDeserializer problemModuleDeserializer, @NotNull Collection<? extends IrModuleDeserializer> allModuleDeserializers, @NotNull UserVisibleIrModulesSupport userVisibleIrModulesSupport) {
        String string2;
        Intrinsics.checkNotNullParameter(idSignature, "idSignature");
        Intrinsics.checkNotNullParameter(problemModuleDeserializer, "problemModuleDeserializer");
        Intrinsics.checkNotNullParameter(allModuleDeserializers, "allModuleDeserializers");
        Intrinsics.checkNotNullParameter(userVisibleIrModulesSupport, "userVisibleIrModulesSupport");
        this.idSignature = idSignature;
        this.problemModuleDeserializer = problemModuleDeserializer;
        this.allModuleDeserializers = allModuleDeserializers;
        this.userVisibleIrModulesSupport = userVisibleIrModulesSupport;
        SignatureIdNotFoundInModuleWithDependencies signatureIdNotFoundInModuleWithDependencies = this;
        try {
            SignatureIdNotFoundInModuleWithDependencies signatureIdNotFoundInModuleWithDependencies2 = signatureIdNotFoundInModuleWithDependencies;
            string2 = this.computeErrorMessage();
        }
        catch (Throwable throwable) {
            void $this$errorMessage_u24lambda_u240;
            StringBuilder stringBuilder;
            StringBuilder stringBuilder2 = stringBuilder = new StringBuilder();
            boolean bl = false;
            $this$errorMessage_u24lambda_u240.append("Failed to compute the detailed error message. See the root cause exception.").append('\n');
            $this$errorMessage_u24lambda_u240.append('\n');
            $this$errorMessage_u24lambda_u240.append("Shortly: The required symbol " + IdSignatureRendererKt.render$default(this.idSignature, null, 1, null) + " is missing in the module or module dependencies.");
            $this$errorMessage_u24lambda_u240.append(" This could happen if the required dependency is missing in the project.");
            $this$errorMessage_u24lambda_u240.append(" Or if there is a dependency that has a different version (without the required symbol) in the project");
            $this$errorMessage_u24lambda_u240.append(" than the version (with the required symbol) that the module was initially compiled with.");
            SignatureIdNotFoundInModuleWithDependencies signatureIdNotFoundInModuleWithDependencies3 = signatureIdNotFoundInModuleWithDependencies;
            String string3 = stringBuilder.toString();
            throw new RuntimeException(string3);
        }
        signatureIdNotFoundInModuleWithDependencies2.errorMessage = string2;
    }

    @Override
    @NotNull
    protected String getErrorMessage() {
        return this.errorMessage;
    }

    private final String computeErrorMessage() {
        StringBuilder stringBuilder;
        StringBuilder $this$computeErrorMessage_u24lambda_u241 = stringBuilder = new StringBuilder();
        boolean bl = false;
        Map<ResolvedDependencyId, ResolvedDependency> allModules = this.userVisibleIrModulesSupport.getUserVisibleModules(this.allModuleDeserializers);
        ResolvedDependencyId problemModuleId = KotlinIrLinkerIssuesKt.access$getProblemModuleId(this.userVisibleIrModulesSupport, this.problemModuleDeserializer, allModules);
        String problemModuleIdWithVersion = MapsKt.getValue(allModules, problemModuleId).getModuleIdWithVersion();
        $this$computeErrorMessage_u24lambda_u241.append("Module \"" + problemModuleId + "\" has a reference to symbol " + IdSignatureRendererKt.render$default(this.idSignature, null, 1, null) + '.');
        $this$computeErrorMessage_u24lambda_u241.append(" Neither the module itself nor its dependencies contain such declaration.");
        $this$computeErrorMessage_u24lambda_u241.append("\n\nThis could happen if the required dependency is missing in the project.");
        $this$computeErrorMessage_u24lambda_u241.append(" Or if there is a dependency of \"" + problemModuleId + "\" that has a different version in the project");
        $this$computeErrorMessage_u24lambda_u241.append(" than the version that \"" + problemModuleIdWithVersion + "\" was initially compiled with.");
        $this$computeErrorMessage_u24lambda_u241.append(" Please check that the project configuration is correct and has consistent versions of all required dependencies.");
        KotlinIrLinkerIssuesKt.access$appendPotentiallyConflictingDependencies($this$computeErrorMessage_u24lambda_u241, "The list of \"" + problemModuleIdWithVersion + "\" dependencies that may lead to conflicts:", allModules, KotlinIrLinkerIssuesKt.access$findPotentiallyConflictingOutgoingDependencies(problemModuleId, allModules), this.userVisibleIrModulesSupport.getModuleIdComparator());
        KotlinIrLinkerIssuesKt.access$appendProjectDependencies($this$computeErrorMessage_u24lambda_u241, allModules, SetsKt.setOf(problemModuleId), "This module requires symbol " + IdSignatureRendererKt.render$default(this.idSignature, null, 1, null), this.userVisibleIrModulesSupport.getSourceCodeModuleId(), this.userVisibleIrModulesSupport.getModuleIdComparator());
        return stringBuilder.toString();
    }
}

