/*
 * Decompiled with CFR 0.152.
 */
package liquibase.changelog.filter;

import java.util.List;
import liquibase.changelog.ChangeSet;
import liquibase.changelog.RanChangeSet;
import liquibase.changelog.filter.ChangeSetFilter;
import liquibase.changelog.filter.ChangeSetFilterResult;

public class NotRanChangeSetFilter
implements ChangeSetFilter {
    public List<RanChangeSet> ranChangeSets;

    public NotRanChangeSetFilter(List<RanChangeSet> ranChangeSets) {
        this.ranChangeSets = ranChangeSets;
    }

    @Override
    public ChangeSetFilterResult accepts(ChangeSet changeSet) {
        for (RanChangeSet ranChangeSet : this.ranChangeSets) {
            if (!ranChangeSet.getId().equalsIgnoreCase(changeSet.getId()) || !ranChangeSet.getAuthor().equalsIgnoreCase(changeSet.getAuthor()) || !ranChangeSet.getChangeLog().replaceFirst("^classpath:", "").equalsIgnoreCase(changeSet.getFilePath().replaceFirst("^classpath:", ""))) continue;
            return new ChangeSetFilterResult(false, "Change set already ran", this.getClass());
        }
        return new ChangeSetFilterResult(true, "Change set not yet ran", this.getClass());
    }
}

