/**
 * Controls the overview page of the message drawer.
 *
 * @module     core_message/message_drawer_view_overview
 * @copyright  2018 Ryan Wyllie <ryan@moodle.com>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
define("core_message/message_drawer_view_overview",["jquery","core/key_codes","core/pubsub","core/str","core_message/message_drawer_router","core_message/message_drawer_routes","core_message/message_drawer_events","core_message/message_drawer_view_overview_section","core_message/message_repository","core_message/message_drawer_view_conversation_constants"],(function($,KeyCodes,PubSub,Str,Router,Routes,MessageDrawerEvents,Section,MessageRepository,Constants){var SELECTORS_CONTACT_REQUEST_COUNT='[data-region="contact-request-count"]',SELECTORS_FAVOURITES='[data-region="view-overview-favourites"]',SELECTORS_GROUP_MESSAGES='[data-region="view-overview-group-messages"]',SELECTORS_MESSAGES='[data-region="view-overview-messages"]',SELECTORS_SEARCH_INPUT='[data-region="view-overview-search-input"]',SELECTORS_SECTION_TOGGLE_BUTTON="[data-toggle]",OVERVIEW_SECTION_TYPES={PRIVATE:[Constants.CONVERSATION_TYPES.PRIVATE,Constants.CONVERSATION_TYPES.SELF],PUBLIC:[Constants.CONVERSATION_TYPES.PUBLIC],FAVOURITE:null},loadAllCountsPromise=null,filterCountsByTypes=function(counts,types,includeFavourites){var total=0;return types&&types.length&&(total=types.reduce((function(carry,type){return carry+counts.types[type]}),total)),includeFavourites&&(total+=counts.favourites),total},getSearchInput=function(header){return header.find(SELECTORS_SEARCH_INPUT)},decrementContactRequestCount=function(header){return function(){var countContainer=header.find(SELECTORS_CONTACT_REQUEST_COUNT),count=parseInt(countContainer.text(),10);(count=isNaN(count)?0:count-1)<=0?countContainer.addClass("hidden"):countContainer.text(count)}};return{show:function(namespace,header,body){header.attr("data-init")||(!function(namespace,header){var searchInput=getSearchInput(header),ignoredKeys=[KeyCodes.tab,KeyCodes.shift,KeyCodes.ctrl,KeyCodes.alt];searchInput.on("click",(function(){Router.go(namespace,Routes.VIEW_SEARCH)})),searchInput.on("keydown",(function(e){ignoredKeys.indexOf(e.keyCode)<0&&"Meta"!=e.key&&Router.go(namespace,Routes.VIEW_SEARCH)})),PubSub.subscribe(MessageDrawerEvents.CONTACT_REQUEST_ACCEPTED,decrementContactRequestCount(header)),PubSub.subscribe(MessageDrawerEvents.CONTACT_REQUEST_DECLINED,decrementContactRequestCount(header))}(namespace,header),header.attr("data-init",!0));var fromPanel=header.attr("data-in-panel")?"frompanel":null;getSearchInput(header).val("");var loggedInUserId=function(body){return body.attr("data-user-id")}(body),allCounts=function(loggedInUserId){return null===loadAllCountsPromise&&(loadAllCountsPromise=MessageRepository.getAllConversationCounts(loggedInUserId)),loadAllCountsPromise}(loggedInUserId),sections=[[body.find(SELECTORS_FAVOURITES),OVERVIEW_SECTION_TYPES.FAVOURITE,!0],[body.find(SELECTORS_GROUP_MESSAGES),OVERVIEW_SECTION_TYPES.PUBLIC,!1],[body.find(SELECTORS_MESSAGES),OVERVIEW_SECTION_TYPES.PRIVATE,!1]];return sections.forEach((function(args){var sectionRoot=args[0],sectionTypes=args[1],includeFavourites=args[2],totalCountPromise=allCounts.then((function(result){return filterCountsByTypes(result.total,sectionTypes,includeFavourites)})),unreadCountPromise=allCounts.then((function(result){return filterCountsByTypes(result.unread,sectionTypes,includeFavourites)}));Section.show(namespace,null,sectionRoot,null,sectionTypes,includeFavourites,totalCountPromise,unreadCountPromise,fromPanel)})),allCounts.then((function(result){return function(sections){sections.some((function(section){var sectionRoot=section[0];return Section.isVisible(sectionRoot)}))||(sections.sort((function(a,b){var aTotal=a[1],aUnread=a[2],bTotal=b[1],bUnread=b[2];return aUnread>0&&0==bUnread?-1:0==aUnread&&bUnread>0?1:aTotal>0&&0==bTotal?-1:0==aTotal&&bTotal>0?1:0})),sections[0][0].find(SELECTORS_SECTION_TOGGLE_BUTTON).click())}(sections.map((function(section){var sectionRoot=section[0],sectionTypes=section[1],includeFavourites=section[2];return[sectionRoot,filterCountsByTypes(result.total,sectionTypes,includeFavourites),filterCountsByTypes(result.unread,sectionTypes,includeFavourites)]})))}))},description:function(){return Str.get_string("messagedrawerviewoverview","core_message")}}}));

//# sourceMappingURL=message_drawer_view_overview.min.js.map