/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.remote.jdbc.helpers;

import com.intellij.database.remote.jdbc.ColumnInfo;
import com.intellij.database.remote.jdbc.RemotePreparedStatement;
import com.intellij.database.remote.jdbc.helpers.JdbcNativeUtil;
import com.intellij.database.remote.jdbc.helpers.PgBaseJdbcHelper;
import com.intellij.database.remote.jdbc.impl.ReflectionHelper;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.util.Arrays;
import java.util.regex.Pattern;
import javax.sql.DataSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.Postgres;
import org.jetbrains.dekaf.intermediate.DBExceptionRecognizer;
import org.jetbrains.dekaf.jdbc.JdbcIntermediateFacade;
import org.jetbrains.dekaf.jdbc.PostgresExceptionRecognizer;
import org.jetbrains.dekaf.jdbc.PostgresIntermediateFacade;

public class PgJdbcHelper
extends PgBaseJdbcHelper {
    private static final Pattern PG_VERSION_PATTERN = Pattern.compile("(\\d+(?:(?:alpha|beta|rc)\\d*|\\.\\d+)(?:\\.\\d+)*)", 2);

    public PgJdbcHelper(@Nullable String version, @Nullable Connection connection) {
        super(Postgres.RDBMS, version, connection);
    }

    public PgJdbcHelper() {
        this(null, null);
    }

    @Override
    @Nullable
    public String parseVersion(@Nullable String version) {
        return PgJdbcHelper.extractVersion(version);
    }

    @Override
    public int fixJdbcType(@Nullable String typeName, @Nullable String clazz, int type) {
        if (Arrays.asList("bit", "varbit", "tid", "uuid").contains(typeName)) {
            return 12;
        }
        if ("money".equals(typeName)) {
            return 1111;
        }
        return super.fixJdbcType(typeName, clazz, type);
    }

    @Override
    protected boolean isDriverFailsOnType(int jdbcType, String typeName) {
        boolean isBitOrMoney;
        boolean bl = isBitOrMoney = "_money".equalsIgnoreCase(typeName) || "money".equalsIgnoreCase(typeName) || "bit".equalsIgnoreCase(typeName);
        if (isBitOrMoney || "refcursor".equals(typeName)) {
            return true;
        }
        return super.isDriverFailsOnType(jdbcType, typeName);
    }

    @Override
    @NotNull
    public JdbcIntermediateFacade createFacade(@NotNull DataSource ds) {
        if (ds == null) {
            PgJdbcHelper.$$$reportNull$$$0(0);
        }
        PostgresIntermediateFacade postgresIntermediateFacade = new PostgresIntermediateFacade(ds, 1, false, (DBExceptionRecognizer)PostgresExceptionRecognizer.INSTANCE);
        if (postgresIntermediateFacade == null) {
            PgJdbcHelper.$$$reportNull$$$0(1);
        }
        return postgresIntermediateFacade;
    }

    @Override
    public void setStatementParameter(@NotNull RemotePreparedStatement statement, @Nullable Object value, @NotNull ColumnInfo columnInfo, boolean needsEscaping, int idx) throws Exception {
        if (statement == null) {
            PgJdbcHelper.$$$reportNull$$$0(2);
        }
        if (columnInfo == null) {
            PgJdbcHelper.$$$reportNull$$$0(3);
        }
        int type = columnInfo.getType();
        String typeName = columnInfo.getTypeName();
        if (!(value instanceof String) || !PgJdbcHelper.setNative((String)value, typeName, statement, type, idx)) {
            super.setStatementParameter(statement, value, columnInfo, needsEscaping, idx);
        }
    }

    private static boolean setNative(@NotNull String value, @NotNull String typeName, @NotNull RemotePreparedStatement statement, int jdbcType, int idx) {
        if (value == null) {
            PgJdbcHelper.$$$reportNull$$$0(4);
        }
        if (typeName == null) {
            PgJdbcHelper.$$$reportNull$$$0(5);
        }
        if (statement == null) {
            PgJdbcHelper.$$$reportNull$$$0(6);
        }
        if (!PgJdbcHelper.isSupportedNativeType(typeName, jdbcType)) {
            return false;
        }
        try {
            Object pgObject;
            Class<?> aClass = Class.forName("org.postgresql.util.PGobject");
            Object v0 = pgObject = aClass == null ? null : aClass.newInstance();
            if (pgObject == null) {
                return false;
            }
            ReflectionHelper.tryInvokeMethod(pgObject, "setType", new Class[]{String.class}, new Object[]{typeName});
            ReflectionHelper.tryInvokeMethod(pgObject, "setValue", new Class[]{String.class}, new Object[]{value});
            statement.setObject(idx, pgObject);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private static boolean isSupportedNativeType(@NotNull String typeName, int type) {
        if (typeName == null) {
            PgJdbcHelper.$$$reportNull$$$0(7);
        }
        return NATIVE_TYPES.contains(typeName) || type == 2002;
    }

    @NotNull
    protected static PgJdbcHelper create(@NotNull Connection delegate) throws Exception {
        DatabaseMetaData md;
        if (delegate == null) {
            PgJdbcHelper.$$$reportNull$$$0(8);
        }
        String versionStr = (md = delegate.getMetaData()) == null ? null : md.getDatabaseProductVersion();
        String version = PgJdbcHelper.extractVersion(versionStr);
        PgJdbcHelper pgJdbcHelper = new PgJdbcHelper(version, delegate);
        if (pgJdbcHelper == null) {
            PgJdbcHelper.$$$reportNull$$$0(9);
        }
        return pgJdbcHelper;
    }

    @Nullable
    public static String extractVersion(@Nullable String str) {
        return JdbcNativeUtil.findVersion(str, PG_VERSION_PATTERN);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ds";
                break;
            }
            case 1: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/remote/jdbc/helpers/PgJdbcHelper";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columnInfo";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeName";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delegate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/remote/jdbc/helpers/PgJdbcHelper";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createFacade";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createFacade";
                break;
            }
            case 1: 
            case 9: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setStatementParameter";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setNative";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isSupportedNativeType";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

