/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coverage;

import com.intellij.coverage.AbstractCoverageProjectViewNodeDecorator;
import com.intellij.coverage.CoverageAnnotator;
import com.intellij.coverage.CoverageDataManager;
import com.intellij.coverage.CoverageSuitesBundle;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.packageDependencies.ui.PackageDependenciesNode;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.ui.ColoredTreeCellRenderer;

public class CoverageProjectViewDirectoryNodeDecorator
extends AbstractCoverageProjectViewNodeDecorator {
    public CoverageProjectViewDirectoryNodeDecorator(CoverageDataManager coverageDataManager) {
        super(coverageDataManager);
    }

    public void decorate(PackageDependenciesNode node, ColoredTreeCellRenderer cellRenderer) {
        CoverageAnnotator coverageAnnotator;
        PsiElement psiElement = node.getPsiElement();
        if (psiElement == null || !psiElement.isValid()) {
            return;
        }
        CoverageDataManager coverageDataManager = this.getCoverageDataManager();
        CoverageSuitesBundle coverageSuitesBundle = coverageDataManager.getCurrentSuitesBundle();
        CoverageAnnotator coverageAnnotator2 = coverageAnnotator = coverageSuitesBundle != null ? coverageSuitesBundle.getAnnotator(psiElement.getProject()) : null;
        if (coverageAnnotator == null) {
            return;
        }
        String string = null;
        if (psiElement instanceof PsiDirectory) {
            string = coverageAnnotator.getDirCoverageInformationString((PsiDirectory)psiElement, coverageSuitesBundle, coverageDataManager);
        } else if (psiElement instanceof PsiFile) {
            string = coverageAnnotator.getFileCoverageInformationString((PsiFile)psiElement, coverageSuitesBundle, coverageDataManager);
        }
        if (string != null) {
            CoverageProjectViewDirectoryNodeDecorator.appendCoverageInfo(cellRenderer, string);
        }
    }

    public void decorate(ProjectViewNode node, PresentationData data) {
        CoverageAnnotator coverageAnnotator;
        CoverageDataManager coverageDataManager = this.getCoverageDataManager();
        CoverageSuitesBundle coverageSuitesBundle = coverageDataManager.getCurrentSuitesBundle();
        CoverageAnnotator coverageAnnotator2 = coverageAnnotator = coverageSuitesBundle != null ? coverageSuitesBundle.getAnnotator(node.getProject()) : null;
        if (coverageAnnotator == null) {
            return;
        }
        Object object = node.getValue();
        PsiElement psiElement = null;
        if (object instanceof PsiElement) {
            psiElement = (PsiElement)object;
        } else if (object instanceof SmartPsiElementPointer) {
            psiElement = ((SmartPsiElementPointer)object).getElement();
        }
        String string = null;
        if (psiElement instanceof PsiDirectory) {
            string = coverageAnnotator.getDirCoverageInformationString((PsiDirectory)psiElement, coverageSuitesBundle, coverageDataManager);
        } else if (psiElement instanceof PsiFile) {
            string = coverageAnnotator.getFileCoverageInformationString((PsiFile)psiElement, coverageSuitesBundle, coverageDataManager);
        }
        if (string != null) {
            data.setLocationString(string);
        }
    }
}

