/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.application;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.RepositoryLocation;
import com.intellij.openapi.vcs.TreeDiffProvider;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.FilePathsHelper;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesCache;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.jetbrains.idea.perforce.application.PerforceCommittedChangesProvider;
import org.jetbrains.idea.perforce.application.PerforceVcs;

public class PerforceTreeDiffProvider
implements TreeDiffProvider {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.idea.perforce.application.PerforceTreeDiffProvider");
    private final PerforceVcs myVcs;

    public PerforceTreeDiffProvider(PerforceVcs vcs) {
        this.myVcs = vcs;
    }

    public Collection<String> getRemotelyChanged(VirtualFile vcsRoot, Collection<String> paths) {
        RepositoryLocation location = CommittedChangesCache.getInstance((Project)this.myVcs.getProject()).getLocationCache().getLocation((AbstractVcs)this.myVcs, VcsUtil.getFilePath((VirtualFile)vcsRoot), true);
        PerforceCommittedChangesProvider committedChangesProvider = this.myVcs.getCommittedChangesProvider();
        try {
            Collection<FilePath> files = committedChangesProvider.getIncomingFiles(location);
            HashSet<String> helper = new HashSet<String>();
            for (FilePath file : files) {
                String convertedPath = FilePathsHelper.convertPath((FilePath)file);
                helper.add(convertedPath);
            }
            HashSet<String> result = new HashSet<String>();
            for (String path : paths) {
                String convertedPath = FilePathsHelper.convertPath((String)path);
                if (!helper.contains(convertedPath)) continue;
                result.add(path);
            }
            return result;
        }
        catch (VcsException e) {
            LOG.info((Throwable)e);
            return Collections.emptyList();
        }
    }
}

