/*
 * Decompiled with CFR 0.152.
 */
package com.yourkit.api;

import com.yourkit.api.ControllerImpl;
import com.yourkit.api.ProbeActivityMode;
import com.yourkit.api.ProfilingModesExt;
import java.lang.reflect.Field;
import java.util.HashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Controller {
    public static final long SNAPSHOT_WITHOUT_HEAP = 0L;
    public static final long SNAPSHOT_WITH_HEAP = 1L;
    public static final long SNAPSHOT_HPROF = 17L;
    @NotNull
    private final ControllerImpl myImpl;
    private static final String CMD_PRINT_STATUS = "status";
    private static final String CMD_PRINT_STATUS_OLD = "print-current-status";
    private static final String CMD_CAPTURE_PERFORMANCE_SNAPSHOT = "capture-performance-snapshot";
    private static final String CMD_CAPTURE_MEMORY_SNAPSHOT = "capture-memory-snapshot";
    private static final String CMD_CAPTURE_HPROF_SNAPSHOT = "capture-hprof-snapshot";
    private static final String CMD_START_CPU_SAMPLING = "start-cpu-sampling";
    private static final String CMD_START_CPU_TRACING = "start-cpu-tracing";
    private static final String CMD_START_CPU_CALL_COUNTING = "start-cpu-call-counting";
    private static final String OPT_ALLOC_SAMPLED = "alloc-sampled";
    private static final String CMD_STOP_CPU_PROFILING = "stop-cpu-profiling";
    private static final String CMD_CLEAR_CPU_DATA = "clear-cpu-data";
    private static final String CMD_START_ALLOC_ALL = "start-alloc-recording-all";
    private static final String CMD_START_ALLOC_ADAPTIVE = "start-alloc-recording-adaptive";
    private static final String CMD_STOP_ALLOC = "stop-alloc-recording";
    private static final String CMD_CLEAR_ALLOC_DATA = "clear-alloc-data";
    private static final String CMD_START_MONITOR_PROFILING = "start-monitor-profiling";
    private static final String CMD_STOP_MONITOR_PROFILING = "stop-monitor-profiling";
    private static final String CMD_CLEAR_MONITOR_DATA = "clear-monitor-data";
    private static final String CMD_ENABLE_STACK_TELEMETRY = "enable-stack-telemetry";
    private static final String CMD_DISABLE_STACK_TELEMETRY = "disable-stack-telemetry";
    private static final String CMD_FORCE_GC = "force-gc";
    private static final String CMD_CHARTS = "clear-charts";

    public Controller() throws Exception {
        this("localhost", Controller.getUsedPort());
    }

    public Controller(@NotNull String host, int port) throws Exception {
        if (host == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        this.myImpl = new ControllerImpl(host, port);
    }

    @NotNull
    public String getSessionName() {
        String string = this.myImpl.getSessionName();
        if (string == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return string;
    }

    @NotNull
    public String getHost() {
        String string = this.myImpl.getHost();
        if (string == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return string;
    }

    public int getPort() {
        return this.myImpl.getPort();
    }

    public int getPID() {
        return this.myImpl.getPID();
    }

    public static int getUsedPort() throws Exception {
        int port = -1;
        try {
            ClassLoader loader = ClassLoader.getSystemClassLoader();
            Class<?> aClass = loader.loadClass("com.yourkit.runtime.Core");
            Field field = aClass.getDeclaredField("ourPort");
            port = (Integer)field.get(null);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (port == -1) {
            throw new Exception("To profile application, you should run it with the profiler agent");
        }
        return port;
    }

    @NotNull
    public String captureSnapshot(long snapshotFlags) throws Exception {
        if (snapshotFlags != 0L && snapshotFlags != 1L && snapshotFlags != 17L) {
            throw new IllegalArgumentException("illegal snapshot flags value " + snapshotFlags + "; use one of the " + this.getClass().getName() + ".SNAPSHOT_xxx constants");
        }
        String string = this.myImpl.captureSnapshot(snapshotFlags, null, null, null);
        if (string == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return string;
    }

    public String captureMemorySnapshot() throws Exception {
        return this.captureSnapshot(1L);
    }

    public String capturePerformanceSnapshot() throws Exception {
        return this.captureSnapshot(0L);
    }

    public String captureHPROFSnapshot() throws Exception {
        return this.captureSnapshot(17L);
    }

    public void startAllocationRecording(@Nullable String settings) throws Exception {
        this.myImpl.startAllocationRecording(settings);
    }

    public void stopAllocationRecording() throws Exception {
        this.myImpl.stopAllocationRecording();
    }

    public void clearAllocationData() throws Exception {
        this.myImpl.clearAllocationData();
    }

    public void startCPUSampling(@Nullable String settings) throws Exception {
        this.myImpl.startCPUProfiling(4L, settings);
    }

    public void startCPUTracing(@Nullable String settings) throws Exception {
        this.myImpl.startCPUProfiling(12L, settings);
    }

    public void startCPUCallCounting() throws Exception {
        this.myImpl.startCPUProfiling(4100L, null);
    }

    public void stopCPUProfiling() throws Exception {
        this.myImpl.stopCPUProfiling();
    }

    public void clearCPUData() throws Exception {
        this.myImpl.clearCPUData();
    }

    public void startMonitorProfiling() throws Exception {
        this.myImpl.startMonitorProfiling();
    }

    public void stopMonitorProfiling() throws Exception {
        this.myImpl.stopMonitorProfiling();
    }

    public void clearMonitorData() throws Exception {
        this.myImpl.clearMonitorData();
    }

    public void enableStackTelemetry() throws Exception {
        this.myImpl.enableStackTelemetry();
    }

    public void disableStackTelemetry() throws Exception {
        this.myImpl.disableStackTelemetry();
    }

    public void enableExceptionTelemetry() throws Exception {
        this.myImpl.enableExceptionTelemetry();
    }

    public void disableExceptionTelemetry() throws Exception {
        this.myImpl.disableExceptionTelemetry();
    }

    public void clearExceptions() throws Exception {
        this.myImpl.clearExceptions();
    }

    public void clearEventTables(String ... tableNames) throws Exception {
        if (tableNames == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        this.myImpl.clearEventTables(tableNames);
    }

    public void advanceGeneration(@Nullable String description) throws Exception {
        this.myImpl.advanceGeneration(description == null ? "" : description);
    }

    public long[] forceGC() throws Exception {
        return this.myImpl.forceGC();
    }

    public long getStatus() throws Exception {
        return this.myImpl.getStatus();
    }

    public void setTriggers(String triggersDescription, boolean append) throws Exception {
        this.myImpl.setTriggers(triggersDescription, append);
    }

    @NotNull
    public String getTriggers() throws Exception {
        String string = this.myImpl.getTriggers();
        if (string == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return string;
    }

    @NotNull
    public HashMap<String, ProbeActivityMode> getProbeActivityModes() throws Exception {
        HashMap<String, ProbeActivityMode> hashMap = this.myImpl.getProbes();
        if (hashMap == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return hashMap;
    }

    public void setProbeActivityModes(@NotNull HashMap<String, ProbeActivityMode> probeClassName2mode) throws Exception {
        if (probeClassName2mode == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        this.myImpl.setProbes(probeClassName2mode);
    }

    public void clearCharts() throws Exception {
        this.myImpl.clearCharts();
    }

    public static boolean isCPUProfiling(long status) {
        return ProfilingModesExt.isCPUProfiling(status);
    }

    public static boolean isCPUSampling(long status) {
        return ProfilingModesExt.isCPUSampling(status);
    }

    public static boolean isCPUTracing(long status) {
        return ProfilingModesExt.isCPUTracing(status);
    }

    public static boolean isCPUCallCounting(long status) {
        return ProfilingModesExt.isCPUCallCounting(status);
    }

    public static boolean isMonitorProfiling(long status) {
        return ProfilingModesExt.isMonitorProfiling(status);
    }

    public static boolean isAllocationRecording(long status) {
        return ProfilingModesExt.isAllocationRecording(status);
    }

    public static boolean isStackTelemetry(long status) {
        return ProfilingModesExt.isStackTelemetry(status);
    }

    public static boolean isExceptionTelemetry(long status) {
        return ProfilingModesExt.isExceptionTelemetry(status);
    }

    public static boolean isDeadlockDetected(long status) {
        return ProfilingModesExt.isDeadlockDetected(status);
    }

    private static void printHelp() {
        System.out.println("YourKit Java Profiler 2017.02-b66 command line tools\n\nUsage: java -jar yjp-controller-api-redist.jar <host> <port> <command>\n\nwhere <command> is one of:\n\nstatus\ncapture-memory-snapshot\ncapture-hprof-snapshot\ncapture-performance-snapshot\nstart-cpu-sampling\nstart-cpu-tracing\nstart-cpu-call-counting\nstop-cpu-profiling\nclear-cpu-data\nstart-alloc-recording-all\n  // record all objects\nstart-alloc-recording-adaptive [alloc-sampled] \n  // record all objects with size >= 4 KB, and only each 10th smaller object\nstop-alloc-recording\nclear-alloc-data\nstart-monitor-profiling\nstop-monitor-profiling\nclear-monitor-data\nenable-stack-telemetry\ndisable-stack-telemetry\nforce-gc\nclear-charts\n\nExamples:\njava -jar yjp-controller-api-redist.jar localhost 10001 capture-memory-snapshot\njava -jar yjp-controller-api-redist.jar localhost 10001 start-cpu-sampling\n");
    }

    public static void main(@NotNull String[] args) throws Exception {
        String path;
        int port;
        if (args == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (args.length < 3) {
            Controller.printHelp();
            return;
        }
        String host = args[0];
        String portStr = args[1];
        String command = args[2].toLowerCase();
        try {
            port = Integer.parseInt(portStr);
        }
        catch (Exception ignored) {
            System.out.println("Error: invalid port number specified: " + portStr);
            Controller.printHelp();
            return;
        }
        boolean allocSampled = false;
        for (int i = 3; i < args.length; ++i) {
            String option = args[i];
            if (!CMD_START_ALLOC_ALL.equals(command) && !CMD_START_ALLOC_ADAPTIVE.equals(command) || !OPT_ALLOC_SAMPLED.equals(option)) {
                Controller.printHelp();
                return;
            }
            allocSampled = true;
        }
        if (CMD_CAPTURE_MEMORY_SNAPSHOT.equals(command)) {
            Controller controller = new Controller(host, port);
            path = controller.captureMemorySnapshot();
            System.out.println("Snapshot captured: " + path);
            return;
        }
        if (CMD_CAPTURE_HPROF_SNAPSHOT.equals(command)) {
            Controller controller = new Controller(host, port);
            path = controller.captureHPROFSnapshot();
            System.out.println("Snapshot captured: " + path);
            return;
        }
        if (CMD_CAPTURE_PERFORMANCE_SNAPSHOT.equals(command)) {
            Controller controller = new Controller(host, port);
            path = controller.capturePerformanceSnapshot();
            System.out.println("Snapshot captured: " + path);
            return;
        }
        if (CMD_START_CPU_SAMPLING.equals(command)) {
            Controller controller = new Controller(host, port);
            controller.startCPUSampling(null);
            System.out.println("CPU sampling started");
            return;
        }
        if (CMD_START_CPU_TRACING.equals(command)) {
            Controller controller = new Controller(host, port);
            controller.startCPUTracing(null);
            System.out.println("CPU tracing started");
            return;
        }
        if (CMD_START_CPU_CALL_COUNTING.equals(command)) {
            Controller controller = new Controller(host, port);
            controller.startCPUCallCounting();
            System.out.println("Call counting started");
            return;
        }
        if (CMD_STOP_CPU_PROFILING.equals(command)) {
            Controller controller = new Controller(host, port);
            controller.stopCPUProfiling();
            System.out.println("CPU profiling stopped");
            return;
        }
        if (CMD_CLEAR_CPU_DATA.equals(command)) {
            Controller controller = new Controller(host, port);
            controller.clearCPUData();
            System.out.println("CPU profiling data cleared");
            return;
        }
        if (CMD_START_ALLOC_ALL.equals(command)) {
            Controller controller = new Controller(host, port);
            controller.startAllocationRecording(ControllerImpl.composeAllocationRecordingSettings(1, 1, allocSampled));
            System.out.println("Allocation recording started");
            return;
        }
        if (CMD_START_ALLOC_ADAPTIVE.equals(command)) {
            Controller controller = new Controller(host, port);
            controller.startAllocationRecording(ControllerImpl.composeAllocationRecordingSettings(4096, 10, allocSampled));
            System.out.println("Allocation recording started");
            return;
        }
        if (CMD_STOP_ALLOC.equals(command)) {
            Controller controller = new Controller(host, port);
            controller.stopAllocationRecording();
            System.out.println("Allocation recording stopped");
            return;
        }
        if (CMD_CLEAR_ALLOC_DATA.equals(command)) {
            Controller controller = new Controller(host, port);
            controller.clearAllocationData();
            System.out.println("Allocation data cleared");
            return;
        }
        if (CMD_START_MONITOR_PROFILING.equals(command)) {
            Controller controller = new Controller(host, port);
            controller.startMonitorProfiling();
            System.out.println("Monitor profiling started");
            return;
        }
        if (CMD_STOP_MONITOR_PROFILING.equals(command)) {
            Controller controller = new Controller(host, port);
            controller.stopMonitorProfiling();
            System.out.println("Monitor profiling stopped");
            return;
        }
        if (CMD_CLEAR_MONITOR_DATA.equals(command)) {
            Controller controller = new Controller(host, port);
            controller.clearMonitorData();
            System.out.println("Monitor data cleared");
            return;
        }
        if (CMD_FORCE_GC.equals(command)) {
            Controller controller = new Controller(host, port);
            controller.forceGC();
            System.out.println("GC forced");
            return;
        }
        if (CMD_ENABLE_STACK_TELEMETRY.equals(command)) {
            Controller controller = new Controller(host, port);
            controller.enableStackTelemetry();
            System.out.println("Stack telemetry enabled");
            return;
        }
        if (CMD_DISABLE_STACK_TELEMETRY.equals(command)) {
            Controller controller = new Controller(host, port);
            controller.disableStackTelemetry();
            System.out.println("Stack telemetry disabled");
            return;
        }
        if (CMD_CHARTS.equals(command)) {
            Controller controller = new Controller(host, port);
            controller.clearCharts();
            System.out.println("Telemetry charts cleared");
            return;
        }
        if (CMD_PRINT_STATUS.equals(command) || CMD_PRINT_STATUS_OLD.equals(command)) {
            Controller controller = new Controller(host, port);
            System.out.println("Host: " + controller.getHost());
            System.out.println("Agent port: " + controller.getPort());
            System.out.println("PID: " + controller.getPID());
            System.out.println("Session name: " + controller.getSessionName());
            System.out.println();
            long status = controller.getStatus();
            if (Controller.isAllocationRecording(status)) {
                System.out.println("Allocation recording: on");
            } else {
                System.out.println("Allocation recording: off");
            }
            if (Controller.isCPUTracing(status)) {
                System.out.println("CPU profiling: on (tracing)");
            } else if (Controller.isCPUSampling(status)) {
                System.out.println("CPU profiling: on (sampling)");
            } else if (Controller.isCPUCallCounting(status)) {
                System.out.println("CPU profiling: on (call counting)");
            } else {
                System.out.println("CPU profiling: off");
            }
            if (Controller.isMonitorProfiling(status)) {
                System.out.println("Monitor profiling: on");
            } else {
                System.out.println("Monitor profiling: off");
            }
            if (Controller.isStackTelemetry(status)) {
                System.out.println("Stack telemetry: on");
            } else {
                System.out.println("Stack telemetry: off");
            }
            if (Controller.isExceptionTelemetry(status)) {
                System.out.println("Exception telemetry: on");
            } else {
                System.out.println("Exception telemetry: off");
            }
            System.out.println("Deadlock detected: " + Controller.isDeadlockDetected(status));
            return;
        }
        Controller.printHelp();
    }
}

