/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.vagrant;

import com.google.common.collect.Maps;
import java.util.Map;

public class VagrantProviders {
    public static Map<String, String> PROVIDER_PLUGINS = Maps.newHashMap();

    private static void put(String pluginName, String providerName) {
        PROVIDER_PLUGINS.put(pluginName, providerName);
    }

    public static String providerForPlugin(String plugin) {
        return PROVIDER_PLUGINS.get(plugin);
    }

    static {
        VagrantProviders.put("docker-provider", "docker");
        VagrantProviders.put("vagrant-aws", "aws");
        VagrantProviders.put("vagrant-cloudstack", "cloudstack");
        VagrantProviders.put("vagrant-digitalocean", "digital_ocean");
        VagrantProviders.put("vagrant-hp", "hp");
        VagrantProviders.put("vagrant-joyent", "joyent");
        VagrantProviders.put("vagrant-kvm", "kvm");
        VagrantProviders.put("vagrant-libvirt", "libvirt");
        VagrantProviders.put("vagrant-lxc", "lxc");
        VagrantProviders.put("vagrant-managed-servers", "managed");
        VagrantProviders.put("vagrant-openstack", "openstack");
        VagrantProviders.put("vagrant-parallels", "parallels");
        VagrantProviders.put("vagrant-proxmox", "proxmox");
        VagrantProviders.put("vagrant-rackspace", "rackspace");
        VagrantProviders.put("vagrant-softlayer", "softlayer");
        VagrantProviders.put("vagrant-vsphere", "vsphere");
        VagrantProviders.put("vagrant-vmware-fusion", "vmware_fusion");
        VagrantProviders.put("vagrant-vmware-workstation", "vmware_workstation");
    }
}

