/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.emmet.filters;

import com.intellij.application.options.emmet.EmmetOptions;
import com.intellij.codeInsight.template.emmet.filters.ZenCodingFilter;
import com.intellij.codeInsight.template.emmet.nodes.GenerationNode;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.util.HtmlUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BemEmmetFilter
extends ZenCodingFilter {
    private static final String SUFFIX = "bem";
    private static final Key<BemState> BEM_STATE = Key.create((String)"BEM_STATE");
    private static final Pattern BLOCK_NAME_PATTERN = Pattern.compile("^[A-z]-");

    @Override
    @NotNull
    public String getDisplayName() {
        if ("BEM" == null) {
            BemEmmetFilter.$$$reportNull$$$0(0);
        }
        return "BEM";
    }

    @Override
    @NotNull
    public String getSuffix() {
        if (SUFFIX == null) {
            BemEmmetFilter.$$$reportNull$$$0(1);
        }
        return SUFFIX;
    }

    @Override
    public boolean isMyContext(@NotNull PsiElement context) {
        if (context == null) {
            BemEmmetFilter.$$$reportNull$$$0(2);
        }
        return context.getLanguage() instanceof XMLLanguage;
    }

    @Override
    @NotNull
    public GenerationNode filterNode(@NotNull GenerationNode node) {
        if (node == null) {
            BemEmmetFilter.$$$reportNull$$$0(3);
        }
        Map<String, String> attributes = node.getTemplateToken().getAttributes();
        String classAttributeName = this.getClassAttributeName();
        String classValue = attributes.get(classAttributeName);
        EmmetOptions emmetOptions = EmmetOptions.getInstance();
        if (classValue != null && emmetOptions != null) {
            String elementSeparator = emmetOptions.getBemElementSeparator();
            String modifierSeparator = emmetOptions.getBemModifierSeparator();
            String shortElementPrefix = emmetOptions.getBemShortElementPrefix();
            List classNames = ContainerUtil.map(HtmlUtil.splitClassNames(classValue), s -> BemEmmetFilter.normalizeClassName(s, elementSeparator, shortElementPrefix));
            BEM_STATE.set((UserDataHolder)node, (Object)new BemState(BemEmmetFilter.suggestBlockName(classNames), null, null));
            LinkedHashSet newClassNames = ContainerUtil.newLinkedHashSet();
            for (String className : classNames) {
                ContainerUtil.addAll((Collection)newClassNames, BemEmmetFilter.processClassName(className, node, elementSeparator, modifierSeparator));
            }
            attributes.put(classAttributeName, StringUtil.join((Collection)newClassNames, (String)" "));
        }
        GenerationNode generationNode = node;
        if (generationNode == null) {
            BemEmmetFilter.$$$reportNull$$$0(4);
        }
        return generationNode;
    }

    @NotNull
    public String getClassAttributeName() {
        if ("class" == null) {
            BemEmmetFilter.$$$reportNull$$$0(5);
        }
        return "class";
    }

    private static Iterable<String> processClassName(@NotNull String className, @NotNull GenerationNode node, @NotNull String elementSeparator, @NotNull String modifierSeparator) {
        if (className == null) {
            BemEmmetFilter.$$$reportNull$$$0(6);
        }
        if (node == null) {
            BemEmmetFilter.$$$reportNull$$$0(7);
        }
        if (elementSeparator == null) {
            BemEmmetFilter.$$$reportNull$$$0(8);
        }
        if (modifierSeparator == null) {
            BemEmmetFilter.$$$reportNull$$$0(9);
        }
        className = BemEmmetFilter.fillWithBemElements(className, node, elementSeparator);
        className = BemEmmetFilter.fillWithBemModifiers(className, node, modifierSeparator);
        BemState nodeBemState = (BemState)BEM_STATE.get((UserDataHolder)node);
        BemState bemState = BemEmmetFilter.extractBemStateFromClassName(className, elementSeparator, modifierSeparator);
        ArrayList result2 = ContainerUtil.newArrayList();
        if (!bemState.isEmpty()) {
            String nodeBlockValue = nodeBemState != null ? nodeBemState.getBlock() : null;
            String block = bemState.getBlock();
            if (StringUtil.isEmpty((String)block)) {
                block = StringUtil.notNullize((String)nodeBlockValue);
                bemState.setBlock(block);
            }
            String prefix = block;
            String element = bemState.getElement();
            if (StringUtil.isNotEmpty((String)element)) {
                prefix = prefix + elementSeparator + element;
            }
            result2.add(prefix);
            String modifier = bemState.getModifier();
            if (StringUtil.isNotEmpty((String)modifier)) {
                result2.add(prefix + modifierSeparator + modifier);
            }
            BemState newNodeBemState = bemState.copy();
            if (StringUtil.isNotEmpty((String)nodeBlockValue) && StringUtil.isEmpty((String)modifier)) {
                newNodeBemState.setBlock(nodeBlockValue);
            }
            BEM_STATE.set((UserDataHolder)node, (Object)newNodeBemState);
        } else {
            result2.add(className);
        }
        return result2;
    }

    @NotNull
    private static BemState extractBemStateFromClassName(@NotNull String className, String elementSeparator, String modifierSeparator) {
        if (className == null) {
            BemEmmetFilter.$$$reportNull$$$0(10);
        }
        BemState result2 = new BemState();
        int indexOfElementSeparator = className.indexOf(elementSeparator);
        if (indexOfElementSeparator >= 0) {
            result2.setBlock(className.substring(0, indexOfElementSeparator));
            result2.setElement(className.substring(indexOfElementSeparator + elementSeparator.length()));
            int lastIndexOfElementSeparator = className.lastIndexOf(elementSeparator);
            assert (lastIndexOfElementSeparator >= 0);
            int indexOfModifierSeparator = className.indexOf(modifierSeparator, lastIndexOfElementSeparator + elementSeparator.length());
            if (indexOfModifierSeparator >= 0) {
                result2.setModifier(className.substring(indexOfModifierSeparator + modifierSeparator.length()));
                result2.setElement(className.substring(indexOfElementSeparator + elementSeparator.length(), indexOfModifierSeparator));
            }
        } else {
            int indexOfModifierSeparator = className.indexOf(modifierSeparator);
            if (indexOfModifierSeparator >= 0) {
                result2.setBlock(className.substring(0, indexOfModifierSeparator));
                result2.setModifier(className.substring(indexOfModifierSeparator + modifierSeparator.length()));
            }
        }
        BemState bemState = result2;
        if (bemState == null) {
            BemEmmetFilter.$$$reportNull$$$0(11);
        }
        return bemState;
    }

    @NotNull
    private static String fillWithBemElements(@NotNull String className, @NotNull GenerationNode node, @NotNull String separator) {
        if (className == null) {
            BemEmmetFilter.$$$reportNull$$$0(12);
        }
        if (node == null) {
            BemEmmetFilter.$$$reportNull$$$0(13);
        }
        if (separator == null) {
            BemEmmetFilter.$$$reportNull$$$0(14);
        }
        String string = BemEmmetFilter.transformClassNameToBemFormat(className, separator, node, false);
        if (string == null) {
            BemEmmetFilter.$$$reportNull$$$0(15);
        }
        return string;
    }

    @NotNull
    private static String fillWithBemModifiers(@NotNull String className, @NotNull GenerationNode node, @NotNull String separator) {
        if (className == null) {
            BemEmmetFilter.$$$reportNull$$$0(16);
        }
        if (node == null) {
            BemEmmetFilter.$$$reportNull$$$0(17);
        }
        if (separator == null) {
            BemEmmetFilter.$$$reportNull$$$0(18);
        }
        String string = BemEmmetFilter.transformClassNameToBemFormat(className, separator, node, true);
        if (string == null) {
            BemEmmetFilter.$$$reportNull$$$0(19);
        }
        return string;
    }

    @NotNull
    private static String transformClassNameToBemFormat(@NotNull String className, @NotNull String separator, @NotNull GenerationNode node, boolean isModifierSeparator) {
        if (className == null) {
            BemEmmetFilter.$$$reportNull$$$0(20);
        }
        if (separator == null) {
            BemEmmetFilter.$$$reportNull$$$0(21);
        }
        if (node == null) {
            BemEmmetFilter.$$$reportNull$$$0(22);
        }
        Pair<String, Integer> cleanStringAndDepth = BemEmmetFilter.getCleanStringAndDepth(className, separator);
        Integer depth = (Integer)cleanStringAndDepth.second;
        if (depth > 0) {
            String prefix;
            GenerationNode donor = node;
            while (donor.getParent() != null && depth > 0) {
                donor = donor.getParent();
                Integer n = depth;
                Integer n2 = depth = Integer.valueOf(depth - 1);
            }
            BemState bemState = (BemState)BEM_STATE.get((UserDataHolder)donor);
            if (bemState != null && !StringUtil.isEmpty((String)(prefix = bemState.getBlock()))) {
                String element = bemState.getElement();
                if (isModifierSeparator && !StringUtil.isEmpty((String)element)) {
                    prefix = prefix + separator + element;
                }
                String string = prefix + separator + (String)cleanStringAndDepth.first;
                if (string == null) {
                    BemEmmetFilter.$$$reportNull$$$0(23);
                }
                return string;
            }
        }
        String string = className;
        if (string == null) {
            BemEmmetFilter.$$$reportNull$$$0(24);
        }
        return string;
    }

    @NotNull
    private static Pair<String, Integer> getCleanStringAndDepth(@NotNull String name, @NotNull String separator) {
        if (name == null) {
            BemEmmetFilter.$$$reportNull$$$0(25);
        }
        if (separator == null) {
            BemEmmetFilter.$$$reportNull$$$0(26);
        }
        int result2 = 0;
        while (!separator.isEmpty() && name.startsWith(separator)) {
            ++result2;
            name = name.substring(separator.length());
        }
        Pair pair = Pair.create((Object)name, (Object)result2);
        if (pair == null) {
            BemEmmetFilter.$$$reportNull$$$0(27);
        }
        return pair;
    }

    @NotNull
    private static String suggestBlockName(Iterable<String> classNames) {
        String result2 = (String)ContainerUtil.find(classNames, className -> BLOCK_NAME_PATTERN.matcher((CharSequence)className).matches());
        if (result2 == null) {
            result2 = (String)ContainerUtil.find(classNames, s -> s != null && !s.isEmpty() && Character.isLetter(s.charAt(0)));
        }
        String string = StringUtil.notNullize((String)result2);
        if (string == null) {
            BemEmmetFilter.$$$reportNull$$$0(28);
        }
        return string;
    }

    @NotNull
    private static String normalizeClassName(@NotNull String className, @NotNull String elementSeparator, @NotNull String shortElementPrefix) {
        if (className == null) {
            BemEmmetFilter.$$$reportNull$$$0(29);
        }
        if (elementSeparator == null) {
            BemEmmetFilter.$$$reportNull$$$0(30);
        }
        if (shortElementPrefix == null) {
            BemEmmetFilter.$$$reportNull$$$0(31);
        }
        if (shortElementPrefix.isEmpty() || !className.startsWith(shortElementPrefix)) {
            String string = className;
            if (string == null) {
                BemEmmetFilter.$$$reportNull$$$0(32);
            }
            return string;
        }
        StringBuilder result2 = new StringBuilder();
        while (className.startsWith(shortElementPrefix)) {
            className = className.substring(shortElementPrefix.length());
            result2.append(elementSeparator);
        }
        String string = result2.append(className).toString();
        if (string == null) {
            BemEmmetFilter.$$$reportNull$$$0(33);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 25: 
            case 26: 
            case 29: 
            case 30: 
            case 31: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 25: 
            case 26: 
            case 29: 
            case 30: 
            case 31: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/template/emmet/filters/BemEmmetFilter";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: 
            case 7: 
            case 13: 
            case 17: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 6: 
            case 10: 
            case 12: 
            case 16: 
            case 20: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 8: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementSeparator";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifierSeparator";
                break;
            }
            case 14: 
            case 18: 
            case 21: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "separator";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shortElementPrefix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuffix";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 25: 
            case 26: 
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/template/emmet/filters/BemEmmetFilter";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "filterNode";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassAttributeName";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "extractBemStateFromClassName";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "fillWithBemElements";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "fillWithBemModifiers";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "transformClassNameToBemFormat";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getCleanStringAndDepth";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestBlockName";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "normalizeClassName";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isMyContext";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "filterNode";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "processClassName";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "extractBemStateFromClassName";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "fillWithBemElements";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "fillWithBemModifiers";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "transformClassNameToBemFormat";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getCleanStringAndDepth";
                break;
            }
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "normalizeClassName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 25: 
            case 26: 
            case 29: 
            case 30: 
            case 31: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class BemState {
        @Nullable
        private String block;
        @Nullable
        private String element;
        @Nullable
        private String modifier;

        private BemState() {
        }

        private BemState(@Nullable String block, @Nullable String element, @Nullable String modifier) {
            this.block = block;
            this.element = element;
            this.modifier = modifier;
        }

        public void setModifier(@Nullable String modifier) {
            this.modifier = modifier;
        }

        public void setElement(@Nullable String element) {
            this.element = element;
        }

        public void setBlock(@Nullable String block) {
            this.block = block;
        }

        @Nullable
        public String getBlock() {
            return this.block;
        }

        @Nullable
        public String getElement() {
            return this.element;
        }

        @Nullable
        public String getModifier() {
            return this.modifier;
        }

        public boolean isEmpty() {
            return StringUtil.isEmpty((String)this.block) && StringUtil.isEmpty((String)this.element) && StringUtil.isEmpty((String)this.modifier);
        }

        @NotNull
        public BemState copy() {
            BemState bemState = new BemState(this.block, this.element, this.modifier);
            if (bemState == null) {
                BemState.$$$reportNull$$$0(0);
            }
            return bemState;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/emmet/filters/BemEmmetFilter$BemState", "copy"));
        }
    }
}

