/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesBrowser;
import com.intellij.openapi.vcs.changes.issueLinks.IssueLinkHtmlRenderer;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeListImpl;
import com.intellij.ui.BrowserHyperlinkListener;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SeparatorFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommittedChangeListPanel
extends JPanel
implements DataProvider {
    private final JLabel myDescriptionLabel;
    private final CommittedChangesBrowser myChangesBrowser;
    private final JEditorPane myCommitMessageArea;
    private final JPanel myCommitMessagePanel;
    private final Project myProject;
    private CommittedChangeList myChangeList;
    private Collection<Change> myChanges;

    public CommittedChangeListPanel(@NotNull Project project) {
        if (project == null) {
            CommittedChangeListPanel.$$$reportNull$$$0(0);
        }
        super(new BorderLayout());
        this.myProject = project;
        this.myDescriptionLabel = new JLabel();
        this.myDescriptionLabel.setBorder(BorderFactory.createEtchedBorder());
        this.myChangesBrowser = new MyChangesBrowser(this.myProject);
        this.myCommitMessageArea = new JEditorPane("text/html", "");
        this.myCommitMessageArea.setBorder(JBUI.Borders.empty((int)3));
        this.myCommitMessageArea.setEditable(false);
        this.myCommitMessageArea.setBackground(UIUtil.getComboBoxDisabledBackground());
        this.myCommitMessageArea.addHyperlinkListener((HyperlinkListener)BrowserHyperlinkListener.INSTANCE);
        this.myCommitMessagePanel = JBUI.Panels.simplePanel((Component)ScrollPaneFactory.createScrollPane((Component)this.myCommitMessageArea)).addToTop((Component)SeparatorFactory.createSeparator((String)VcsBundle.message((String)"label.commit.comment", (Object[])new Object[0]), (JComponent)this.myCommitMessageArea));
        Splitter splitter = new Splitter(true, 0.8f);
        splitter.setFirstComponent((JComponent)this.myChangesBrowser);
        splitter.setSecondComponent((JComponent)this.myCommitMessagePanel);
        this.add((Component)splitter, "Center");
        this.add((Component)this.myDescriptionLabel, "North");
        this.setChangeList((CommittedChangeList)CommittedChangeListPanel.createChangeList(Collections.emptyList()));
        this.setDescription(null);
    }

    public void setChangeList(@NotNull CommittedChangeList changeList) {
        if (changeList == null) {
            CommittedChangeListPanel.$$$reportNull$$$0(1);
        }
        this.myChangeList = changeList;
        this.myChanges = changeList.getChanges();
        this.myChangesBrowser.setChangesToDisplay(this.myChanges);
        this.myCommitMessageArea.setText(IssueLinkHtmlRenderer.formatTextIntoHtml(this.myProject, changeList.getComment().trim()));
        this.myCommitMessageArea.setCaretPosition(0);
    }

    public void setShowCommitMessage(boolean value) {
        this.myCommitMessagePanel.setVisible(value);
    }

    public void setDescription(@Nullable String description) {
        this.myDescriptionLabel.setText(XmlStringUtil.wrapInHtml((CharSequence)StringUtil.notNullize((String)description)));
        this.myDescriptionLabel.setVisible(description != null);
    }

    @NotNull
    public JComponent getPreferredFocusedComponent() {
        JComponent jComponent = this.myChangesBrowser.getPreferredFocusedComponent();
        if (jComponent == null) {
            CommittedChangeListPanel.$$$reportNull$$$0(2);
        }
        return jComponent;
    }

    @NotNull
    public CommittedChangesBrowser getChangesBrowser() {
        CommittedChangesBrowser committedChangesBrowser = this.myChangesBrowser;
        if (committedChangesBrowser == null) {
            CommittedChangeListPanel.$$$reportNull$$$0(3);
        }
        return committedChangesBrowser;
    }

    public Object getData(@NotNull @NonNls String dataId) {
        if (dataId == null) {
            CommittedChangeListPanel.$$$reportNull$$$0(4);
        }
        if (VcsDataKeys.CHANGES.is(dataId)) {
            return this.myChanges.toArray(new Change[0]);
        }
        if (VcsDataKeys.VCS.is(dataId)) {
            AbstractVcs vcs = this.myChangeList.getVcs();
            return vcs == null ? null : vcs.getKeyInstanceMethod();
        }
        if (VcsDataKeys.CHANGE_LISTS.is(dataId)) {
            return new ChangeList[]{this.myChangeList};
        }
        return null;
    }

    @NotNull
    public static CommittedChangeListImpl createChangeList(@NotNull Collection<Change> changes2) {
        if (changes2 == null) {
            CommittedChangeListPanel.$$$reportNull$$$0(5);
        }
        CommittedChangeListImpl committedChangeListImpl = new CommittedChangeListImpl("", "", "", -1L, new Date(0L), changes2);
        if (committedChangeListImpl == null) {
            CommittedChangeListPanel.$$$reportNull$$$0(6);
        }
        return committedChangeListImpl;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changeList";
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/ui/CommittedChangeListPanel";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/ui/CommittedChangeListPanel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreferredFocusedComponent";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getChangesBrowser";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createChangeList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setChangeList";
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createChangeList";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyChangesBrowser
    extends CommittedChangesBrowser {
        MyChangesBrowser(@NotNull Project project) {
            if (project == null) {
                MyChangesBrowser.$$$reportNull$$$0(0);
            }
            super(project);
        }

        @Override
        @NotNull
        protected List<AnAction> createPopupMenuActions() {
            List list2 = ContainerUtil.append(super.createPopupMenuActions(), (Object[])new AnAction[]{ActionManager.getInstance().getAction("Vcs.CopyRevisionNumberAction")});
            if (list2 == null) {
                MyChangesBrowser.$$$reportNull$$$0(1);
            }
            return list2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/changes/ui/CommittedChangeListPanel$MyChangesBrowser";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/changes/ui/CommittedChangeListPanel$MyChangesBrowser";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createPopupMenuActions";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

