/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.impl.ProjectLevelVcsManagerImpl;
import java.util.Arrays;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class BackgroundableActionLock {
    @NotNull
    private final Project myProject;
    @NotNull
    private final Object[] myKeys;

    BackgroundableActionLock(@NotNull Project project, @NotNull Object[] keys) {
        if (project == null) {
            BackgroundableActionLock.$$$reportNull$$$0(0);
        }
        if (keys == null) {
            BackgroundableActionLock.$$$reportNull$$$0(1);
        }
        this.myProject = project;
        this.myKeys = keys;
    }

    public boolean isLocked() {
        return BackgroundableActionLock.isLocked(this.myProject, this.myKeys);
    }

    public void lock() {
        BackgroundableActionLock.lock(this.myProject, this.myKeys);
    }

    public void unlock() {
        BackgroundableActionLock.unlock(this.myProject, this.myKeys);
    }

    @NotNull
    public static BackgroundableActionLock getLock(@NotNull Project project, Object ... keys) {
        if (project == null) {
            BackgroundableActionLock.$$$reportNull$$$0(2);
        }
        if (keys == null) {
            BackgroundableActionLock.$$$reportNull$$$0(3);
        }
        BackgroundableActionLock backgroundableActionLock = new BackgroundableActionLock(project, keys);
        if (backgroundableActionLock == null) {
            BackgroundableActionLock.$$$reportNull$$$0(4);
        }
        return backgroundableActionLock;
    }

    public static boolean isLocked(@NotNull Project project, Object ... keys) {
        if (project == null) {
            BackgroundableActionLock.$$$reportNull$$$0(5);
        }
        if (keys == null) {
            BackgroundableActionLock.$$$reportNull$$$0(6);
        }
        return BackgroundableActionLock.getManager(project).isBackgroundTaskRunning(keys);
    }

    public static void lock(@NotNull Project project, Object ... keys) {
        if (project == null) {
            BackgroundableActionLock.$$$reportNull$$$0(7);
        }
        if (keys == null) {
            BackgroundableActionLock.$$$reportNull$$$0(8);
        }
        BackgroundableActionLock.getManager(project).startBackgroundTask(keys);
    }

    public static void unlock(@NotNull Project project, Object ... keys) {
        if (project == null) {
            BackgroundableActionLock.$$$reportNull$$$0(9);
        }
        if (keys == null) {
            BackgroundableActionLock.$$$reportNull$$$0(10);
        }
        BackgroundableActionLock.getManager(project).stopBackgroundTask(keys);
    }

    @NotNull
    private static ProjectLevelVcsManagerImpl getManager(@NotNull Project project) {
        if (project == null) {
            BackgroundableActionLock.$$$reportNull$$$0(11);
        }
        ProjectLevelVcsManagerImpl projectLevelVcsManagerImpl = (ProjectLevelVcsManagerImpl)ProjectLevelVcsManager.getInstance((Project)project);
        if (projectLevelVcsManagerImpl == null) {
            BackgroundableActionLock.$$$reportNull$$$0(12);
        }
        return projectLevelVcsManagerImpl;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BackgroundableActionLock lock = (BackgroundableActionLock)o;
        return this.myProject.equals(lock.myProject) && Arrays.equals(this.myKeys, lock.myKeys);
    }

    public int hashCode() {
        int result2 = Objects.hash(this.myProject);
        result2 = 31 * result2 + Arrays.hashCode(this.myKeys);
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keys";
                break;
            }
            case 4: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/impl/BackgroundableActionLock";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/impl/BackgroundableActionLock";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getLock";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getLock";
                break;
            }
            case 4: 
            case 12: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isLocked";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "lock";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "unlock";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getManager";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

