/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.AtomicClearableLazyValue;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.PairProcessor;
import com.intellij.util.PatternUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.Transient;
import com.jetbrains.jsonSchema.JsonMappingKind;
import com.jetbrains.jsonSchema.ide.JsonSchemaService;
import com.jetbrains.jsonSchema.impl.JsonSchemaObject;
import com.jetbrains.jsonSchema.impl.JsonSchemaVersion;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Tag(value="SchemaInfo")
public class UserDefinedJsonSchemaConfiguration {
    private static final Comparator<Item> ITEM_COMPARATOR = (o1, o2) -> {
        if (o1.isPattern() != o2.isPattern()) {
            return o1.isPattern() ? -1 : 1;
        }
        if (o1.isDirectory() != o2.isDirectory()) {
            return o1.isDirectory() ? -1 : 1;
        }
        return o1.path.compareToIgnoreCase(o2.path);
    };
    public String name;
    public String relativePathToSchema;
    public JsonSchemaVersion schemaVersion;
    public boolean applicationDefined;
    public List<Item> patterns;
    @Transient
    private final AtomicClearableLazyValue<List<PairProcessor<Project, VirtualFile>>> myCalculatedPatterns;

    public UserDefinedJsonSchemaConfiguration() {
        this.schemaVersion = JsonSchemaVersion.SCHEMA_4;
        this.patterns = new SmartList();
        this.myCalculatedPatterns = new AtomicClearableLazyValue<List<PairProcessor<Project, VirtualFile>>>(){

            @NotNull
            protected List<PairProcessor<Project, VirtualFile>> compute() {
                List list2 = UserDefinedJsonSchemaConfiguration.this.recalculatePatterns();
                if (list2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                return list2;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/jsonSchema/UserDefinedJsonSchemaConfiguration$1", "compute"));
            }
        };
    }

    public UserDefinedJsonSchemaConfiguration(@NotNull String name, JsonSchemaVersion schemaVersion, @NotNull String relativePathToSchema, boolean applicationDefined, @Nullable List<Item> patterns) {
        if (name == null) {
            UserDefinedJsonSchemaConfiguration.$$$reportNull$$$0(0);
        }
        if (relativePathToSchema == null) {
            UserDefinedJsonSchemaConfiguration.$$$reportNull$$$0(1);
        }
        this.schemaVersion = JsonSchemaVersion.SCHEMA_4;
        this.patterns = new SmartList();
        this.myCalculatedPatterns = new /* invalid duplicate definition of identical inner class */;
        this.name = name;
        this.relativePathToSchema = relativePathToSchema;
        this.schemaVersion = schemaVersion;
        this.applicationDefined = applicationDefined;
        this.setPatterns(patterns);
    }

    public String getName() {
        return this.name;
    }

    public void setName(@NotNull String name) {
        if (name == null) {
            UserDefinedJsonSchemaConfiguration.$$$reportNull$$$0(2);
        }
        this.name = name;
    }

    public String getRelativePathToSchema() {
        return this.relativePathToSchema;
    }

    public JsonSchemaVersion getSchemaVersion() {
        return this.schemaVersion;
    }

    public void setSchemaVersion(JsonSchemaVersion schemaVersion) {
        this.schemaVersion = schemaVersion;
    }

    public void setRelativePathToSchema(String relativePathToSchema) {
        this.relativePathToSchema = relativePathToSchema;
    }

    public boolean isApplicationDefined() {
        return this.applicationDefined;
    }

    public void setApplicationDefined(boolean applicationDefined) {
        this.applicationDefined = applicationDefined;
    }

    public List<Item> getPatterns() {
        return this.patterns;
    }

    public void setPatterns(@Nullable List<Item> patterns) {
        this.patterns.clear();
        if (patterns != null) {
            this.patterns.addAll(patterns);
        }
        Collections.sort(this.patterns, ITEM_COMPARATOR);
        this.myCalculatedPatterns.drop();
    }

    public void refreshPatterns() {
        this.myCalculatedPatterns.drop();
    }

    @NotNull
    public List<PairProcessor<Project, VirtualFile>> getCalculatedPatterns() {
        List list2 = (List)this.myCalculatedPatterns.getValue();
        if (list2 == null) {
            UserDefinedJsonSchemaConfiguration.$$$reportNull$$$0(3);
        }
        return list2;
    }

    private List<PairProcessor<Project, VirtualFile>> recalculatePatterns() {
        SmartList result2 = new SmartList();
        for (Item patternText : this.patterns) {
            switch (patternText.mappingKind) {
                case File: {
                    result2.add((project, vfile) -> vfile.equals(UserDefinedJsonSchemaConfiguration.getRelativeFile(project, patternText)) || vfile.getUrl().equals(patternText.getPath()));
                    break;
                }
                case Pattern: {
                    String pathText = patternText.getPath().replace(File.separatorChar, '/').replace('\\', '/');
                    Pattern pattern = pathText.isEmpty() ? PatternUtil.NOTHING : (pathText.indexOf(47) >= 0 ? PatternUtil.compileSafe((String)(".*/" + PatternUtil.convertToRegex((String)pathText)), (Pattern)PatternUtil.NOTHING) : PatternUtil.fromMask((String)pathText));
                    result2.add((project, file2) -> JsonSchemaObject.matchPattern(pattern, pathText.indexOf(47) >= 0 ? file2.getPath() : file2.getName()));
                    break;
                }
                case Directory: {
                    result2.add((project, vfile) -> {
                        VirtualFile relativeFile = UserDefinedJsonSchemaConfiguration.getRelativeFile(project, patternText);
                        if (relativeFile == null || !VfsUtilCore.isAncestor((VirtualFile)relativeFile, (VirtualFile)vfile, (boolean)true)) {
                            return false;
                        }
                        JsonSchemaService service2 = JsonSchemaService.Impl.get(project);
                        return service2.isApplicableToFile((VirtualFile)vfile);
                    });
                }
            }
        }
        return result2;
    }

    @Nullable
    private static VirtualFile getRelativeFile(@NotNull Project project, @NotNull Item pattern) {
        if (project == null) {
            UserDefinedJsonSchemaConfiguration.$$$reportNull$$$0(4);
        }
        if (pattern == null) {
            UserDefinedJsonSchemaConfiguration.$$$reportNull$$$0(5);
        }
        if (project.getBasePath() == null) {
            return null;
        }
        String path = FileUtilRt.toSystemIndependentName((String)StringUtil.notNullize((String)pattern.path));
        List<String> parts = UserDefinedJsonSchemaConfiguration.pathToPartsList(path);
        if (parts.isEmpty()) {
            return project.getBaseDir();
        }
        return VfsUtil.findRelativeFile((VirtualFile)project.getBaseDir(), (String[])ArrayUtil.toStringArray(parts));
    }

    @NotNull
    private static List<String> pathToPartsList(@NotNull String path) {
        if (path == null) {
            UserDefinedJsonSchemaConfiguration.$$$reportNull$$$0(6);
        }
        List list2 = ContainerUtil.filter((Collection)StringUtil.split((String)path, (String)"/"), s -> !".".equals(s));
        if (list2 == null) {
            UserDefinedJsonSchemaConfiguration.$$$reportNull$$$0(7);
        }
        return list2;
    }

    @NotNull
    private static String[] pathToParts(@NotNull String path) {
        if (path == null) {
            UserDefinedJsonSchemaConfiguration.$$$reportNull$$$0(8);
        }
        String[] stringArray = ArrayUtil.toStringArray(UserDefinedJsonSchemaConfiguration.pathToPartsList(path));
        if (stringArray == null) {
            UserDefinedJsonSchemaConfiguration.$$$reportNull$$$0(9);
        }
        return stringArray;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserDefinedJsonSchemaConfiguration info = (UserDefinedJsonSchemaConfiguration)o;
        if (this.applicationDefined != info.applicationDefined) {
            return false;
        }
        if (this.schemaVersion != info.schemaVersion) {
            return false;
        }
        if (!Objects.equals(this.name, info.name)) {
            return false;
        }
        if (!Objects.equals(this.relativePathToSchema, info.relativePathToSchema)) {
            return false;
        }
        return Objects.equals(this.patterns, info.patterns);
    }

    public int hashCode() {
        int result2 = this.name != null ? this.name.hashCode() : 0;
        result2 = 31 * result2 + (this.relativePathToSchema != null ? this.relativePathToSchema.hashCode() : 0);
        result2 = 31 * result2 + (this.applicationDefined ? 1 : 0);
        result2 = 31 * result2 + (this.patterns != null ? this.patterns.hashCode() : 0);
        result2 = 31 * result2 + this.schemaVersion.hashCode();
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 7: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 7: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativePathToSchema";
                break;
            }
            case 3: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/jsonSchema/UserDefinedJsonSchemaConfiguration";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/jsonSchema/UserDefinedJsonSchemaConfiguration";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getCalculatedPatterns";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "pathToPartsList";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "pathToParts";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 3: 
            case 7: 
            case 9: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getRelativeFile";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "pathToPartsList";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "pathToParts";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 7: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Item {
        public String path;
        public JsonMappingKind mappingKind = JsonMappingKind.File;

        public Item() {
        }

        public Item(String path, JsonMappingKind mappingKind) {
            this.path = Item.neutralizePath(path);
            this.mappingKind = mappingKind;
        }

        public Item(String path, boolean isPattern, boolean isDirectory) {
            this.path = Item.neutralizePath(path);
            this.mappingKind = isPattern ? JsonMappingKind.Pattern : (isDirectory ? JsonMappingKind.Directory : JsonMappingKind.File);
        }

        @NotNull
        private static String normalizePath(String path) {
            if (Item.preserveSlashes(path)) {
                String string = path;
                if (string == null) {
                    Item.$$$reportNull$$$0(0);
                }
                return string;
            }
            String string = StringUtil.trimEnd((String)FileUtilRt.toSystemDependentName((String)path), (char)File.separatorChar);
            if (string == null) {
                Item.$$$reportNull$$$0(1);
            }
            return string;
        }

        private static boolean preserveSlashes(String path) {
            return StringUtil.startsWith((CharSequence)path, (CharSequence)"http:") || StringUtil.startsWith((CharSequence)path, (CharSequence)"https:") || StringUtil.startsWith((CharSequence)path, (CharSequence)"mock:");
        }

        @NotNull
        private static String neutralizePath(String path) {
            if (Item.preserveSlashes(path)) {
                String string = path;
                if (string == null) {
                    Item.$$$reportNull$$$0(2);
                }
                return string;
            }
            String string = StringUtil.trimEnd((String)FileUtilRt.toSystemIndependentName((String)path), (char)'/');
            if (string == null) {
                Item.$$$reportNull$$$0(3);
            }
            return string;
        }

        public String getPath() {
            return Item.normalizePath(this.path);
        }

        public void setPath(String path) {
            this.path = Item.neutralizePath(path);
        }

        public String getError() {
            switch (this.mappingKind) {
                case File: {
                    return !StringUtil.isEmpty((String)this.path) ? null : "Empty file path doesn't match anything";
                }
                case Pattern: {
                    return !StringUtil.isEmpty((String)this.path) ? null : "Empty pattern matches nothing";
                }
                case Directory: {
                    return null;
                }
            }
            return "Unknown mapping kind";
        }

        public boolean isPattern() {
            return this.mappingKind == JsonMappingKind.Pattern;
        }

        public void setPattern(boolean pattern) {
            this.mappingKind = pattern ? JsonMappingKind.Pattern : JsonMappingKind.File;
        }

        public boolean isDirectory() {
            return this.mappingKind == JsonMappingKind.Directory;
        }

        public void setDirectory(boolean directory) {
            this.mappingKind = directory ? JsonMappingKind.Directory : JsonMappingKind.File;
        }

        public String getPresentation() {
            if (this.mappingKind == JsonMappingKind.Directory && StringUtil.isEmpty((String)this.path)) {
                return this.mappingKind.getPrefix() + "[Project Directory]";
            }
            return this.mappingKind.getPrefix() + this.getPath();
        }

        public String[] getPathParts() {
            return UserDefinedJsonSchemaConfiguration.pathToParts(this.path);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Item item = (Item)o;
            if (this.mappingKind != item.mappingKind) {
                return false;
            }
            return Objects.equals(this.path, item.path);
        }

        public int hashCode() {
            int result2 = Objects.hashCode(this.path);
            result2 = 31 * result2 + Objects.hashCode((Object)this.mappingKind);
            return result2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/jetbrains/jsonSchema/UserDefinedJsonSchemaConfiguration$Item";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "normalizePath";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "neutralizePath";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

