/*
 * Decompiled with CFR 0.152.
 */
package org.jrubyparser.util.diff;

import org.jrubyparser.ast.Node;

public class Change {
    private Node oldNode;
    private Node newNode;
    private int oldCost;
    private int newCost;

    public Change(Node newNode, int newCost, Node oldNode, int oldCost) {
        this.setNewNode(newNode);
        this.setOldNode(oldNode);
        this.setNewCost(newCost);
        this.setOldCost(oldCost);
    }

    public final void setNewNode(Node newNode) {
        this.newNode = newNode;
    }

    public final void setOldNode(Node oldNode) {
        this.oldNode = oldNode;
    }

    public final void setNewCost(int newCost) {
        this.newCost = newCost;
    }

    public final void setOldCost(int oldCost) {
        this.oldCost = oldCost;
    }

    public Node getOldNode() {
        return this.oldNode;
    }

    public Node getNewNode() {
        return this.newNode;
    }

    public int getOldCost() {
        return this.oldCost;
    }

    public int getNewCost() {
        return this.newCost;
    }

    public int getTotalCost() {
        return this.newCost + this.oldCost;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(60);
        builder.append("\nChange: ");
        if (this.getOldNode() != null) {
            builder.append("\nOld Node: ").append(this.getOldNode()).append(" Complexity: ").append(this.getOldCost()).append(" Position: ").append(this.getOldNode().getPosition()).append("\n");
        }
        if (this.getNewNode() != null) {
            builder.append("\nNew Node: ").append(this.getNewNode()).append(" Complexity: ").append(this.getNewCost()).append(" Position: ").append(this.getNewNode().getPosition()).append("\n");
        }
        return builder.toString();
    }
}

