/*
 * Decompiled with CFR 0.152.
 */
package org.jrubyparser.util.diff;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jrubyparser.ast.MethodDefNode;
import org.jrubyparser.ast.NewlineNode;
import org.jrubyparser.ast.Node;
import org.jrubyparser.ast.NodeType;
import org.jrubyparser.util.diff.Change;
import org.jrubyparser.util.diff.IsJunk;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SequenceMatcher {
    protected IsJunk isJunk;
    protected Node newNode;
    protected Node oldNode;
    protected List<Change> diffNodes;

    public SequenceMatcher(Node newNode, Node oldNode) {
        this(newNode, oldNode, null);
    }

    public SequenceMatcher(Node newNode, Node oldNode, IsJunk isJunk) {
        this.isJunk = isJunk;
        this.diffNodes = new ArrayList<Change>();
        this.setSequences(newNode, oldNode);
    }

    public final void setSequences(Node newNode, Node oldNode) {
        this.setNewNode(newNode);
        this.setOldNode(oldNode);
    }

    public void setNewNode(Node newNode) {
        this.newNode = newNode;
        this.diffNodes.clear();
    }

    public void setOldNode(Node oldNode) {
        this.oldNode = oldNode;
        this.diffNodes.clear();
    }

    public Node getNewNode() {
        return this.newNode;
    }

    public Node getOldNode() {
        return this.oldNode;
    }

    protected void sortNodesIntoDiff(Node childNew, Node childOld) {
        if (childNew.isSame(childOld)) {
            if (childNew.isLeaf()) {
                if (childOld.isLeaf()) {
                    return;
                }
                this.deletedNode(childOld);
            } else if (childOld.isLeaf()) {
                this.insertedNode(childNew);
            } else {
                this.findChanges(childNew, childOld);
            }
        } else {
            this.handleMismatchedNodes(childNew, childOld);
        }
    }

    protected void handleMismatchedNodes(Node childNew, Node childOld) {
        List<Node> oldSiblings = childOld.getParent().childNodes();
        boolean nmatch = false;
        boolean omatch = false;
        for (Node sibling : childNew.getParent().childNodes()) {
            if (!sibling.isSame(childOld)) continue;
            this.modifiedNode(sibling, childOld);
            this.findChanges(sibling, childOld);
            omatch = true;
            break;
        }
        for (Node sibling : oldSiblings) {
            if (!sibling.isSame(childNew)) continue;
            this.modifiedNode(childNew, sibling);
            this.findChanges(childNew, sibling);
            nmatch = true;
            break;
        }
        if (!nmatch || !omatch) {
            this.insertedNode(childNew);
            this.deletedNode(childOld);
        }
    }

    protected void insertedNode(Node node) {
        this.diffNodes.add(new Change(node, this.calcComplexity(node), null, 0));
    }

    protected void deletedNode(Node node) {
        this.diffNodes.add(new Change(null, 0, node, this.calcComplexity(node)));
    }

    protected void modifiedNode(Node newNode, Node oldNode) {
        this.diffNodes.add(new Change(newNode, this.calcComplexity(newNode), oldNode, this.calcComplexity(oldNode)));
    }

    protected void findChanges(Node newNode, Node oldNode) {
        if (oldNode == null || newNode == null) {
            return;
        }
        Iterator<Node> oldChildren = oldNode.childNodes().iterator();
        block0: for (Node childNew : newNode.childNodes()) {
            if (this.checkForJunk(childNew = this.stripOutNewlines(childNew))) continue;
            if (oldChildren.hasNext()) {
                Node childOld = this.stripOutNewlines(oldChildren.next());
                while (this.checkForJunk(childOld)) {
                    if (!oldChildren.hasNext()) continue block0;
                    childOld = this.stripOutNewlines(oldChildren.next());
                }
                if (childNew.getNodeType() == NodeType.BLOCKNODE || childOld.getNodeType() == NodeType.BLOCKNODE) {
                    this.handleBlockNodes(childNew, childOld);
                    continue;
                }
                this.sortNodesIntoDiff(childNew, childOld);
                continue;
            }
            this.insertedNode(childNew);
        }
    }

    protected void handleBlockNodes(Node childNew, Node childOld) {
        if (childNew.getNodeType() == NodeType.BLOCKNODE) {
            if (childOld.getNodeType() == NodeType.BLOCKNODE) {
                this.findChanges(childNew, childOld);
            } else {
                this.findChanges(childNew, childOld.getParent());
            }
        } else if (childOld.getNodeType() == NodeType.BLOCKNODE) {
            this.findChanges(childNew.getParent(), childOld);
        }
    }

    protected boolean checkForJunk(Node node) {
        return node.getNodeType() != NodeType.BLOCKNODE && this.isJunk != null ? this.isJunk.checkJunk(node) : false;
    }

    protected Node stripOutNewlines(Node node) {
        return node.getNodeType() == NodeType.NEWLINENODE ? ((NewlineNode)node).getNextNode() : node;
    }

    protected void checkDiffForMoves() {
        ArrayList<Change> diffClone = new ArrayList<Change>(this.diffNodes);
        for (Change change : diffClone) {
            if (change.getOldNode() == null) continue;
            Node oNode = change.getOldNode();
            for (Change newChange : diffClone) {
                if (newChange.getNewNode() == null) continue;
                Node nNode = newChange.getNewNode();
                if (this.diffNodes.indexOf(change) == this.diffNodes.indexOf(newChange)) continue;
                if (oNode.isSame(nNode) && this.diffNodes.contains(change)) {
                    this.diffNodes.set(this.diffNodes.indexOf(change), new Change(nNode, this.calcComplexity(nNode), oNode, this.calcComplexity(oNode)));
                    this.diffNodes.remove(newChange);
                    this.findChanges(nNode, oNode);
                    this.checkDiffForMoves();
                }
                if (oNode.getNodeType() != NodeType.DEFNNODE || nNode.getNodeType() != NodeType.DEFNNODE || !((MethodDefNode)oNode).isNameMatch(((MethodDefNode)nNode).getName()) || !this.diffNodes.contains(change)) continue;
                this.diffNodes.set(this.diffNodes.indexOf(change), new Change(nNode, this.calcComplexity(nNode), oNode, this.calcComplexity(oNode)));
                this.diffNodes.remove(newChange);
                this.findChanges(nNode, oNode);
                this.checkDiffForMoves();
            }
        }
    }

    public List<Change> getDiffNodes() {
        if (this.diffNodes.isEmpty()) {
            this.diffNodes = new ArrayList<Change>();
            this.findChanges(this.getNewNode(), this.getOldNode());
            this.checkDiffForMoves();
        }
        return this.diffNodes;
    }

    public int calcComplexity(Node node) {
        if (node.isLeaf()) {
            return 1;
        }
        int complexity = 1;
        for (Node child : node.childNodes()) {
            complexity += this.calcComplexity(child);
        }
        return complexity;
    }
}

