/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JavaScriptFileType;
import com.intellij.lang.javascript.dialects.ECMA6LanguageDialect;
import com.intellij.lang.javascript.dialects.ECMAL4LanguageDialect;
import com.intellij.lang.javascript.dialects.FlowJSLanguageDialect;
import com.intellij.lang.javascript.dialects.GwtLanguageDialect;
import com.intellij.lang.javascript.dialects.JS15LanguageDialect;
import com.intellij.lang.javascript.dialects.JS16LanguageDialect;
import com.intellij.lang.javascript.dialects.JS17LanguageDialect;
import com.intellij.lang.javascript.dialects.JS18LanguageDialect;
import com.intellij.lang.javascript.dialects.JSXHarmonyLanguageDialect;
import com.intellij.lang.javascript.dialects.TypeScriptJSXLanguageDialect;
import com.intellij.lang.javascript.dialects.TypeScriptLanguageDialect;
import com.intellij.lang.javascript.nashorn.NashornJSLanguageDialect;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class JavaScriptSupportLoader {
    public static final LanguageFileType JAVASCRIPT = JavaScriptFileType.INSTANCE;
    public static final JSLanguageDialect JAVASCRIPT_1_5 = new JS15LanguageDialect();
    public static final JSLanguageDialect JAVASCRIPT_1_6 = new JS16LanguageDialect();
    public static final JSLanguageDialect JAVASCRIPT_1_7 = new JS17LanguageDialect();
    public static final JSLanguageDialect JAVASCRIPT_1_8 = new JS18LanguageDialect();
    public static final JSLanguageDialect ECMA_SCRIPT_L4 = new ECMAL4LanguageDialect();
    public static final JSLanguageDialect GWT_DIALECT = new GwtLanguageDialect();
    public static final JSLanguageDialect ECMA_SCRIPT_6 = new ECMA6LanguageDialect();
    public static final JSLanguageDialect JSX_HARMONY = new JSXHarmonyLanguageDialect();
    public static final JSLanguageDialect TYPESCRIPT = new TypeScriptLanguageDialect();
    public static final JSLanguageDialect TYPESCRIPT_JSX = new TypeScriptJSXLanguageDialect();
    public static final JSLanguageDialect NASHORN_JS = new NashornJSLanguageDialect();
    public static final JSLanguageDialect FLOW_JS = new FlowJSLanguageDialect();
    @NonNls
    public static final String JS_FILE_EXTENSION = "js";
    @NonNls
    public static final String ECMA_SCRIPT_L4_FILE_EXTENSION = "as";
    @NonNls
    public static final String ECMA_SCRIPT_L4_FILE_EXTENSION2 = "js2";
    @NonNls
    public static final String ECMA_SCRIPT_L4_FILE_EXTENSION3 = "es";
    @NonNls
    public static final String TYPESCRIPT_FILE_EXTENSION = "ts";
    @NonNls
    public static final String FLOW_FILE_EXTENSION = "js.flow";
    @NonNls
    public static final String TSX_FILE_EXTENSION = "tsx";
    @NonNls
    public static final String JSX_FILE_EXTENSION = "jsx";
    @NonNls
    public static final String ATSCRIPT_FILE_EXTENSION = "ats";
    @NonNls
    public static final String FXG_FILE_EXTENSION = "fxg";
    @NonNls
    public static final String FXG_FILE_EXTENSION_DOT = ".fxg";
    @NonNls
    public static final String MXML_FILE_EXTENSION = "mxml";
    @NonNls
    public static final String MXML_FILE_EXTENSION_DOT = ".mxml";
    @NonNls
    public static final String MXML_URI = "http://www.adobe.com/2006/mxml";
    @NonNls
    public static final String MXML_URI3 = "http://ns.adobe.com/mxml/2009";
    @NonNls
    public static final String FXG_URI = "http://ns.adobe.com/fxg/2008";
    @NonNls
    public static final String[] LANGUAGE_NAMESPACES = new String[]{"http://www.adobe.com/2006/mxml", "http://ns.adobe.com/mxml/2009"};
    @NonNls
    public static final String BINDOWS_URI = "http://www.bindows.net";

    public static boolean isPlainJavaScriptFile(PsiFile file2) {
        if (file2 == null) {
            return false;
        }
        return DialectDetector.JAVASCRIPT_FILE_TYPES.contains(file2.getFileType());
    }

    public static FileType getMxmlFileType() {
        return MxmlFileTypeHolder.mxmlFileType;
    }

    public static boolean isFlexMxmFile(@NotNull PsiFile file2) {
        if (file2 == null) {
            JavaScriptSupportLoader.$$$reportNull$$$0(0);
        }
        return JavaScriptSupportLoader.isFlexMxmFile(file2.getViewProvider().getVirtualFile());
    }

    public static boolean isFlexMxmFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            JavaScriptSupportLoader.$$$reportNull$$$0(1);
        }
        return file2.getFileType() == MxmlFileTypeHolder.mxmlFileType && JavaScriptSupportLoader.nameHasMxmlExtension(file2.getName());
    }

    public static boolean isMxmlOrFxgFile(@NotNull PsiFile file2) {
        if (file2 == null) {
            JavaScriptSupportLoader.$$$reportNull$$$0(2);
        }
        return JavaScriptSupportLoader.isMxmlOrFxgFile(file2.getViewProvider().getVirtualFile());
    }

    public static boolean isMxmlOrFxgFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            JavaScriptSupportLoader.$$$reportNull$$$0(3);
        }
        return file2.getFileType() == MxmlFileTypeHolder.mxmlFileType && (JavaScriptSupportLoader.nameHasMxmlExtension(file2.getName()) || file2.getName().toLowerCase().endsWith(FXG_FILE_EXTENSION_DOT));
    }

    public static boolean isFxgFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            JavaScriptSupportLoader.$$$reportNull$$$0(4);
        }
        return file2.getFileType() == MxmlFileTypeHolder.mxmlFileType && file2.getName().toLowerCase().endsWith(FXG_FILE_EXTENSION_DOT);
    }

    private static boolean nameHasMxmlExtension(@NotNull String fileName) {
        if (fileName == null) {
            JavaScriptSupportLoader.$$$reportNull$$$0(5);
        }
        String lowercaseName = fileName.toLowerCase();
        return lowercaseName.endsWith(MXML_FILE_EXTENSION_DOT);
    }

    public static boolean isFlexMxmFile(@NotNull String filename) {
        if (filename == null) {
            JavaScriptSupportLoader.$$$reportNull$$$0(6);
        }
        return FileTypeRegistry.getInstance().getFileTypeByFileName(filename) == MxmlFileTypeHolder.mxmlFileType && JavaScriptSupportLoader.nameHasMxmlExtension(filename);
    }

    public static boolean isBindowsFile(@NotNull PsiElement element) {
        if (element == null) {
            JavaScriptSupportLoader.$$$reportNull$$$0(7);
        }
        PsiFile containingFile = element.getContainingFile();
        PsiElement parent = element.getParent();
        if (parent == null) {
            return false;
        }
        PsiElement tag = parent.getParent();
        if (!(tag instanceof XmlTag)) {
            return false;
        }
        if (BINDOWS_URI.equals(((XmlTag)tag).getNamespace())) {
            return true;
        }
        if (!(containingFile instanceof XmlFile)) {
            return false;
        }
        XmlDocument document = ((XmlFile)containingFile).getDocument();
        if (document == null) {
            return false;
        }
        XmlTag rootTag = document.getRootTag();
        if (rootTag == null) {
            return false;
        }
        return "Application".equals(rootTag.getName());
    }

    public static boolean isLanguageNamespace(String namespace) {
        return ArrayUtil.contains((String)namespace, (String[])LANGUAGE_NAMESPACES);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filename";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/JavaScriptSupportLoader";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isFlexMxmFile";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isMxmlOrFxgFile";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isFxgFile";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "nameHasMxmlExtension";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "isBindowsFile";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static class MxmlFileTypeHolder {
        private static final FileType mxmlFileType;

        MxmlFileTypeHolder() {
        }

        static {
            FileType mxmlFileTypeL = FileTypeRegistry.getInstance().getFileTypeByExtension(JavaScriptSupportLoader.MXML_FILE_EXTENSION);
            if (mxmlFileTypeL == UnknownFileType.INSTANCE) {
                mxmlFileTypeL = null;
            }
            mxmlFileType = mxmlFileTypeL;
        }
    }
}

